/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.junit.Assert;
import org.junit.Test;

public class TestMountTable {
    private static final String SRC = "/test";
    private static final String DST_NS_0 = "ns0";
    private static final String DST_NS_1 = "ns1";
    private static final String DST_PATH_0 = "/path1";
    private static final String DST_PATH_1 = "/path/path2";
    private static final List<RemoteLocation> DST = new LinkedList<RemoteLocation>();
    private static final Map<String, String> DST_MAP;
    private static final long DATE_CREATED = 100L;
    private static final long DATE_MOD = 200L;

    @Test
    public void testGetterSetter() throws IOException {
        MountTable record = MountTable.newInstance((String)SRC, DST_MAP);
        this.validateDestinations(record);
        Assert.assertEquals((Object)SRC, (Object)record.getSourcePath());
        Assert.assertEquals(DST, (Object)record.getDestinations());
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        MountTable record2 = MountTable.newInstance((String)SRC, DST_MAP, (long)100L, (long)200L);
        this.validateDestinations(record2);
        Assert.assertEquals((Object)SRC, (Object)record2.getSourcePath());
        Assert.assertEquals(DST, (Object)record2.getDestinations());
        Assert.assertEquals((long)100L, (long)record2.getDateCreated());
        Assert.assertEquals((long)200L, (long)record2.getDateModified());
        Assert.assertFalse((boolean)record.isReadOnly());
        Assert.assertEquals((Object)DestinationOrder.HASH, (Object)record.getDestOrder());
    }

    @Test
    public void testSerialization() throws IOException {
        this.testSerialization(DestinationOrder.RANDOM);
        this.testSerialization(DestinationOrder.HASH);
        this.testSerialization(DestinationOrder.LOCAL);
    }

    private void testSerialization(DestinationOrder order) throws IOException {
        MountTable record = MountTable.newInstance((String)SRC, DST_MAP, (long)100L, (long)200L);
        record.setReadOnly(true);
        record.setDestOrder(order);
        StateStoreSerializer serializer = StateStoreSerializer.getSerializer();
        String serializedString = serializer.serializeString((BaseRecord)record);
        MountTable record2 = (MountTable)serializer.deserialize(serializedString, MountTable.class);
        this.validateDestinations(record2);
        Assert.assertEquals((Object)SRC, (Object)record2.getSourcePath());
        Assert.assertEquals(DST, (Object)record2.getDestinations());
        Assert.assertEquals((long)100L, (long)record2.getDateCreated());
        Assert.assertEquals((long)200L, (long)record2.getDateModified());
        Assert.assertTrue((boolean)record2.isReadOnly());
        Assert.assertEquals((Object)order, (Object)record2.getDestOrder());
    }

    @Test
    public void testReadOnly() throws IOException {
        LinkedHashMap<String, String> dest = new LinkedHashMap<String, String>();
        dest.put(DST_NS_0, DST_PATH_0);
        dest.put(DST_NS_1, DST_PATH_1);
        MountTable record1 = MountTable.newInstance((String)SRC, dest);
        record1.setReadOnly(true);
        this.validateDestinations(record1);
        Assert.assertEquals((Object)SRC, (Object)record1.getSourcePath());
        Assert.assertEquals(DST, (Object)record1.getDestinations());
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((boolean)record1.isReadOnly());
        MountTable record2 = MountTable.newInstance((String)SRC, DST_MAP, (long)100L, (long)200L);
        record2.setReadOnly(true);
        this.validateDestinations(record2);
        Assert.assertEquals((Object)SRC, (Object)record2.getSourcePath());
        Assert.assertEquals(DST, (Object)record2.getDestinations());
        Assert.assertEquals((long)100L, (long)record2.getDateCreated());
        Assert.assertEquals((long)200L, (long)record2.getDateModified());
        Assert.assertTrue((boolean)record2.isReadOnly());
    }

    @Test
    public void testOrder() throws IOException {
        this.testOrder(DestinationOrder.HASH);
        this.testOrder(DestinationOrder.LOCAL);
        this.testOrder(DestinationOrder.RANDOM);
    }

    private void testOrder(DestinationOrder order) throws IOException {
        MountTable record = MountTable.newInstance((String)SRC, DST_MAP, (long)100L, (long)200L);
        record.setDestOrder(order);
        this.validateDestinations(record);
        Assert.assertEquals((Object)SRC, (Object)record.getSourcePath());
        Assert.assertEquals(DST, (Object)record.getDestinations());
        Assert.assertEquals((long)100L, (long)record.getDateCreated());
        Assert.assertEquals((long)200L, (long)record.getDateModified());
        Assert.assertEquals((Object)order, (Object)record.getDestOrder());
    }

    private void validateDestinations(MountTable record) {
        Assert.assertEquals((Object)SRC, (Object)record.getSourcePath());
        Assert.assertEquals((long)2L, (long)record.getDestinations().size());
        RemoteLocation location1 = (RemoteLocation)record.getDestinations().get(0);
        Assert.assertEquals((Object)DST_NS_0, (Object)location1.getNameserviceId());
        Assert.assertEquals((Object)DST_PATH_0, (Object)location1.getDest());
        RemoteLocation location2 = (RemoteLocation)record.getDestinations().get(1);
        Assert.assertEquals((Object)DST_NS_1, (Object)location2.getNameserviceId());
        Assert.assertEquals((Object)DST_PATH_1, (Object)location2.getDest());
    }

    static {
        DST.add(new RemoteLocation(DST_NS_0, DST_PATH_0));
        DST.add(new RemoteLocation(DST_NS_1, DST_PATH_1));
        DST_MAP = new LinkedHashMap<String, String>();
        DST_MAP.put(DST_NS_0, DST_PATH_0);
        DST_MAP.put(DST_NS_1, DST_PATH_1);
    }
}

