/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hdfs.server.namenode.StartupProgressServlet;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressTestHelper;
import org.eclipse.jetty.util.ajax.JSON;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestStartupProgressServlet {
    private HttpServletRequest req;
    private HttpServletResponse resp;
    private ByteArrayOutputStream respOut;
    private StartupProgress startupProgress;
    private StartupProgressServlet servlet;

    @Before
    public void setUp() throws Exception {
        this.startupProgress = new StartupProgress();
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute("startup.progress")).thenReturn((Object)this.startupProgress);
        this.servlet = (StartupProgressServlet)Mockito.mock(StartupProgressServlet.class);
        Mockito.when((Object)this.servlet.getServletContext()).thenReturn((Object)context);
        ((StartupProgressServlet)Mockito.doCallRealMethod().when((Object)this.servlet)).doGet((HttpServletRequest)Mockito.any(HttpServletRequest.class), (HttpServletResponse)Mockito.any(HttpServletResponse.class));
        this.req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.respOut = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(this.respOut);
        this.resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)this.resp.getWriter()).thenReturn((Object)writer);
    }

    @Test
    public void testInitialState() throws Exception {
        String respBody = this.doGetAndReturnResponseBody();
        Assert.assertNotNull((Object)respBody);
        ImmutableMap expected = ImmutableMap.builder().put((Object)"percentComplete", (Object)Float.valueOf(0.0f)).put((Object)"phases", Arrays.asList(ImmutableMap.builder().put((Object)"name", (Object)"LoadingFsImage").put((Object)"desc", (Object)"Loading fsimage").put((Object)"status", (Object)"PENDING").put((Object)"percentComplete", (Object)Float.valueOf(0.0f)).put((Object)"steps", Collections.emptyList()).build(), ImmutableMap.builder().put((Object)"name", (Object)"LoadingEdits").put((Object)"desc", (Object)"Loading edits").put((Object)"status", (Object)"PENDING").put((Object)"percentComplete", (Object)Float.valueOf(0.0f)).put((Object)"steps", Collections.emptyList()).build(), ImmutableMap.builder().put((Object)"name", (Object)"SavingCheckpoint").put((Object)"desc", (Object)"Saving checkpoint").put((Object)"status", (Object)"PENDING").put((Object)"percentComplete", (Object)Float.valueOf(0.0f)).put((Object)"steps", Collections.emptyList()).build(), ImmutableMap.builder().put((Object)"name", (Object)"SafeMode").put((Object)"desc", (Object)"Safe mode").put((Object)"status", (Object)"PENDING").put((Object)"percentComplete", (Object)Float.valueOf(0.0f)).put((Object)"steps", Collections.emptyList()).build())).build();
        Assert.assertEquals((Object)JSON.toString((Map)expected), (Object)this.filterJson(respBody));
    }

    @Test
    public void testRunningState() throws Exception {
        StartupProgressTestHelper.setStartupProgressForRunningState(this.startupProgress);
        String respBody = this.doGetAndReturnResponseBody();
        Assert.assertNotNull((Object)respBody);
        ImmutableMap expected = ImmutableMap.builder().put((Object)"percentComplete", (Object)Float.valueOf(0.375f)).put((Object)"phases", Arrays.asList(ImmutableMap.builder().put((Object)"name", (Object)"LoadingFsImage").put((Object)"desc", (Object)"Loading fsimage").put((Object)"status", (Object)"COMPLETE").put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).put((Object)"steps", Collections.singletonList(ImmutableMap.builder().put((Object)"name", (Object)"Inodes").put((Object)"desc", (Object)"inodes").put((Object)"count", (Object)100L).put((Object)"total", (Object)100L).put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).build())).build(), ImmutableMap.builder().put((Object)"name", (Object)"LoadingEdits").put((Object)"desc", (Object)"Loading edits").put((Object)"status", (Object)"RUNNING").put((Object)"percentComplete", (Object)Float.valueOf(0.5f)).put((Object)"steps", Collections.singletonList(ImmutableMap.builder().put((Object)"count", (Object)100L).put((Object)"file", (Object)"file").put((Object)"size", (Object)1000L).put((Object)"total", (Object)200L).put((Object)"percentComplete", (Object)Float.valueOf(0.5f)).build())).build(), ImmutableMap.builder().put((Object)"name", (Object)"SavingCheckpoint").put((Object)"desc", (Object)"Saving checkpoint").put((Object)"status", (Object)"PENDING").put((Object)"percentComplete", (Object)Float.valueOf(0.0f)).put((Object)"steps", Collections.emptyList()).build(), ImmutableMap.builder().put((Object)"name", (Object)"SafeMode").put((Object)"desc", (Object)"Safe mode").put((Object)"status", (Object)"PENDING").put((Object)"percentComplete", (Object)Float.valueOf(0.0f)).put((Object)"steps", Collections.emptyList()).build())).build();
        Assert.assertEquals((Object)JSON.toString((Map)expected), (Object)this.filterJson(respBody));
    }

    @Test
    public void testFinalState() throws Exception {
        StartupProgressTestHelper.setStartupProgressForFinalState(this.startupProgress);
        String respBody = this.doGetAndReturnResponseBody();
        Assert.assertNotNull((Object)respBody);
        ImmutableMap expected = ImmutableMap.builder().put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).put((Object)"phases", Arrays.asList(ImmutableMap.builder().put((Object)"name", (Object)"LoadingFsImage").put((Object)"desc", (Object)"Loading fsimage").put((Object)"status", (Object)"COMPLETE").put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).put((Object)"steps", Collections.singletonList(ImmutableMap.builder().put((Object)"name", (Object)"Inodes").put((Object)"desc", (Object)"inodes").put((Object)"count", (Object)100L).put((Object)"total", (Object)100L).put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).build())).build(), ImmutableMap.builder().put((Object)"name", (Object)"LoadingEdits").put((Object)"desc", (Object)"Loading edits").put((Object)"status", (Object)"COMPLETE").put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).put((Object)"steps", Collections.singletonList(ImmutableMap.builder().put((Object)"count", (Object)200L).put((Object)"file", (Object)"file").put((Object)"size", (Object)1000L).put((Object)"total", (Object)200L).put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).build())).build(), ImmutableMap.builder().put((Object)"name", (Object)"SavingCheckpoint").put((Object)"desc", (Object)"Saving checkpoint").put((Object)"status", (Object)"COMPLETE").put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).put((Object)"steps", Collections.singletonList(ImmutableMap.builder().put((Object)"name", (Object)"Inodes").put((Object)"desc", (Object)"inodes").put((Object)"count", (Object)300L).put((Object)"total", (Object)300L).put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).build())).build(), ImmutableMap.builder().put((Object)"name", (Object)"SafeMode").put((Object)"desc", (Object)"Safe mode").put((Object)"status", (Object)"COMPLETE").put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).put((Object)"steps", Collections.singletonList(ImmutableMap.builder().put((Object)"name", (Object)"AwaitingReportedBlocks").put((Object)"desc", (Object)"awaiting reported blocks").put((Object)"count", (Object)400L).put((Object)"total", (Object)400L).put((Object)"percentComplete", (Object)Float.valueOf(1.0f)).build())).build())).build();
        Assert.assertEquals((Object)JSON.toString((Map)expected), (Object)this.filterJson(respBody));
    }

    private String doGetAndReturnResponseBody() throws IOException {
        this.servlet.doGet(this.req, this.resp);
        return new String(this.respOut.toByteArray(), "UTF-8");
    }

    private String filterJson(String str) {
        return str.replaceAll("\"elapsedTime\":\\d+\\,", "").replaceAll("\\,\"elapsedTime\":\\d+", "");
    }
}

