/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.CreateFlagParam;
import org.apache.hadoop.hdfs.web.resources.CreateParentParam;
import org.apache.hadoop.hdfs.web.resources.DoAsParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.NamenodeAddressParam;
import org.apache.hadoop.hdfs.web.resources.NoRedirectParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.UnmaskedPermissionParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;

class ParameterParser {
    private final Configuration conf;
    private final String path;
    private final Map<String, List<String>> params;

    ParameterParser(QueryStringDecoder decoder, Configuration conf) {
        this.path = ParameterParser.decodeComponent(decoder.path().substring(WebHdfsHandler.WEBHDFS_PREFIX_LENGTH), StandardCharsets.UTF_8);
        this.params = decoder.parameters();
        this.conf = conf;
    }

    String path() {
        return this.path;
    }

    String op() {
        return this.param("op");
    }

    long offset() {
        return new OffsetParam(this.param("offset")).getOffset();
    }

    long length() {
        return new LengthParam(this.param("length")).getLength();
    }

    String namenodeId() {
        return (String)new NamenodeAddressParam(this.param("namenoderpcaddress")).getValue();
    }

    String doAsUser() {
        return (String)new DoAsParam(this.param("doas")).getValue();
    }

    String userName() {
        return (String)new UserParam(this.param("user.name")).getValue();
    }

    int bufferSize() {
        return new BufferSizeParam(this.param("buffersize")).getValue(this.conf);
    }

    long blockSize() {
        return new BlockSizeParam(this.param("blocksize")).getValue(this.conf);
    }

    short replication() {
        return new ReplicationParam(this.param("replication")).getValue(this.conf);
    }

    FsPermission permission() {
        return new PermissionParam(this.param("permission")).getFileFsPermission();
    }

    FsPermission unmaskedPermission() {
        String value = this.param("unmaskedpermission");
        return value == null ? null : new UnmaskedPermissionParam(value).getFileFsPermission();
    }

    boolean overwrite() {
        return (Boolean)new OverwriteParam(this.param("overwrite")).getValue();
    }

    boolean noredirect() {
        return (Boolean)new NoRedirectParam(this.param("noredirect")).getValue();
    }

    Token<DelegationTokenIdentifier> delegationToken() throws IOException {
        String delegation = this.param("delegation");
        Token token = new Token();
        token.decodeFromUrlString(delegation);
        URI nnUri = URI.create("hdfs://" + this.namenodeId());
        boolean isLogical = HAUtilClient.isLogicalUri((Configuration)this.conf, (URI)nnUri);
        if (isLogical) {
            token.setService(HAUtilClient.buildTokenServiceForLogicalUri((URI)nnUri, (String)"hdfs"));
        } else {
            token.setService(SecurityUtil.buildTokenService((URI)nnUri));
        }
        return token;
    }

    public boolean createParent() {
        return (Boolean)new CreateParentParam(this.param("createparent")).getValue();
    }

    public EnumSet<CreateFlag> createFlag() {
        String cf = ParameterParser.decodeComponent(this.param("createflag"), StandardCharsets.UTF_8);
        return (EnumSet)new CreateFlagParam(cf).getValue();
    }

    Configuration conf() {
        return this.conf;
    }

    private String param(String key) {
        List<String> p = this.params.get(key);
        return p == null ? null : p.get(0);
    }

    private static String decodeComponent(String s, Charset charset) {
        if (s == null) {
            return "";
        }
        int size = s.length();
        boolean modified = false;
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (c != '%' && c != '+') continue;
            modified = true;
            break;
        }
        if (!modified) {
            return s;
        }
        byte[] buf = new byte[size];
        int pos = 0;
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i == size - 1) {
                    throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s);
                }
                if ((c = s.charAt(++i)) == '%') {
                    buf[pos++] = 37;
                    break;
                }
                if (i == size - 1) {
                    throw new IllegalArgumentException("partial escape sequence at end of string: " + s);
                }
                c = ParameterParser.decodeHexNibble(c);
                char c2 = ParameterParser.decodeHexNibble(s.charAt(++i));
                if (c == '\uffff' || c2 == '\uffff') {
                    throw new IllegalArgumentException("invalid escape sequence `%" + s.charAt(i - 1) + s.charAt(i) + "' at index " + (i - 2) + " of: " + s);
                }
                c = (char)(c * 16 + c2);
            }
            buf[pos++] = (byte)c;
        }
        return new String(buf, 0, pos, charset);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }
}

