/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.federation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RouterAdmin
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(RouterAdmin.class);
    private RouterClient client;

    public static void main(String[] argv) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        RouterAdmin admin = new RouterAdmin((Configuration)conf);
        int res = ToolRunner.run((Tool)admin, (String[])argv);
        System.exit(res);
    }

    public RouterAdmin(Configuration conf) {
        super(conf);
    }

    public void printUsage() {
        String usage = "Federation Admin Tools:\n\t[-add <source> <nameservice> <destination> [-readonly] [-order HASH|LOCAL|RANDOM|HASH_ALL]]\n\t[-rm <source>]\n\t[-ls <path>]\n";
        System.out.println(usage);
    }

    public int run(String[] argv) throws Exception {
        Throwable debugException;
        int exitCode;
        block22: {
            String cmd;
            if (argv.length < 1) {
                System.err.println("Not enough parameters specificed");
                this.printUsage();
                return -1;
            }
            exitCode = -1;
            int i = 0;
            if ("-add".equals(cmd = argv[i++])) {
                if (argv.length < 4) {
                    System.err.println("Not enough parameters specificed for cmd " + cmd);
                    this.printUsage();
                    return exitCode;
                }
            } else if ("-rm".equalsIgnoreCase(cmd) && argv.length < 2) {
                System.err.println("Not enough parameters specificed for cmd " + cmd);
                this.printUsage();
                return exitCode;
            }
            try {
                String address = this.getConf().getTrimmed("dfs.federation.router.admin-address", "0.0.0.0:8111");
                InetSocketAddress routerSocket = NetUtils.createSocketAddr((String)address);
                this.client = new RouterClient(routerSocket, this.getConf());
            }
            catch (RPC.VersionMismatch v) {
                System.err.println("Version mismatch between client and server... command aborted");
                return exitCode;
            }
            catch (IOException e) {
                System.err.println("Bad connection to Router... command aborted");
                return exitCode;
            }
            debugException = null;
            exitCode = 0;
            try {
                if ("-add".equals(cmd)) {
                    if (this.addMount(argv, i)) {
                        System.err.println("Successfuly added mount point " + argv[i]);
                    }
                    break block22;
                }
                if ("-rm".equals(cmd)) {
                    if (this.removeMount(argv[i])) {
                        System.err.println("Successfully removed mount point " + argv[i]);
                    }
                    break block22;
                }
                if ("-ls".equals(cmd)) {
                    if (argv.length > 1) {
                        this.listMounts(argv[i]);
                    } else {
                        this.listMounts("/");
                    }
                    break block22;
                }
                this.printUsage();
                return exitCode;
            }
            catch (IllegalArgumentException arge) {
                debugException = arge;
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
                this.printUsage();
            }
            catch (RemoteException e) {
                exitCode = -1;
                debugException = e;
                try {
                    String[] content = e.getLocalizedMessage().split("\n");
                    System.err.println(cmd.substring(1) + ": " + content[0]);
                    e.printStackTrace();
                }
                catch (Exception ex) {
                    System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
                    e.printStackTrace();
                    debugException = ex;
                }
            }
            catch (Exception e) {
                exitCode = -1;
                debugException = e;
                System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        if (debugException != null) {
            LOG.debug("Exception encountered", debugException);
        }
        return exitCode;
    }

    public boolean addMount(String[] parameters, int i) throws IOException {
        String mount = parameters[i++];
        String[] nss = parameters[i++].split(",");
        String dest = parameters[i++];
        boolean readOnly = false;
        DestinationOrder order = DestinationOrder.HASH;
        while (i < parameters.length) {
            if (parameters[i].equals("-readonly")) {
                readOnly = true;
            } else if (parameters[i].equals("-order")) {
                ++i;
                try {
                    order = DestinationOrder.valueOf(parameters[i]);
                }
                catch (Exception e) {
                    System.err.println("Cannot parse order: " + parameters[i]);
                }
            }
            ++i;
        }
        return this.addMount(mount, nss, dest, readOnly, order);
    }

    public boolean addMount(String mount, String[] nss, String dest, boolean readonly, DestinationOrder order) throws IOException {
        UpdateMountTableEntryRequest updateRequest;
        UpdateMountTableEntryResponse updateMountTableEntryResponse;
        boolean updated;
        MountTableManager mountTable = this.client.getMountTableManager();
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance(mount);
        GetMountTableEntriesResponse getResponse = mountTable.getMountTableEntries(getRequest);
        List<MountTable> results = getResponse.getEntries();
        MountTable existingEntry = null;
        for (MountTable mountTable2 : results) {
            if (!mount.equals(mountTable2.getSourcePath())) continue;
            existingEntry = mountTable2;
        }
        if (existingEntry == null) {
            AddMountTableEntryRequest request;
            AddMountTableEntryResponse addResponse;
            boolean added;
            LinkedHashMap destMap = new LinkedHashMap();
            for (String ns : nss) {
                destMap.put(ns, dest);
            }
            MountTable mountTable3 = MountTable.newInstance(mount, destMap);
            if (readonly) {
                mountTable3.setReadOnly(true);
            }
            if (order != null) {
                mountTable3.setDestOrder(order);
            }
            if (!(added = (addResponse = mountTable.addMountTableEntry(request = AddMountTableEntryRequest.newInstance(mountTable3))).getStatus())) {
                System.err.println("Cannot add mount point " + mount);
            }
            return added;
        }
        for (String nsId : nss) {
            if (existingEntry.addDestination(nsId, dest)) continue;
            System.err.println("Cannot add destination at " + nsId + " " + dest);
        }
        if (readonly) {
            existingEntry.setReadOnly(true);
        }
        if (order != null) {
            existingEntry.setDestOrder(order);
        }
        if (!(updated = (updateMountTableEntryResponse = mountTable.updateMountTableEntry(updateRequest = UpdateMountTableEntryRequest.newInstance(existingEntry))).getStatus())) {
            System.err.println("Cannot update mount point " + mount);
        }
        return updated;
    }

    public boolean removeMount(String path) throws IOException {
        RemoveMountTableEntryRequest request;
        MountTableManager mountTable = this.client.getMountTableManager();
        RemoveMountTableEntryResponse response = mountTable.removeMountTableEntry(request = RemoveMountTableEntryRequest.newInstance(path));
        boolean removed = response.getStatus();
        if (!removed) {
            System.out.println("Cannot remove mount point " + path);
        }
        return removed;
    }

    public void listMounts(String path) throws IOException {
        MountTableManager mountTable = this.client.getMountTableManager();
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance(path);
        GetMountTableEntriesResponse response = mountTable.getMountTableEntries(request);
        List<MountTable> entries = response.getEntries();
        RouterAdmin.printMounts(entries);
    }

    private static void printMounts(List<MountTable> entries) {
        System.out.println("Mount Table Entries:");
        System.out.println(String.format("%-25s %-25s", "Source", "Destinations"));
        for (MountTable entry : entries) {
            StringBuilder destBuilder = new StringBuilder();
            for (RemoteLocation location : entry.getDestinations()) {
                if (destBuilder.length() > 0) {
                    destBuilder.append(",");
                }
                destBuilder.append(String.format("%s->%s", location.getNameserviceId(), location.getDest()));
            }
            System.out.println(String.format("%-25s %-25s", entry.getSourcePath(), destBuilder.toString()));
        }
    }
}

