/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSTestWrapper;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestWrapper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.TestPath;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.PlatformAssumptions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestGlobPaths {
    private static final UserGroupInformation unprivilegedUser = UserGroupInformation.createUserForTesting((String)"myuser", (String[])new String[]{"mygroup"});
    private static MiniDFSCluster dfsCluster;
    private static FileSystem fs;
    private static FileSystem privilegedFs;
    private static FileContext fc;
    private static FileContext privilegedFc;
    private static final int NUM_OF_PATHS = 4;
    private static String USER_DIR;
    private final Path[] path = new Path[4];
    private static final PathFilter trueFilter;

    @BeforeClass
    public static void setUp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        privilegedFs = FileSystem.get((Configuration)conf);
        privilegedFc = FileContext.getFileContext((Configuration)conf);
        privilegedFs.setPermission(new Path("/"), FsPermission.createImmutable((short)511));
        UserGroupInformation.setLoginUser((UserGroupInformation)unprivilegedUser);
        fs = FileSystem.get((Configuration)conf);
        fc = FileContext.getFileContext((Configuration)conf);
        USER_DIR = fs.getHomeDirectory().toUri().getPath().toString();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    @Test
    public void testCRInPathGlob() throws IOException {
        Path d1 = new Path(USER_DIR, "dir1");
        Path fNormal = new Path(d1, "f1");
        Path fWithCR = new Path(d1, "f1\r");
        fs.mkdirs(d1);
        fs.createNewFile(fNormal);
        fs.createNewFile(fWithCR);
        FileStatus[] statuses = fs.globStatus(new Path(d1, "f1*"));
        Assert.assertEquals((String)"Expected both normal and CR-carrying files in result: ", (long)2L, (long)statuses.length);
        this.cleanupDFS();
    }

    @Test
    public void testMultiGlob() throws IOException {
        Path d1 = new Path(USER_DIR, "dir1");
        Path d11 = new Path(d1, "subdir1");
        Path d12 = new Path(d1, "subdir2");
        Path f111 = new Path(d11, "f1");
        fs.createNewFile(f111);
        Path f112 = new Path(d11, "f2");
        fs.createNewFile(f112);
        Path f121 = new Path(d12, "f1");
        fs.createNewFile(f121);
        Path d2 = new Path(USER_DIR, "dir2");
        Path d21 = new Path(d2, "subdir1");
        fs.mkdirs(d21);
        Path d22 = new Path(d2, "subdir2");
        Path f221 = new Path(d22, "f1");
        fs.createNewFile(f221);
        Path d3 = new Path(USER_DIR, "dir3");
        Path f31 = new Path(d3, "f1");
        fs.createNewFile(f31);
        Path d32 = new Path(d3, "f2");
        fs.mkdirs(d32);
        Path f32 = new Path(d3, "subdir2");
        fs.createNewFile(f32);
        Path d33 = new Path(d3, "subdir3");
        Path f333 = new Path(d33, "f3");
        fs.createNewFile(f333);
        Path d331 = new Path(d33, "f1");
        Path f3311 = new Path(d331, "f1");
        fs.createNewFile(f3311);
        Path d4 = new Path(USER_DIR, "dir4");
        fs.mkdirs(d4);
        Path root = new Path(USER_DIR);
        FileStatus[] status = fs.globStatus(root);
        this.checkStatus(status, root);
        status = fs.globStatus(new Path(USER_DIR, "x"));
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path("x"));
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path(USER_DIR, "x/x"));
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path("x/x"));
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path(USER_DIR, "*"));
        this.checkStatus(status, d1, d2, d3, d4);
        status = fs.globStatus(new Path("*"));
        this.checkStatus(status, d1, d2, d3, d4);
        status = fs.globStatus(new Path(USER_DIR, "*/x"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("*/x"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "x/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("x/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "x/x/x/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("x/x/x/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "*/*"));
        this.checkStatus(status, d11, d12, d21, d22, f31, d32, f32, d33);
        status = fs.globStatus(new Path("*/*"));
        this.checkStatus(status, d11, d12, d21, d22, f31, d32, f32, d33);
        status = fs.globStatus(new Path(USER_DIR, "dir*/*"));
        this.checkStatus(status, d11, d12, d21, d22, f31, d32, f32, d33);
        status = fs.globStatus(new Path("dir*/*"));
        this.checkStatus(status, d11, d12, d21, d22, f31, d32, f32, d33);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*"));
        this.checkStatus(status, d11, d12, d21, d22, f32, d33);
        status = fs.globStatus(new Path("dir*/subdir*"));
        this.checkStatus(status, d11, d12, d21, d22, f32, d33);
        status = fs.globStatus(new Path(USER_DIR, "dir*/f*"));
        this.checkStatus(status, f31, d32);
        status = fs.globStatus(new Path("dir*/f*"));
        this.checkStatus(status, f31, d32);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1"));
        this.checkStatus(status, d11, d21);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/*"));
        this.checkStatus(status, f111, f112);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/*/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/x"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/x*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir2"));
        this.checkStatus(status, d12, d22, f32);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir2/*"));
        this.checkStatus(status, f121, f221);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir2/*/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir3"));
        this.checkStatus(status, d33);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir3/*"));
        this.checkStatus(status, d331, f333);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir3/*/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir3/*/*/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f1"));
        this.checkStatus(status, f111);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f1*"));
        this.checkStatus(status, f111);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f1/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f1*/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1"));
        this.checkStatus(status, f111, f121, f221, d331);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1*"));
        this.checkStatus(status, f111, f121, f221, d331);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1*/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1*/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1*/x"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f1*/*/*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*"));
        this.checkStatus(status, d11, d12, d21, d22, f32, d33);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/*"));
        this.checkStatus(status, f111, f112, f121, f221, d331, f333);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f*"));
        this.checkStatus(status, f111, f112, f121, f221, d331, f333);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/f*/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/*/f1"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir*/*/*"));
        this.checkStatus(status, f3311);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f3"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path(USER_DIR, "dir*/subdir1/f3*"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("{x}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("{x,y}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("dir*/{x,y}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("dir*/{f1,y}"));
        this.checkStatus(status, f31);
        status = fs.globStatus(new Path("{x,y}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("/{x/x,y/y}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("{x/x,y/y}"));
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("."));
        this.checkStatus(status, new Path(USER_DIR));
        status = fs.globStatus(new Path(USER_DIR + "{/dir1}"));
        this.checkStatus(status, d1);
        status = fs.globStatus(new Path(USER_DIR + "{/dir*}"));
        this.checkStatus(status, d1, d2, d3, d4);
        status = fs.globStatus(new Path("/"), trueFilter);
        this.checkStatus(status, new Path("/"));
        status = fs.globStatus(new Path("."), trueFilter);
        this.checkStatus(status, new Path(USER_DIR));
        status = fs.globStatus(d1, trueFilter);
        this.checkStatus(status, d1);
        status = fs.globStatus(new Path(USER_DIR), trueFilter);
        this.checkStatus(status, new Path(USER_DIR));
        status = fs.globStatus(new Path(USER_DIR, "*"), trueFilter);
        this.checkStatus(status, d1, d2, d3, d4);
        status = fs.globStatus(new Path("/x/*"), trueFilter);
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("/x"), trueFilter);
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path("/x/x"), trueFilter);
        Assert.assertNull((Object)status);
        PathFilter falseFilter = new PathFilter(){

            public boolean accept(Path path) {
                return false;
            }
        };
        status = fs.globStatus(new Path("/"), falseFilter);
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path("."), falseFilter);
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path(USER_DIR), falseFilter);
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path(USER_DIR, "*"), falseFilter);
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("/x/*"), falseFilter);
        this.checkStatus(status, new Path[0]);
        status = fs.globStatus(new Path("/x"), falseFilter);
        Assert.assertNull((Object)status);
        status = fs.globStatus(new Path("/x/x"), falseFilter);
        Assert.assertNull((Object)status);
        this.cleanupDFS();
    }

    private void checkStatus(FileStatus[] status, Path ... expectedMatches) {
        Assert.assertNotNull((Object)status);
        Object[] paths = new String[status.length];
        for (int i = 0; i < status.length; ++i) {
            paths[i] = this.getPathFromStatus(status[i]);
        }
        String got = StringUtils.join((Object[])paths, (String)"\n");
        String expected = StringUtils.join((Object[])expectedMatches, (String)"\n");
        Assert.assertEquals((Object)expected, (Object)got);
    }

    private String getPathFromStatus(FileStatus status) {
        return status.getPath().toUri().getPath();
    }

    @Test
    public void testPathFilter() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a", USER_DIR + "/a/b"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/*", files, new RegexPathFilter("^.*" + Pattern.quote(USER_DIR) + "/a/b"));
            Assert.assertEquals((long)1L, (long)matchedPath.length);
            Assert.assertEquals((Object)this.path[1], (Object)matchedPath[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void testPathFilterWithFixedLastComponent() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a", USER_DIR + "/a/b", USER_DIR + "/c", USER_DIR + "/c/b"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/b", files, new RegexPathFilter("^.*" + Pattern.quote(USER_DIR) + "/a/b"));
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestLiteral() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a2c", USER_DIR + "/abc.d"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/abc.d", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestEscape() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        try {
            String[] files = new String[]{USER_DIR + "/ab\\[c.d"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/ab\\[c.d", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestAny() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/abc", USER_DIR + "/a2c", USER_DIR + "/a.c", USER_DIR + "/abcd"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a?c", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[2]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestClosure1() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a", USER_DIR + "/abc", USER_DIR + "/abc.p", USER_DIR + "/bacd"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a*", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[2]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestClosure2() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.", USER_DIR + "/a.txt", USER_DIR + "/a.old.java", USER_DIR + "/.java"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.*", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestClosure3() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.txt.x", USER_DIR + "/ax", USER_DIR + "/ab37x", USER_DIR + "/bacd"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a*x", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestClosure4() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/dir1/file1", USER_DIR + "/dir2/file2", USER_DIR + "/dir3/file1"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/file1", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestClosure5() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/dir1/file1", USER_DIR + "/file1"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/*/file1", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestSet() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.c", USER_DIR + "/a.cpp", USER_DIR + "/a.hlp", USER_DIR + "/a.hxy"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.[ch]??", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[2]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestRange() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.d", USER_DIR + "/a.e", USER_DIR + "/a.f", USER_DIR + "/a.h"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.[d-fm]", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[2]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestSetExcl() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/a.d", USER_DIR + "/a.e", USER_DIR + "/a.0", USER_DIR + "/a.h"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/a.[^a-cg-z0-9]", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestCombination() throws IOException {
        try {
            String[] files = new String[]{"/user/aa/a.c", "/user/bb/a.cpp", "/user1/cc/b.hlp", "/user/dd/a.hxy"};
            Path[] matchedPath = this.prepareTesting("/use?/*/a.[ch]{lp,xy}", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pTestCurlyBracket() throws IOException {
        Path[] matchedPath;
        String[] files;
        try {
            files = new String[]{USER_DIR + "/a.abcxx", USER_DIR + "/a.abxy", USER_DIR + "/a.hlp", USER_DIR + "/a.jhyy"};
            matchedPath = this.prepareTesting(USER_DIR + "/a.{abc,jh}??", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{USER_DIR + "/a.abcxx", USER_DIR + "/a.abdxy", USER_DIR + "/a.hlp", USER_DIR + "/a.jhyy"};
            matchedPath = this.prepareTesting(USER_DIR + "/a.{ab{c,d},jh}??", files);
            Assert.assertEquals((long)matchedPath.length, (long)3L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            Assert.assertEquals((Object)matchedPath[2], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{USER_DIR + "/a/b", USER_DIR + "/a/d", USER_DIR + "/c/b", USER_DIR + "/c/d"};
            matchedPath = this.prepareTesting(USER_DIR + "/{a/b,c/d}", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{"/a/b", "/a/d", "/c/b", "/c/d"};
            matchedPath = this.prepareTesting("{/a/b,/c/d}", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[3]);
        }
        finally {
            this.cleanupDFS();
        }
        try {
            files = new String[]{USER_DIR + "/}bc", USER_DIR + "/}c"};
            matchedPath = this.prepareTesting(USER_DIR + "/}{a,b}c", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{b}c", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{}bc", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{,}bc", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{b,}c", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{,b}c", files);
            Assert.assertEquals((long)matchedPath.length, (long)2L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
            Assert.assertEquals((Object)matchedPath[1], (Object)this.path[1]);
            matchedPath = this.prepareTesting(USER_DIR + "/}{ac,?}", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[1]);
            boolean hasException = false;
            try {
                this.prepareTesting(USER_DIR + "}{bc", files);
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Illegal file pattern:"));
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Test
    public void pTestJavaRegexSpecialChars() throws IOException {
        try {
            String[] files = new String[]{USER_DIR + "/($.|+)bc", USER_DIR + "/abc"};
            Path[] matchedPath = this.prepareTesting(USER_DIR + "/($.|+)*", files);
            Assert.assertEquals((long)matchedPath.length, (long)1L);
            Assert.assertEquals((Object)matchedPath[0], (Object)this.path[0]);
        }
        finally {
            this.cleanupDFS();
        }
    }

    private Path[] prepareTesting(String pattern, String[] files) throws IOException {
        for (int i = 0; i < Math.min(4, files.length); ++i) {
            this.path[i] = fs.makeQualified(new Path(files[i]));
            if (fs.mkdirs(this.path[i])) continue;
            throw new IOException("Mkdirs failed to create " + this.path[i].toString());
        }
        Path patternPath = new Path(pattern);
        Path[] globResults = FileUtil.stat2Paths((FileStatus[])fs.globStatus(patternPath), (Path)patternPath);
        for (int i = 0; i < globResults.length; ++i) {
            globResults[i] = globResults[i].makeQualified(fs.getUri(), fs.getWorkingDirectory());
        }
        return globResults;
    }

    private Path[] prepareTesting(String pattern, String[] files, PathFilter filter) throws IOException {
        for (int i = 0; i < Math.min(4, files.length); ++i) {
            this.path[i] = fs.makeQualified(new Path(files[i]));
            if (fs.mkdirs(this.path[i])) continue;
            throw new IOException("Mkdirs failed to create " + this.path[i].toString());
        }
        Path patternPath = new Path(pattern);
        Path[] globResults = FileUtil.stat2Paths((FileStatus[])fs.globStatus(patternPath, filter), (Path)patternPath);
        for (int i = 0; i < globResults.length; ++i) {
            globResults[i] = globResults[i].makeQualified(fs.getUri(), fs.getWorkingDirectory());
        }
        return globResults;
    }

    private void cleanupDFS() throws IOException {
        fs.delete(new Path(USER_DIR), true);
    }

    private void testOnFileSystem(FSTestWrapperGlobTest test) throws Exception {
        try {
            fc.mkdir(new Path(USER_DIR), FsPermission.getDefault(), true);
            test.run();
        }
        finally {
            fc.delete(new Path(USER_DIR), true);
        }
    }

    private void testOnFileContext(FSTestWrapperGlobTest test) throws Exception {
        try {
            fs.mkdirs(new Path(USER_DIR));
            test.run();
        }
        finally {
            this.cleanupDFS();
        }
    }

    @Ignore
    @Test
    public void testGlobWithSymlinksOnFS() throws Exception {
        this.testOnFileSystem(new TestGlobWithSymlinks(false));
    }

    @Ignore
    @Test
    public void testGlobWithSymlinksOnFC() throws Exception {
        this.testOnFileContext(new TestGlobWithSymlinks(true));
    }

    @Ignore
    @Test
    public void testGlobWithSymlinksToSymlinksOnFS() throws Exception {
        this.testOnFileSystem(new TestGlobWithSymlinksToSymlinks(false));
    }

    @Ignore
    @Test
    public void testGlobWithSymlinksToSymlinksOnFC() throws Exception {
        this.testOnFileContext(new TestGlobWithSymlinksToSymlinks(true));
    }

    @Ignore
    @Test
    public void testGlobSymlinksWithCustomPathFilterOnFS() throws Exception {
        this.testOnFileSystem(new TestGlobSymlinksWithCustomPathFilter(false));
    }

    @Ignore
    @Test
    public void testGlobSymlinksWithCustomPathFilterOnFC() throws Exception {
        this.testOnFileContext(new TestGlobSymlinksWithCustomPathFilter(true));
    }

    @Test
    public void testGlobFillsInSchemeOnFS() throws Exception {
        this.testOnFileSystem(new TestGlobFillsInScheme(false));
    }

    @Test
    public void testGlobFillsInSchemeOnFC() throws Exception {
        this.testOnFileContext(new TestGlobFillsInScheme(true));
    }

    @Test
    public void testRelativePathOnFS() throws Exception {
        this.testOnFileSystem(new TestRelativePath(false));
    }

    @Test
    public void testRelativePathOnFC() throws Exception {
        this.testOnFileContext(new TestRelativePath(true));
    }

    @Test
    public void testGlobAccessDeniedOnFS() throws Exception {
        this.testOnFileSystem(new TestGlobAccessDenied(false));
    }

    @Test
    public void testGlobAccessDeniedOnFC() throws Exception {
        this.testOnFileContext(new TestGlobAccessDenied(true));
    }

    @Test
    public void testReservedHdfsPathsOnFS() throws Exception {
        this.testOnFileSystem(new TestReservedHdfsPaths(false));
    }

    @Test
    public void testReservedHdfsPathsOnFC() throws Exception {
        this.testOnFileContext(new TestReservedHdfsPaths(true));
    }

    @Test
    public void testGlobRootOnFS() throws Exception {
        this.testOnFileSystem(new TestGlobRoot(false));
    }

    @Test
    public void testGlobRootOnFC() throws Exception {
        this.testOnFileContext(new TestGlobRoot(true));
    }

    @Test
    public void testNonTerminalGlobsOnFS() throws Exception {
        this.testOnFileSystem(new TestNonTerminalGlobs(false));
    }

    @Test
    public void testNonTerminalGlobsOnFC() throws Exception {
        this.testOnFileContext(new TestNonTerminalGlobs(true));
    }

    @Test
    public void testLocalFilesystem() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        String localTmp = System.getProperty("java.io.tmpdir");
        Path base = new Path(new Path(localTmp), UUID.randomUUID().toString());
        Assert.assertTrue((boolean)fs.mkdirs(base));
        Assert.assertTrue((boolean)fs.mkdirs(new Path(base, "e")));
        Assert.assertTrue((boolean)fs.mkdirs(new Path(base, "c")));
        Assert.assertTrue((boolean)fs.mkdirs(new Path(base, "a")));
        Assert.assertTrue((boolean)fs.mkdirs(new Path(base, "d")));
        Assert.assertTrue((boolean)fs.mkdirs(new Path(base, "b")));
        fs.deleteOnExit(base);
        FileStatus[] status = fs.globStatus(new Path(base, "*"));
        ArrayList<String> list = new ArrayList<String>();
        for (FileStatus f : status) {
            list.add(f.getPath().toString());
        }
        boolean sorted = Ordering.natural().isOrdered(list);
        Assert.assertTrue((boolean)sorted);
    }

    static {
        trueFilter = new AcceptAllPathFilter();
    }

    private class TestNonTerminalGlobs
    extends FSTestWrapperGlobTest {
        TestNonTerminalGlobs(boolean useFc) {
            super(useFc);
        }

        @Override
        void run() throws Exception {
            try {
                this.privWrap.mkdir(new Path("/filed_away/alpha"), new FsPermission(511), true);
                this.privWrap.createFile(new Path("/filed"), 0, new Options.CreateOpts[0]);
                FileStatus[] statuses = this.wrap.globStatus(new Path("/filed*/alpha"), (PathFilter)new AcceptAllPathFilter());
                Assert.assertEquals((long)1L, (long)statuses.length);
                Assert.assertEquals((Object)"/filed_away/alpha", (Object)statuses[0].getPath().toUri().getPath());
                this.privWrap.mkdir(new Path("/filed_away/alphabet"), new FsPermission(511), true);
                this.privWrap.mkdir(new Path("/filed_away/alphabet/abc"), new FsPermission(511), true);
                statuses = this.wrap.globStatus(new Path("/filed*/alph*/*b*"), (PathFilter)new AcceptAllPathFilter());
                Assert.assertEquals((long)1L, (long)statuses.length);
                Assert.assertEquals((Object)"/filed_away/alphabet/abc", (Object)statuses[0].getPath().toUri().getPath());
            }
            finally {
                this.privWrap.delete(new Path("/filed"), true);
                this.privWrap.delete(new Path("/filed_away"), true);
            }
        }
    }

    private class TestGlobRoot
    extends FSTestWrapperGlobTest {
        TestGlobRoot(boolean useFc) {
            super(useFc);
        }

        @Override
        void run() throws Exception {
            Path rootPath = new Path("/");
            FileStatus oldRootStatus = this.wrap.getFileStatus(rootPath);
            String newOwner = UUID.randomUUID().toString();
            this.privWrap.setOwner(new Path("/"), newOwner, null);
            FileStatus[] status = this.wrap.globStatus(rootPath, (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((long)1L, (long)status.length);
            Assert.assertEquals((Object)newOwner, (Object)status[0].getOwner());
            this.privWrap.setOwner(new Path("/"), oldRootStatus.getOwner(), null);
        }
    }

    private class TestReservedHdfsPaths
    extends FSTestWrapperGlobTest {
        TestReservedHdfsPaths(boolean useFc) {
            super(useFc);
        }

        @Override
        void run() throws Exception {
            String reservedRoot = "/.reserved/.inodes/16385";
            Assert.assertEquals((Object)reservedRoot, (Object)TestPath.mergeStatuses((FileStatus[])this.wrap.globStatus(new Path(reservedRoot), (PathFilter)new AcceptAllPathFilter())));
        }
    }

    private class TestGlobAccessDenied
    extends FSTestWrapperGlobTest {
        TestGlobAccessDenied(boolean useFc) {
            super(useFc);
        }

        @Override
        void run() throws Exception {
            this.privWrap.mkdir(new Path("/nopermission/val"), new FsPermission(511), true);
            this.privWrap.mkdir(new Path("/norestrictions/val"), new FsPermission(511), true);
            this.privWrap.setPermission(new Path("/nopermission"), new FsPermission(0));
            try {
                this.wrap.globStatus(new Path("/no*/*"), (PathFilter)new AcceptAllPathFilter());
                Assert.fail((String)"expected to get an AccessControlException when globbing through a directory we don't have permissions to list.");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            Assert.assertEquals((Object)"/norestrictions/val", (Object)TestPath.mergeStatuses((FileStatus[])this.wrap.globStatus(new Path("/norestrictions/*"), (PathFilter)new AcceptAllPathFilter())));
        }
    }

    private class TestRelativePath
    extends FSTestWrapperGlobTest {
        TestRelativePath(boolean useFc) {
            super(useFc);
        }

        @Override
        void run() throws Exception {
            String[] files = new String[]{"a", "abc", "abc.p", "bacd"};
            Path[] path = new Path[files.length];
            for (int i = 0; i < files.length; ++i) {
                path[i] = this.wrap.makeQualified(new Path(files[i]));
                this.wrap.mkdir(path[i], FsPermission.getDirDefault(), true);
            }
            Path patternPath = new Path("a*");
            Path[] globResults = FileUtil.stat2Paths((FileStatus[])this.wrap.globStatus(patternPath, (PathFilter)new AcceptAllPathFilter()), (Path)patternPath);
            for (int i = 0; i < globResults.length; ++i) {
                globResults[i] = this.wrap.makeQualified(globResults[i]);
            }
            Assert.assertEquals((long)globResults.length, (long)3L);
            String pwd = this.wrap.getWorkingDirectory().toUri().getPath();
            Assert.assertEquals((Object)(pwd + "/a;" + pwd + "/abc;" + pwd + "/abc.p"), (Object)TestPath.mergeStatuses((Path[])globResults));
        }
    }

    private class TestGlobFillsInScheme
    extends FSTestWrapperGlobTest {
        TestGlobFillsInScheme(boolean useFc) {
            super(useFc);
        }

        @Override
        void run() throws Exception {
            this.wrap.mkdir(new Path(USER_DIR + "/alpha"), FsPermission.getDirDefault(), false);
            this.wrap.createSymlink(new Path(USER_DIR + "/alpha"), new Path(USER_DIR + "/alphaLink"), false);
            FileStatus[] statuses = this.wrap.globStatus(new Path(USER_DIR + "/alphaLink"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((long)1L, (long)statuses.length);
            Path path = statuses[0].getPath();
            Assert.assertEquals((Object)(USER_DIR + "/alpha"), (Object)path.toUri().getPath());
            Assert.assertEquals((Object)"hdfs", (Object)path.toUri().getScheme());
            statuses = fc.util().globStatus(new Path("file:///"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((long)1L, (long)statuses.length);
            Path filePath = statuses[0].getPath();
            Assert.assertEquals((Object)"file", (Object)filePath.toUri().getScheme());
            Assert.assertEquals((Object)"/", (Object)filePath.toUri().getPath());
            Assert.assertEquals((Object)"hdfs", (Object)fs.getScheme());
        }
    }

    private class TestGlobSymlinksWithCustomPathFilter
    extends FSTestWrapperGlobTest {
        TestGlobSymlinksWithCustomPathFilter(boolean useFc) {
            super(useFc);
        }

        @Override
        void run() throws Exception {
            this.wrap.mkdir(new Path(USER_DIR + "/alpha"), FsPermission.getDirDefault(), false);
            this.wrap.createSymlink(new Path(USER_DIR + "/alpha"), new Path(USER_DIR + "/alphaLinkz"), false);
            this.wrap.mkdir(new Path(USER_DIR + "/alpha/beta"), FsPermission.getDirDefault(), false);
            this.wrap.mkdir(new Path(USER_DIR + "/alpha/betaz"), FsPermission.getDirDefault(), false);
            FileStatus[] statuses = this.wrap.globStatus(new Path(USER_DIR + "/alpha/beta"), (PathFilter)new AcceptPathsEndingInZ());
            Assert.assertNull((Object)statuses);
            statuses = this.wrap.globStatus(new Path(USER_DIR + "/alphaLinkz/betaz"), (PathFilter)new AcceptPathsEndingInZ());
            Assert.assertEquals((long)1L, (long)statuses.length);
            Assert.assertEquals((Object)(USER_DIR + "/alphaLinkz/betaz"), (Object)statuses[0].getPath().toUri().getPath());
            statuses = this.wrap.globStatus(new Path(USER_DIR + "/*/*"), (PathFilter)new AcceptPathsEndingInZ());
            Assert.assertEquals((Object)(USER_DIR + "/alpha/betaz;" + USER_DIR + "/alphaLinkz/betaz"), (Object)TestPath.mergeStatuses((FileStatus[])statuses));
            statuses = this.wrap.globStatus(new Path(USER_DIR + "/*/*"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((Object)(USER_DIR + "/alpha/beta;" + USER_DIR + "/alpha/betaz;" + USER_DIR + "/alphaLinkz/beta;" + USER_DIR + "/alphaLinkz/betaz"), (Object)TestPath.mergeStatuses((FileStatus[])statuses));
        }
    }

    private class TestGlobWithSymlinksToSymlinks
    extends FSTestWrapperGlobTest {
        TestGlobWithSymlinksToSymlinks(boolean useFc) {
            super(useFc);
        }

        @Override
        void run() throws Exception {
            this.wrap.mkdir(new Path(USER_DIR + "/alpha"), FsPermission.getDirDefault(), false);
            this.wrap.createSymlink(new Path(USER_DIR + "/alpha"), new Path(USER_DIR + "/alphaLink"), false);
            this.wrap.createSymlink(new Path(USER_DIR + "/alphaLink"), new Path(USER_DIR + "/alphaLinkLink"), false);
            this.wrap.mkdir(new Path(USER_DIR + "/alpha/beta"), FsPermission.getDirDefault(), false);
            FileStatus[] statuses = this.wrap.globStatus(new Path(USER_DIR + "/alphaLinkLink"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((long)1L, (long)statuses.length);
            Assert.assertEquals((Object)(USER_DIR + "/alphaLinkLink"), (Object)statuses[0].getPath().toUri().getPath());
            statuses = this.wrap.globStatus(new Path(USER_DIR + "/alphaLinkLink/*"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((long)1L, (long)statuses.length);
            Assert.assertEquals((Object)(USER_DIR + "/alphaLinkLink/beta"), (Object)statuses[0].getPath().toUri().getPath());
            this.wrap.createSymlink(new Path(USER_DIR + "theta"), new Path(USER_DIR + "/alpha/kappa"), false);
            statuses = this.wrap.globStatus(new Path(USER_DIR + "/alpha/kappa/kappa"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertNull((Object)statuses);
            this.wrap.createFile(USER_DIR + "/alpha/beta/gamma");
            this.wrap.createSymlink(new Path(USER_DIR + "gamma"), new Path(USER_DIR + "/alpha/beta/gammaLink"), false);
            this.wrap.createSymlink(new Path(USER_DIR + "gammaLink"), new Path(USER_DIR + "/alpha/beta/gammaLinkLink"), false);
            this.wrap.createSymlink(new Path(USER_DIR + "gammaLinkLink"), new Path(USER_DIR + "/alpha/beta/gammaLinkLinkLink"), false);
            statuses = this.wrap.globStatus(new Path(USER_DIR + "/alpha/*/gammaLinkLinkLink"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((long)1L, (long)statuses.length);
            Assert.assertEquals((Object)(USER_DIR + "/alpha/beta/gammaLinkLinkLink"), (Object)statuses[0].getPath().toUri().getPath());
            statuses = this.wrap.globStatus(new Path(USER_DIR + "/alpha/beta/*"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((Object)(USER_DIR + "/alpha/beta/gamma;" + USER_DIR + "/alpha/beta/gammaLink;" + USER_DIR + "/alpha/beta/gammaLinkLink;" + USER_DIR + "/alpha/beta/gammaLinkLinkLink"), (Object)TestPath.mergeStatuses((FileStatus[])statuses));
            this.wrap.createSymlink(new Path(USER_DIR + "tweedledee"), new Path(USER_DIR + "/tweedledum"), false);
            this.wrap.createSymlink(new Path(USER_DIR + "tweedledum"), new Path(USER_DIR + "/tweedledee"), false);
            statuses = this.wrap.globStatus(new Path(USER_DIR + "/tweedledee/unobtainium"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertNull((Object)statuses);
        }
    }

    private class TestGlobWithSymlinks
    extends FSTestWrapperGlobTest {
        TestGlobWithSymlinks(boolean useFc) {
            super(useFc);
        }

        @Override
        void run() throws Exception {
            this.wrap.mkdir(new Path(USER_DIR + "/alpha"), FsPermission.getDirDefault(), false);
            this.wrap.createSymlink(new Path(USER_DIR + "/alpha"), new Path(USER_DIR + "/alphaLink"), false);
            this.wrap.mkdir(new Path(USER_DIR + "/alphaLink/beta"), FsPermission.getDirDefault(), false);
            FileStatus[] statuses = this.wrap.globStatus(new Path(USER_DIR + "/alpha/*"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((long)1L, (long)statuses.length);
            Assert.assertEquals((Object)(USER_DIR + "/alpha/beta"), (Object)statuses[0].getPath().toUri().getPath());
            statuses = this.wrap.globStatus(new Path(USER_DIR + "/alphaLink/*"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((long)1L, (long)statuses.length);
            Assert.assertEquals((Object)(USER_DIR + "/alphaLink/beta"), (Object)statuses[0].getPath().toUri().getPath());
            this.wrap.createSymlink(new Path("beta"), new Path(USER_DIR + "/alphaLink/betaLink"), false);
            statuses = this.wrap.globStatus(new Path(USER_DIR + "/alpha/betaLi*"), (PathFilter)new AcceptAllPathFilter());
            Assert.assertEquals((long)1L, (long)statuses.length);
            Assert.assertEquals((Object)(USER_DIR + "/alpha/betaLink"), (Object)statuses[0].getPath().toUri().getPath());
        }
    }

    private static class AcceptPathsEndingInZ
    implements PathFilter {
        private AcceptPathsEndingInZ() {
        }

        public boolean accept(Path path) {
            String stringPath = path.toUri().getPath();
            return stringPath.endsWith("z");
        }
    }

    private static class AcceptAllPathFilter
    implements PathFilter {
        private AcceptAllPathFilter() {
        }

        public boolean accept(Path path) {
            return true;
        }
    }

    private abstract class FSTestWrapperGlobTest {
        final FSTestWrapper privWrap;
        final FSTestWrapper wrap;

        FSTestWrapperGlobTest(boolean useFc) {
            if (useFc) {
                this.privWrap = new FileContextTestWrapper(privilegedFc);
                this.wrap = new FileContextTestWrapper(fc);
            } else {
                this.privWrap = new FileSystemTestWrapper(privilegedFs);
                this.wrap = new FileSystemTestWrapper(fs);
            }
        }

        abstract void run() throws Exception;
    }

    static class RegexPathFilter
    implements PathFilter {
        private final String regex;

        public RegexPathFilter(String regex) {
            this.regex = regex;
        }

        public boolean accept(Path path) {
            return path.toString().matches(this.regex);
        }
    }
}

