/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestErasureCodingExerciseAPIs {
    private Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private HdfsAdmin dfsAdmin;
    private FileSystemTestWrapper fsWrapper;
    private static final int BLOCK_SIZE = 16384;
    private ErasureCodingPolicy ecPolicy;
    private static final Logger LOG = LoggerFactory.getLogger(TestErasureCodingExerciseAPIs.class);

    private static ErasureCodingPolicy getEcPolicy() {
        return StripedFileTestUtil.getDefaultECPolicy();
    }

    @Before
    public void setupCluster() throws IOException {
        this.ecPolicy = TestErasureCodingExerciseAPIs.getEcPolicy();
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.blocksize", 16384);
        this.conf.setBoolean("dfs.namenode.acls.enabled", true);
        String testRootDir = Paths.get(new FileSystemTestHelper().getTestRootDir(), new String[0]).toString();
        String keyProviderURI = "jceks://file" + new Path(testRootDir, "test.jks").toUri();
        this.conf.set("hadoop.security.key.provider.path", keyProviderURI);
        this.conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits()).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.fsWrapper = new FileSystemTestWrapper((FileSystem)this.fs);
        this.dfsAdmin = new HdfsAdmin(this.cluster.getURI(), this.conf);
        DFSTestUtil.enableAllECPolicies(this.fs);
        this.fs.setErasureCodingPolicy(new Path("/"), this.ecPolicy.getName());
    }

    @Test
    public void testAccess() throws IOException, InterruptedException {
        Path p1 = new Path("/p1");
        String userName = "user1";
        String groupName = "group1";
        this.fs.mkdir(p1, new FsPermission(292));
        this.fs.setOwner(p1, "user1", "group1");
        UserGroupInformation userGroupInfo = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"group1"});
        FileSystem userFs = (FileSystem)userGroupInfo.doAs(() -> FileSystem.get((Configuration)this.conf));
        userFs.setOwner(p1, "user1", "group1");
        userFs.access(p1, FsAction.READ);
        long mtime = System.currentTimeMillis() - 1000L;
        long atime = System.currentTimeMillis() - 2000L;
        this.fs.setTimes(p1, mtime, atime);
        FileStatus fileStatus = this.fs.getFileStatus(p1);
        Assert.assertEquals((Object)"user1", (Object)fileStatus.getOwner());
        Assert.assertEquals((Object)"group1", (Object)fileStatus.getGroup());
        Assert.assertEquals((Object)new FsPermission(FsAction.READ, FsAction.READ, FsAction.READ), (Object)fileStatus.getPermission());
        Assert.assertEquals((long)mtime, (long)fileStatus.getModificationTime());
        Assert.assertEquals((long)atime, (long)fileStatus.getAccessTime());
    }

    @Test
    public void testQuota() throws IOException {
        Path qDir = new Path("/quotaDir");
        this.fs.mkdirs(qDir);
        this.fs.setQuota(qDir, 6L, Long.MAX_VALUE);
        QuotaUsage usage = this.fs.getQuotaUsage(qDir);
        Assert.assertEquals((Object)this.fs.getContentSummary(qDir), (Object)usage);
        this.fs.setQuotaByStorageType(qDir, StorageType.DEFAULT, 10L);
    }

    @Test
    public void testCache() throws IOException {
        this.fs.addCachePool(new CachePoolInfo("pool1"));
        this.fs.modifyCachePool(new CachePoolInfo("pool1"));
        this.fs.removeCachePool("pool1");
        this.fs.addCachePool(new CachePoolInfo("pool1"));
        long id = this.fs.addCacheDirective(new CacheDirectiveInfo.Builder().setPool("pool1").setPath(new Path("/pool2")).build());
        RemoteIterator iter = this.fs.listCacheDirectives(new CacheDirectiveInfo.Builder().setPool("pool1").build());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"pool1", (Object)((CacheDirectiveEntry)iter.next()).getInfo().getPool());
        this.fs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(id)).setReplication(Short.valueOf((short)2)).build());
        this.fs.removeCacheDirective(id);
    }

    @Test
    public void testErasureCodingPolicy() throws IOException {
        Path tDir = new Path("/ecpDir");
        this.fs.mkdirs(tDir);
        ErasureCodingPolicy defaultPolicy = (ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(0);
        this.fs.setErasureCodingPolicy(tDir, defaultPolicy.getName());
        ErasureCodingPolicy fPolicy = this.fs.getErasureCodingPolicy(tDir);
        Assert.assertEquals((Object)defaultPolicy, (Object)fPolicy);
        int cellSize = 0x100000;
        ECSchema schema = new ECSchema("rs", 5, 3);
        ErasureCodingPolicy newPolicy = new ErasureCodingPolicy(schema, 0x100000);
        this.fs.addErasureCodingPolicies(new ErasureCodingPolicy[]{newPolicy});
        Assert.assertEquals((long)(SystemErasureCodingPolicies.getPolicies().size() + 1), (long)this.fs.getAllErasureCodingPolicies().size());
        this.fs.disableErasureCodingPolicy(ErasureCodingPolicy.composePolicyName((ECSchema)schema, (int)0x100000));
        Assert.assertEquals((long)(SystemErasureCodingPolicies.getPolicies().size() + 1), (long)this.fs.getAllErasureCodingPolicies().size());
        this.fs.unsetErasureCodingPolicy(tDir);
        fPolicy = this.fs.getErasureCodingPolicy(tDir);
        Assert.assertNotNull((Object)fPolicy);
        this.fs.removeErasureCodingPolicy(ErasureCodingPolicy.composePolicyName((ECSchema)schema, (int)0x100000));
        Assert.assertEquals((long)(SystemErasureCodingPolicies.getPolicies().size() + 1), (long)this.fs.getAllErasureCodingPolicies().size());
    }

    @Test
    public void testACLAPI() throws IOException {
        Path p = new Path("/aclTest");
        this.fs.mkdirs(p, FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)});
        this.fs.setAcl(p, (List)aclSpec);
        AclStatus as = this.fs.getAclStatus(p);
        for (AclEntry entry : aclSpec) {
            Assert.assertTrue((String)String.format("as: %s, entry: %s", as, entry), (boolean)as.getEntries().contains(entry));
        }
        ArrayList maclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", FsAction.READ_EXECUTE)});
        this.fs.modifyAclEntries(p, (List)maclSpec);
        as = this.fs.getAclStatus(p);
        for (AclEntry entry : maclSpec) {
            Assert.assertTrue((String)String.format("as: %s, entry: %s", as, entry), (boolean)as.getEntries().contains(entry));
        }
        this.fs.removeAclEntries(p, (List)maclSpec);
        this.fs.removeDefaultAcl(p);
        this.fs.removeAcl(p);
        Assert.assertEquals((long)0L, (long)this.fs.getAclStatus(p).getEntries().size());
    }

    @Test
    public void testAttr() throws IOException {
        Path p = new Path("/attrTest");
        this.fs.mkdirs(p);
        Path filePath = new Path(p, "file");
        try (FSDataOutputStream dos = this.fs.create(filePath);){
            dos.writeBytes("write something");
        }
        String name = "user.a1";
        byte[] value = new byte[]{49, 50, 51};
        this.fs.setXAttr(filePath, "user.a1", value, EnumSet.of(XAttrSetFlag.CREATE));
        Map xattrs = this.fs.getXAttrs(filePath);
        Assert.assertEquals((long)1L, (long)xattrs.size());
        Assert.assertArrayEquals((byte[])value, (byte[])((byte[])xattrs.get("user.a1")));
        Assert.assertArrayEquals((byte[])value, (byte[])this.fs.getXAttr(filePath, "user.a1"));
        List listXAttrs = this.fs.listXAttrs(filePath);
        Assert.assertEquals((long)1L, (long)listXAttrs.size());
        this.fs.removeXAttr(filePath, "user.a1");
        xattrs = this.fs.getXAttrs(filePath);
        Assert.assertEquals((long)0L, (long)xattrs.size());
        listXAttrs = this.fs.listXAttrs(filePath);
        Assert.assertEquals((long)0L, (long)listXAttrs.size());
    }

    @Test
    public void testSnapshotAPI() throws IOException {
        Path p = new Path("/snapshotTest");
        this.fs.mkdirs(p);
        this.fs.allowSnapshot(p);
        this.fs.createSnapshot(p, "s1");
        Path f = new Path("/snapshotTest/f1");
        try (FSDataOutputStream dos = this.fs.create(f);){
            dos.writeBytes("write something");
        }
        this.fs.createSnapshot(p, "s2");
        this.fs.renameSnapshot(p, "s2", "s3");
        SnapshotDiffReport report = this.fs.getSnapshotDiffReport(p, "s1", "s3");
        Assert.assertEquals((Object)"s1", (Object)report.getFromSnapshot());
        Assert.assertEquals((Object)"s3", (Object)report.getLaterSnapshotName());
        this.fs.deleteSnapshot(p, "s1");
        this.fs.deleteSnapshot(p, "s3");
        this.fs.disallowSnapshot(p);
    }

    @Test
    public void testSymbolicLink() throws IOException {
        Path p = new Path("/slTest");
        this.fs.mkdirs(p);
        Path f = new Path("/slTest/file");
        try (FSDataOutputStream dos = this.fs.create(f);){
            dos.writeBytes("write something");
        }
        Path sl = new Path("/slTest1/sl");
        this.fs.createSymlink(f, sl, true);
        Assert.assertEquals((Object)this.fs.getLinkTarget(sl), (Object)f);
        FileStatus linkStatus = this.fs.getFileLinkStatus(sl);
        Assert.assertTrue((boolean)linkStatus.isSymlink());
    }

    @Test
    public void testFileOpsAPI() throws IOException {
        Path[] concatPs;
        Path p = new Path("/fileTest");
        this.fs.mkdirs(p);
        Path f1 = new Path(p, "file1");
        Path fa = new Path(p, "filea");
        try (FSDataOutputStream dos = this.fs.create(f1);){
            dos.writeBytes("create with some content");
        }
        dos = this.fs.create(fa);
        var5_6 = null;
        try {
            dos.writeBytes("create with some content");
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
        finally {
            if (dos != null) {
                if (var5_6 != null) {
                    try {
                        dos.close();
                    }
                    catch (Throwable throwable) {
                        var5_6.addSuppressed(throwable);
                    }
                } else {
                    dos.close();
                }
            }
        }
        short replication = this.fs.getDefaultReplication();
        this.fs.setReplication(f1, (short)5);
        Assert.assertEquals((long)replication, (long)this.fs.getDefaultReplication(f1));
        BlockLocation[] locations = this.fs.getFileBlockLocations(f1, 0L, 1L);
        Assert.assertEquals((long)1L, (long)locations.length);
        FileStatus status1 = this.fs.getFileStatus(f1);
        Assert.assertFalse((boolean)status1.isDirectory());
        Assert.assertTrue((boolean)status1.getPath().toString().contains(p.toString()));
        FileStatus statusa = this.fs.getFileStatus(fa);
        Assert.assertFalse((boolean)statusa.isDirectory());
        Assert.assertTrue((boolean)statusa.getPath().toString().contains(fa.toString()));
        FileStatus[] statuses = this.fs.listStatus(p);
        Assert.assertEquals((long)2L, (long)statuses.length);
        Assert.assertEquals((Object)status1, (Object)statuses[0]);
        Assert.assertEquals((Object)statusa, (Object)statuses[1]);
        RemoteIterator iter = this.fs.listStatusIterator(p);
        Assert.assertEquals((Object)status1, (Object)iter.next());
        Assert.assertEquals((Object)statusa, (Object)iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
        for (Path cp : concatPs = new Path[]{new Path(p, "c1"), new Path(p, "c2"), new Path(p, "c3")}) {
            try (FSDataOutputStream dos = this.fs.create(cp);){
                dos.writeBytes("concat some content");
            }
        }
        this.fs.concat(f1, concatPs);
        FileChecksum checksum1 = this.fs.getFileChecksum(f1);
        Path f2 = new Path("/fileTest/file2");
        this.fs.rename(f1, f2);
        FileStatus fileStatus = this.fs.getFileStatus(f2);
        Assert.assertTrue((boolean)fileStatus.getPath().toString().contains("/fileTest/file2"));
        FileChecksum checksum2 = this.fs.getFileChecksum(f2);
        Assert.assertEquals((Object)checksum1, (Object)checksum2);
        this.fs.delete(f2, true);
        RemoteIterator corruptFileBlocks = this.fs.listCorruptFileBlocks(f2);
        Assert.assertFalse((boolean)corruptFileBlocks.hasNext());
    }

    @Test
    public void testEncryptionZone() throws IOException, NoSuchAlgorithmException {
        Path zoneRoot = new Path("ecRoot");
        Path zonePath = new Path(zoneRoot, "/ec");
        this.fsWrapper.mkdir(zonePath, FsPermission.getDirDefault(), true);
        String testKey = "test_key";
        DFSTestUtil.createKey("test_key", this.cluster, this.conf);
        EnumSet<CreateEncryptionZoneFlag> noTrash = EnumSet.of(CreateEncryptionZoneFlag.NO_TRASH);
        this.dfsAdmin.createEncryptionZone(zonePath, "test_key", noTrash);
        Path fp = new Path(zonePath, "encFile");
        DFSTestUtil.createFile((FileSystem)this.fs, fp, 8192L, (short)1, 65262L);
        LocatedBlocks blocks = this.fs.getClient().getLocatedBlocks(fp.toString(), 0L);
        FileEncryptionInfo fei = blocks.getFileEncryptionInfo();
        Assert.assertEquals((Object)"test_key", (Object)fei.getKeyName());
        EncryptionZone ez = this.fs.getEZForPath(fp);
        Assert.assertEquals((Object)zonePath.toString(), (Object)ez.getPath());
        this.dfsAdmin.reencryptEncryptionZone(zonePath, HdfsConstants.ReencryptAction.START);
        Credentials creds = new Credentials();
        Token[] tokens = this.fs.addDelegationTokens("JobTracker", creds);
        Assert.assertEquals((long)1L, (long)tokens.length);
    }

    @Test
    public void testStoragePolicy() throws IOException {
        Path p = new Path("/storagePolicyTest");
        this.fs.mkdirs(p);
        Path sp = new Path(p, "/sp");
        try (FSDataOutputStream dos = this.fs.create(sp);){
            dos.writeBytes("create with some content");
        }
        BlockStoragePolicySuite suite = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy hot = suite.getPolicy("HOT");
        this.fs.setStoragePolicy(sp, hot.getName());
        Assert.assertEquals((Object)this.fs.getStoragePolicy(sp), (Object)hot);
        this.fs.unsetStoragePolicy(sp);
        Assert.assertEquals((Object)this.fs.getStoragePolicy(sp), (Object)hot);
    }

    @Test
    public void testAppend() throws IOException {
        Path p = new Path("/fileTest");
        this.fs.mkdirs(p);
        Path f = new Path("/fileTest/appendFile");
        try (FSDataOutputStream dos = this.fs.create(f);){
            dos.writeBytes("create with some content");
        }
        try {
            this.fs.append(f);
            Assert.fail((String)"append is not supported on erasure coded file");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testTruncate() throws IOException {
        Path p = new Path("/truncateTest");
        this.fs.mkdirs(p);
        Path f = new Path("/truncateTest/truncatefile");
        try (FSDataOutputStream dos = this.fs.create(f);){
            dos.writeBytes("create with some content");
        }
        try {
            this.fs.truncate(f, 0L);
            Assert.fail((String)"truncate is not supported on erasure coded file.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @After
    public void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }
}

