/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.net.PeerServer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.server.datanode.BlockReceiver;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiver;
import org.apache.hadoop.hdfs.server.datanode.DataXceiverServer;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class TestDataXceiverBackwardsCompat {
    @Rule
    public Timeout timeout = new Timeout(60000);

    private void failWithException(String message, Exception exception) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        exception.printStackTrace(new PrintStream(buffer));
        String stacktrace = buffer.toString();
        Assert.fail((String)(message + ": " + exception + "; " + exception.getMessage() + "\n" + stacktrace));
    }

    @Test
    public void testBackwardsCompat() throws Exception {
        Peer peer = (Peer)Mockito.mock(Peer.class);
        ((Peer)Mockito.doReturn((Object)"").when((Object)peer)).getRemoteAddressString();
        Configuration conf = new Configuration();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int port = ServerSocketUtil.getPort((int)1234, (int)10);
        NullDataNode dataNode = new NullDataNode(conf, out, port);
        DataXceiverServer server = new DataXceiverServer((PeerServer)Mockito.mock(PeerServer.class), conf, (DataNode)dataNode);
        DataXceiver xceiver = (DataXceiver)Mockito.spy((Object)DataXceiver.create((Peer)peer, (DataNode)dataNode, (DataXceiverServer)server));
        BlockReceiver mockBlockReceiver = (BlockReceiver)Mockito.mock(BlockReceiver.class);
        ((BlockReceiver)Mockito.doReturn((Object)Mockito.mock(Replica.class)).when((Object)mockBlockReceiver)).getReplica();
        DatanodeInfo[] targets = new DatanodeInfo[]{(DatanodeInfo)Mockito.mock(DatanodeInfo.class)};
        ((DatanodeInfo)Mockito.doReturn((Object)("localhost:" + port)).when((Object)targets[0])).getXferAddr(true);
        ((DatanodeInfo)Mockito.doReturn((Object)("127.0.0.1:" + port)).when((Object)targets[0])).getXferAddr(false);
        StorageType[] storageTypes = new StorageType[]{StorageType.RAM_DISK};
        ((DataXceiver)Mockito.doReturn((Object)mockBlockReceiver).when((Object)xceiver)).getBlockReceiver((ExtendedBlock)Mockito.any(ExtendedBlock.class), (StorageType)Mockito.any(StorageType.class), (DataInputStream)Mockito.any(DataInputStream.class), Mockito.anyString(), Mockito.anyString(), (BlockConstructionStage)Mockito.any(BlockConstructionStage.class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyString(), (DatanodeInfo)Mockito.any(DatanodeInfo.class), (DataNode)Mockito.any(DataNode.class), (DataChecksum)Mockito.any(DataChecksum.class), (CachingStrategy)Mockito.any(CachingStrategy.class), ((Boolean)ArgumentCaptor.forClass(Boolean.class).capture()).booleanValue(), Mockito.anyBoolean(), (String)Mockito.any(String.class));
        Token token = (Token)Mockito.mock(Token.class);
        ((Token)Mockito.doReturn((Object)"".getBytes()).when((Object)token)).getIdentifier();
        ((Token)Mockito.doReturn((Object)"".getBytes()).when((Object)token)).getPassword();
        ((Token)Mockito.doReturn((Object)new Text("")).when((Object)token)).getKind();
        ((Token)Mockito.doReturn((Object)new Text("")).when((Object)token)).getService();
        DataChecksum checksum = (DataChecksum)Mockito.mock(DataChecksum.class);
        ((DataChecksum)Mockito.doReturn((Object)DataChecksum.Type.NULL).when((Object)checksum)).getChecksumType();
        DatanodeInfo datanodeInfo = (DatanodeInfo)Mockito.mock(DatanodeInfo.class);
        ((DatanodeInfo)Mockito.doReturn((Object)"localhost").when((Object)datanodeInfo)).getHostName();
        ((DatanodeInfo)Mockito.doReturn((Object)"127.0.0.1").when((Object)datanodeInfo)).getIpAddr();
        ((DatanodeInfo)Mockito.doReturn((Object)DatanodeInfo.AdminStates.NORMAL).when((Object)datanodeInfo)).getAdminState();
        Exception storedException = null;
        try {
            xceiver.writeBlock(new ExtendedBlock("Dummy-pool", 0L), StorageType.RAM_DISK, token, "Dummy-Client", targets, storageTypes, datanodeInfo, BlockConstructionStage.PIPELINE_SETUP_CREATE, 0, 0L, 0L, 0L, checksum, CachingStrategy.newDefaultStrategy(), false, false, new boolean[0], null, new String[0]);
        }
        catch (Exception e) {
            storedException = e;
        }
        byte[] output = out.toByteArray();
        if (output.length == 0) {
            if (storedException == null) {
                this.failWithException("No output written, but no exception either (this shouldn't happen", storedException);
            } else {
                this.failWithException("Exception occurred before anything was written", storedException);
            }
        }
    }

    public class NullDataNode
    extends DataNode {
        public NullDataNode(Configuration conf, OutputStream out, int port) throws Exception {
            super(conf);
            this.data = (FsDatasetSpi)Mockito.mock(FsDatasetSpi.class);
            this.saslClient = (SaslDataTransferClient)Mockito.mock(SaslDataTransferClient.class);
            IOStreamPair pair = new IOStreamPair(null, out);
            ((SaslDataTransferClient)Mockito.doReturn((Object)pair).when((Object)this.saslClient)).socketSend((Socket)Mockito.any(Socket.class), (OutputStream)Mockito.any(OutputStream.class), (InputStream)Mockito.any(InputStream.class), (DataEncryptionKeyFactory)Mockito.any(DataEncryptionKeyFactory.class), (Token)Mockito.any(Token.class), (DatanodeID)Mockito.any(DatanodeID.class));
            ((FsDatasetSpi)Mockito.doReturn((Object)Mockito.mock(ReplicaHandler.class)).when((Object)this.data)).createTemporary((StorageType)Mockito.any(StorageType.class), (String)Mockito.any(String.class), (ExtendedBlock)Mockito.any(ExtendedBlock.class), Mockito.anyBoolean());
            new Thread(new NullServer(port)).start();
        }

        public DatanodeRegistration getDNRegistrationForBP(String bpid) throws IOException {
            return null;
        }

        public Socket newSocket() throws IOException {
            return new Socket();
        }

        private class NullServer
        implements Runnable {
            private ServerSocket serverSocket;

            NullServer(int port) throws IOException {
                this.serverSocket = new ServerSocket(port);
            }

            @Override
            public void run() {
                try {
                    this.serverSocket.accept();
                    this.serverSocket.close();
                    DataNode.LOG.info("Client connection accepted by NullServer");
                }
                catch (Exception e) {
                    DataNode.LOG.info("Exception in NullServer: " + e + "; " + e.getMessage());
                }
            }
        }
    }
}

