/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ShortCircuitRegistry;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaLruTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFsDatasetImpl {
    Logger LOG = LoggerFactory.getLogger(TestFsDatasetImpl.class);
    private static final String BASE_DIR = new FileSystemTestHelper().getTestRootDir();
    private static final int NUM_INIT_VOLUMES = 2;
    private static final String CLUSTER_ID = "cluser-id";
    private static final String[] BLOCK_POOL_IDS = new String[]{"bpid-0", "bpid-1"};
    private static final DataStorage dsForStorageUuid = new DataStorage(new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE));
    private Configuration conf;
    private DataNode datanode;
    private DataStorage storage;
    private FsDatasetImpl dataset;
    private static final String BLOCKPOOL = "BP-TEST";

    private static Storage.StorageDirectory createStorageDirectory(File root, Configuration conf) throws SecurityException, IOException {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(StorageLocation.parse((String)root.toURI().toString()));
        DataStorage.createStorageID((Storage.StorageDirectory)sd, (boolean)false, (Configuration)conf);
        return sd;
    }

    private static void createStorageDirs(DataStorage storage, Configuration conf, int numDirs) throws IOException {
        ArrayList<Storage.StorageDirectory> dirs = new ArrayList<Storage.StorageDirectory>();
        ArrayList<String> dirStrings = new ArrayList<String>();
        FileUtils.deleteDirectory((File)new File(BASE_DIR));
        for (int i = 0; i < numDirs; ++i) {
            File loc = new File(BASE_DIR + "/data" + i);
            dirStrings.add(new Path(loc.toString()).toUri().toString());
            loc.mkdirs();
            dirs.add(TestFsDatasetImpl.createStorageDirectory(loc, conf));
            Mockito.when((Object)storage.getStorageDir(i)).thenReturn(dirs.get(i));
        }
        String dataDir = StringUtils.join((CharSequence)",", dirStrings);
        conf.set("dfs.datanode.data.dir", dataDir);
        Mockito.when((Object)storage.dirIterator()).thenReturn(dirs.iterator());
        Mockito.when((Object)storage.getNumStorageDirs()).thenReturn((Object)numDirs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getNumVolumes() {
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            int n = volumes.size();
            return n;
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Before
    public void setUp() throws IOException {
        this.datanode = (DataNode)Mockito.mock(DataNode.class);
        this.storage = (DataStorage)Mockito.mock(DataStorage.class);
        this.conf = new Configuration();
        this.conf.setLong("dfs.datanode.scan.period.hours", 0L);
        Mockito.when((Object)this.datanode.getConf()).thenReturn((Object)this.conf);
        DNConf dnConf = new DNConf((Configurable)this.datanode);
        Mockito.when((Object)this.datanode.getDnConf()).thenReturn((Object)dnConf);
        BlockScanner disabledBlockScanner = new BlockScanner(this.datanode);
        Mockito.when((Object)this.datanode.getBlockScanner()).thenReturn((Object)disabledBlockScanner);
        ShortCircuitRegistry shortCircuitRegistry = new ShortCircuitRegistry(this.conf);
        Mockito.when((Object)this.datanode.getShortCircuitRegistry()).thenReturn((Object)shortCircuitRegistry);
        TestFsDatasetImpl.createStorageDirs(this.storage, this.conf, 2);
        this.dataset = new FsDatasetImpl(this.datanode, this.storage, this.conf);
        for (String bpid : BLOCK_POOL_IDS) {
            this.dataset.addBlockPool(bpid, this.conf);
        }
        Assert.assertEquals((long)2L, (long)this.getNumVolumes());
        Assert.assertEquals((long)0L, (long)this.dataset.getNumFailedVolumes());
    }

    @Test
    public void testAddVolumes() throws IOException {
        int numNewVolumes = 3;
        int numExistingVolumes = this.getNumVolumes();
        int totalVolumes = 3 + numExistingVolumes;
        HashSet<String> expectedVolumes = new HashSet<String>();
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        for (int i = 0; i < 3; ++i) {
            String path = BASE_DIR + "/newData" + i;
            String pathUri = new Path(path).toUri().toString();
            expectedVolumes.add(new File(pathUri).getAbsolutePath());
            StorageLocation loc = StorageLocation.parse((String)pathUri);
            Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(path), this.conf);
            DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
            Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (StorageLocation)Matchers.eq((Object)loc), Matchers.anyListOf(NamespaceInfo.class))).thenReturn((Object)builder);
            this.dataset.addVolume(loc, (List)nsInfos);
            this.LOG.info("expectedVolumes " + i + " is " + new File(pathUri).getAbsolutePath());
        }
        Assert.assertEquals((long)totalVolumes, (long)this.getNumVolumes());
        Assert.assertEquals((long)totalVolumes, (long)this.dataset.storageMap.size());
        HashSet<String> actualVolumes = new HashSet<String>();
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            for (int i = 0; i < 3; ++i) {
                String volumeName = volumes.get(numExistingVolumes + i).toString();
                actualVolumes.add(volumeName);
                this.LOG.info("actualVolume " + i + " is " + volumeName);
            }
        }
        Assert.assertEquals((long)actualVolumes.size(), (long)expectedVolumes.size());
        Assert.assertTrue((boolean)actualVolumes.containsAll(expectedVolumes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddVolumeWithSameStorageUuid() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            Assert.assertTrue((boolean)cluster.getDataNodes().get(0).isConnectedToNN(cluster.getNameNode().getServiceRpcAddress()));
            MiniDFSCluster.DataNodeProperties dn = cluster.stopDataNode(0);
            File vol0 = cluster.getStorageDir(0, 0);
            File vol1 = cluster.getStorageDir(0, 1);
            Storage.StorageDirectory sd0 = new Storage.StorageDirectory(vol0);
            Storage.StorageDirectory sd1 = new Storage.StorageDirectory(vol1);
            FileUtils.copyFile((File)sd0.getVersionFile(), (File)sd1.getVersionFile());
            cluster.restartDataNode(dn, true);
            cluster.waitActive();
            Assert.assertFalse((boolean)cluster.getDataNodes().get(0).isConnectedToNN(cluster.getNameNode().getServiceRpcAddress()));
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test(timeout=30000L)
    public void testRemoveVolumes() throws IOException {
        int NUM_BLOCKS = 100;
        for (int i = 0; i < 100; ++i) {
            String bpid = BLOCK_POOL_IDS[100 % BLOCK_POOL_IDS.length];
            ExtendedBlock eb = new ExtendedBlock(bpid, (long)i);
            ReplicaHandler replica = this.dataset.createRbw(StorageType.DEFAULT, null, eb, false);
            Throwable throwable = null;
            if (replica == null) continue;
            if (throwable != null) {
                try {
                    replica.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                continue;
            }
            replica.close();
        }
        String[] dataDirs = this.conf.get("dfs.datanode.data.dir").split(",");
        String volumePathToRemove = dataDirs[0];
        HashSet<StorageLocation> volumesToRemove = new HashSet<StorageLocation>();
        volumesToRemove.add(StorageLocation.parse((String)volumePathToRemove));
        FsDatasetSpi.FsVolumeReferences volReferences = this.dataset.getFsVolumeReferences();
        FsVolumeImpl volumeToRemove = null;
        for (FsVolumeSpi vol : volReferences) {
            if (!vol.getStorageLocation().equals(volumesToRemove.iterator().next())) continue;
            volumeToRemove = (FsVolumeImpl)vol;
        }
        Assert.assertTrue((volumeToRemove != null ? 1 : 0) != 0);
        volReferences.close();
        this.dataset.removeVolumes(volumesToRemove, true);
        int expectedNumVolumes = dataDirs.length - 1;
        Assert.assertEquals((String)"The volume has been removed from the volumeList.", (long)expectedNumVolumes, (long)this.getNumVolumes());
        Assert.assertEquals((String)"The volume has been removed from the storageMap.", (long)expectedNumVolumes, (long)this.dataset.storageMap.size());
        try {
            this.dataset.asyncDiskService.execute(volumeToRemove, new Runnable(){

                @Override
                public void run() {
                }
            });
            Assert.fail((String)"Expect RuntimeException: the volume has been removed from the AsyncDiskService.");
        }
        catch (RuntimeException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot find volume", (Throwable)e);
        }
        int totalNumReplicas = 0;
        for (String bpid : this.dataset.volumeMap.getBlockPoolList()) {
            totalNumReplicas += this.dataset.volumeMap.size(bpid);
        }
        Assert.assertEquals((String)"The replica infos on this volume has been removed from the volumeMap.", (long)50L, (long)totalNumReplicas);
    }

    @Test(timeout=5000L)
    public void testRemoveNewlyAddedVolume() throws IOException {
        int numExistingVolumes = this.getNumVolumes();
        ArrayList<NamespaceInfo> nsInfos = new ArrayList<NamespaceInfo>();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        String newVolumePath = BASE_DIR + "/newVolumeToRemoveLater";
        StorageLocation loc = StorageLocation.parse((String)newVolumePath);
        Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(newVolumePath), this.conf);
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
        Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (StorageLocation)Matchers.eq((Object)loc), Matchers.anyListOf(NamespaceInfo.class))).thenReturn((Object)builder);
        this.dataset.addVolume(loc, nsInfos);
        Assert.assertEquals((long)(numExistingVolumes + 1), (long)this.getNumVolumes());
        Mockito.when((Object)this.storage.getNumStorageDirs()).thenReturn((Object)(numExistingVolumes + 1));
        Mockito.when((Object)this.storage.getStorageDir(numExistingVolumes)).thenReturn((Object)sd);
        HashSet<StorageLocation> volumesToRemove = new HashSet<StorageLocation>();
        volumesToRemove.add(loc);
        this.dataset.removeVolumes(volumesToRemove, true);
        Assert.assertEquals((long)numExistingVolumes, (long)this.getNumVolumes());
    }

    @Test
    public void testAddVolumeFailureReleasesInUseLock() throws IOException {
        FsDatasetImpl spyDataset = (FsDatasetImpl)Mockito.spy((Object)this.dataset);
        FsVolumeImpl mockVolume = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        File badDir = new File(BASE_DIR, "bad");
        badDir.mkdirs();
        ((FsDatasetImpl)Mockito.doReturn((Object)mockVolume).when((Object)spyDataset)).createFsVolume(Matchers.anyString(), (Storage.StorageDirectory)Matchers.any(Storage.StorageDirectory.class), (StorageLocation)Matchers.any(StorageLocation.class));
        ((FsVolumeImpl)Mockito.doThrow((Throwable)new IOException("Failed to getVolumeMap()")).when((Object)mockVolume)).getVolumeMap(Matchers.anyString(), (ReplicaMap)Matchers.any(ReplicaMap.class), (RamDiskReplicaTracker)Matchers.any(RamDiskReplicaLruTracker.class));
        Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(badDir, this.conf);
        sd.lock();
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
        Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (StorageLocation)Matchers.eq((Object)StorageLocation.parse((String)badDir.toURI().toString())), (List)Matchers.any())).thenReturn((Object)builder);
        StorageLocation location = StorageLocation.parse((String)badDir.toString());
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        try {
            spyDataset.addVolume(location, (List)nsInfos);
            Assert.fail((String)"Expect to throw MultipleIOException");
        }
        catch (MultipleIOException multipleIOException) {
            // empty catch block
        }
        FsDatasetTestUtil.assertFileLockReleased(badDir.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeletingBlocks() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            ExtendedBlock eb;
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetSpi<?> ds = DataNodeTestUtils.getFSDataset(dn);
            ds.addBlockPool(BLOCKPOOL, (Configuration)conf);
            try (FsDatasetSpi.FsVolumeReferences volumes = ds.getFsVolumeReferences();){
                FsVolumeImpl vol = (FsVolumeImpl)volumes.get(0);
            }
            ArrayList<Block> blockList = new ArrayList<Block>();
            for (int i = 1; i <= 63; ++i) {
                eb = new ExtendedBlock(BLOCKPOOL, (long)i, 1L, (long)(1000 + i));
                cluster.getFsDatasetTestUtils(0).createFinalizedReplica(eb);
                blockList.add(eb.getLocalBlock());
            }
            ds.invalidate(BLOCKPOOL, blockList.toArray(new Block[0]));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)ds.isDeletingBlock(BLOCKPOOL, ((Block)blockList.get(0)).getBlockId()));
            blockList.clear();
            eb = new ExtendedBlock(BLOCKPOOL, 64L, 1L, 1064L);
            cluster.getFsDatasetTestUtils(0).createFinalizedReplica(eb);
            blockList.add(eb.getLocalBlock());
            ds.invalidate(BLOCKPOOL, blockList.toArray(new Block[0]));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)ds.isDeletingBlock(BLOCKPOOL, ((Block)blockList.get(0)).getBlockId()));
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testDuplicateReplicaResolution() throws IOException {
        FsVolumeImpl fsv1 = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        FsVolumeImpl fsv2 = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        File f1 = new File("d1/block");
        File f2 = new File("d2/block");
        FinalizedReplica replicaOlder = new FinalizedReplica(1L, 1L, 1L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replica = new FinalizedReplica(1L, 2L, 2L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replicaSame = new FinalizedReplica(1L, 2L, 2L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replicaNewer = new FinalizedReplica(1L, 3L, 3L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replicaOtherOlder = new FinalizedReplica(1L, 1L, 1L, (FsVolumeSpi)fsv2, f2);
        FinalizedReplica replicaOtherSame = new FinalizedReplica(1L, 2L, 2L, (FsVolumeSpi)fsv2, f2);
        FinalizedReplica replicaOtherNewer = new FinalizedReplica(1L, 3L, 3L, (FsVolumeSpi)fsv2, f2);
        Assert.assertNull((Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaSame, (ReplicaInfo)replica));
        Assert.assertNull((Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOlder, (ReplicaInfo)replica));
        Assert.assertNull((Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaNewer, (ReplicaInfo)replica));
        Assert.assertSame((Object)replica, (Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOtherSame, (ReplicaInfo)replica));
        Assert.assertSame((Object)replicaOtherOlder, (Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOtherOlder, (ReplicaInfo)replica));
        Assert.assertSame((Object)replica, (Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOtherNewer, (ReplicaInfo)replica));
    }

    @Test
    public void testLoadingDfsUsedForVolumes() throws IOException, InterruptedException {
        long waitIntervalTime = 5000L;
        long cachedDfsUsedIntervalTime = waitIntervalTime + 1000L;
        this.conf.setLong("dfs.datanode.cached-dfsused.check.interval.ms", cachedDfsUsedIntervalTime);
        long cacheDfsUsed = 1024L;
        long dfsUsed = this.getDfsUsedValueOfNewVolume(cacheDfsUsed, waitIntervalTime);
        Assert.assertEquals((long)cacheDfsUsed, (long)dfsUsed);
    }

    @Test
    public void testLoadingDfsUsedForVolumesExpired() throws IOException, InterruptedException {
        long waitIntervalTime = 5000L;
        long cachedDfsUsedIntervalTime = waitIntervalTime - 1000L;
        this.conf.setLong("dfs.datanode.cached-dfsused.check.interval.ms", cachedDfsUsedIntervalTime);
        long cacheDfsUsed = 1024L;
        long dfsUsed = this.getDfsUsedValueOfNewVolume(cacheDfsUsed, waitIntervalTime);
        Assert.assertTrue((cacheDfsUsed != dfsUsed ? 1 : 0) != 0);
    }

    private long getDfsUsedValueOfNewVolume(long cacheDfsUsed, long waitIntervalTime) throws IOException, InterruptedException {
        FsVolumeImpl newVolume;
        ArrayList nsInfos = Lists.newArrayList();
        nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, BLOCK_POOL_IDS[0], 1L));
        String CURRENT_DIR = "current";
        String DU_CACHE_FILE = "dfsUsed";
        String path = BASE_DIR + "/newData0";
        String pathUri = new Path(path).toUri().toString();
        StorageLocation loc = StorageLocation.parse((String)pathUri);
        Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(path), this.conf);
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
        Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (StorageLocation)Matchers.eq((Object)loc), Matchers.anyListOf(NamespaceInfo.class))).thenReturn((Object)builder);
        String cacheFilePath = String.format("%s/%s/%s/%s/%s", path, CURRENT_DIR, BLOCK_POOL_IDS[0], CURRENT_DIR, DU_CACHE_FILE);
        File outFile = new File(cacheFilePath);
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        FakeTimer timer = new FakeTimer();
        try (OutputStreamWriter out2 = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8);){
            out2.write(Long.toString(cacheDfsUsed) + " " + Long.toString(timer.now()));
            ((Writer)out2).flush();
        }
        catch (IOException out2) {
            // empty catch block
        }
        this.dataset.setTimer((Timer)timer);
        timer.advance(waitIntervalTime);
        this.dataset.addVolume(loc, (List)nsInfos);
        try (FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();){
            newVolume = (FsVolumeImpl)volumes.get(volumes.size() - 1);
        }
        long dfsUsed = newVolume.getDfsUsed();
        return dfsUsed;
    }

    @Test(timeout=60000L)
    public void testRemoveVolumeBeingWritten() throws Exception {
        final ExtendedBlock eb = new ExtendedBlock(BLOCK_POOL_IDS[0], 0L);
        final CountDownLatch startFinalizeLatch = new CountDownLatch(1);
        final CountDownLatch blockReportReceivedLatch = new CountDownLatch(1);
        final CountDownLatch volRemoveStartedLatch = new CountDownLatch(1);
        final CountDownLatch volRemoveCompletedLatch = new CountDownLatch(1);
        class ResponderThread
        extends Thread {
            ResponderThread() {
            }

            @Override
            public void run() {
                try (ReplicaHandler replica = TestFsDatasetImpl.this.dataset.createRbw(StorageType.DEFAULT, null, eb, false);){
                    TestFsDatasetImpl.this.LOG.info("CreateRbw finished");
                    startFinalizeLatch.countDown();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        TestFsDatasetImpl.this.LOG.info("Ignoring ", (Throwable)ie);
                    }
                    blockReportReceivedLatch.await();
                    TestFsDatasetImpl.this.dataset.finalizeBlock(eb, false);
                    TestFsDatasetImpl.this.LOG.info("FinalizeBlock finished");
                }
                catch (Exception e) {
                    TestFsDatasetImpl.this.LOG.warn("Exception caught. This should not affect the test", (Throwable)e);
                }
            }
        }
        ResponderThread responderThread = new ResponderThread();
        responderThread.start();
        startFinalizeLatch.await();
        class BlockReportThread
        extends Thread {
            BlockReportThread() {
            }

            @Override
            public void run() {
                try {
                    volRemoveStartedLatch.await();
                }
                catch (Exception e) {
                    TestFsDatasetImpl.this.LOG.info("Unexpected exception when waiting for vol removal:", (Throwable)e);
                }
                TestFsDatasetImpl.this.LOG.info("Getting block report");
                TestFsDatasetImpl.this.dataset.getBlockReports(eb.getBlockPoolId());
                TestFsDatasetImpl.this.LOG.info("Successfully received block report");
                blockReportReceivedLatch.countDown();
            }
        }
        BlockReportThread blockReportThread = new BlockReportThread();
        blockReportThread.start();
        class VolRemoveThread
        extends Thread {
            VolRemoveThread() {
            }

            @Override
            public void run() {
                HashSet<StorageLocation> volumesToRemove = new HashSet<StorageLocation>();
                try {
                    volumesToRemove.add(TestFsDatasetImpl.this.dataset.getVolume(eb).getStorageLocation());
                }
                catch (Exception e) {
                    TestFsDatasetImpl.this.LOG.info("Problem preparing volumes to remove: ", (Throwable)e);
                    Assert.fail((String)"Exception in remove volume thread, check log for details.");
                }
                TestFsDatasetImpl.this.LOG.info("Removing volume " + volumesToRemove);
                TestFsDatasetImpl.this.dataset.removeVolumes(volumesToRemove, true);
                volRemoveCompletedLatch.countDown();
                TestFsDatasetImpl.this.LOG.info("Removed volume " + volumesToRemove);
            }
        }
        VolRemoveThread volRemoveThread = new VolRemoveThread();
        volRemoveThread.start();
        Thread.sleep(2000L);
        volRemoveStartedLatch.countDown();
        blockReportReceivedLatch.await();
        volRemoveCompletedLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanShutdownOfVolume() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration config = new HdfsConfiguration();
            config.setLong("dfs.datanode.xceiver.stop.timeout.millis", 1000L);
            config.setTimeDuration("dfs.datanode.disk.check.min.gap", 0L, TimeUnit.MILLISECONDS);
            config.setInt("dfs.datanode.failed.volumes.tolerated", 1);
            cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path("test.dat");
            FSDataOutputStream out = fs.create(filePath, (short)1);
            out.write(1);
            out.hflush();
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            final FsVolumeImpl volume = (FsVolumeImpl)dataNode.getFSDataset().getVolume(block);
            File finalizedDir = volume.getFinalizedDir(cluster.getNamesystem().getBlockPoolId());
            LocatedBlock lb = DFSTestUtil.getAllBlocks((FileSystem)fs, filePath).get(0);
            DatanodeInfo info = lb.getLocations()[0];
            if (finalizedDir.exists()) {
                finalizedDir.setExecutable(false);
                finalizedDir.setWritable(false);
            }
            Assert.assertTrue((String)"Reference count for the volume should be greater than 0", (volume.getReferenceCount() > 0 ? 1 : 0) != 0);
            dataNode.checkDiskError();
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return volume.getReferenceCount() == 0;
                }
            }, (int)100, (int)1000);
            Assert.assertThat((Object)dataNode.getFSDataset().getNumFailedVolumes(), (Matcher)Is.is((Object)1));
            try {
                out.close();
                Assert.fail((String)"This is not a valid code path. out.close should have thrown an exception.");
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)info.getXferAddr(), (Throwable)ioe);
            }
            finalizedDir.setWritable(true);
            finalizedDir.setExecutable(true);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testReportBadBlocks() throws Exception {
        boolean threwException = false;
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration config = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();
            cluster.waitActive();
            Assert.assertEquals((long)0L, (long)cluster.getNamesystem().getCorruptReplicaBlocks());
            DataNode dataNode = cluster.getDataNodes().get(0);
            ExtendedBlock block = new ExtendedBlock(cluster.getNamesystem().getBlockPoolId(), 0L);
            try {
                dataNode.reportBadBlocks(block);
            }
            catch (NullPointerException npe) {
                threwException = true;
            }
            Thread.sleep(3000L);
            Assert.assertFalse((boolean)threwException);
            Assert.assertEquals((long)0L, (long)cluster.getNamesystem().getCorruptReplicaBlocks());
            DistributedFileSystem fs = cluster.getFileSystem();
            Path filePath = new Path("testData");
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)1, 0L);
            block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            dataNode.reportBadBlocks(block, dataNode.getFSDataset().getFsVolumeReferences().get(0));
            Thread.sleep(3000L);
            BlockManagerTestUtil.updateState(cluster.getNamesystem().getBlockManager());
            Assert.assertEquals((long)1L, (long)cluster.getNamesystem().getCorruptReplicaBlocks());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testMoveBlockFailure() {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.DISK}).storagesPerDatanode(2).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path("testData");
            DFSTestUtil.createFile((FileSystem)fs, filePath, 100L, (short)1, 0L);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            FsDatasetImpl fsDataSetImpl = (FsDatasetImpl)dataNode.getFSDataset();
            ReplicaInfo newReplicaInfo = this.createNewReplicaObj(block, fsDataSetImpl);
            FSDataOutputStream out = fs.append(filePath, 1);
            out.write(100);
            out.hflush();
            this.LOG.info("GenerationStamp of old replica: {}", (Object)block.getGenerationStamp());
            this.LOG.info("GenerationStamp of new replica: {}", (Object)fsDataSetImpl.getReplicaInfo(block.getBlockPoolId(), newReplicaInfo.getBlockId()).getGenerationStamp());
            LambdaTestUtils.intercept(IOException.class, (String)"Generation Stamp should be monotonically increased.", () -> fsDataSetImpl.finalizeNewReplica(newReplicaInfo, block));
        }
        catch (Exception ex) {
            this.LOG.info("Exception in testMoveBlockFailure ", (Throwable)ex);
            Assert.fail((String)"Exception while testing testMoveBlockFailure ");
        }
        finally {
            if (cluster.isClusterUp()) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testMoveBlockSuccess() {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.DISK}).storagesPerDatanode(2).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNode dataNode = cluster.getDataNodes().get(0);
            Path filePath = new Path("testData");
            DFSTestUtil.createFile((FileSystem)fs, filePath, 100L, (short)1, 0L);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            FsDatasetImpl fsDataSetImpl = (FsDatasetImpl)dataNode.getFSDataset();
            ReplicaInfo newReplicaInfo = this.createNewReplicaObj(block, fsDataSetImpl);
            fsDataSetImpl.finalizeNewReplica(newReplicaInfo, block);
        }
        catch (Exception ex) {
            this.LOG.info("Exception in testMoveBlockSuccess ", (Throwable)ex);
            Assert.fail((String)"MoveBlock operation should succeed");
        }
        finally {
            if (cluster.isClusterUp()) {
                cluster.shutdown();
            }
        }
    }

    private ReplicaInfo createNewReplicaObj(ExtendedBlock block, FsDatasetImpl fsDataSetImpl) throws IOException {
        ReplicaInfo replicaInfo = fsDataSetImpl.getReplicaInfo(block);
        FsVolumeSpi destVolume = null;
        String srcStorageId = fsDataSetImpl.getVolume(block).getStorageID();
        try (FsDatasetSpi.FsVolumeReferences volumeReferences = fsDataSetImpl.getFsVolumeReferences();){
            for (int i = 0; i < volumeReferences.size(); ++i) {
                if (volumeReferences.get(i).getStorageID().equals(srcStorageId)) continue;
                destVolume = volumeReferences.get(i);
                break;
            }
        }
        return fsDataSetImpl.copyReplicaToVolume(block, replicaInfo, destVolume.obtainReference());
    }
}

