/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.net.NetUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOfflineImageViewerForXAttr {
    private static final Log LOG = LogFactory.getLog(TestOfflineImageViewerForXAttr.class);
    private static File originalFsimage = null;
    static String attr1JSon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void createOriginalFSImage() throws IOException {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            Path dir = new Path("/dir1");
            hdfs.mkdirs(dir);
            hdfs.setXAttr(dir, "user.attr1", "value1".getBytes());
            hdfs.setXAttr(dir, "user.attr2", "value2".getBytes());
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            hdfs.saveNamespace();
            ArrayList<XAttr> attributes = new ArrayList<XAttr>();
            attributes.add(XAttrHelper.buildXAttr((String)"user.attr1", (byte[])"value1".getBytes()));
            attr1JSon = JsonUtil.toJsonString(attributes, null);
            attributes.add(XAttrHelper.buildXAttr((String)"user.attr2", (byte[])"value2".getBytes()));
            originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (originalFsimage == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
            LOG.debug((Object)("original FS image file is " + originalFsimage));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void deleteOriginalFSImage() throws IOException {
        if (originalFsimage != null && originalFsimage.exists()) {
            originalFsimage.delete();
        }
    }

    @Test
    public void testWebImageViewerForListXAttrs() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/dir1/?op=LISTXATTRS");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)200L, (long)connection.getResponseCode());
            String content = IOUtils.toString((InputStream)connection.getInputStream());
            Assert.assertTrue((String)"Missing user.attr1 in response ", (boolean)content.contains("user.attr1"));
            Assert.assertTrue((String)"Missing user.attr2 in response ", (boolean)content.contains("user.attr2"));
        }
    }

    @Test
    public void testWebImageViewerForGetXAttrsWithOutParameters() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/dir1/?op=GETXATTRS");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)200L, (long)connection.getResponseCode());
            String content = IOUtils.toString((InputStream)connection.getInputStream());
            Assert.assertTrue((String)"Missing user.attr1 in response ", (boolean)content.contains("user.attr1"));
            Assert.assertTrue((String)"Missing user.attr2 in response ", (boolean)content.contains("user.attr2"));
        }
    }

    @Test
    public void testWebImageViewerForGetXAttrsWithParameters() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/dir1/?op=GETXATTRS&xattr.name=attr8");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)400L, (long)connection.getResponseCode());
            url = new URL("http://localhost:" + port + "/webhdfs/v1/dir1/?op=GETXATTRS&xattr.name=user.attr1");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)200L, (long)connection.getResponseCode());
            String content = IOUtils.toString((InputStream)connection.getInputStream());
            Assert.assertEquals((Object)attr1JSon, (Object)content);
        }
    }

    @Test
    public void testWebImageViewerForGetXAttrsWithCodecParameters() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/dir1/?op=GETXATTRS&xattr.name=USER.attr1&encoding=TEXT");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)200L, (long)connection.getResponseCode());
            String content = IOUtils.toString((InputStream)connection.getInputStream());
            Assert.assertEquals((Object)attr1JSon, (Object)content);
        }
    }

    @Test
    public void testWithWebHdfsFileSystem() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URI uri = new URI("webhdfs://localhost:" + String.valueOf(port));
            Configuration conf = new Configuration();
            WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            List names = webhdfs.listXAttrs(new Path("/dir1"));
            Assert.assertTrue((boolean)names.contains("user.attr1"));
            Assert.assertTrue((boolean)names.contains("user.attr2"));
            String value = new String(webhdfs.getXAttr(new Path("/dir1"), "user.attr1"));
            Assert.assertEquals((Object)"value1", (Object)value);
            value = new String(webhdfs.getXAttr(new Path("/dir1"), "USER.attr1"));
            Assert.assertEquals((Object)"value1", (Object)value);
            Map contentMap = webhdfs.getXAttrs(new Path("/dir1"), names);
            Assert.assertEquals((Object)"value1", (Object)new String((byte[])contentMap.get("user.attr1")));
            Assert.assertEquals((Object)"value2", (Object)new String((byte[])contentMap.get("user.attr2")));
        }
    }

    @Test
    public void testResponseCode() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/dir1/?op=GETXATTRS&xattr.name=user.notpresent&encoding=TEXT");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            Assert.assertEquals((long)403L, (long)connection.getResponseCode());
        }
    }
}

