/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Test;

public class TestLargeBlock {
    private static final Log LOG = LogFactory.getLog(TestLargeBlock.class);
    static final boolean verifyData = true;
    static final byte[] pattern = new byte[]{68, 69, 65, 68, 66, 69, 69, 70};
    static final int numDatanodes = 3;

    static FSDataOutputStream createFile(FileSystem fileSys, Path name, int repl, long blockSize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, blockSize);
        LOG.info((Object)("createFile: Created " + name + " with " + repl + " replica."));
        return stm;
    }

    static void writeFile(FSDataOutputStream stm, long fileSize) throws IOException {
        int writeSize = pattern.length * 8 * 1024 * 1024;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IOException("A single write is too large " + writeSize);
        }
        long bytesToWrite = fileSize;
        byte[] b = new byte[writeSize];
        for (int j = 0; j < writeSize; ++j) {
            b[j] = pattern[j % pattern.length];
        }
        while (bytesToWrite > 0L) {
            int thiswrite = (int)Math.min((long)writeSize, bytesToWrite);
            stm.write(b, 0, thiswrite);
            bytesToWrite -= (long)thiswrite;
        }
    }

    static void checkFullFile(FileSystem fs, Path name, long fileSize) throws IOException {
        int readSize = pattern.length * 16 * 1024 * 1024;
        if (readSize > Integer.MAX_VALUE) {
            throw new IOException("A single read is too large " + readSize);
        }
        byte[] b = new byte[readSize];
        long bytesToRead = fileSize;
        byte[] compb = new byte[readSize];
        for (int j = 0; j < readSize; ++j) {
            compb[j] = pattern[j % pattern.length];
        }
        FSDataInputStream stm = fs.open(name);
        while (bytesToRead > 0L) {
            int thisread = (int)Math.min((long)readSize, bytesToRead);
            stm.readFully(b, 0, thisread);
            if (thisread == readSize) {
                Assert.assertTrue((String)("file is corrupted at or after byte " + (fileSize - bytesToRead)), (boolean)Arrays.equals(b, compb));
            } else {
                for (int k = 0; k < thisread; ++k) {
                    Assert.assertTrue((String)("file is corrupted at or after byte " + (fileSize - bytesToRead)), (b[k] == compb[k] ? 1 : 0) != 0);
                }
            }
            LOG.debug((Object)("Before update: to read: " + bytesToRead + "; read already: " + thisread));
            LOG.debug((Object)("After  update: to read: " + (bytesToRead -= (long)thisread) + "; read already: " + thisread));
        }
        stm.close();
    }

    @Test(timeout=1800000L)
    public void testLargeBlockSize() throws IOException {
        long blockSize = 0x80000200L;
        this.runTest(0x80000200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(long blockSize) throws IOException {
        long fileSize = blockSize + 1L;
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path file1 = new Path("/tmp/TestLargeBlock", blockSize + ".dat");
            FSDataOutputStream stm = TestLargeBlock.createFile((FileSystem)fs, file1, 1, blockSize);
            LOG.info((Object)("File " + file1 + " created with file size " + fileSize + " blocksize " + blockSize));
            Assert.assertTrue((String)(file1 + " should be a file"), (boolean)fs.getFileStatus(file1).isFile());
            TestLargeBlock.writeFile(stm, fileSize);
            LOG.info((Object)("File " + file1 + " written to."));
            stm.close();
            LOG.info((Object)("File " + file1 + " closed."));
            TestLargeBlock.checkFullFile((FileSystem)fs, file1, fileSize);
            long len = fs.getFileStatus(file1).getLen();
            Assert.assertTrue((String)(file1 + " should be of size " + fileSize + " but found to be of size " + len), (len == fileSize ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }
}

