/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections.list.TreeList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.client.impl.SnapshotDiffReportGenerator;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotDiffInfo;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSnapshotDiffReport {
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotDiffReport.class);
    private static final long SEED = 0L;
    private static final short REPLICATION = 3;
    private static final short REPLICATION_1 = 2;
    private static final long BLOCKSIZE = 1024L;
    private static final long BUFFERLEN = 512L;
    private static final long FILELEN = 2048L;
    private final Path dir = new Path("/TestSnapshot");
    private final Path sub1 = new Path(this.dir, "sub1");
    protected Configuration conf;
    protected MiniDFSCluster cluster;
    protected DistributedFileSystem hdfs;
    private final HashMap<Path, Integer> snapshotNumberMap = new HashMap();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setBoolean("dfs.namenode.snapshot.capture.openfiles", true);
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setBoolean("dfs.namenode.snapshot.skip.capture.accesstime-only-change", true);
        this.conf.setBoolean("dfs.namenode.snapshotdiff.allow.snap-root-descendant", true);
        this.conf.setInt("dfs.namenode.snapshotdiff.listing.limit", 3);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).format(true).build();
        this.cluster.waitActive();
        this.hdfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    protected Path getSnapRootDir() {
        return this.sub1;
    }

    private String genSnapshotName(Path snapshotDir) {
        int sNum = -1;
        if (this.snapshotNumberMap.containsKey(snapshotDir)) {
            sNum = this.snapshotNumberMap.get(snapshotDir);
        }
        this.snapshotNumberMap.put(snapshotDir, ++sNum);
        return "s" + sNum;
    }

    protected void modifyAndCreateSnapshot(Path modifyDir, Path[] snapshotDirs) throws Exception {
        Path file10 = new Path(modifyDir, "file10");
        Path file11 = new Path(modifyDir, "file11");
        Path file12 = new Path(modifyDir, "file12");
        Path file13 = new Path(modifyDir, "file13");
        Path link13 = new Path(modifyDir, "link13");
        Path file14 = new Path(modifyDir, "file14");
        Path file15 = new Path(modifyDir, "file15");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file10, 1024L, (short)2, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file11, 1024L, (short)2, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file12, 1024L, (short)2, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file13, 1024L, (short)2, 0L);
        this.hdfs.createSymlink(file13, link13, false);
        for (Path snapshotDir : snapshotDirs) {
            this.hdfs.allowSnapshot(snapshotDir);
            this.hdfs.createSnapshot(snapshotDir, this.genSnapshotName(snapshotDir));
        }
        this.hdfs.delete(file11, true);
        this.hdfs.setReplication(file12, (short)3);
        this.hdfs.setReplication(file13, (short)3);
        this.hdfs.delete(link13, false);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file14, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, file15, 1024L, (short)3, 0L);
        for (Path snapshotDir : snapshotDirs) {
            this.hdfs.createSnapshot(snapshotDir, this.genSnapshotName(snapshotDir));
        }
        DFSTestUtil.createFile((FileSystem)this.hdfs, file11, 1024L, (short)3, 0L);
        this.hdfs.delete(file12, true);
        this.hdfs.setReplication(file13, (short)1);
        this.hdfs.createSymlink(file13, link13, false);
        this.hdfs.delete(file14, true);
        this.hdfs.setReplication(file15, (short)2);
        for (Path snapshotDir : snapshotDirs) {
            this.hdfs.createSnapshot(snapshotDir, this.genSnapshotName(snapshotDir));
        }
        this.hdfs.setReplication(file10, (short)4);
    }

    private void verifyDiffReport(Path dir, String from, String to, SnapshotDiffReport.DiffReportEntry ... entries) throws IOException {
        DFSTestUtil.verifySnapshotDiffReport(this.hdfs, dir, from, to, entries);
    }

    @Test(timeout=60000L)
    public void testDiffReport() throws Exception {
        this.cluster.getNamesystem().getSnapshotManager().setAllowNestedSnapshots(true);
        Path subsub1 = new Path(this.sub1, "subsub1");
        Path subsubsub1 = new Path(subsub1, "subsubsub1");
        this.hdfs.mkdirs(subsubsub1);
        this.modifyAndCreateSnapshot(this.sub1, new Path[]{this.sub1, subsubsub1});
        this.modifyAndCreateSnapshot(subsubsub1, new Path[]{this.sub1, subsubsub1});
        String invalidName = "invalid";
        try {
            this.hdfs.getSnapshotDiffReport(this.sub1, "invalid", "invalid");
            Assert.fail((String)"Expect exception when providing invalid snapshot name for diff report");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Cannot find the snapshot of directory " + this.sub1 + " with name " + "invalid"), (Throwable)e);
        }
        SnapshotDiffReport report = this.hdfs.getSnapshotDiffReport(this.sub1, "s0", "s0");
        LOG.info(report.toString());
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        report = this.hdfs.getSnapshotDiffReport(this.sub1, "", "");
        LOG.info(report.toString());
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        report = this.hdfs.getSnapshotDiffReport(subsubsub1, "s0", "s2");
        LOG.info(report.toString());
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        report = this.hdfs.getSnapshotDiffReport(this.hdfs.makeQualified(subsubsub1), "s0", "s2");
        LOG.info(report.toString());
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        this.verifyDiffReport(this.sub1, "s0", "s2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"link13")));
        this.verifyDiffReport(this.sub1, "s0", "s5", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file15")));
        this.verifyDiffReport(this.sub1, "s2", "s5", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file15")));
        this.verifyDiffReport(this.sub1, "s3", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/link13")));
    }

    @Test(timeout=60000L)
    public void testSnapRootDescendantDiffReport() throws Exception {
        Assume.assumeTrue((boolean)this.conf.getBoolean("dfs.namenode.snapshotdiff.allow.snap-root-descendant", true));
        Path subSub = new Path(this.sub1, "subsub1");
        Path subSubSub = new Path(subSub, "subsubsub1");
        Path nonSnapDir = new Path(this.dir, "non_snap");
        this.hdfs.mkdirs(subSubSub);
        this.hdfs.mkdirs(nonSnapDir);
        this.modifyAndCreateSnapshot(this.sub1, new Path[]{this.sub1});
        this.modifyAndCreateSnapshot(subSub, new Path[]{this.sub1});
        this.modifyAndCreateSnapshot(subSubSub, new Path[]{this.sub1});
        try {
            this.hdfs.getSnapshotDiffReport(subSub, "s1", "s2");
            this.hdfs.getSnapshotDiffReport(subSubSub, "s1", "s2");
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception when getting snapshot diff report " + subSub + ": " + e));
        }
        try {
            this.hdfs.getSnapshotDiffReport(nonSnapDir, "s1", "s2");
            Assert.fail((String)("Snapshot diff report on a non snapshot directory '" + nonSnapDir.getName() + "'should fail!"));
        }
        catch (SnapshotException e) {
            GenericTestUtils.assertExceptionContains((String)"Directory is neither snapshottable nor under a snap root!", (Throwable)e);
        }
        String invalidName = "invalid";
        try {
            this.hdfs.getSnapshotDiffReport(subSub, "invalid", "invalid");
            Assert.fail((String)"Expect exception when providing invalid snapshot name for diff report");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Cannot find the snapshot of directory " + this.sub1 + " with name " + "invalid"), (Throwable)e);
        }
        SnapshotDiffReport report = this.hdfs.getSnapshotDiffReport(subSub, "s0", "s0");
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        report = this.hdfs.getSnapshotDiffReport(subSub, "", "");
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        report = this.hdfs.getSnapshotDiffReport(subSubSub, "s0", "s2");
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        report = this.hdfs.getSnapshotDiffReport(this.hdfs.makeQualified(subSubSub), "s0", "s2");
        Assert.assertEquals((long)0L, (long)report.getDiffList().size());
        this.verifyDescendantDiffReports(this.sub1, subSub, subSubSub);
    }

    private void verifyDescendantDiffReports(Path snapDir, Path snapSubDir, Path snapSubSubDir) throws IOException {
        this.verifyDiffReport(snapDir, "s0", "s2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"link13")));
        this.verifyDiffReport(snapSubDir, "s0", "s2", new SnapshotDiffReport.DiffReportEntry[0]);
        this.verifyDiffReport(snapSubSubDir, "s0", "s2", new SnapshotDiffReport.DiffReportEntry[0]);
        this.verifyDiffReport(snapDir, "s0", "s8", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file15")));
        this.verifyDiffReport(snapSubDir, "s0", "s8", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsubsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsubsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsubsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsubsub1/file15")));
        this.verifyDiffReport(snapSubSubDir, "s0", "s8", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")));
        this.verifyDiffReport(snapDir, "s2", "s5", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/file15")));
        this.verifyDiffReport(snapSubDir, "s2", "s5", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")));
        this.verifyDiffReport(snapSubSubDir, "s2", "s5", new SnapshotDiffReport.DiffReportEntry[0]);
        this.verifyDiffReport(snapDir, "s3", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file15")));
        this.verifyDiffReport(snapSubDir, "s3", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsubsub1/file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsubsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsubsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsubsub1/file15")));
        this.verifyDiffReport(snapSubSubDir, "s3", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file10")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file15")));
    }

    @Test
    public void testSnapRootDescendantDiffReportWithRename() throws Exception {
        Assume.assumeTrue((boolean)this.conf.getBoolean("dfs.namenode.snapshotdiff.allow.snap-root-descendant", true));
        Path subSub = new Path(this.sub1, "subsub1");
        Path subSubSub = new Path(subSub, "subsubsub1");
        Path nonSnapDir = new Path(this.dir, "non_snap");
        this.hdfs.mkdirs(subSubSub);
        this.hdfs.mkdirs(nonSnapDir);
        this.hdfs.allowSnapshot(this.sub1);
        this.hdfs.createSnapshot(this.sub1, this.genSnapshotName(this.sub1));
        Path file20 = new Path(subSubSub, "file20");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file20, 1024L, (short)2, 0L);
        this.hdfs.createSnapshot(this.sub1, this.genSnapshotName(this.sub1));
        this.hdfs.rename(file20, new Path(subSub, file20.getName()));
        this.hdfs.createSnapshot(this.sub1, this.genSnapshotName(this.sub1));
        this.verifyDiffReport(this.sub1, "s1", "s2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file20"), DFSUtil.string2Bytes((String)"subsub1/file20")));
        this.verifyDiffReport(subSub, "s1", "s2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"subsubsub1/file20"), DFSUtil.string2Bytes((String)"file20")));
        this.verifyDiffReport(subSubSub, "s1", "s2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file20")));
        this.hdfs.rename(new Path(subSub, file20.getName()), new Path(this.dir, file20.getName()));
        this.hdfs.createSnapshot(this.sub1, this.genSnapshotName(this.sub1));
        this.verifyDiffReport(this.sub1, "s2", "s3", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/file20")));
        this.verifyDiffReport(subSub, "s2", "s3", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"file20")));
        this.verifyDiffReport(subSubSub, "s2", "s3", new SnapshotDiffReport.DiffReportEntry[0]);
        this.hdfs.rename(new Path(this.dir, file20.getName()), new Path(this.sub1, file20.getName()));
        this.hdfs.createSnapshot(this.sub1, this.genSnapshotName(this.sub1));
        this.verifyDiffReport(this.sub1, "s3", "s4", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file20")));
        this.verifyDiffReport(subSub, "s3", "s4", new SnapshotDiffReport.DiffReportEntry[0]);
        this.verifyDiffReport(subSubSub, "s3", "s4", new SnapshotDiffReport.DiffReportEntry[0]);
        this.hdfs.rename(new Path(this.sub1, file20.getName()), new Path(subSub, file20.getName()));
        this.hdfs.createSnapshot(this.sub1, this.genSnapshotName(this.sub1));
        this.verifyDiffReport(this.sub1, "s4", "s5", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"file20"), DFSUtil.string2Bytes((String)"subsub1/file20")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1")));
        this.verifyDiffReport(subSub, "s4", "s5", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"file20")));
        this.verifyDiffReport(subSubSub, "s4", "s5", new SnapshotDiffReport.DiffReportEntry[0]);
        Path subSubSub2 = new Path(subSub, "subsubsub2");
        this.hdfs.mkdirs(subSubSub2);
        Path file30 = new Path(subSubSub2, "file30");
        DFSTestUtil.createFile((FileSystem)this.hdfs, file30, 1024L, (short)2, 0L);
        this.hdfs.createFile(file30);
        this.hdfs.createSnapshot(this.sub1, this.genSnapshotName(this.sub1));
        this.verifyDiffReport(this.sub1, "s5", "s6", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub2")));
        this.verifyDiffReport(subSubSub2, "s5", "s6", new SnapshotDiffReport.DiffReportEntry[0]);
        this.verifyDiffReport(subSubSub2, "s1", "s2", new SnapshotDiffReport.DiffReportEntry[0]);
    }

    @Test
    public void testSnapshotDiffInfo() throws Exception {
        SnapshotDiffInfo sdi;
        Path snapshotRootDirPath = this.dir;
        Path snapshotDirDescendantPath = new Path(snapshotRootDirPath, "desc");
        Path snapshotDirNonDescendantPath = new Path("/dummy/non/snap/desc");
        this.hdfs.mkdirs(snapshotDirDescendantPath);
        this.hdfs.mkdirs(snapshotDirNonDescendantPath);
        this.hdfs.allowSnapshot(snapshotRootDirPath);
        this.hdfs.createSnapshot(snapshotRootDirPath, "s0");
        this.hdfs.createSnapshot(snapshotRootDirPath, "s1");
        INodeDirectory snapshotRootDir = this.cluster.getNameNode().getNamesystem().getFSDirectory().getINode(snapshotRootDirPath.toUri().getPath()).asDirectory();
        INodeDirectory snapshotRootDescendantDir = this.cluster.getNameNode().getNamesystem().getFSDirectory().getINode(snapshotDirDescendantPath.toUri().getPath()).asDirectory();
        INodeDirectory snapshotRootNonDescendantDir = this.cluster.getNameNode().getNamesystem().getFSDirectory().getINode(snapshotDirNonDescendantPath.toUri().getPath()).asDirectory();
        try {
            sdi = new SnapshotDiffInfo(snapshotRootDir, snapshotRootDescendantDir, new Snapshot(0, "s0", snapshotRootDescendantDir), new Snapshot(0, "s1", snapshotRootDescendantDir));
            LOG.info("SnapshotDiffInfo: " + sdi.getFrom() + " - " + sdi.getTo());
        }
        catch (IllegalArgumentException iae) {
            Assert.fail((String)("Unexpected exception when constructing SnapshotDiffInfo: " + iae));
        }
        try {
            sdi = new SnapshotDiffInfo(snapshotRootDir, snapshotRootNonDescendantDir, new Snapshot(0, "s0", snapshotRootNonDescendantDir), new Snapshot(0, "s1", snapshotRootNonDescendantDir));
            LOG.info("SnapshotDiffInfo: " + sdi.getFrom() + " - " + sdi.getTo());
            Assert.fail((String)"SnapshotDiffInfo construction should fail for non snapshot root or non snapshot root descendant directories!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testDiffReport2() throws Exception {
        Path subsub1 = new Path(this.sub1, "subsub1");
        Path subsubsub1 = new Path(subsub1, "subsubsub1");
        this.hdfs.mkdirs(subsubsub1);
        this.modifyAndCreateSnapshot(subsubsub1, new Path[]{this.sub1});
        this.hdfs.delete(subsub1, true);
        this.verifyDiffReport(this.sub1, "s0", "s2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file15")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file12")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file11")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/file13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/link13")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1/subsubsub1/link13")));
        this.verifyDiffReport(this.sub1, "s0", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"subsub1")));
    }

    @Test
    public void testDiffReportWithRename() throws Exception {
        Path root = new Path("/");
        Path sdir1 = new Path(root, "dir1");
        Path sdir2 = new Path(root, "dir2");
        Path foo = new Path(sdir1, "foo");
        Path bar = new Path(foo, "bar");
        this.hdfs.mkdirs(bar);
        this.hdfs.mkdirs(sdir2);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s1");
        Path bar2 = new Path(sdir2, "bar");
        this.hdfs.rename(bar, bar2);
        Path foo2 = new Path(bar2, "foo");
        this.hdfs.rename(foo, foo2);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s2");
        this.hdfs.delete(sdir2, true);
        this.verifyDiffReport(root, "s1", "s2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir1/foo"), DFSUtil.string2Bytes((String)"dir2/bar/foo")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir1/foo/bar")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir1/foo")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir1/foo/bar"), DFSUtil.string2Bytes((String)"dir2/bar")));
    }

    @Test
    public void testDiffReportWithRenameOutside() throws Exception {
        Path root = new Path("/");
        Path dir1 = new Path(root, "dir1");
        Path dir2 = new Path(root, "dir2");
        Path foo = new Path(dir1, "foo");
        Path fileInFoo = new Path(foo, "file");
        Path bar = new Path(dir2, "bar");
        Path fileInBar = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, fileInFoo, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, fileInBar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, dir1, "s0");
        Path newBar = new Path(dir1, "newBar");
        this.hdfs.rename(bar, newBar);
        Path newFoo = new Path(dir2, "new");
        this.hdfs.rename(foo, newFoo);
        SnapshotTestHelper.createSnapshot(this.hdfs, dir1, "s1");
        this.verifyDiffReport(dir1, "s0", "s1", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)newBar.getName())), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)foo.getName())));
    }

    @Test
    public void testDiffReportWithRenameAndDelete() throws Exception {
        Path root = new Path("/");
        Path dir1 = new Path(root, "dir1");
        Path dir2 = new Path(root, "dir2");
        Path foo = new Path(dir1, "foo");
        Path fileInFoo = new Path(foo, "file");
        Path bar = new Path(dir2, "bar");
        Path fileInBar = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, fileInFoo, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, fileInBar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s0");
        this.hdfs.rename(fileInFoo, fileInBar, new Options.Rename[]{Options.Rename.OVERWRITE});
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s1");
        this.verifyDiffReport(root, "s0", "s1", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir1/foo")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir2/bar")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"dir2/bar/file")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir1/foo/file"), DFSUtil.string2Bytes((String)"dir2/bar/file")));
        this.hdfs.delete(bar, true);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s2");
        this.verifyDiffReport(root, "s0", "s2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir1/foo")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"dir2/bar")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"dir1/foo/file")));
    }

    @Test
    public void testDiffReportWithRenameToNewDir() throws Exception {
        Path root = new Path("/");
        Path foo = new Path(root, "foo");
        Path fileInFoo = new Path(foo, "file");
        DFSTestUtil.createFile((FileSystem)this.hdfs, fileInFoo, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s0");
        Path bar = new Path(root, "bar");
        this.hdfs.mkdirs(bar);
        Path fileInBar = new Path(bar, "file");
        this.hdfs.rename(fileInFoo, fileInBar);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s1");
        this.verifyDiffReport(root, "s0", "s1", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"foo")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"bar")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"foo/file"), DFSUtil.string2Bytes((String)"bar/file")));
    }

    @Test
    public void testDiffReportWithRenameAndAppend() throws Exception {
        Path root = new Path("/");
        Path foo = new Path(root, "foo");
        DFSTestUtil.createFile((FileSystem)this.hdfs, foo, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s0");
        Path bar = new Path(root, "bar");
        this.hdfs.rename(foo, bar);
        DFSTestUtil.appendFile((FileSystem)this.hdfs, bar, 10);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s1");
        this.verifyDiffReport(root, "s0", "s1", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"foo")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"foo"), DFSUtil.string2Bytes((String)"bar")));
    }

    @Test
    public void testDiffReportWithRenameAndSnapshotDeletion() throws Exception {
        Path root = new Path("/");
        Path foo = new Path(root, "foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)this.hdfs, bar, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s0");
        Path foo2 = new Path(root, "foo2");
        this.hdfs.rename(foo, foo2);
        Path bar2 = new Path(foo2, "bar");
        this.hdfs.deleteSnapshot(root, "s0");
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s1");
        Path bar3 = new Path(foo2, "bar-new");
        this.hdfs.rename(bar2, bar3);
        this.verifyDiffReport(root, "s1", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"foo2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"foo2/bar"), DFSUtil.string2Bytes((String)"foo2/bar-new")));
    }

    private void createFile(Path filePath) throws IOException {
        DFSTestUtil.createFile((FileSystem)this.hdfs, filePath, 512, 2048L, 1024L, (short)3, 0L);
    }

    private int writeToStream(FSDataOutputStream outputStream, byte[] buf) throws IOException {
        outputStream.write(buf);
        ((HdfsDataOutputStream)outputStream).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        return buf.length;
    }

    private void restartNameNode() throws Exception {
        this.cluster.triggerBlockReports();
        NameNode nameNode = this.cluster.getNameNode();
        NameNodeAdapter.enterSafeMode(nameNode, false);
        NameNodeAdapter.saveNamespace(nameNode);
        NameNodeAdapter.leaveSafeMode(nameNode);
        this.cluster.restartNameNode(true);
    }

    @Test(timeout=120000L)
    public void testDiffReportWithOpenFiles() throws Exception {
        Path level0A;
        Path flumeSnapRootDir = level0A = new Path("/level_0_A");
        String flumeFileName = "flume.log";
        String flumeSnap1Name = "flume_snap_1";
        String flumeSnap2Name = "flume_snap_2";
        Path flumeFile = new Path(level0A, "flume.log");
        this.createFile(flumeFile);
        FSDataOutputStream flumeOutputStream = this.hdfs.append(flumeFile);
        Path flumeS1Dir = SnapshotTestHelper.createSnapshot(this.hdfs, flumeSnapRootDir, "flume_snap_1");
        Path flumeS1Path = new Path(flumeS1Dir, "flume.log");
        long flumeFileLengthAfterS1 = this.hdfs.getFileStatus(flumeFile).getLen();
        Assert.assertEquals((long)flumeFileLengthAfterS1, (long)this.hdfs.getFileStatus(flumeS1Path).getLen());
        this.verifyDiffReport(level0A, "flume_snap_1", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")));
        long flumeFileWrittenDataLength = flumeFileLengthAfterS1;
        int newWriteLength = 1536;
        byte[] buf = new byte[newWriteLength];
        Random random = new Random();
        random.nextBytes(buf);
        Path flumeS2Dir = SnapshotTestHelper.createSnapshot(this.hdfs, flumeSnapRootDir, "flume_snap_2");
        Path flumeS2Path = new Path(flumeS2Dir, "flume.log");
        long flumeFileLengthAfterS2 = this.hdfs.getFileStatus(flumeFile).getLen();
        Assert.assertEquals((long)(flumeFileWrittenDataLength += (long)this.writeToStream(flumeOutputStream, buf)), (long)flumeFileLengthAfterS2);
        Assert.assertEquals((long)flumeFileLengthAfterS2, (long)this.hdfs.getFileStatus(flumeS2Path).getLen());
        this.verifyDiffReport(level0A, "flume_snap_1", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"flume.log")));
        this.verifyDiffReport(level0A, "flume_snap_2", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")));
        this.verifyDiffReport(level0A, "flume_snap_1", "flume_snap_2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"flume.log")));
        Assert.assertEquals((long)flumeFileLengthAfterS1, (long)this.hdfs.getFileStatus(flumeS1Path).getLen());
        Assert.assertEquals((long)flumeFileLengthAfterS2, (long)this.hdfs.getFileStatus(flumeS2Path).getLen());
        flumeOutputStream.close();
        Assert.assertEquals((long)(flumeFileWrittenDataLength += (long)this.writeToStream(flumeOutputStream, buf)), (long)this.hdfs.getFileStatus(flumeFile).getLen());
        Assert.assertEquals((long)flumeFileLengthAfterS1, (long)this.hdfs.getFileStatus(flumeS1Path).getLen());
        Assert.assertEquals((long)flumeFileLengthAfterS2, (long)this.hdfs.getFileStatus(flumeS2Path).getLen());
        this.verifyDiffReport(level0A, "flume_snap_1", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"flume.log")));
        this.verifyDiffReport(level0A, "flume_snap_2", "", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"flume.log")));
        this.verifyDiffReport(level0A, "flume_snap_1", "flume_snap_2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"flume.log")));
        this.restartNameNode();
        this.verifyDiffReport(level0A, "flume_snap_1", "flume_snap_2", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"flume.log")));
    }

    private long getAccessTime(Path path) throws IOException {
        return this.hdfs.getFileStatus(path).getAccessTime();
    }

    private String getAccessTimeStr(Path path) throws IOException {
        SimpleDateFormat timeFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return timeFmt.format(new Date(this.getAccessTime(path)));
    }

    private Path getSSpath(Path path, Path ssRoot, String ssName) {
        return new Path(ssRoot, ".snapshot/" + ssName + "/" + path.toString().substring(ssRoot.toString().length()));
    }

    private void printAtime(Path path, Path ssRoot, String ssName) throws IOException {
        Path ssPath = this.getSSpath(path, ssRoot, ssName);
        LOG.info("Access time " + path + ": " + this.getAccessTimeStr(path) + " " + ssPath + ": " + this.getAccessTimeStr(ssPath));
    }

    private void assertAtimeEquals(Path path, Path ssRoot, String ssName1, String ssName2) throws IOException {
        Path ssPath1 = this.getSSpath(path, ssRoot, ssName1);
        Path ssPath2 = this.getSSpath(path, ssRoot, ssName2);
        Assert.assertEquals((long)this.getAccessTime(ssPath1), (long)this.getAccessTime(ssPath2));
    }

    private void assertAtimeNotEquals(Path path, Path ssRoot, String ssName1, String ssName2) throws IOException {
        Path ssPath1 = this.getSSpath(path, ssRoot, ssName1);
        Path ssPath2 = this.getSSpath(path, ssRoot, ssName2);
        Assert.assertNotEquals((long)this.getAccessTime(ssPath1), (long)this.getAccessTime(ssPath2));
    }

    @Test
    public void testDontCaptureAccessTimeOnlyChangeReport() throws Exception {
        Path froot = new Path("/");
        Path root = new Path(froot, "/testSdiffCalc");
        Path filePreSS = new Path(root, "fParent/filePreSS");
        Path dirPreSS = new Path(root, "dirPreSS");
        Path dirPreSSChild = new Path(dirPreSS, "dirPreSSChild");
        Path filePostSS = new Path(root, "fParent/filePostSS");
        Path dirPostSS = new Path(root, "dirPostSS");
        Path dirPostSSChild = new Path(dirPostSS, "dirPostSSChild");
        DFSTestUtil.createFile((FileSystem)this.hdfs, filePreSS, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, dirPreSSChild, 1024L, (short)3, 0L);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s0");
        this.printAtime(filePreSS, root, "s0");
        this.printAtime(dirPreSS, root, "s0");
        DFSTestUtil.createFile((FileSystem)this.hdfs, filePostSS, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, dirPostSSChild, 1024L, (short)3, 0L);
        Thread.sleep(3000L);
        long now = Time.now();
        this.hdfs.setTimes(filePreSS, -1L, now);
        this.hdfs.setTimes(filePostSS, -1L, now);
        this.hdfs.setTimes(dirPreSS, -1L, now);
        this.hdfs.setTimes(dirPostSS, -1L, now);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s1");
        this.printAtime(filePreSS, root, "s1");
        this.printAtime(dirPreSS, root, "s1");
        this.printAtime(filePostSS, root, "s1");
        this.printAtime(dirPostSS, root, "s1");
        Thread.sleep(3000L);
        now = Time.now();
        this.hdfs.setTimes(filePreSS, -1L, now);
        this.hdfs.setTimes(filePostSS, -1L, now);
        this.hdfs.setTimes(dirPreSS, -1L, now);
        this.hdfs.setTimes(dirPostSS, -1L, now);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s2");
        this.printAtime(filePreSS, root, "s2");
        this.printAtime(dirPreSS, root, "s2");
        this.printAtime(filePostSS, root, "s2");
        this.printAtime(dirPostSS, root, "s2");
        Thread.sleep(3000L);
        now = Time.now();
        this.hdfs.setReplication(filePostSS, (short)2);
        this.hdfs.setTimes(filePostSS, -1L, now);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s3");
        LOG.info("\nsnapshotDiff s0 -> s1:");
        LOG.info(this.hdfs.getSnapshotDiffReport(root, "s0", "s1").toString());
        LOG.info("\nsnapshotDiff s1 -> s2:");
        LOG.info(this.hdfs.getSnapshotDiffReport(root, "s1", "s2").toString());
        this.assertAtimeEquals(filePreSS, root, "s0", "s1");
        this.assertAtimeEquals(dirPreSS, root, "s0", "s1");
        this.assertAtimeEquals(filePreSS, root, "s1", "s2");
        this.assertAtimeEquals(dirPreSS, root, "s1", "s2");
        this.assertAtimeEquals(filePostSS, root, "s1", "s2");
        this.assertAtimeEquals(dirPostSS, root, "s1", "s2");
        this.assertAtimeNotEquals(filePostSS, root, "s2", "s3");
        this.cluster.restartNameNodes();
        this.cluster.waitActive();
        this.assertAtimeEquals(filePreSS, root, "s0", "s1");
        this.assertAtimeEquals(dirPreSS, root, "s0", "s1");
        this.assertAtimeEquals(filePreSS, root, "s1", "s2");
        this.assertAtimeEquals(dirPreSS, root, "s1", "s2");
        this.assertAtimeEquals(filePostSS, root, "s1", "s2");
        this.assertAtimeEquals(dirPostSS, root, "s1", "s2");
        this.assertAtimeNotEquals(filePostSS, root, "s2", "s3");
    }

    @Test
    public void testDiffReportWithRpcLimit() throws Exception {
        Path path;
        int i;
        Path root = new Path("/");
        this.hdfs.mkdirs(root);
        for (i = 1; i < 4; ++i) {
            path = new Path(root, "dir" + i);
            this.hdfs.mkdirs(path);
        }
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s0");
        for (i = 1; i < 4; ++i) {
            path = new Path(root, "dir" + i);
            for (int j = 1; j < 4; ++j) {
                Path file = new Path(path, "file" + j);
                DFSTestUtil.createFile((FileSystem)this.hdfs, file, 1024L, (short)3, 0L);
            }
        }
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s1");
        this.verifyDiffReport(root, "s0", "s1", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir1/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir1/file2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir1/file3")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir2/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir2/file2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir2/file3")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir3")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir3/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir3/file2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir3/file3")));
    }

    @Test
    public void testDiffReportWithRpcLimit2() throws Exception {
        Path targetPath;
        Path srcPath;
        int j;
        Path path;
        int i;
        Path root = new Path("/");
        this.hdfs.mkdirs(root);
        for (i = 1; i <= 3; ++i) {
            path = new Path(root, "dir" + i);
            this.hdfs.mkdirs(path);
        }
        for (i = 1; i <= 3; ++i) {
            path = new Path(root, "dir" + i);
            for (j = 1; j < 4; ++j) {
                Path file = new Path(path, "file" + j);
                DFSTestUtil.createFile((FileSystem)this.hdfs, file, 1024L, (short)3, 0L);
            }
        }
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s0");
        Path targetDir = new Path(root, "dir4");
        this.hdfs.mkdirs(targetDir);
        path = new Path(root, "dir1");
        for (j = 1; j < 4; ++j) {
            srcPath = new Path(path, "file" + j);
            targetPath = new Path(targetDir, "file" + j);
            this.hdfs.rename(srcPath, targetPath);
        }
        targetDir = new Path(root, "dir3");
        path = new Path(root, "dir2");
        for (j = 1; j < 4; ++j) {
            srcPath = new Path(path, "file" + j);
            targetPath = new Path(targetDir, "file" + j);
            this.hdfs.rename(srcPath, targetPath, new Options.Rename[]{Options.Rename.OVERWRITE});
        }
        Path pathToRename = new Path(root, "dir2");
        this.hdfs.rename(pathToRename, targetDir);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s1");
        this.verifyDiffReport(root, "s0", "s1", new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir4")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir2"), DFSUtil.string2Bytes((String)"dir3/dir2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir1/file1"), DFSUtil.string2Bytes((String)"dir4/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir1/file2"), DFSUtil.string2Bytes((String)"dir4/file2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir1/file3"), DFSUtil.string2Bytes((String)"dir4/file3")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir2/file1"), DFSUtil.string2Bytes((String)"dir3/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir2/file2"), DFSUtil.string2Bytes((String)"dir3/file2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir2/file3"), DFSUtil.string2Bytes((String)"dir3/file3")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir3")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"dir3/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"dir3/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"dir3/file3")));
    }

    private void verifyDiffReportForGivenReport(Path dirPath, String from, String to, SnapshotDiffReport report, SnapshotDiffReport.DiffReportEntry ... entries) throws IOException {
        SnapshotDiffReport inverseReport = this.hdfs.getSnapshotDiffReport(dirPath, to, from);
        LOG.info(report.toString());
        LOG.info(inverseReport.toString() + "\n");
        Assert.assertEquals((long)entries.length, (long)report.getDiffList().size());
        Assert.assertEquals((long)entries.length, (long)inverseReport.getDiffList().size());
        for (SnapshotDiffReport.DiffReportEntry entry : entries) {
            if (entry.getType() == SnapshotDiffReport.DiffType.MODIFY) {
                Assert.assertTrue((boolean)report.getDiffList().contains(entry));
                Assert.assertTrue((boolean)inverseReport.getDiffList().contains(entry));
                continue;
            }
            if (entry.getType() == SnapshotDiffReport.DiffType.DELETE) {
                Assert.assertTrue((boolean)report.getDiffList().contains(entry));
                Assert.assertTrue((boolean)inverseReport.getDiffList().contains(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, entry.getSourcePath())));
                continue;
            }
            if (entry.getType() != SnapshotDiffReport.DiffType.CREATE) continue;
            Assert.assertTrue((boolean)report.getDiffList().contains(entry));
            Assert.assertTrue((boolean)inverseReport.getDiffList().contains(new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, entry.getSourcePath())));
        }
    }

    @Test
    public void testSnapshotDiffReportRemoteIterator() throws Exception {
        Path targetPath;
        Path srcPath;
        int j;
        Path path;
        int i;
        Path root = new Path("/");
        this.hdfs.mkdirs(root);
        for (i = 1; i <= 3; ++i) {
            path = new Path(root, "dir" + i);
            this.hdfs.mkdirs(path);
        }
        for (i = 1; i <= 3; ++i) {
            path = new Path(root, "dir" + i);
            for (j = 1; j < 4; ++j) {
                Path file = new Path(path, "file" + j);
                DFSTestUtil.createFile((FileSystem)this.hdfs, file, 1024L, (short)3, 0L);
            }
        }
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s0");
        Path targetDir = new Path(root, "dir4");
        this.hdfs.mkdirs(targetDir);
        path = new Path(root, "dir1");
        for (j = 1; j < 4; ++j) {
            srcPath = new Path(path, "file" + j);
            targetPath = new Path(targetDir, "file" + j);
            this.hdfs.rename(srcPath, targetPath);
        }
        targetDir = new Path(root, "dir3");
        path = new Path(root, "dir2");
        for (j = 1; j < 4; ++j) {
            srcPath = new Path(path, "file" + j);
            targetPath = new Path(targetDir, "file" + j);
            this.hdfs.rename(srcPath, targetPath, new Options.Rename[]{Options.Rename.OVERWRITE});
        }
        Path pathToRename = new Path(root, "dir2");
        this.hdfs.rename(pathToRename, targetDir);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s1");
        RemoteIterator iterator = this.hdfs.snapshotDiffReportListingRemoteIterator(root, "s0", "s1");
        TreeList modifiedList = new TreeList();
        ChunkedArrayList createdList = new ChunkedArrayList();
        ChunkedArrayList deletedList = new ChunkedArrayList();
        SnapshotDiffReportListing report = null;
        ArrayList<SnapshotDiffReportListing> reportList = new ArrayList<SnapshotDiffReportListing>();
        while (iterator.hasNext()) {
            report = (SnapshotDiffReportListing)iterator.next();
            reportList.add(report);
            modifiedList.addAll(report.getModifyList());
            createdList.addAll(report.getCreateList());
            deletedList.addAll(report.getDeleteList());
        }
        try {
            iterator.next();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No more entry in SnapshotDiffReport for /"));
        }
        Assert.assertNotEquals((long)0L, (long)reportList.size());
        SnapshotDiffReportGenerator snapshotDiffReport = new SnapshotDiffReportGenerator("/", "s0", "s1", report.getIsFromEarlier(), (List)modifiedList, (List)createdList, (List)deletedList);
        this.verifyDiffReportForGivenReport(root, "s0", "s1", snapshotDiffReport.generateReport(), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.CREATE, DFSUtil.string2Bytes((String)"dir4")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir2"), DFSUtil.string2Bytes((String)"dir3/dir2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir1/file1"), DFSUtil.string2Bytes((String)"dir4/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir1/file2"), DFSUtil.string2Bytes((String)"dir4/file2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir1/file3"), DFSUtil.string2Bytes((String)"dir4/file3")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir2/file1"), DFSUtil.string2Bytes((String)"dir3/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir2/file2"), DFSUtil.string2Bytes((String)"dir3/file2")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.RENAME, DFSUtil.string2Bytes((String)"dir2/file3"), DFSUtil.string2Bytes((String)"dir3/file3")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.MODIFY, DFSUtil.string2Bytes((String)"dir3")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"dir3/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"dir3/file1")), new SnapshotDiffReport.DiffReportEntry(SnapshotDiffReport.DiffType.DELETE, DFSUtil.string2Bytes((String)"dir3/file3")));
    }

    @Test
    public void testSnapshotDiffReportRemoteIterator2() throws Exception {
        Path root = new Path("/");
        this.hdfs.mkdirs(root);
        SnapshotTestHelper.createSnapshot(this.hdfs, root, "s0");
        try {
            this.hdfs.snapshotDiffReportListingRemoteIterator(root, "s0", "");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Remote Iterator issupported for snapshotDiffReport between two snapshots"));
        }
    }
}

