/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.net.DFSNetworkTopology;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class BlockPlacementPolicyDefault
extends BlockPlacementPolicy {
    private static final String enableDebugLogging = "For more information, please enable DEBUG log level on " + BlockPlacementPolicy.class.getName() + " and " + NetworkTopology.class.getName();
    private static final ThreadLocal<StringBuilder> debugLoggingBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    private static final ThreadLocal<HashMap<NodeNotChosenReason, Integer>> CHOOSE_RANDOM_REASONS = ThreadLocal.withInitial(() -> new HashMap());
    protected boolean considerLoad;
    protected double considerLoadFactor;
    private boolean preferLocalNode;
    protected NetworkTopology clusterMap;
    protected Host2NodesMap host2datanodeMap;
    private FSClusterStats stats;
    protected long heartbeatInterval;
    private long staleInterval;
    protected int tolerateHeartbeatMultiplier;

    protected BlockPlacementPolicyDefault() {
    }

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap, Host2NodesMap host2datanodeMap) {
        this.considerLoad = conf.getBoolean("dfs.namenode.redundancy.considerLoad", true);
        this.considerLoadFactor = conf.getDouble("dfs.namenode.redundancy.considerLoad.factor", 2.0);
        this.stats = stats;
        this.clusterMap = clusterMap;
        this.host2datanodeMap = host2datanodeMap;
        this.heartbeatInterval = conf.getTimeDuration("dfs.heartbeat.interval", 3L, TimeUnit.SECONDS) * 1000L;
        this.tolerateHeartbeatMultiplier = conf.getInt("dfs.namenode.tolerate.heartbeat.multiplier", 4);
        this.staleInterval = conf.getLong("dfs.namenode.stale.datanode.interval", 30000L);
        this.preferLocalNode = conf.getBoolean("dfs.namenode.block-placement-policy.default.prefer-local-node", true);
    }

    @Override
    public DatanodeStorageInfo[] chooseTarget(String srcPath, int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosenNodes, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, BlockStoragePolicy storagePolicy, EnumSet<AddBlockFlag> flags) {
        return this.chooseTarget(numOfReplicas, writer, chosenNodes, returnChosenNodes, excludedNodes, blocksize, storagePolicy, flags);
    }

    @Override
    DatanodeStorageInfo[] chooseTarget(String src, int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, List<DatanodeDescriptor> favoredNodes, BlockStoragePolicy storagePolicy, EnumSet<AddBlockFlag> flags) {
        try {
            if (favoredNodes == null || favoredNodes.size() == 0) {
                return this.chooseTarget(src, numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>(numOfReplicas), false, excludedNodes, blocksize, storagePolicy, flags);
            }
            HashSet<Node> favoriteAndExcludedNodes = excludedNodes == null ? new HashSet<Node>() : new HashSet<Node>(excludedNodes);
            List requiredStorageTypes = storagePolicy.chooseStorageTypes((short)numOfReplicas);
            EnumMap<StorageType, Integer> storageTypes = this.getRequiredStorageTypes(requiredStorageTypes);
            ArrayList<DatanodeStorageInfo> results = new ArrayList<DatanodeStorageInfo>();
            boolean avoidStaleNodes = this.stats != null && this.stats.isAvoidingStaleDataNodesForWrite();
            int[] maxNodesAndReplicas = this.getMaxNodesPerRack(0, numOfReplicas);
            numOfReplicas = maxNodesAndReplicas[0];
            int maxNodesPerRack = maxNodesAndReplicas[1];
            this.chooseFavouredNodes(src, numOfReplicas, favoredNodes, favoriteAndExcludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
            if (results.size() < numOfReplicas) {
                numOfReplicas -= results.size();
                for (DatanodeStorageInfo storage : results) {
                    this.addToExcludedNodes(storage.getDatanodeDescriptor(), favoriteAndExcludedNodes);
                }
                DatanodeStorageInfo[] remainingTargets = this.chooseTarget(src, numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>(numOfReplicas), false, favoriteAndExcludedNodes, blocksize, storagePolicy, flags);
                for (int i = 0; i < remainingTargets.length; ++i) {
                    results.add(remainingTargets[i]);
                }
            }
            return this.getPipeline(writer, results.toArray(new DatanodeStorageInfo[results.size()]));
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException nr) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to choose with favored nodes (=" + favoredNodes + "), disregard favored nodes hint and retry.", (Throwable)nr);
            }
            return this.chooseTarget(src, numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>(numOfReplicas), false, excludedNodes, blocksize, storagePolicy, flags);
        }
    }

    protected void chooseFavouredNodes(String src, int numOfReplicas, List<DatanodeDescriptor> favoredNodes, Set<Node> favoriteAndExcludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        for (int i = 0; i < favoredNodes.size() && results.size() < numOfReplicas; ++i) {
            DatanodeDescriptor favoredNode = favoredNodes.get(i);
            DatanodeStorageInfo target = this.chooseLocalStorage((Node)favoredNode, favoriteAndExcludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes, false);
            if (target == null) {
                LOG.warn("Could not find a target for file " + src + " with favored node " + (Object)((Object)favoredNode));
                continue;
            }
            favoriteAndExcludedNodes.add((Node)target.getDatanodeDescriptor());
        }
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosenStorage, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, BlockStoragePolicy storagePolicy, EnumSet<AddBlockFlag> addBlockFlags) {
        boolean avoidLocalNode;
        if (numOfReplicas == 0 || this.clusterMap.getNumOfLeaves() == 0) {
            return DatanodeStorageInfo.EMPTY_ARRAY;
        }
        if (excludedNodes == null) {
            excludedNodes = new HashSet<Node>();
        }
        int[] result = this.getMaxNodesPerRack(chosenStorage.size(), numOfReplicas);
        numOfReplicas = result[0];
        int maxNodesPerRack = result[1];
        for (DatanodeStorageInfo storage : chosenStorage) {
            this.addToExcludedNodes(storage.getDatanodeDescriptor(), excludedNodes);
        }
        ArrayList<DatanodeStorageInfo> results = null;
        Node localNode = null;
        boolean avoidStaleNodes = this.stats != null && this.stats.isAvoidingStaleDataNodesForWrite();
        boolean bl = avoidLocalNode = addBlockFlags != null && addBlockFlags.contains(AddBlockFlag.NO_LOCAL_WRITE) && writer != null && !excludedNodes.contains(writer);
        if (avoidLocalNode) {
            results = new ArrayList<DatanodeStorageInfo>(chosenStorage);
            HashSet<Node> excludedNodeCopy = new HashSet<Node>(excludedNodes);
            if (writer != null) {
                excludedNodeCopy.add(writer);
            }
            localNode = this.chooseTarget(numOfReplicas, writer, excludedNodeCopy, blocksize, maxNodesPerRack, results, avoidStaleNodes, storagePolicy, EnumSet.noneOf(StorageType.class), results.isEmpty());
            if (results.size() < numOfReplicas) {
                results = null;
            }
        }
        if (results == null) {
            results = new ArrayList<DatanodeStorageInfo>(chosenStorage);
            localNode = this.chooseTarget(numOfReplicas, writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storagePolicy, EnumSet.noneOf(StorageType.class), results.isEmpty());
        }
        if (!returnChosenNodes) {
            results.removeAll(chosenStorage);
        }
        return this.getPipeline(writer != null && writer instanceof DatanodeDescriptor ? writer : localNode, results.toArray(new DatanodeStorageInfo[results.size()]));
    }

    protected int[] getMaxNodesPerRack(int numOfChosen, int numOfReplicas) {
        int numOfRacks;
        int totalNumOfReplicas = numOfChosen + numOfReplicas;
        int clusterSize = this.clusterMap.getNumOfLeaves();
        if (totalNumOfReplicas > clusterSize) {
            numOfReplicas -= totalNumOfReplicas - clusterSize;
            totalNumOfReplicas = clusterSize;
        }
        if ((numOfRacks = this.clusterMap.getNumOfRacks()) == 1 || totalNumOfReplicas <= 1) {
            return new int[]{numOfReplicas, totalNumOfReplicas};
        }
        int maxNodesPerRack = (totalNumOfReplicas - 1) / numOfRacks + 2;
        if (maxNodesPerRack == totalNumOfReplicas) {
            // empty if block
        }
        return new int[]{numOfReplicas, --maxNodesPerRack};
    }

    private EnumMap<StorageType, Integer> getRequiredStorageTypes(List<StorageType> types) {
        EnumMap<StorageType, Integer> map = new EnumMap<StorageType, Integer>(StorageType.class);
        for (StorageType type : types) {
            if (!map.containsKey(type)) {
                map.put(type, 1);
                continue;
            }
            int num = map.get(type);
            map.put(type, num + 1);
        }
        return map;
    }

    private Node chooseTarget(int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, BlockStoragePolicy storagePolicy, EnumSet<StorageType> unavailableStorages, boolean newBlock) {
        block12: {
            if (numOfReplicas == 0 || this.clusterMap.getNumOfLeaves() == 0) {
                return writer instanceof DatanodeDescriptor ? writer : null;
            }
            int numOfResults = results.size();
            int totalReplicasExpected = numOfReplicas + numOfResults;
            if (!(writer != null && writer instanceof DatanodeDescriptor || newBlock)) {
                writer = results.get(0).getDatanodeDescriptor();
            }
            HashSet<Node> oldExcludedNodes = new HashSet<Node>(excludedNodes);
            List requiredStorageTypes = storagePolicy.chooseStorageTypes((short)totalReplicasExpected, DatanodeStorageInfo.toStorageTypes(results), unavailableStorages, newBlock);
            EnumMap<StorageType, Integer> storageTypes = this.getRequiredStorageTypes(requiredStorageTypes);
            if (LOG.isTraceEnabled()) {
                LOG.trace("storageTypes=" + storageTypes);
            }
            try {
                numOfReplicas = requiredStorageTypes.size();
                if (numOfReplicas == 0) {
                    throw new BlockPlacementPolicy.NotEnoughReplicasException("All required storage types are unavailable:  unavailableStorages=" + unavailableStorages + ", storagePolicy=" + storagePolicy);
                }
                writer = this.chooseTargetInOrder(numOfReplicas, (Node)writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, newBlock, storageTypes);
            }
            catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
                String message = "Failed to place enough replicas, still in need of " + (totalReplicasExpected - results.size()) + " to reach " + totalReplicasExpected + " (unavailableStorages=" + unavailableStorages + ", storagePolicy=" + storagePolicy + ", newBlock=" + newBlock + ")";
                if (LOG.isTraceEnabled()) {
                    LOG.trace(message, (Throwable)e);
                } else {
                    LOG.warn(message + " " + e.getMessage());
                }
                if (avoidStaleNodes) {
                    for (DatanodeStorageInfo resultStorage : results) {
                        this.addToExcludedNodes(resultStorage.getDatanodeDescriptor(), oldExcludedNodes);
                    }
                    numOfReplicas = totalReplicasExpected - results.size();
                    return this.chooseTarget(numOfReplicas, (Node)writer, (Set<Node>)oldExcludedNodes, blocksize, maxNodesPerRack, results, false, storagePolicy, unavailableStorages, newBlock);
                }
                boolean retry = false;
                for (StorageType type : storageTypes.keySet()) {
                    if (unavailableStorages.contains(type)) continue;
                    unavailableStorages.add(type);
                    retry = true;
                }
                if (!retry) break block12;
                for (DatanodeStorageInfo resultStorage : results) {
                    this.addToExcludedNodes(resultStorage.getDatanodeDescriptor(), oldExcludedNodes);
                }
                numOfReplicas = totalReplicasExpected - results.size();
                return this.chooseTarget(numOfReplicas, (Node)writer, (Set<Node>)oldExcludedNodes, blocksize, maxNodesPerRack, results, false, storagePolicy, unavailableStorages, newBlock);
            }
        }
        return writer;
    }

    protected Node chooseTargetInOrder(int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, boolean newBlock, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int numOfResults = results.size();
        if (numOfResults == 0) {
            DatanodeStorageInfo storageInfo = this.chooseLocalStorage((Node)writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes, true);
            DatanodeDescriptor datanodeDescriptor = writer = storageInfo != null ? storageInfo.getDatanodeDescriptor() : null;
            if (--numOfReplicas == 0) {
                return writer;
            }
        }
        DatanodeDescriptor dn0 = results.get(0).getDatanodeDescriptor();
        if (numOfResults <= 1) {
            this.chooseRemoteRack(1, dn0, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
            if (--numOfReplicas == 0) {
                return writer;
            }
        }
        if (numOfResults <= 2) {
            DatanodeDescriptor dn1 = results.get(1).getDatanodeDescriptor();
            if (this.clusterMap.isOnSameRack((Node)dn0, (Node)dn1)) {
                this.chooseRemoteRack(1, dn0, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
            } else if (newBlock) {
                this.chooseLocalRack((Node)dn1, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
            } else {
                this.chooseLocalRack((Node)writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
            }
            if (--numOfReplicas == 0) {
                return writer;
            }
        }
        this.chooseRandom(numOfReplicas, "", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        return writer;
    }

    protected DatanodeStorageInfo chooseLocalStorage(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        if (this.preferLocalNode && localMachine instanceof DatanodeDescriptor && this.clusterMap.contains(localMachine)) {
            DatanodeDescriptor localDatanode = (DatanodeDescriptor)localMachine;
            if (excludedNodes.add(localMachine) && this.isGoodDatanode(localDatanode, maxNodesPerRack, false, results, avoidStaleNodes)) {
                Iterator<Map.Entry<StorageType, Integer>> iter = storageTypes.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<StorageType, Integer> entry = iter.next();
                    DatanodeStorageInfo localStorage = this.chooseStorage4Block(localDatanode, blocksize, results, entry.getKey());
                    if (localStorage == null) continue;
                    this.addToExcludedNodes(localDatanode, excludedNodes);
                    int num = entry.getValue();
                    if (num == 1) {
                        iter.remove();
                    } else {
                        entry.setValue(num - 1);
                    }
                    return localStorage;
                }
            }
        }
        return null;
    }

    protected DatanodeStorageInfo chooseLocalStorage(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes, boolean fallbackToLocalRack) throws BlockPlacementPolicy.NotEnoughReplicasException {
        DatanodeStorageInfo localStorage = this.chooseLocalStorage(localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        if (localStorage != null) {
            return localStorage;
        }
        if (!fallbackToLocalRack) {
            return null;
        }
        return this.chooseLocalRack(localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
    }

    protected int addToExcludedNodes(DatanodeDescriptor localMachine, Set<Node> excludedNodes) {
        return excludedNodes.add((Node)localMachine) ? 1 : 0;
    }

    protected DatanodeStorageInfo chooseLocalRack(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        String localRack = localMachine.getNetworkLocation();
        try {
            return this.chooseRandom(localRack, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            for (DatanodeStorageInfo resultStorage : results) {
                DatanodeDescriptor nextNode = resultStorage.getDatanodeDescriptor();
                if (nextNode == localMachine) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to choose from local rack (location = " + localRack + "), retry with the rack of the next replica (location = " + nextNode.getNetworkLocation() + ")", (Throwable)e);
                }
                return this.chooseFromNextRack((Node)nextNode, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to choose from local rack (location = " + localRack + "); the second replica is not found, retry choosing randomly", (Throwable)e);
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    private DatanodeStorageInfo chooseFromNextRack(Node next, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        String nextRack = next.getNetworkLocation();
        try {
            return this.chooseRandom(nextRack, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to choose from the next rack (location = " + nextRack + "), retry choosing randomly", (Throwable)e);
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    protected void chooseRemoteRack(int numOfReplicas, DatanodeDescriptor localMachine, Set<Node> excludedNodes, long blocksize, int maxReplicasPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int oldNumOfReplicas = results.size();
        try {
            this.chooseRandom(numOfReplicas, "~" + localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to choose remote rack (location = ~" + localMachine.getNetworkLocation() + "), fallback to local rack", (Throwable)e);
            }
            this.chooseRandom(numOfReplicas - (results.size() - oldNumOfReplicas), localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    protected DatanodeStorageInfo chooseRandom(String scope, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        return this.chooseRandom(1, scope, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
    }

    protected DatanodeStorageInfo chooseRandom(int numOfReplicas, String scope, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        StringBuilder builder = null;
        if (LOG.isDebugEnabled()) {
            builder = debugLoggingBuilder.get();
            builder.setLength(0);
            builder.append("[");
        }
        CHOOSE_RANDOM_REASONS.get().clear();
        boolean badTarget = false;
        DatanodeStorageInfo firstChosen = null;
        while (numOfReplicas > 0) {
            StorageType includeType = null;
            DatanodeDescriptor chosenNode = null;
            if (this.clusterMap instanceof DFSNetworkTopology) {
                for (StorageType type : storageTypes.keySet()) {
                    chosenNode = this.chooseDataNode(scope, excludedNodes, type);
                    if (chosenNode == null) continue;
                    includeType = type;
                    break;
                }
            } else {
                chosenNode = this.chooseDataNode(scope, excludedNodes);
            }
            if (chosenNode == null) break;
            Preconditions.checkState((boolean)excludedNodes.add((Node)chosenNode), (Object)("chosenNode " + (Object)((Object)chosenNode) + " is already in excludedNodes " + excludedNodes));
            if (LOG.isDebugEnabled() && builder != null) {
                builder.append("\nNode ").append(NodeBase.getPath((Node)chosenNode)).append(" [");
            }
            DatanodeStorageInfo storage = null;
            if (!this.isGoodDatanode(chosenNode, maxNodesPerRack, this.considerLoad, results, avoidStaleNodes)) continue;
            Iterator<Map.Entry<StorageType, Integer>> iter = storageTypes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<StorageType, Integer> entry = iter.next();
                if (includeType != null && entry.getKey() != includeType || (storage = this.chooseStorage4Block(chosenNode, blocksize, results, entry.getKey())) == null) continue;
                --numOfReplicas;
                if (firstChosen == null) {
                    firstChosen = storage;
                }
                this.addToExcludedNodes(chosenNode, excludedNodes);
                int num = entry.getValue();
                if (num == 1) {
                    iter.remove();
                    break;
                }
                entry.setValue(num - 1);
                break;
            }
            if (LOG.isDebugEnabled() && builder != null) {
                builder.append("\n]");
            }
            badTarget = storage == null;
        }
        if (numOfReplicas > 0) {
            HashMap<NodeNotChosenReason, Integer> reasonMap;
            String detail = enableDebugLogging;
            if (LOG.isDebugEnabled() && builder != null) {
                detail = builder.toString();
                if (badTarget) {
                    builder.setLength(0);
                } else {
                    if (detail.length() > 1) {
                        LOG.debug(detail);
                    }
                    detail = "";
                }
            }
            if (!(reasonMap = CHOOSE_RANDOM_REASONS.get()).isEmpty()) {
                LOG.info("Not enough replicas was chosen. Reason:{}", reasonMap);
            }
            throw new BlockPlacementPolicy.NotEnoughReplicasException(detail);
        }
        return firstChosen;
    }

    protected DatanodeDescriptor chooseDataNode(String scope, Collection<Node> excludedNodes) {
        return (DatanodeDescriptor)this.clusterMap.chooseRandom(scope, excludedNodes);
    }

    protected DatanodeDescriptor chooseDataNode(String scope, Collection<Node> excludedNodes, StorageType type) {
        return (DatanodeDescriptor)((DFSNetworkTopology)this.clusterMap).chooseRandomWithStorageTypeTwoTrial(scope, excludedNodes, type);
    }

    DatanodeStorageInfo chooseStorage4Block(DatanodeDescriptor dnd, long blockSize, List<DatanodeStorageInfo> results, StorageType storageType) {
        DatanodeStorageInfo storage = dnd.chooseStorage4Block(storageType, blockSize);
        if (storage != null) {
            results.add(storage);
        } else {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(dnd, NodeNotChosenReason.NOT_ENOUGH_STORAGE_SPACE, " for storage type " + storageType);
        }
        return storage;
    }

    private static void logNodeIsNotChosen(DatanodeDescriptor node, NodeNotChosenReason reason) {
        BlockPlacementPolicyDefault.logNodeIsNotChosen(node, reason, null);
    }

    private static void logNodeIsNotChosen(DatanodeDescriptor node, NodeNotChosenReason reason, String reasonDetails) {
        HashMap<NodeNotChosenReason, Integer> reasonMap;
        Integer base;
        assert (reason != null);
        if (LOG.isDebugEnabled()) {
            debugLoggingBuilder.get().append("\n  Datanode ").append((Object)node).append(" is not chosen since ").append(reason.getText());
            if (reasonDetails != null) {
                debugLoggingBuilder.get().append(" ").append(reasonDetails);
            }
            debugLoggingBuilder.get().append(".");
        }
        if ((base = (reasonMap = CHOOSE_RANDOM_REASONS.get()).get((Object)reason)) == null) {
            base = 0;
        }
        reasonMap.put(reason, base + 1);
    }

    boolean isGoodDatanode(DatanodeDescriptor node, int maxTargetPerRack, boolean considerLoad, List<DatanodeStorageInfo> results, boolean avoidStaleNodes) {
        if (!node.isInService()) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(node, NodeNotChosenReason.NOT_IN_SERVICE);
            return false;
        }
        if (avoidStaleNodes && node.isStale(this.staleInterval)) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(node, NodeNotChosenReason.NODE_STALE);
            return false;
        }
        if (considerLoad) {
            double maxLoad = this.considerLoadFactor * this.stats.getInServiceXceiverAverage();
            int nodeLoad = node.getXceiverCount();
            if ((double)nodeLoad > maxLoad) {
                BlockPlacementPolicyDefault.logNodeIsNotChosen(node, NodeNotChosenReason.NODE_TOO_BUSY, "(load: " + nodeLoad + " > " + maxLoad + ")");
                return false;
            }
        }
        String rackname = node.getNetworkLocation();
        int counter = 1;
        for (DatanodeStorageInfo resultStorage : results) {
            if (!rackname.equals(resultStorage.getDatanodeDescriptor().getNetworkLocation())) continue;
            ++counter;
        }
        if (counter > maxTargetPerRack) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(node, NodeNotChosenReason.TOO_MANY_NODES_ON_RACK);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatanodeStorageInfo[] getPipeline(Node writer, DatanodeStorageInfo[] storages) {
        if (storages.length == 0) {
            return storages;
        }
        NetworkTopology networkTopology = this.clusterMap;
        synchronized (networkTopology) {
            int index = 0;
            if (writer == null || !this.clusterMap.contains(writer)) {
                writer = storages[0].getDatanodeDescriptor();
            }
            while (index < storages.length) {
                DatanodeStorageInfo shortestStorage = storages[index];
                int shortestDistance = this.clusterMap.getDistance(writer, (Node)shortestStorage.getDatanodeDescriptor());
                int shortestIndex = index;
                for (int i = index + 1; i < storages.length; ++i) {
                    int currentDistance = this.clusterMap.getDistance(writer, (Node)storages[i].getDatanodeDescriptor());
                    if (shortestDistance <= currentDistance) continue;
                    shortestDistance = currentDistance;
                    shortestStorage = storages[i];
                    shortestIndex = i;
                }
                if (index != shortestIndex) {
                    storages[shortestIndex] = storages[index];
                    storages[index] = shortestStorage;
                }
                writer = shortestStorage.getDatanodeDescriptor();
                ++index;
            }
        }
        return storages;
    }

    @Override
    public BlockPlacementStatus verifyBlockPlacement(DatanodeInfo[] locs, int numberOfReplicas) {
        if (locs == null) {
            locs = DatanodeDescriptor.EMPTY_ARRAY;
        }
        if (!this.clusterMap.hasClusterEverBeenMultiRack()) {
            return new BlockPlacementStatusDefault(1, 1, 1);
        }
        int minRacks = 2;
        minRacks = Math.min(minRacks, numberOfReplicas);
        TreeSet<String> racks = new TreeSet<String>();
        for (DatanodeInfo dn : locs) {
            racks.add(dn.getNetworkLocation());
        }
        return new BlockPlacementStatusDefault(racks.size(), minRacks, this.clusterMap.getNumOfRacks());
    }

    @VisibleForTesting
    public DatanodeStorageInfo chooseReplicaToDelete(Collection<DatanodeStorageInfo> moreThanOne, Collection<DatanodeStorageInfo> exactlyOne, List<StorageType> excessTypes, Map<String, List<DatanodeStorageInfo>> rackMap) {
        DatanodeStorageInfo storage;
        long oldestHeartbeat = Time.monotonicNow() - this.heartbeatInterval * (long)this.tolerateHeartbeatMultiplier;
        DatanodeStorageInfo oldestHeartbeatStorage = null;
        long minSpace = Long.MAX_VALUE;
        DatanodeStorageInfo minSpaceStorage = null;
        for (DatanodeStorageInfo storage2 : this.pickupReplicaSet(moreThanOne, exactlyOne, rackMap)) {
            if (!excessTypes.contains(storage2.getStorageType())) continue;
            DatanodeDescriptor node = storage2.getDatanodeDescriptor();
            long free = storage2.getRemaining();
            long lastHeartbeat = node.getLastUpdateMonotonic();
            if (lastHeartbeat < oldestHeartbeat) {
                oldestHeartbeat = lastHeartbeat;
                oldestHeartbeatStorage = storage2;
            }
            if (minSpace <= free) continue;
            minSpace = free;
            minSpaceStorage = storage2;
        }
        if (oldestHeartbeatStorage != null) {
            storage = oldestHeartbeatStorage;
        } else if (minSpaceStorage != null) {
            storage = minSpaceStorage;
        } else {
            return null;
        }
        excessTypes.remove(storage.getStorageType());
        return storage;
    }

    @Override
    public List<DatanodeStorageInfo> chooseReplicasToDelete(Collection<DatanodeStorageInfo> availableReplicas, Collection<DatanodeStorageInfo> delCandidates, int expectedNumOfReplicas, List<StorageType> excessTypes, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        ArrayList<DatanodeStorageInfo> excessReplicas = new ArrayList<DatanodeStorageInfo>();
        HashMap<String, List<DatanodeStorageInfo>> rackMap = new HashMap<String, List<DatanodeStorageInfo>>();
        ArrayList<DatanodeStorageInfo> moreThanOne = new ArrayList<DatanodeStorageInfo>();
        ArrayList<DatanodeStorageInfo> exactlyOne = new ArrayList<DatanodeStorageInfo>();
        this.splitNodesWithRack(availableReplicas, delCandidates, rackMap, moreThanOne, exactlyOne);
        boolean firstOne = true;
        DatanodeStorageInfo delNodeHintStorage = DatanodeStorageInfo.getDatanodeStorageInfo(delCandidates, delNodeHint);
        DatanodeStorageInfo addedNodeStorage = DatanodeStorageInfo.getDatanodeStorageInfo(delCandidates, addedNode);
        while (delCandidates.size() - expectedNumOfReplicas > excessReplicas.size()) {
            DatanodeStorageInfo cur = firstOne && this.useDelHint(delNodeHintStorage, addedNodeStorage, moreThanOne, exactlyOne, excessTypes) ? delNodeHintStorage : this.chooseReplicaToDelete(moreThanOne, exactlyOne, excessTypes, rackMap);
            firstOne = false;
            if (cur == null) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("No excess replica can be found. excessTypes: {}. moreThanOne: {}. exactlyOne: {}.", new Object[]{excessTypes, moreThanOne, exactlyOne});
                break;
            }
            this.adjustSetsWithChosenReplica(rackMap, moreThanOne, exactlyOne, cur);
            excessReplicas.add(cur);
        }
        return excessReplicas;
    }

    @VisibleForTesting
    boolean useDelHint(DatanodeStorageInfo delHint, DatanodeStorageInfo added, List<DatanodeStorageInfo> moreThanOne, Collection<DatanodeStorageInfo> exactlyOne, List<StorageType> excessTypes) {
        if (delHint == null) {
            return false;
        }
        if (!excessTypes.contains(delHint.getStorageType())) {
            return false;
        }
        return this.notReduceNumOfGroups(moreThanOne, delHint, added);
    }

    <T> boolean notReduceNumOfGroups(List<T> moreThanOne, T source, T target) {
        if (moreThanOne.contains(source)) {
            return true;
        }
        return target != null && !moreThanOne.contains(target);
    }

    @Override
    public boolean isMovable(Collection<DatanodeInfo> locs, DatanodeInfo source, DatanodeInfo target) {
        HashMap rackMap = new HashMap();
        ArrayList moreThanOne = new ArrayList();
        ArrayList exactlyOne = new ArrayList();
        this.splitNodesWithRack(locs, locs, rackMap, moreThanOne, exactlyOne);
        return this.notReduceNumOfGroups(moreThanOne, source, target);
    }

    protected Collection<DatanodeStorageInfo> pickupReplicaSet(Collection<DatanodeStorageInfo> moreThanOne, Collection<DatanodeStorageInfo> exactlyOne, Map<String, List<DatanodeStorageInfo>> rackMap) {
        ArrayList<DatanodeStorageInfo> ret = new ArrayList<DatanodeStorageInfo>();
        if (rackMap.size() == 2) {
            for (List<DatanodeStorageInfo> dsi : rackMap.values()) {
                if (dsi.size() < 2) continue;
                ret.addAll(dsi);
            }
        }
        if (ret.isEmpty()) {
            ret.addAll(moreThanOne);
            ret.addAll(exactlyOne);
        }
        return ret;
    }

    @VisibleForTesting
    void setPreferLocalNode(boolean prefer) {
        this.preferLocalNode = prefer;
    }

    private static enum NodeNotChosenReason {
        NOT_IN_SERVICE("the node is not in service"),
        NODE_STALE("the node is stale"),
        NODE_TOO_BUSY("the node is too busy"),
        TOO_MANY_NODES_ON_RACK("the rack has too many chosen nodes"),
        NOT_ENOUGH_STORAGE_SPACE("not enough storage space to place the block");

        private final String text;

        private NodeNotChosenReason(String logText) {
            this.text = logText;
        }

        private String getText() {
            return this.text;
        }
    }
}

