/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputChecker;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.FsDatasetTestUtils;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;

public class TestDFSShell {
    private static final Log LOG = LogFactory.getLog(TestDFSShell.class);
    private static final AtomicInteger counter = new AtomicInteger();
    private final int SUCCESS = 0;
    private final int ERROR = 1;
    static final String TEST_ROOT_DIR = PathUtils.getTestDirName(TestDFSShell.class);
    private static final String RAW_A1 = "raw.a1";
    private static final String TRUSTED_A1 = "trusted.a1";
    private static final String USER_A1 = "user.a1";
    private static final byte[] RAW_A1_VALUE = new byte[]{50, 50, 50};
    private static final byte[] TRUSTED_A1_VALUE = new byte[]{49, 49, 49};
    private static final byte[] USER_A1_VALUE = new byte[]{49, 50, 51};
    private static final int BLOCK_SIZE = 1024;
    private static MiniDFSCluster miniCluster;
    private static DistributedFileSystem dfs;
    @Rule
    public Timeout globalTimeout = new Timeout(30000);

    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.permissions.enabled", true);
        conf.setInt("dfs.blocksize", 1024);
        conf.set("hdfs.minidfs.basedir", GenericTestUtils.getTestDir((String)"TestDFSShell").getAbsolutePath());
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setLong("dfs.namenode.accesstime.precision", 1000L);
        miniCluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        miniCluster.waitActive();
        dfs = miniCluster.getFileSystem();
    }

    @AfterClass
    public static void tearDown() {
        if (miniCluster != null) {
            miniCluster.shutdown(true, true);
        }
    }

    static Path writeFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream out = fs.create(f);
        out.writeBytes("dhruba: " + f);
        out.close();
        Assert.assertTrue((boolean)fs.exists(f));
        return f;
    }

    static Path writeByte(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream out = fs.create(f);
        out.writeByte(1);
        out.close();
        Assert.assertTrue((boolean)fs.exists(f));
        return f;
    }

    static Path mkdir(FileSystem fs, Path p) throws IOException {
        Assert.assertTrue((boolean)fs.mkdirs(p));
        Assert.assertTrue((boolean)fs.exists(p));
        Assert.assertTrue((boolean)fs.getFileStatus(p).isDirectory());
        return p;
    }

    static void rmr(FileSystem fs, Path p) throws IOException {
        Assert.assertTrue((boolean)fs.delete(p, true));
        Assert.assertFalse((boolean)fs.exists(p));
    }

    static File createLocalFile(File f) throws IOException {
        Assert.assertTrue((!f.exists() ? 1 : 0) != 0);
        PrintWriter out = new PrintWriter(f);
        out.print("createLocalFile: " + f.getAbsolutePath());
        out.flush();
        out.close();
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f.isFile());
        return f;
    }

    static File createLocalFileWithRandomData(int fileLength, File f) throws IOException {
        Assert.assertTrue((!f.exists() ? 1 : 0) != 0);
        f.createNewFile();
        FileOutputStream out = new FileOutputStream(f.toString());
        byte[] buffer = new byte[fileLength];
        out.write(buffer);
        out.flush();
        out.close();
        return f;
    }

    static void show(String s) {
        System.out.println(Thread.currentThread().getStackTrace()[2] + " " + s);
    }

    @Test(timeout=30000L)
    public void testZeroSizeFile() throws IOException {
        File f1 = new File(TEST_ROOT_DIR, "f1");
        Assert.assertTrue((!f1.exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)f1.createNewFile());
        Assert.assertTrue((boolean)f1.exists());
        Assert.assertTrue((boolean)f1.isFile());
        Assert.assertEquals((long)0L, (long)f1.length());
        Path root = TestDFSShell.mkdir((FileSystem)dfs, new Path("/testZeroSizeFile/zeroSizeFile"));
        Path remotef = new Path(root, "dst");
        TestDFSShell.show("copy local " + f1 + " to remote " + remotef);
        dfs.copyFromLocalFile(false, false, new Path(f1.getPath()), remotef);
        TestDFSShell.show("Block size = " + dfs.getFileStatus(remotef).getBlockSize());
        File f2 = new File(TEST_ROOT_DIR, "f2");
        Assert.assertTrue((!f2.exists() ? 1 : 0) != 0);
        dfs.copyToLocalFile(remotef, new Path(f2.getPath()));
        Assert.assertTrue((boolean)f2.exists());
        Assert.assertTrue((boolean)f2.isFile());
        Assert.assertEquals((long)0L, (long)f2.length());
        f1.delete();
        f2.delete();
    }

    @Test(timeout=30000L)
    public void testRecursiveRm() throws IOException {
        Path parent = new Path("/testRecursiveRm", "parent");
        Path child = new Path(parent, "child");
        dfs.mkdirs(child);
        try {
            dfs.delete(parent, false);
            Assert.fail((String)"Should have failed because dir is not empty");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        dfs.delete(parent, true);
        Assert.assertFalse((boolean)dfs.exists(parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testDu() throws IOException {
        int replication = 2;
        PrintStream psBackup = System.out;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(out);
        System.setOut(psOut);
        FsShell shell = new FsShell(dfs.getConf());
        try {
            Path myPath = new Path("/testDu", "dir");
            Assert.assertTrue((boolean)dfs.mkdirs(myPath));
            Assert.assertTrue((boolean)dfs.exists(myPath));
            Path myFile = new Path(myPath, "file");
            TestDFSShell.writeFile((FileSystem)dfs, myFile);
            Assert.assertTrue((boolean)dfs.exists(myFile));
            Path myFile2 = new Path(myPath, "file2");
            TestDFSShell.writeFile((FileSystem)dfs, myFile2);
            Assert.assertTrue((boolean)dfs.exists(myFile2));
            Long myFileLength = dfs.getFileStatus(myFile).getLen();
            Long myFileDiskUsed = myFileLength * (long)replication;
            Long myFile2Length = dfs.getFileStatus(myFile2).getLen();
            Long myFile2DiskUsed = myFile2Length * (long)replication;
            String[] args = new String[]{"-du", myPath.toString()};
            int val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertTrue((val == 0 ? 1 : 0) != 0);
            String returnString = out.toString();
            out.reset();
            Assert.assertThat((Object)returnString, (Matcher)StringContains.containsString((String)myFileLength.toString()));
            Assert.assertThat((Object)returnString, (Matcher)StringContains.containsString((String)myFileDiskUsed.toString()));
            Assert.assertThat((Object)returnString, (Matcher)StringContains.containsString((String)myFile2Length.toString()));
            Assert.assertThat((Object)returnString, (Matcher)StringContains.containsString((String)myFile2DiskUsed.toString()));
            String snapshotName = "ss1";
            Path snapshotPath = new Path(myPath, ".snapshot/" + snapshotName);
            dfs.allowSnapshot(myPath);
            Assert.assertThat((Object)dfs.createSnapshot(myPath, snapshotName), (Matcher)CoreMatchers.is((Object)snapshotPath));
            Assert.assertThat((Object)dfs.delete(myFile, false), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)dfs.exists(myFile), (Matcher)CoreMatchers.is((Object)false));
            args = new String[]{"-du", "-s", snapshotPath.toString()};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertThat((Object)val, (Matcher)CoreMatchers.is((Object)0));
            returnString = out.toString();
            out.reset();
            Long combinedLength = myFileLength + myFile2Length;
            Long combinedDiskUsed = myFileDiskUsed + myFile2DiskUsed;
            Assert.assertThat((Object)returnString, (Matcher)StringContains.containsString((String)combinedLength.toString()));
            Assert.assertThat((Object)returnString, (Matcher)StringContains.containsString((String)combinedDiskUsed.toString()));
            Path myFile3 = new Path(myPath, "file3");
            TestDFSShell.writeByte((FileSystem)dfs, myFile3);
            Assert.assertTrue((boolean)dfs.exists(myFile3));
            args = new String[]{"-du", myFile3.toString(), myFile2.toString()};
            val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((String)"Return code should be 0.", (long)0L, (long)val);
            returnString = out.toString();
            out.reset();
            Assert.assertTrue((boolean)returnString.contains("1   2   " + myFile3.toString()));
            Assert.assertTrue((boolean)returnString.contains("25  50  " + myFile2.toString()));
        }
        finally {
            System.setOut(psBackup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testDuSnapshots() throws IOException {
        int replication = 2;
        PrintStream psBackup = System.out;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(out);
        FsShell shell = new FsShell(dfs.getConf());
        try {
            System.setOut(psOut);
            Path parent = new Path("/testDuSnapshots");
            Path dir = new Path(parent, "dir");
            TestDFSShell.mkdir((FileSystem)dfs, dir);
            Path file = new Path(dir, "file");
            TestDFSShell.writeFile((FileSystem)dfs, file);
            Path file2 = new Path(dir, "file2");
            TestDFSShell.writeFile((FileSystem)dfs, file2);
            Long fileLength = dfs.getFileStatus(file).getLen();
            Long fileDiskUsed = fileLength * 2L;
            Long file2Length = dfs.getFileStatus(file2).getLen();
            Long file2DiskUsed = file2Length * 2L;
            int ret = -1;
            try {
                ret = shell.run(new String[]{"-du", dir.toString()});
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)ret);
            String returnString = out.toString();
            LOG.info((Object)("-du return is:\n" + returnString));
            Assert.assertTrue((boolean)returnString.contains(fileLength.toString()));
            Assert.assertTrue((boolean)returnString.contains(fileDiskUsed.toString()));
            Assert.assertTrue((boolean)returnString.contains(file2Length.toString()));
            Assert.assertTrue((boolean)returnString.contains(file2DiskUsed.toString()));
            out.reset();
            String snapshotName = "ss1";
            Path snapshotPath = new Path(parent, ".snapshot/ss1");
            dfs.allowSnapshot(parent);
            Assert.assertThat((Object)dfs.createSnapshot(parent, "ss1"), (Matcher)CoreMatchers.is((Object)snapshotPath));
            TestDFSShell.rmr((FileSystem)dfs, file);
            Path newFile = new Path(dir, "newfile");
            TestDFSShell.writeFile((FileSystem)dfs, newFile);
            Long newFileLength = dfs.getFileStatus(newFile).getLen();
            Long newFileDiskUsed = newFileLength * 2L;
            ret = -1;
            try {
                ret = shell.run(new String[]{"-du", "-s", parent.toString()});
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)ret);
            returnString = out.toString();
            LOG.info((Object)("-du -s return is:\n" + returnString));
            Long combinedLength = fileLength + file2Length + newFileLength;
            Long combinedDiskUsed = fileDiskUsed + file2DiskUsed + newFileDiskUsed;
            Assert.assertTrue((boolean)returnString.contains(combinedLength.toString()));
            Assert.assertTrue((boolean)returnString.contains(combinedDiskUsed.toString()));
            out.reset();
            ret = -1;
            try {
                ret = shell.run(new String[]{"-du", parent.toString()});
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)ret);
            returnString = out.toString();
            LOG.info((Object)("-du return is:\n" + returnString));
            Assert.assertTrue((boolean)returnString.contains(combinedLength.toString()));
            Assert.assertTrue((boolean)returnString.contains(combinedDiskUsed.toString()));
            out.reset();
            ret = -1;
            try {
                ret = shell.run(new String[]{"-du", "-s", "-x", parent.toString()});
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)ret);
            returnString = out.toString();
            LOG.info((Object)("-du -s -x return is:\n" + returnString));
            Long exludeSnapshotLength = file2Length + newFileLength;
            Long excludeSnapshotDiskUsed = file2DiskUsed + newFileDiskUsed;
            Assert.assertTrue((boolean)returnString.contains(exludeSnapshotLength.toString()));
            Assert.assertTrue((boolean)returnString.contains(excludeSnapshotDiskUsed.toString()));
            out.reset();
            ret = -1;
            try {
                ret = shell.run(new String[]{"-du", "-x", parent.toString()});
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)ret);
            returnString = out.toString();
            LOG.info((Object)("-du -x return is:\n" + returnString));
            Assert.assertTrue((boolean)returnString.contains(exludeSnapshotLength.toString()));
            Assert.assertTrue((boolean)returnString.contains(excludeSnapshotDiskUsed.toString()));
            out.reset();
        }
        finally {
            System.setOut(psBackup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testCountSnapshots() throws IOException {
        PrintStream psBackup = System.out;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream psOut = new PrintStream(out);
        System.setOut(psOut);
        FsShell shell = new FsShell(dfs.getConf());
        try {
            Path parent = new Path("/testCountSnapshots");
            Path dir = new Path(parent, "dir");
            TestDFSShell.mkdir((FileSystem)dfs, dir);
            Path file = new Path(dir, "file");
            TestDFSShell.writeFile((FileSystem)dfs, file);
            Path file2 = new Path(dir, "file2");
            TestDFSShell.writeFile((FileSystem)dfs, file2);
            long fileLength = dfs.getFileStatus(file).getLen();
            long file2Length = dfs.getFileStatus(file2).getLen();
            Path dir2 = new Path(parent, "dir2");
            TestDFSShell.mkdir((FileSystem)dfs, dir2);
            String snapshotName = "s1";
            Path snapshotPath = new Path(parent, ".snapshot/s1");
            dfs.allowSnapshot(parent);
            Assert.assertThat((Object)dfs.createSnapshot(parent, "s1"), (Matcher)CoreMatchers.is((Object)snapshotPath));
            TestDFSShell.rmr((FileSystem)dfs, file);
            TestDFSShell.rmr((FileSystem)dfs, dir2);
            Path newFile = new Path(dir, "new file");
            TestDFSShell.writeFile((FileSystem)dfs, newFile);
            Long newFileLength = dfs.getFileStatus(newFile).getLen();
            int val = -1;
            try {
                val = shell.run(new String[]{"-count", "-v", parent.toString()});
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)val);
            String returnString = out.toString();
            LOG.info((Object)("-count return is:\n" + returnString));
            Scanner in = new Scanner(returnString);
            in.nextLine();
            Assert.assertEquals((long)3L, (long)in.nextLong());
            Assert.assertEquals((long)3L, (long)in.nextLong());
            Assert.assertEquals((long)(fileLength + file2Length + newFileLength), (long)in.nextLong());
            out.reset();
            val = -1;
            try {
                val = shell.run(new String[]{"-count", "-x", "-v", parent.toString()});
            }
            catch (Exception e) {
                System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
            }
            Assert.assertEquals((long)0L, (long)val);
            returnString = out.toString();
            LOG.info((Object)("-count -x return is:\n" + returnString));
            in = new Scanner(returnString);
            in.nextLine();
            Assert.assertEquals((long)2L, (long)in.nextLong());
            Assert.assertEquals((long)2L, (long)in.nextLong());
            Assert.assertEquals((long)(file2Length + newFileLength), (long)in.nextLong());
            out.reset();
        }
        finally {
            System.setOut(psBackup);
        }
    }

    @Test(timeout=30000L)
    public void testPut() throws IOException {
        new File(TEST_ROOT_DIR, ".f1.crc").delete();
        new File(TEST_ROOT_DIR, ".f2.crc").delete();
        File f1 = TestDFSShell.createLocalFile(new File(TEST_ROOT_DIR, "f1"));
        final File f2 = TestDFSShell.createLocalFile(new File(TEST_ROOT_DIR, "f2"));
        Path root = TestDFSShell.mkdir((FileSystem)dfs, new Path("/testPut"));
        final Path dst = new Path(root, "dst");
        TestDFSShell.show("begin");
        final Thread copy2ndFileThread = new Thread(){

            @Override
            public void run() {
                try {
                    TestDFSShell.show("copy local " + f2 + " to remote " + dst);
                    dfs.copyFromLocalFile(false, false, new Path(f2.getPath()), dst);
                }
                catch (IOException ioe) {
                    TestDFSShell.show("good " + StringUtils.stringifyException((Throwable)ioe));
                    return;
                }
                Assert.assertTrue((boolean)false);
            }
        };
        SecurityManager sm = System.getSecurityManager();
        System.out.println("SecurityManager = " + sm);
        System.setSecurityManager(new SecurityManager(){
            private boolean firstTime = true;

            @Override
            public void checkPermission(Permission perm) {
                String s;
                Thread t;
                if (this.firstTime && !(t = Thread.currentThread()).toString().contains("DataNode") && (s = "" + Arrays.asList(t.getStackTrace())).contains("FileUtil.copyContent")) {
                    this.firstTime = false;
                    copy2ndFileThread.start();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        TestDFSShell.show("copy local " + f1 + " to remote " + dst);
        dfs.copyFromLocalFile(false, false, new Path(f1.getPath()), dst);
        TestDFSShell.show("done");
        try {
            copy2ndFileThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.setSecurityManager(sm);
        Path destmultiple = TestDFSShell.mkdir((FileSystem)dfs, new Path(root, "putmultiple"));
        Path[] srcs = new Path[]{new Path(f1.getPath()), new Path(f2.getPath())};
        dfs.copyFromLocalFile(false, false, srcs, destmultiple);
        srcs[0] = new Path(destmultiple, "f1");
        srcs[1] = new Path(destmultiple, "f2");
        Assert.assertTrue((boolean)dfs.exists(srcs[0]));
        Assert.assertTrue((boolean)dfs.exists(srcs[1]));
        Path destmultiple2 = TestDFSShell.mkdir((FileSystem)dfs, new Path(root, "movemultiple"));
        srcs[0] = new Path(f1.getPath());
        srcs[1] = new Path(f2.getPath());
        dfs.moveFromLocalFile(srcs, destmultiple2);
        Assert.assertFalse((boolean)f1.exists());
        Assert.assertFalse((boolean)f2.exists());
        srcs[0] = new Path(destmultiple2, "f1");
        srcs[1] = new Path(destmultiple2, "f2");
        Assert.assertTrue((boolean)dfs.exists(srcs[0]));
        Assert.assertTrue((boolean)dfs.exists(srcs[1]));
        f1.delete();
        f2.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(timeout=30000L)
    public void testErrOutPut() throws Exception {
        PrintStream bak = null;
        try {
            Path root = new Path("/nonexistentfile");
            bak = System.err;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream tmp = new PrintStream(out);
            System.setErr(tmp);
            String[] argv = new String[]{"-cat", root.toUri().getPath()};
            int ret = ToolRunner.run((Tool)new FsShell(), (String[])argv);
            Assert.assertEquals((String)" -cat returned 1 ", (long)1L, (long)ret);
            String returned = out.toString();
            Assert.assertTrue((String)"cat does not print exceptions ", (returned.lastIndexOf("Exception") == -1 ? 1 : 0) != 0);
            out.reset();
            argv[0] = "-rm";
            argv[1] = root.toString();
            FsShell shell = new FsShell(dfs.getConf());
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" -rm returned 1 ", (long)1L, (long)ret);
            returned = out.toString();
            out.reset();
            Assert.assertTrue((String)"rm prints reasonable error ", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
            argv[0] = "-rmr";
            argv[1] = root.toString();
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" -rmr returned 1", (long)1L, (long)ret);
            returned = out.toString();
            Assert.assertTrue((String)"rmr prints reasonable error ", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
            out.reset();
            argv[0] = "-du";
            argv[1] = "/nonexistentfile";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            returned = out.toString();
            Assert.assertTrue((String)" -du prints reasonable error ", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
            out.reset();
            argv[0] = "-dus";
            argv[1] = "/nonexistentfile";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            returned = out.toString();
            Assert.assertTrue((String)" -dus prints reasonable error", (returned.lastIndexOf("No such file or directory") != -1 ? 1 : 0) != 0);
            out.reset();
            argv[0] = "-ls";
            argv[1] = "/nonexistenfile";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            returned = out.toString();
            Assert.assertTrue((String)" -ls does not return Found 0 items", (returned.lastIndexOf("Found 0") == -1 ? 1 : 0) != 0);
            out.reset();
            argv[0] = "-ls";
            argv[1] = "/nonexistentfile";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" -lsr should fail ", (long)1L, (long)ret);
            out.reset();
            dfs.mkdirs(new Path("/testdir"));
            argv[0] = "-ls";
            argv[1] = "/testdir";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            returned = out.toString();
            Assert.assertTrue((String)" -ls does not print out anything ", (returned.lastIndexOf("Found 0") == -1 ? 1 : 0) != 0);
            out.reset();
            argv[0] = "-ls";
            argv[1] = "/user/nonxistant/*";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" -ls on nonexistent glob returns 1", (long)1L, (long)ret);
            out.reset();
            argv[0] = "-mkdir";
            argv[1] = "/testdir";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            returned = out.toString();
            Assert.assertEquals((String)" -mkdir returned 1 ", (long)1L, (long)ret);
            Assert.assertTrue((String)" -mkdir returned File exists", (returned.lastIndexOf("File exists") != -1 ? 1 : 0) != 0);
            Path testFile = new Path("/testfile");
            FSDataOutputStream outtmp = dfs.create(testFile);
            outtmp.write(testFile.toString().getBytes());
            outtmp.close();
            out.reset();
            argv[0] = "-mkdir";
            argv[1] = "/testfile";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            returned = out.toString();
            Assert.assertEquals((String)" -mkdir returned 1", (long)1L, (long)ret);
            Assert.assertTrue((String)" -mkdir returned this is a file ", (returned.lastIndexOf("not a directory") != -1 ? 1 : 0) != 0);
            out.reset();
            argv = new String[]{"-mv", "/testfile", "/no-such-dir/file"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"mv failed to rename", (long)1L, (long)ret);
            out.reset();
            argv = new String[]{"-mv", "/testfile", "/testfiletest"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            returned = out.toString();
            Assert.assertTrue((String)"no output from rename", (returned.lastIndexOf("Renamed") == -1 ? 1 : 0) != 0);
            out.reset();
            argv[0] = "-mv";
            argv[1] = "/testfile";
            argv[2] = "/testfiletmp";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            returned = out.toString();
            Assert.assertTrue((String)" unix like output", (returned.lastIndexOf("No such file or") != -1 ? 1 : 0) != 0);
            out.reset();
            argv = new String[]{"-du"};
            dfs.mkdirs(dfs.getHomeDirectory());
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            returned = out.toString();
            Assert.assertEquals((String)" no error ", (long)0L, (long)ret);
            Assert.assertTrue((String)"empty path specified", (returned.lastIndexOf("empty string") == -1 ? 1 : 0) != 0);
            out.reset();
            argv = new String[]{"-test", "-d", "/no/such/dir"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            returned = out.toString();
            Assert.assertEquals((String)" -test -d wrong result ", (long)1L, (long)ret);
            Assert.assertTrue((boolean)returned.isEmpty());
            if (bak == null) return;
        }
        catch (Throwable throwable) {
            if (bak == null) throw throwable;
            System.setErr(bak);
            throw throwable;
        }
        System.setErr(bak);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveWithTargetPortEmpty() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(2).nameNodePort(ServerSocketUtil.waitForPort((int)8020, (int)60)).waitSafeMode(true).build();
            DistributedFileSystem srcFs = cluster.getFileSystem();
            FsShell shell = new FsShell();
            shell.setConf((Configuration)conf);
            String[] argv = new String[]{"-mkdir", "/testfile"};
            ToolRunner.run((Tool)shell, (String[])argv);
            argv = new String[]{"-mv", srcFs.getUri() + "/testfile", "hdfs://" + srcFs.getUri().getHost() + "/testfile2"};
            int ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"mv should have succeeded", (long)0L, (long)ret);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testURIPaths() throws Exception {
        HdfsConfiguration srcConf = new HdfsConfiguration();
        HdfsConfiguration dstConf = new HdfsConfiguration();
        MiniDFSCluster srcCluster = null;
        MiniDFSCluster dstCluster = null;
        File bak = new File(PathUtils.getTestDir(this.getClass()), "testURIPaths");
        bak.mkdirs();
        try {
            srcCluster = new MiniDFSCluster.Builder((Configuration)srcConf).numDataNodes(2).build();
            dstConf.set("hdfs.minidfs.basedir", bak.getAbsolutePath());
            dstCluster = new MiniDFSCluster.Builder((Configuration)dstConf).numDataNodes(2).build();
            DistributedFileSystem srcFs = srcCluster.getFileSystem();
            DistributedFileSystem dstFs = dstCluster.getFileSystem();
            FsShell shell = new FsShell();
            shell.setConf((Configuration)srcConf);
            String[] argv = new String[]{"-ls", dstFs.getUri().toString() + "/"};
            int ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"ls works on remote uri ", (long)0L, (long)ret);
            dstFs.mkdirs(new Path("/hadoopdir"));
            argv = new String[]{"-rmr", dstFs.getUri().toString() + "/hadoopdir"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)("-rmr works on remote uri " + argv[1]), (long)0L, (long)ret);
            argv[0] = "-du";
            argv[1] = dstFs.getUri().toString() + "/";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"du works on remote uri ", (long)0L, (long)ret);
            File furi = new File(TEST_ROOT_DIR, "furi");
            TestDFSShell.createLocalFile(furi);
            argv = new String[]{"-put", furi.toURI().toString(), dstFs.getUri().toString() + "/furi"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" put is working ", (long)0L, (long)ret);
            argv[0] = "-cp";
            argv[1] = dstFs.getUri().toString() + "/furi";
            argv[2] = srcFs.getUri().toString() + "/furi";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" cp is working ", (long)0L, (long)ret);
            Assert.assertTrue((boolean)srcFs.exists(new Path("/furi")));
            argv = new String[]{"-cat", dstFs.getUri().toString() + "/furi"};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" cat is working ", (long)0L, (long)ret);
            dstFs.delete(new Path("/furi"), true);
            dstFs.delete(new Path("/hadoopdir"), true);
            String file = "/tmp/chownTest";
            Path path = new Path(file);
            Path parent = new Path("/tmp");
            Path root = new Path("/");
            TestDFSShell.writeFile((FileSystem)dstFs, path);
            TestDFSShell.runCmd(shell, "-chgrp", "-R", "herbivores", dstFs.getUri().toString() + "/*");
            this.confirmOwner(null, "herbivores", (FileSystem)dstFs, parent, path);
            TestDFSShell.runCmd(shell, "-chown", "-R", ":reptiles", dstFs.getUri().toString() + "/");
            this.confirmOwner(null, "reptiles", (FileSystem)dstFs, root, parent, path);
            argv[0] = "-cat";
            argv[1] = "hdfs:///furi";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)" default works for cat", (long)0L, (long)ret);
            argv[0] = "-ls";
            argv[1] = "hdfs:///";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"default works for ls ", (long)0L, (long)ret);
            argv[0] = "-rmr";
            argv[1] = "hdfs:///furi";
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"default works for rm/rmr", (long)0L, (long)ret);
        }
        finally {
            if (null != srcCluster) {
                srcCluster.shutdown();
            }
            if (null != dstCluster) {
                dstCluster.shutdown();
            }
        }
    }

    @Test(timeout=30000L)
    public void testHead() throws Exception {
        int fileLen = 5120;
        Path testFile = new Path("testHead", "file1");
        String text = RandomStringUtils.randomAscii((int)5120);
        try (FSDataOutputStream pout = dfs.create(testFile);){
            pout.write(text.getBytes());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        Object[] argv = new String[]{"-head", testFile.toString()};
        int ret = ToolRunner.run((Tool)new FsShell(dfs.getConf()), (String[])argv);
        Assert.assertEquals((String)(Arrays.toString(argv) + " returned " + ret), (long)0L, (long)ret);
        Assert.assertEquals((String)("-head returned " + out.size() + " bytes data, expected 1KB"), (long)1024L, (long)out.size());
        Assert.assertArrayEquals((String)"Head output doesn't match input", (byte[])text.substring(0, 1024).getBytes(), (byte[])out.toByteArray());
        out.reset();
    }

    @Test(timeout=30000L)
    public void testTail() throws Exception {
        int fileLen = 5120;
        Path testFile = new Path("testTail", "file1");
        String text = RandomStringUtils.randomAscii((int)5120);
        try (FSDataOutputStream pout = dfs.create(testFile);){
            pout.write(text.getBytes());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        Object[] argv = new String[]{"-tail", testFile.toString()};
        int ret = ToolRunner.run((Tool)new FsShell(dfs.getConf()), (String[])argv);
        Assert.assertEquals((String)(Arrays.toString(argv) + " returned " + ret), (long)0L, (long)ret);
        Assert.assertEquals((String)("-tail returned " + out.size() + " bytes data, expected 1KB"), (long)1024L, (long)out.size());
        Assert.assertArrayEquals((String)"Tail output doesn't match input", (byte[])text.substring(4096).getBytes(), (byte[])out.toByteArray());
        out.reset();
    }

    @Test(timeout=30000L)
    public void testTailWithFresh() throws Exception {
        final Path testFile = new Path("testTailWithFresh", "file1");
        dfs.create(testFile);
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        final Thread tailer = new Thread(){

            @Override
            public void run() {
                String[] argv = new String[]{"-tail", "-f", testFile.toString()};
                try {
                    ToolRunner.run((Tool)new FsShell(dfs.getConf()), (String[])argv);
                }
                catch (Exception e) {
                    LOG.error((Object)"Client that tails the test file fails", (Throwable)e);
                }
                finally {
                    out.reset();
                }
            }
        };
        tailer.start();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return tailer.getState() == Thread.State.TIMED_WAITING;
            }
        }, (long)100L, (long)10000L);
        final String text = RandomStringUtils.randomAscii((int)512);
        try (FSDataOutputStream pout = dfs.create(testFile);){
            pout.write(text.getBytes());
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return Arrays.equals(text.getBytes(), out.toByteArray());
            }
        }, (long)100L, (long)10000L);
    }

    @Test(timeout=30000L)
    public void testText() throws Exception {
        Configuration conf = dfs.getConf();
        this.textTest(new Path("/texttest").makeQualified(dfs.getUri(), dfs.getWorkingDirectory()), conf);
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        this.textTest(new Path(TEST_ROOT_DIR, "texttest").makeQualified(lfs.getUri(), lfs.getWorkingDirectory()), conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void textTest(Path root, Configuration conf) throws Exception {
        PrintStream bak = null;
        try {
            FileSystem fs = root.getFileSystem(conf);
            fs.mkdirs(root);
            GZIPOutputStream zout = new GZIPOutputStream((OutputStream)fs.create(new Path(root, "file.gz")));
            Random r = new Random();
            bak = System.out;
            ByteArrayOutputStream file = new ByteArrayOutputStream();
            for (int i = 0; i < 1024; ++i) {
                char c = Character.forDigit(r.nextInt(26) + 10, 36);
                file.write(c);
                ((OutputStream)zout).write(c);
            }
            ((OutputStream)zout).close();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            String[] argv = new String[]{"-text", new Path(root, "file.gz").toString()};
            int ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
            Assert.assertEquals((String)("'-text " + argv[1] + " returned " + ret), (long)0L, (long)ret);
            Assert.assertTrue((String)"Output doesn't match input", (boolean)Arrays.equals(file.toByteArray(), out.toByteArray()));
            SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)new Path(root, "file.gz")), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});
            writer.append((Writable)new Text("Foo"), (Writable)new Text("Bar"));
            writer.close();
            out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            argv = new String[]{"-text", new Path(root, "file.gz").toString()};
            ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
            Assert.assertEquals((String)("'-text " + argv[1] + " returned " + ret), (long)0L, (long)ret);
            Assert.assertTrue((String)"Output doesn't match input", (boolean)Arrays.equals("Foo\tBar\n".getBytes(), out.toByteArray()));
            out.reset();
            DeflaterOutputStream dout = new DeflaterOutputStream((OutputStream)fs.create(new Path(root, "file.deflate")));
            byte[] outbytes = "foo".getBytes();
            ((OutputStream)dout).write(outbytes);
            ((OutputStream)dout).close();
            out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            argv = new String[]{"-text", new Path(root, "file.deflate").toString()};
            ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
            Assert.assertEquals((String)("'-text " + argv[1] + " returned " + ret), (long)0L, (long)ret);
            Assert.assertTrue((String)"Output doesn't match input", (boolean)Arrays.equals(outbytes, out.toByteArray()));
            out.reset();
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(BZip2Codec.class, (Configuration)conf);
            String extension = codec.getDefaultExtension();
            Path p = new Path(root, "file." + extension);
            DataOutputStream fout = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fs.create(p, true)));
            byte[] writebytes = "foo".getBytes();
            ((OutputStream)fout).write(writebytes);
            ((OutputStream)fout).close();
            out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            argv = new String[]{"-text", new Path(root, p).toString()};
            ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
            Assert.assertEquals((String)("'-text " + argv[1] + " returned " + ret), (long)0L, (long)ret);
            Assert.assertTrue((String)"Output doesn't match input", (boolean)Arrays.equals(writebytes, out.toByteArray()));
            out.reset();
            FSDataOutputStream pout = fs.create(new Path(root, "file.txt"));
            writebytes = "bar".getBytes();
            pout.write(writebytes);
            pout.close();
            out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            argv = new String[]{"-text", new Path(root, "file.txt").toString()};
            ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv);
            Assert.assertEquals((String)("'-text " + argv[1] + " returned " + ret), (long)0L, (long)ret);
            Assert.assertTrue((String)"Output doesn't match input", (boolean)Arrays.equals(writebytes, out.toByteArray()));
            out.reset();
            if (null == bak) return;
        }
        catch (Throwable throwable) {
            if (null == bak) throw throwable;
            System.setOut(bak);
            throw throwable;
        }
        System.setOut(bak);
    }

    @Test(timeout=30000L)
    public void testCopyToLocal() throws IOException {
        FsShell shell = new FsShell(dfs.getConf());
        String root = TestDFSShell.createTree((FileSystem)dfs, "copyToLocal");
        try {
            Assert.assertEquals((long)0L, (long)TestDFSShell.runCmd(shell, "-copyToLocal", root + "*", TEST_ROOT_DIR));
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        File localroot = new File(TEST_ROOT_DIR, "copyToLocal");
        File localroot2 = new File(TEST_ROOT_DIR, "copyToLocal2");
        File f1 = new File(localroot, "f1");
        Assert.assertTrue((String)"Copying failed.", (boolean)f1.isFile());
        File f2 = new File(localroot, "f2");
        Assert.assertTrue((String)"Copying failed.", (boolean)f2.isFile());
        File sub = new File(localroot, "sub");
        Assert.assertTrue((String)"Copying failed.", (boolean)sub.isDirectory());
        File f3 = new File(sub, "f3");
        Assert.assertTrue((String)"Copying failed.", (boolean)f3.isFile());
        File f4 = new File(sub, "f4");
        Assert.assertTrue((String)"Copying failed.", (boolean)f4.isFile());
        File f5 = new File(localroot2, "f1");
        Assert.assertTrue((String)"Copying failed.", (boolean)f5.isFile());
        f1.delete();
        f2.delete();
        f3.delete();
        f4.delete();
        f5.delete();
        sub.delete();
        String[] args = new String[]{"-copyToLocal", "nosuchfile", TEST_ROOT_DIR};
        try {
            Assert.assertEquals((long)1L, (long)shell.run(args));
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        File f6 = new File(TEST_ROOT_DIR, "nosuchfile");
        Assert.assertTrue((!f6.exists() ? 1 : 0) != 0);
    }

    static String createTree(FileSystem fs, String name) throws IOException {
        String path = "/test/" + name;
        Path root = TestDFSShell.mkdir(fs, new Path(path));
        Path sub = TestDFSShell.mkdir(fs, new Path(root, "sub"));
        Path root2 = TestDFSShell.mkdir(fs, new Path(path + "2"));
        TestDFSShell.writeFile(fs, new Path(root, "f1"));
        TestDFSShell.writeFile(fs, new Path(root, "f2"));
        TestDFSShell.writeFile(fs, new Path(sub, "f3"));
        TestDFSShell.writeFile(fs, new Path(sub, "f4"));
        TestDFSShell.writeFile(fs, new Path(root2, "f1"));
        TestDFSShell.mkdir(fs, new Path(root2, "sub"));
        return path;
    }

    @Test(timeout=30000L)
    public void testCount() throws Exception {
        FsShell shell = new FsShell(dfs.getConf());
        String root = TestDFSShell.createTree((FileSystem)dfs, "count");
        TestDFSShell.runCount(root, 2L, 4L, shell);
        TestDFSShell.runCount(root + "2", 2L, 1L, shell);
        TestDFSShell.runCount(root + "2/f1", 0L, 1L, shell);
        TestDFSShell.runCount(root + "2/sub", 1L, 0L, shell);
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)dfs.getConf());
        Path localpath = new Path(TEST_ROOT_DIR, "testcount");
        localpath = localpath.makeQualified(localfs.getUri(), localfs.getWorkingDirectory());
        localfs.mkdirs(localpath);
        String localstr = localpath.toString();
        System.out.println("localstr=" + localstr);
        TestDFSShell.runCount(localstr, 1L, 0L, shell);
        Assert.assertEquals((long)0L, (long)TestDFSShell.runCmd(shell, "-count", root, localstr));
    }

    @Test(timeout=30000L)
    public void testTotalSizeOfAllFiles() throws Exception {
        Path root = new Path("/testTotalSizeOfAllFiles");
        dfs.mkdirs(root);
        FSDataOutputStream File1 = dfs.create(new Path(root, "File1"));
        File1.write("hi".getBytes());
        File1.close();
        FSDataOutputStream File2 = dfs.create(new Path(root, "Folder1/File2"));
        File2.write("hi".getBytes());
        File2.close();
        Assert.assertEquals((long)4L, (long)dfs.getUsed(root));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCount(String path, long dirs, long files, FsShell shell) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        System.setOut(out);
        Scanner in = null;
        String results = null;
        try {
            TestDFSShell.runCmd(shell, "-count", path);
            results = bytes.toString();
            in = new Scanner(results);
            Assert.assertEquals((long)dirs, (long)in.nextLong());
            Assert.assertEquals((long)files, (long)in.nextLong());
        }
        finally {
            System.setOut(oldOut);
            if (in != null) {
                in.close();
            }
            IOUtils.closeStream((Closeable)out);
            System.out.println("results:\n" + results);
        }
    }

    private static int runCmd(FsShell shell, String ... args) throws IOException {
        StringBuilder cmdline = new StringBuilder("RUN:");
        for (String arg : args) {
            cmdline.append(" " + arg);
        }
        LOG.info((Object)cmdline.toString());
        try {
            int exitCode = shell.run(args);
            LOG.info((Object)("RUN: " + args[0] + " exit=" + exitCode));
            return exitCode;
        }
        catch (IOException e) {
            LOG.error((Object)("RUN: " + args[0] + " IOException=" + e.getMessage()));
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error((Object)("RUN: " + args[0] + " RuntimeException=" + e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("RUN: " + args[0] + " Exception=" + e.getMessage()));
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testChmod(Configuration conf, FileSystem fs, String chmodDir) throws IOException {
        FsShell shell = new FsShell();
        shell.setConf(conf);
        try {
            Path dir = new Path(chmodDir);
            fs.delete(dir, true);
            fs.mkdirs(dir);
            this.confirmPermissionChange("u+rwx,g=rw,o-rwx", "rwxrw----", fs, shell, dir);
            Path file = new Path(chmodDir, "file");
            TestDFSShell.writeFile(fs, file);
            this.confirmPermissionChange("644", "rw-r--r--", fs, shell, file);
            TestDFSShell.runCmd(shell, "-chmod", "-R", "a+rwX", chmodDir);
            Assert.assertEquals((Object)"rwxrwxrwx", (Object)fs.getFileStatus(dir).getPermission().toString());
            Assert.assertEquals((Object)"rw-rw-rw-", (Object)fs.getFileStatus(file).getPermission().toString());
            if (!Path.WINDOWS) {
                Path dir2 = new Path(dir, "stickybit");
                fs.mkdirs(dir2);
                LOG.info((Object)("Testing sticky bit on: " + dir2));
                LOG.info((Object)("Sticky bit directory initial mode: " + fs.getFileStatus(dir2).getPermission()));
                this.confirmPermissionChange("u=rwx,g=rx,o=rx", "rwxr-xr-x", fs, shell, dir2);
                this.confirmPermissionChange("+t", "rwxr-xr-t", fs, shell, dir2);
                this.confirmPermissionChange("-t", "rwxr-xr-x", fs, shell, dir2);
                this.confirmPermissionChange("=t", "--------T", fs, shell, dir2);
                this.confirmPermissionChange("0000", "---------", fs, shell, dir2);
                this.confirmPermissionChange("1666", "rw-rw-rwT", fs, shell, dir2);
                this.confirmPermissionChange("1777", "rwxrwxrwt", fs, shell, dir2);
                this.confirmPermissionChange("0777", "rwxrwxrwx", fs, shell, dir2);
                this.confirmPermissionChange("1777", "rwxrwxrwt", fs, shell, dir2);
                this.confirmPermissionChange("777", "rwxrwxrwx", fs, shell, dir2);
                fs.delete(dir2, true);
            } else {
                LOG.info((Object)"Skipped sticky bit tests on Windows");
            }
            fs.delete(dir, true);
        }
        finally {
            try {
                shell.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void confirmPermissionChange(String toApply, String expected, FileSystem fs, FsShell shell, Path dir2) throws IOException {
        LOG.info((Object)("Confirming permission change of " + toApply + " to " + expected));
        TestDFSShell.runCmd(shell, "-chmod", toApply, dir2.toString());
        String result = fs.getFileStatus(dir2).getPermission().toString();
        LOG.info((Object)("Permission change result: " + result));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private void confirmOwner(String owner, String group, FileSystem fs, Path ... paths) throws IOException {
        for (Path path : paths) {
            if (owner != null) {
                Assert.assertEquals((Object)owner, (Object)fs.getFileStatus(path).getOwner());
            }
            if (group == null) continue;
            Assert.assertEquals((Object)group, (Object)fs.getFileStatus(path).getGroup());
        }
    }

    @Test(timeout=30000L)
    public void testFilePermissions() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        this.testChmod((Configuration)conf, (FileSystem)fs, new File(TEST_ROOT_DIR, "chmodTest").getAbsolutePath());
        conf.set("dfs.permissions.enabled", "true");
        fs = dfs;
        conf = dfs.getConf();
        this.testChmod((Configuration)conf, (FileSystem)fs, "/tmp/chmodTest");
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        String file = "/tmp/chownTest";
        Path path = new Path(file);
        Path parent = new Path("/tmp");
        Path root = new Path("/");
        TestDFSShell.writeFile((FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chgrp", "-R", "herbivores", "/*", "unknownFile*");
        this.confirmOwner(null, "herbivores", (FileSystem)fs, parent, path);
        TestDFSShell.runCmd(shell, "-chgrp", "mammals", file);
        this.confirmOwner(null, "mammals", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "-R", ":reptiles", "/");
        this.confirmOwner(null, "reptiles", (FileSystem)fs, root, parent, path);
        TestDFSShell.runCmd(shell, "-chown", "python:", "/nonExistentFile", file);
        this.confirmOwner("python", "reptiles", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "-R", "hadoop:toys", "unknownFile", "/");
        this.confirmOwner("hadoop", "toys", (FileSystem)fs, root, parent, path);
        TestDFSShell.runCmd(shell, "-chown", "hdfs.user", file);
        this.confirmOwner("hdfs.user", null, (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "_Hdfs.User-10:_hadoop.users--", file);
        this.confirmOwner("_Hdfs.User-10", "_hadoop.users--", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chown", "hdfs/hadoop-core@apache.org:asf-projects", file);
        this.confirmOwner("hdfs/hadoop-core@apache.org", "asf-projects", (FileSystem)fs, path);
        TestDFSShell.runCmd(shell, "-chgrp", "hadoop-core@apache.org/100", file);
        this.confirmOwner(null, "hadoop-core@apache.org/100", (FileSystem)fs, path);
    }

    @Test(timeout=120000L)
    public void testDFSShell() throws Exception {
        FsShell shell = new FsShell(dfs.getConf());
        Path myPath = new Path("/testDFSShell/mkdirs");
        Assert.assertTrue((boolean)dfs.mkdirs(myPath));
        Assert.assertTrue((boolean)dfs.exists(myPath));
        Assert.assertTrue((boolean)dfs.mkdirs(myPath));
        Path myFile = new Path("/testDFSShell/mkdirs/myFile");
        TestDFSShell.writeFile((FileSystem)dfs, myFile);
        Assert.assertTrue((boolean)dfs.exists(myFile));
        Path myFile2 = new Path("/testDFSShell/mkdirs/myFile2");
        TestDFSShell.writeFile((FileSystem)dfs, myFile2);
        Assert.assertTrue((boolean)dfs.exists(myFile2));
        String[] args = new String[]{"-rm", "/testDFSShell/mkdirs/myFile*"};
        int val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertTrue((val == 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)dfs.exists(myFile));
        Assert.assertFalse((boolean)dfs.exists(myFile2));
        TestDFSShell.writeFile((FileSystem)dfs, myFile);
        Assert.assertTrue((boolean)dfs.exists(myFile));
        TestDFSShell.writeFile((FileSystem)dfs, myFile2);
        Assert.assertTrue((boolean)dfs.exists(myFile2));
        args = new String[]{"-cat", "/testDFSShell/mkdirs/myFile", "/testDFSShell/mkdirs/myFile2"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run: " + StringUtils.stringifyException((Throwable)e));
        }
        Assert.assertTrue((val == 0 ? 1 : 0) != 0);
        dfs.delete(myFile2, true);
        args = new String[]{"-cat", "/testDFSShell/mkdirs/myFile1"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertTrue((val != 0 ? 1 : 0) != 0);
        args = new String[]{"-rm", "/testDFSShell/mkdirs/myFile1"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertTrue((val != 0 ? 1 : 0) != 0);
        args = new String[]{"-rm", "/testDFSShell/mkdirs/myFile"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertTrue((val == 0 ? 1 : 0) != 0);
        args = new String[]{"-test", "-e", "/testDFSShell/mkdirs/noFileHere"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)1L, (long)val);
        args[1] = "-z";
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)1L, (long)val);
        args = new String[]{"-touchz", "/testDFSShell/mkdirs/isFileHere"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)0L, (long)val);
        args = new String[]{"-touchz", "/testDFSShell/mkdirs/thisDirNotExists/isFileHere"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)1L, (long)val);
        args = new String[]{"-test", "-e", "/testDFSShell/mkdirs/isFileHere"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)0L, (long)val);
        args[1] = "-d";
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)1L, (long)val);
        args[1] = "-z";
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)0L, (long)val);
        args = new String[]{"-mkdir", "/testDFSShell/dir1"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)0L, (long)val);
        String[] args1 = new String[]{"-cp", "/testDFSShell/dir1", "/testDFSShell/dir1/dir2"};
        val = 0;
        try {
            val = shell.run(args1);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)1L, (long)val);
        args1[0] = "-cp";
        args1[1] = "/testDFSShell/dir1";
        args1[2] = "/testDFSShell/dir1foo";
        val = -1;
        try {
            val = shell.run(args1);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)0L, (long)val);
        args1[0] = "-cp";
        args1[1] = "/";
        args1[2] = "/test";
        val = 0;
        try {
            val = shell.run(args1);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)1L, (long)val);
        args = new String[]{"-test", "-f", "/testDFSShell/mkdirs/noFileHere"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)1L, (long)val);
        args = new String[]{"-test", "-f", "/testDFSShell/mkdirs"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)1L, (long)val);
        TestDFSShell.writeFile((FileSystem)dfs, myFile);
        Assert.assertTrue((boolean)dfs.exists(myFile));
        args = new String[]{"-test", "-f", myFile.toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)0L, (long)val);
        args = new String[]{"-test", "-s", "/testDFSShell/mkdirs/noFileHere"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)1L, (long)val);
        args = new String[]{"-test", "-s", "/testDFSShell/mkdirs/isFileHere"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)1L, (long)val);
        args = new String[]{"-test", "-s", myFile.toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)0L, (long)val);
        Path permDir = new Path("/testDFSShell/permDir");
        Path permFile = new Path("/testDFSShell/permDir/permFile");
        TestDFSShell.mkdir((FileSystem)dfs, permDir);
        TestDFSShell.writeFile((FileSystem)dfs, permFile);
        final String[] wargs = new String[]{"-test", "-w", permDir.toString()};
        int val2 = -1;
        try {
            val2 = shell.run(wargs);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)0L, (long)val2);
        final String[] rargs = new String[]{"-test", "-r", permFile.toString()};
        try {
            val2 = shell.run(rargs);
        }
        catch (Exception e) {
            System.err.println("Exception raised from DFSShell.run " + e.getLocalizedMessage());
        }
        Assert.assertEquals((long)0L, (long)val2);
        TestDFSShell.runCmd(shell, "-chmod", "600", permFile.toString());
        UserGroupInformation smokeUser = UserGroupInformation.createUserForTesting((String)"smokeUser", (String[])new String[]{"hadoop"});
        smokeUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                FsShell shell = new FsShell(dfs.getConf());
                int exitCode = shell.run(rargs);
                Assert.assertEquals((long)1L, (long)exitCode);
                return null;
            }
        });
        TestDFSShell.runCmd(shell, "-chown", "-R", "not_allowed", permDir.toString());
        TestDFSShell.runCmd(shell, "-chmod", "-R", "700", permDir.toString());
        smokeUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                FsShell shell = new FsShell(dfs.getConf());
                int exitCode = shell.run(wargs);
                Assert.assertEquals((long)1L, (long)exitCode);
                return null;
            }
        });
        dfs.delete(permDir, true);
    }

    private static List<FsDatasetTestUtils.MaterializedReplica> getMaterializedReplicas(MiniDFSCluster cluster) throws IOException {
        ArrayList<FsDatasetTestUtils.MaterializedReplica> replicas = new ArrayList<FsDatasetTestUtils.MaterializedReplica>();
        String poolId = cluster.getNamesystem().getBlockPoolId();
        List<Map<DatanodeStorage, BlockListAsLongs>> blocks = cluster.getAllBlockReports(poolId);
        for (int i = 0; i < blocks.size(); ++i) {
            Map<DatanodeStorage, BlockListAsLongs> map = blocks.get(i);
            for (Map.Entry<DatanodeStorage, BlockListAsLongs> e : map.entrySet()) {
                for (Block b : e.getValue()) {
                    replicas.add(cluster.getMaterializedReplica(i, new ExtendedBlock(poolId, b)));
                }
            }
        }
        return replicas;
    }

    private static void corrupt(List<FsDatasetTestUtils.MaterializedReplica> replicas, String content) throws IOException {
        StringBuilder sb = new StringBuilder(content);
        char c = content.charAt(0);
        c = (char)(c + '\u0001');
        sb.setCharAt(0, c);
        for (FsDatasetTestUtils.MaterializedReplica replica : replicas) {
            replica.corruptData(sb.toString().getBytes("UTF8"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(timeout=30000L)
    public void testRemoteException() throws Exception {
        UserGroupInformation tmpUGI = UserGroupInformation.createUserForTesting((String)"tmpname", (String[])new String[]{"mygroup"});
        PrintStream bak = null;
        try {
            Path p = new Path("/foo");
            dfs.mkdirs(p);
            dfs.setPermission(p, new FsPermission(448));
            bak = System.err;
            tmpUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    FsShell fshell = new FsShell(dfs.getConf());
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PrintStream tmp = new PrintStream(out);
                    System.setErr(tmp);
                    String[] args = new String[]{"-ls", "/foo"};
                    int ret = ToolRunner.run((Tool)fshell, (String[])args);
                    Assert.assertEquals((String)"returned should be 1", (long)1L, (long)ret);
                    String str = out.toString();
                    Assert.assertTrue((String)"permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                    out.reset();
                    return null;
                }
            });
            if (bak == null) return;
        }
        catch (Throwable throwable) {
            if (bak == null) throw throwable;
            System.setErr(bak);
            throw throwable;
        }
        System.setErr(bak);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testGet() throws IOException {
        GenericTestUtils.setLogLevel((Logger)FSInputChecker.LOG, (Level)Level.ALL);
        String fname = "testGet.txt";
        Path root = new Path("/test/get");
        Path remotef = new Path(root, "testGet.txt");
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.retry.window.base", 10);
        TestGetRunner runner = new TestGetRunner((Configuration)conf, remotef){
            private int count = 0;
            private final FsShell shell = new FsShell(this.val$conf);
            final /* synthetic */ Configuration val$conf;
            final /* synthetic */ Path val$remotef;
            {
                this.val$conf = configuration;
                this.val$remotef = path;
            }

            @Override
            public String run(int exitcode, String ... options) throws IOException {
                String dst = new File(TEST_ROOT_DIR, "testGet.txt" + ++this.count).getAbsolutePath();
                String[] args = new String[options.length + 3];
                args[0] = "-get";
                args[args.length - 2] = this.val$remotef.toString();
                args[args.length - 1] = dst;
                for (int i = 0; i < options.length; ++i) {
                    args[i + 1] = options[i];
                }
                TestDFSShell.show("args=" + Arrays.asList(args));
                try {
                    Assert.assertEquals((long)exitcode, (long)this.shell.run(args));
                }
                catch (Exception e) {
                    Assert.assertTrue((String)StringUtils.stringifyException((Throwable)e), (boolean)false);
                }
                return exitcode == 0 ? DFSTestUtil.readFile(new File(dst)) : null;
            }
        };
        File localf = TestDFSShell.createLocalFile(new File(TEST_ROOT_DIR, "testGet.txt"));
        MiniDFSCluster cluster = null;
        DistributedFileSystem dfs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(true).build();
            dfs = cluster.getFileSystem();
            TestDFSShell.mkdir((FileSystem)dfs, root);
            dfs.copyFromLocalFile(false, false, new Path(localf.getPath()), remotef);
            String localfcontent = DFSTestUtil.readFile(localf);
            Assert.assertEquals((Object)localfcontent, (Object)runner.run(0, new String[0]));
            Assert.assertEquals((Object)localfcontent, (Object)runner.run(0, "-ignoreCrc"));
            List<FsDatasetTestUtils.MaterializedReplica> replicas = TestDFSShell.getMaterializedReplicas(cluster);
            dfs.close();
            cluster.shutdown();
            TestDFSShell.show("replicas=" + replicas);
            TestDFSShell.corrupt(replicas, localfcontent);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).format(false).build();
            dfs = cluster.getFileSystem();
            Assert.assertEquals(null, (Object)runner.run(1, new String[0]));
            String corruptedcontent = runner.run(0, "-ignoreCrc");
            Assert.assertEquals((Object)localfcontent.substring(1), (Object)corruptedcontent.substring(1));
            Assert.assertEquals((long)(localfcontent.charAt(0) + '\u0001'), (long)corruptedcontent.charAt(0));
        }
        finally {
            if (null != dfs) {
                try {
                    dfs.close();
                }
                catch (Exception exception) {}
            }
            if (null != cluster) {
                cluster.shutdown();
            }
            localf.delete();
        }
    }

    @Test(timeout=30000L)
    public void testStat() throws Exception {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        Path testDir1 = new Path("testStat", "dir1");
        dfs.mkdirs(testDir1);
        Path testFile2 = new Path(testDir1, "file2");
        DFSTestUtil.createFile((FileSystem)dfs, testFile2, 2048L, (short)3, 0L);
        FileStatus status1 = dfs.getFileStatus(testDir1);
        String mtime1 = fmt.format(new Date(status1.getModificationTime()));
        String atime1 = fmt.format(new Date(status1.getAccessTime()));
        long now = Time.now();
        dfs.setTimes(testFile2, now + 3000L, now + 6000L);
        FileStatus status2 = dfs.getFileStatus(testFile2);
        String mtime2 = fmt.format(new Date(status2.getModificationTime()));
        String atime2 = fmt.format(new Date(status2.getAccessTime()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        TestDFSShell.doFsStat(dfs.getConf(), null, new Path[0]);
        out.reset();
        TestDFSShell.doFsStat(dfs.getConf(), null, testDir1);
        Assert.assertEquals((String)("Unexpected -stat output: " + out), (Object)out.toString(), (Object)String.format("%s%n", mtime1));
        out.reset();
        TestDFSShell.doFsStat(dfs.getConf(), null, testDir1, testFile2);
        Assert.assertEquals((String)("Unexpected -stat output: " + out), (Object)out.toString(), (Object)String.format("%s%n%s%n", mtime1, mtime2));
        TestDFSShell.doFsStat(dfs.getConf(), "%F %u:%g %b %y %n", new Path[0]);
        out.reset();
        TestDFSShell.doFsStat(dfs.getConf(), "%F %a %A %u:%g %b %y %n", testDir1);
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains(mtime1));
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains("directory"));
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains(status1.getGroup()));
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains(status1.getPermission().toString()));
        short n = status1.getPermission().toShort();
        int octal = (n >>> 9 & 1) * 1000 + (n >>> 6 & 7) * 100 + (n >>> 3 & 7) * 10 + (n & 7);
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains(String.valueOf(octal)));
        out.reset();
        TestDFSShell.doFsStat(dfs.getConf(), "%F %a %A %u:%g %b %x %y %n", testDir1, testFile2);
        n = status2.getPermission().toShort();
        octal = (n >>> 9 & 1) * 1000 + (n >>> 6 & 7) * 100 + (n >>> 3 & 7) * 10 + (n & 7);
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains(mtime1));
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains(atime1));
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains("regular file"));
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains(status2.getPermission().toString()));
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains(String.valueOf(octal)));
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains(mtime2));
        Assert.assertTrue((String)out.toString(), (boolean)out.toString().contains(atime2));
    }

    private static void doFsStat(Configuration conf, String format, Path ... files) throws Exception {
        if (files == null || files.length == 0) {
            String[] stringArray;
            if (format == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "-stat";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "-stat";
                stringArray = stringArray3;
                stringArray3[1] = format;
            }
            String[] argv = stringArray;
            Assert.assertEquals((String)"Should have failed with missing arguments", (long)-1L, (long)ToolRunner.run((Tool)new FsShell(conf), (String[])argv));
        } else {
            LinkedList<String> argv = new LinkedList<String>();
            argv.add("-stat");
            if (format != null) {
                argv.add(format);
            }
            for (Path f : files) {
                argv.add(f.toString());
            }
            int ret = ToolRunner.run((Tool)new FsShell(conf), (String[])argv.toArray(new String[0]));
            Assert.assertEquals((String)(argv + " returned non-zero status " + ret), (long)0L, (long)ret);
        }
    }

    @Test(timeout=30000L)
    public void testLsr() throws Exception {
        final Configuration conf = dfs.getConf();
        final String root = TestDFSShell.createTree((FileSystem)dfs, "lsr");
        dfs.mkdirs(new Path(root, "zzz"));
        TestDFSShell.runLsr(new FsShell(conf), root, 0);
        Path sub = new Path(root, "sub");
        dfs.setPermission(sub, new FsPermission(0));
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String tmpusername = ugi.getShortUserName() + "1";
        UserGroupInformation tmpUGI = UserGroupInformation.createUserForTesting((String)tmpusername, (String[])new String[]{tmpusername});
        String results = (String)tmpUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return TestDFSShell.runLsr(new FsShell(conf), root, 1);
            }
        });
        Assert.assertTrue((boolean)results.contains("zzz"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runLsr(FsShell shell, String root, int returnvalue) throws Exception {
        String results;
        System.out.println("root=" + root + ", returnvalue=" + returnvalue);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            Assert.assertEquals((long)returnvalue, (long)shell.run(new String[]{"-lsr", root}));
            results = bytes.toString();
        }
        finally {
            System.setOut(oldOut);
            System.setErr(oldErr);
            IOUtils.closeStream((Closeable)out);
        }
        System.out.println("results:\n" + results);
        return results;
    }

    @Test(timeout=30000L)
    public void testInvalidShell() throws Exception {
        Configuration conf = new Configuration();
        DFSAdmin admin = new DFSAdmin();
        admin.setConf(conf);
        int res = admin.run(new String[]{"-refreshNodes"});
        Assert.assertEquals((String)"expected to fail -1", (long)res, (long)-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCopyCommandsWithPreserveOption() throws Exception {
        FsShell shell = null;
        String testdir = "/tmp/TestDFSShell-testCopyCommandsWithPreserveOption-" + counter.getAndIncrement();
        Path hdfsTestDir = new Path(testdir);
        try {
            dfs.mkdirs(hdfsTestDir);
            Path src = new Path(hdfsTestDir, "srcfile");
            dfs.create(src).close();
            dfs.setAcl(src, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.EXECUTE)}));
            FileStatus status = dfs.getFileStatus(src);
            long mtime = status.getModificationTime();
            long atime = status.getAccessTime();
            String owner = status.getOwner();
            String group = status.getGroup();
            FsPermission perm = status.getPermission();
            dfs.setXAttr(src, USER_A1, USER_A1_VALUE);
            dfs.setXAttr(src, TRUSTED_A1, TRUSTED_A1_VALUE);
            shell = new FsShell(dfs.getConf());
            Path target1 = new Path(hdfsTestDir, "targetfile1");
            String[] argv = new String[]{"-cp", "-p", src.toUri().toString(), target1.toUri().toString()};
            int ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -p is not working", (long)0L, (long)ret);
            FileStatus targetStatus = dfs.getFileStatus(target1);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            FsPermission targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            Map xattrs = dfs.getXAttrs(target1);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            List acls = dfs.getAclStatus(target1).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetStatus.hasAcl());
            Path target2 = new Path(hdfsTestDir, "targetfile2");
            argv = new String[]{"-cp", "-ptop", src.toUri().toString(), target2.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptop is not working", (long)0L, (long)ret);
            targetStatus = dfs.getFileStatus(target2);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = dfs.getXAttrs(target2);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = dfs.getAclStatus(target2).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetStatus.hasAcl());
            Path target3 = new Path(hdfsTestDir, "targetfile3");
            argv = new String[]{"-cp", "-ptopx", src.toUri().toString(), target3.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptopx is not working", (long)0L, (long)ret);
            targetStatus = dfs.getFileStatus(target3);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = dfs.getXAttrs(target3);
            Assert.assertEquals((long)xattrs.size(), (long)2L);
            Assert.assertArrayEquals((byte[])USER_A1_VALUE, (byte[])((byte[])xattrs.get(USER_A1)));
            Assert.assertArrayEquals((byte[])TRUSTED_A1_VALUE, (byte[])((byte[])xattrs.get(TRUSTED_A1)));
            acls = dfs.getAclStatus(target3).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetStatus.hasAcl());
            Path target4 = new Path(hdfsTestDir, "targetfile4");
            argv = new String[]{"-cp", "-ptopa", src.toUri().toString(), target4.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptopa is not working", (long)0L, (long)ret);
            targetStatus = dfs.getFileStatus(target4);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = dfs.getXAttrs(target4);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = dfs.getAclStatus(target4).getEntries();
            Assert.assertFalse((boolean)acls.isEmpty());
            Assert.assertTrue((boolean)targetStatus.hasAcl());
            Assert.assertEquals((Object)dfs.getAclStatus(src), (Object)dfs.getAclStatus(target4));
            Path target5 = new Path(hdfsTestDir, "targetfile5");
            argv = new String[]{"-cp", "-ptoa", src.toUri().toString(), target5.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptoa is not working", (long)0L, (long)ret);
            targetStatus = dfs.getFileStatus(target5);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = dfs.getXAttrs(target5);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = dfs.getAclStatus(target5).getEntries();
            Assert.assertFalse((boolean)acls.isEmpty());
            Assert.assertTrue((boolean)targetStatus.hasAcl());
            Assert.assertEquals((Object)dfs.getAclStatus(src), (Object)dfs.getAclStatus(target5));
        }
        finally {
            if (null != shell) {
                shell.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCopyCommandsWithRawXAttrs() throws Exception {
        FsShell shell = null;
        String testdir = "/tmp/TestDFSShell-testCopyCommandsWithRawXAttrs-" + counter.getAndIncrement();
        Path hdfsTestDir = new Path(testdir);
        Path rawHdfsTestDir = new Path("/.reserved/raw" + testdir);
        try {
            dfs.mkdirs(hdfsTestDir);
            Path src = new Path(hdfsTestDir, "srcfile");
            String rawSrcBase = "/.reserved/raw" + testdir;
            Path rawSrc = new Path(rawSrcBase, "srcfile");
            dfs.create(src).close();
            Path srcDir = new Path(hdfsTestDir, "srcdir");
            Path rawSrcDir = new Path("/.reserved/raw" + testdir, "srcdir");
            dfs.mkdirs(srcDir);
            Path srcDirFile = new Path(srcDir, "srcfile");
            Path rawSrcDirFile = new Path("/.reserved/raw" + srcDirFile);
            dfs.create(srcDirFile).close();
            Path[] paths = new Path[]{rawSrc, rawSrcDir, rawSrcDirFile};
            String[] xattrNames = new String[]{USER_A1, RAW_A1};
            byte[][] xattrVals = new byte[][]{USER_A1_VALUE, RAW_A1_VALUE};
            for (int i = 0; i < paths.length; ++i) {
                for (int j = 0; j < xattrNames.length; ++j) {
                    dfs.setXAttr(paths[i], xattrNames[j], xattrVals[j]);
                }
            }
            shell = new FsShell(dfs.getConf());
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)dfs, src, hdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)dfs, rawSrc, hdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)dfs, src, rawHdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)dfs, rawSrc, rawHdfsTestDir, true);
            Path savedWd = dfs.getWorkingDirectory();
            try {
                dfs.setWorkingDirectory(new Path(rawSrcBase));
                Path relRawSrc = new Path("../srcfile");
                Path relRawHdfsTestDir = new Path("..");
                this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)dfs, relRawSrc, relRawHdfsTestDir, true);
            }
            finally {
                dfs.setWorkingDirectory(savedWd);
            }
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)dfs, srcDir, hdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)dfs, rawSrcDir, hdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)dfs, srcDir, rawHdfsTestDir, false);
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)dfs, rawSrcDir, rawHdfsTestDir, true);
            String relRawSrcDir = "./.reserved/../.reserved/raw/../raw" + testdir + "/srcdir";
            String relRawDstDir = "./.reserved/../.reserved/raw/../raw" + testdir;
            this.doTestCopyCommandsWithRawXAttrs(shell, (FileSystem)dfs, new Path(relRawSrcDir), new Path(relRawDstDir), true);
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            dfs.delete(hdfsTestDir, true);
        }
    }

    private void doTestCopyCommandsWithRawXAttrs(FsShell shell, FileSystem fs, Path src, Path hdfsTestDir, boolean expectRaw) throws Exception {
        Path target;
        boolean destIsRaw;
        boolean srcIsRaw = src.isAbsolute() ? src.toString().contains("/.reserved/raw") : new Path(fs.getWorkingDirectory(), src).toString().contains("/.reserved/raw");
        boolean srcDestMismatch = srcIsRaw ^ (destIsRaw = hdfsTestDir.toString().contains("/.reserved/raw"));
        if (srcDestMismatch) {
            this.doCopyAndTest(shell, hdfsTestDir, src, "-p", 1);
        } else {
            target = this.doCopyAndTest(shell, hdfsTestDir, src, "-p", 0);
            this.checkXAttrs(fs, target, expectRaw, false);
        }
        if (srcDestMismatch) {
            this.doCopyAndTest(shell, hdfsTestDir, src, "-px", 1);
        } else {
            target = this.doCopyAndTest(shell, hdfsTestDir, src, "-px", 0);
            this.checkXAttrs(fs, target, expectRaw, true);
        }
        if (srcDestMismatch) {
            this.doCopyAndTest(shell, hdfsTestDir, src, null, 1);
        } else {
            target = this.doCopyAndTest(shell, hdfsTestDir, src, null, 0);
            this.checkXAttrs(fs, target, expectRaw, false);
        }
    }

    private Path doCopyAndTest(FsShell shell, Path dest, Path src, String cpArgs, int expectedExitCode) throws Exception {
        String[] stringArray;
        Path target = new Path(dest, "targetfile" + counter.getAndIncrement());
        if (cpArgs == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "-cp";
            stringArray2[1] = src.toUri().toString();
            stringArray = stringArray2;
            stringArray2[2] = target.toUri().toString();
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "-cp";
            stringArray3[1] = cpArgs;
            stringArray3[2] = src.toUri().toString();
            stringArray = stringArray3;
            stringArray3[3] = target.toUri().toString();
        }
        String[] argv = stringArray;
        int ret = ToolRunner.run((Tool)shell, (String[])argv);
        Assert.assertEquals((String)"cp -p is not working", (long)expectedExitCode, (long)ret);
        return target;
    }

    private void checkXAttrs(FileSystem fs, Path target, boolean expectRaw, boolean expectVanillaXAttrs) throws Exception {
        Map xattrs = fs.getXAttrs(target);
        int expectedCount = 0;
        if (expectRaw) {
            Assert.assertArrayEquals((String)"raw.a1 has incorrect value", (byte[])RAW_A1_VALUE, (byte[])((byte[])xattrs.get(RAW_A1)));
            ++expectedCount;
        }
        if (expectVanillaXAttrs) {
            Assert.assertArrayEquals((String)"user.a1 has incorrect value", (byte[])USER_A1_VALUE, (byte[])((byte[])xattrs.get(USER_A1)));
            ++expectedCount;
        }
        Assert.assertEquals((String)"xattrs size mismatch", (long)expectedCount, (long)xattrs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCopyCommandsToDirectoryWithPreserveOption() throws Exception {
        FsShell shell = null;
        String testdir = "/tmp/TestDFSShell-testCopyCommandsToDirectoryWithPreserveOption-" + counter.getAndIncrement();
        Path hdfsTestDir = new Path(testdir);
        try {
            dfs.mkdirs(hdfsTestDir);
            Path srcDir = new Path(hdfsTestDir, "srcDir");
            dfs.mkdirs(srcDir);
            dfs.setAcl(srcDir, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.EXECUTE)}));
            dfs.setPermission(srcDir, new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.EXECUTE, true));
            Path srcFile = new Path(srcDir, "srcFile");
            dfs.create(srcFile).close();
            FileStatus status = dfs.getFileStatus(srcDir);
            long mtime = status.getModificationTime();
            long atime = status.getAccessTime();
            String owner = status.getOwner();
            String group = status.getGroup();
            FsPermission perm = status.getPermission();
            dfs.setXAttr(srcDir, USER_A1, USER_A1_VALUE);
            dfs.setXAttr(srcDir, TRUSTED_A1, TRUSTED_A1_VALUE);
            shell = new FsShell(dfs.getConf());
            Path targetDir1 = new Path(hdfsTestDir, "targetDir1");
            String[] argv = new String[]{"-cp", "-p", srcDir.toUri().toString(), targetDir1.toUri().toString()};
            int ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -p is not working", (long)0L, (long)ret);
            FileStatus targetStatus = dfs.getFileStatus(targetDir1);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            FsPermission targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            Map xattrs = dfs.getXAttrs(targetDir1);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            List acls = dfs.getAclStatus(targetDir1).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetStatus.hasAcl());
            Path targetDir2 = new Path(hdfsTestDir, "targetDir2");
            argv = new String[]{"-cp", "-ptop", srcDir.toUri().toString(), targetDir2.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptop is not working", (long)0L, (long)ret);
            targetStatus = dfs.getFileStatus(targetDir2);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = dfs.getXAttrs(targetDir2);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = dfs.getAclStatus(targetDir2).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetStatus.hasAcl());
            Path targetDir3 = new Path(hdfsTestDir, "targetDir3");
            argv = new String[]{"-cp", "-ptopx", srcDir.toUri().toString(), targetDir3.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptopx is not working", (long)0L, (long)ret);
            targetStatus = dfs.getFileStatus(targetDir3);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = dfs.getXAttrs(targetDir3);
            Assert.assertEquals((long)xattrs.size(), (long)2L);
            Assert.assertArrayEquals((byte[])USER_A1_VALUE, (byte[])((byte[])xattrs.get(USER_A1)));
            Assert.assertArrayEquals((byte[])TRUSTED_A1_VALUE, (byte[])((byte[])xattrs.get(TRUSTED_A1)));
            acls = dfs.getAclStatus(targetDir3).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetStatus.hasAcl());
            Path targetDir4 = new Path(hdfsTestDir, "targetDir4");
            argv = new String[]{"-cp", "-ptopa", srcDir.toUri().toString(), targetDir4.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptopa is not working", (long)0L, (long)ret);
            targetStatus = dfs.getFileStatus(targetDir4);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = dfs.getXAttrs(targetDir4);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = dfs.getAclStatus(targetDir4).getEntries();
            Assert.assertFalse((boolean)acls.isEmpty());
            Assert.assertTrue((boolean)targetStatus.hasAcl());
            Assert.assertEquals((Object)dfs.getAclStatus(srcDir), (Object)dfs.getAclStatus(targetDir4));
            Path targetDir5 = new Path(hdfsTestDir, "targetDir5");
            argv = new String[]{"-cp", "-ptoa", srcDir.toUri().toString(), targetDir5.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptoa is not working", (long)0L, (long)ret);
            targetStatus = dfs.getFileStatus(targetDir5);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            xattrs = dfs.getXAttrs(targetDir5);
            Assert.assertTrue((boolean)xattrs.isEmpty());
            acls = dfs.getAclStatus(targetDir5).getEntries();
            Assert.assertFalse((boolean)acls.isEmpty());
            Assert.assertTrue((boolean)targetStatus.hasAcl());
            Assert.assertEquals((Object)dfs.getAclStatus(srcDir), (Object)dfs.getAclStatus(targetDir5));
        }
        finally {
            if (shell != null) {
                shell.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testCopyCommandsPreserveAclAndStickyBit() throws Exception {
        FsShell shell = null;
        String testdir = "/tmp/TestDFSShell-testCopyCommandsPreserveAclAndStickyBit-" + counter.getAndIncrement();
        Path hdfsTestDir = new Path(testdir);
        try {
            dfs.mkdirs(hdfsTestDir);
            Path src = new Path(hdfsTestDir, "srcfile");
            dfs.create(src).close();
            dfs.setAcl(src, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.EXECUTE)}));
            dfs.setPermission(src, new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.EXECUTE, true));
            FileStatus status = dfs.getFileStatus(src);
            long mtime = status.getModificationTime();
            long atime = status.getAccessTime();
            String owner = status.getOwner();
            String group = status.getGroup();
            FsPermission perm = status.getPermission();
            shell = new FsShell(dfs.getConf());
            Path target1 = new Path(hdfsTestDir, "targetfile1");
            String[] argv = new String[]{"-cp", "-p", src.toUri().toString(), target1.toUri().toString()};
            int ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp is not working", (long)0L, (long)ret);
            FileStatus targetStatus = dfs.getFileStatus(target1);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            FsPermission targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            List acls = dfs.getAclStatus(target1).getEntries();
            Assert.assertTrue((boolean)acls.isEmpty());
            Assert.assertFalse((boolean)targetStatus.hasAcl());
            Path target2 = new Path(hdfsTestDir, "targetfile2");
            argv = new String[]{"-cp", "-ptopa", src.toUri().toString(), target2.toUri().toString()};
            ret = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -ptopa is not working", (long)0L, (long)ret);
            targetStatus = dfs.getFileStatus(target2);
            Assert.assertEquals((long)mtime, (long)targetStatus.getModificationTime());
            Assert.assertEquals((long)atime, (long)targetStatus.getAccessTime());
            Assert.assertEquals((Object)owner, (Object)targetStatus.getOwner());
            Assert.assertEquals((Object)group, (Object)targetStatus.getGroup());
            targetPerm = targetStatus.getPermission();
            Assert.assertTrue((boolean)perm.equals((Object)targetPerm));
            acls = dfs.getAclStatus(target2).getEntries();
            Assert.assertFalse((boolean)acls.isEmpty());
            Assert.assertTrue((boolean)targetStatus.hasAcl());
            Assert.assertEquals((Object)dfs.getAclStatus(src), (Object)dfs.getAclStatus(target2));
        }
        finally {
            if (null != shell) {
                shell.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCopyCommandsWithForceOption() throws Exception {
        FsShell shell = null;
        File localFile = new File(TEST_ROOT_DIR, "testFileForPut");
        String localfilepath = new Path(localFile.getAbsolutePath()).toUri().toString();
        String testdir = "/tmp/TestDFSShell-testCopyCommandsWithForceOption-" + counter.getAndIncrement();
        Path hdfsTestDir = new Path(testdir);
        try {
            dfs.mkdirs(hdfsTestDir);
            localFile.createNewFile();
            TestDFSShell.writeFile((FileSystem)dfs, new Path(testdir, "testFileForPut"));
            shell = new FsShell();
            String[] argv = new String[]{"-put", "-f", localfilepath, testdir};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"put -f is not working", (long)0L, (long)res);
            argv = new String[]{"-put", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"put command itself is able to overwrite the file", (long)1L, (long)res);
            argv = new String[]{"-copyFromLocal", "-f", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"copyFromLocal -f is not working", (long)0L, (long)res);
            argv = new String[]{"-copyFromLocal", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"copyFromLocal command itself is able to overwrite the file", (long)1L, (long)res);
            argv = new String[]{"-cp", "-f", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp -f is not working", (long)0L, (long)res);
            argv = new String[]{"-cp", localfilepath, testdir};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"cp command itself is able to overwrite the file", (long)1L, (long)res);
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            if (localFile.exists()) {
                localFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCopyFromLocalWithPermissionDenied() throws Exception {
        Path hdfsTestDir;
        File localFile;
        FsShell shell;
        block7: {
            shell = null;
            PrintStream bak = null;
            localFile = new File(TEST_ROOT_DIR, "testFileWithNoReadPermissions");
            String localfilepath = new Path(localFile.getAbsolutePath()).toUri().toString();
            String testdir = "/tmp/TestDFSShell-CopyFromLocalWithPermissionDenied-" + counter.getAndIncrement();
            hdfsTestDir = new Path(testdir);
            try {
                dfs.mkdirs(hdfsTestDir);
                localFile.createNewFile();
                localFile.setReadable(false);
                TestDFSShell.writeFile((FileSystem)dfs, new Path(testdir, "testFileForPut"));
                shell = new FsShell();
                bak = System.err;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream tmp = new PrintStream(out);
                System.setErr(tmp);
                String[] argv = new String[]{"-put", localfilepath, testdir};
                int res = ToolRunner.run((Tool)shell, (String[])argv);
                Assert.assertEquals((String)"put is working", (long)1L, (long)res);
                String returned = out.toString();
                Assert.assertTrue((String)" outputs Permission denied error message", (returned.lastIndexOf("Permission denied") != -1 ? 1 : 0) != 0);
                argv = new String[]{"-copyFromLocal", localfilepath, testdir};
                res = ToolRunner.run((Tool)shell, (String[])argv);
                Assert.assertEquals((String)"copyFromLocal -f is working", (long)1L, (long)res);
                returned = out.toString();
                Assert.assertTrue((String)" outputs Permission denied error message", (returned.lastIndexOf("Permission denied") != -1 ? 1 : 0) != 0);
                if (bak == null) break block7;
            }
            catch (Throwable throwable) {
                if (bak != null) {
                    System.setErr(bak);
                }
                if (null != shell) {
                    shell.close();
                }
                if (localFile.exists()) {
                    localFile.delete();
                }
                dfs.delete(hdfsTestDir, true);
                throw throwable;
            }
            System.setErr(bak);
        }
        if (null != shell) {
            shell.close();
        }
        if (localFile.exists()) {
            localFile.delete();
        }
        dfs.delete(hdfsTestDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSetrepLow() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.replication.min", 2);
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        MiniDFSCluster cluster = builder.numDataNodes(2).format(true).build();
        FsShell shell = new FsShell(conf);
        cluster.waitActive();
        String testdir = "/tmp/TestDFSShell-testSetrepLow";
        Path hdfsFile = new Path("/tmp/TestDFSShell-testSetrepLow", "testFileForSetrepLow");
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Assert.assertTrue((String)"Unable to create test directory", (boolean)fs.mkdirs(new Path("/tmp/TestDFSShell-testSetrepLow")));
            fs.create(hdfsFile, true).close();
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            PrintStream capture = new PrintStream(bao);
            System.setOut(capture);
            System.setErr(capture);
            String[] argv = new String[]{"-setrep", "1", hdfsFile.toString()};
            try {
                Assert.assertEquals((String)"Command did not return the expected exit code", (long)1L, (long)shell.run(argv));
            }
            finally {
                System.setOut(origOut);
                System.setErr(origErr);
            }
            Assert.assertTrue((String)("Error message is not the expected error message" + bao.toString()), (boolean)bao.toString().startsWith("setrep: Requested replication factor of 1 is less than the required minimum of 2 for /tmp/TestDFSShell-testSetrepLow/testFileForSetrepLow"));
        }
        finally {
            shell.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSetrep() throws Exception {
        FsShell shell = null;
        String testdir1 = "/tmp/TestDFSShell-testSetrep-" + counter.getAndIncrement();
        String testdir2 = testdir1 + "/nestedDir";
        Path hdfsFile1 = new Path(testdir1, "testFileForSetrep");
        Path hdfsFile2 = new Path(testdir2, "testFileForSetrep");
        Short oldRepFactor = new Short(2);
        Short newRepFactor = new Short(3);
        try {
            Assert.assertThat((Object)dfs.mkdirs(new Path(testdir2)), (Matcher)CoreMatchers.is((Object)true));
            shell = new FsShell(dfs.getConf());
            dfs.create(hdfsFile1, true).close();
            dfs.create(hdfsFile2, true).close();
            String[] argv = new String[]{"-setrep", newRepFactor.toString(), hdfsFile1.toString()};
            Assert.assertThat((Object)shell.run(argv), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)dfs.getFileStatus(hdfsFile1).getReplication(), (Matcher)CoreMatchers.is((Object)newRepFactor));
            Assert.assertThat((Object)dfs.getFileStatus(hdfsFile2).getReplication(), (Matcher)CoreMatchers.is((Object)oldRepFactor));
            argv = new String[]{"-setrep", newRepFactor.toString(), testdir1};
            Assert.assertThat((Object)shell.run(argv), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)dfs.getFileStatus(hdfsFile1).getReplication(), (Matcher)CoreMatchers.is((Object)newRepFactor));
            Assert.assertThat((Object)dfs.getFileStatus(hdfsFile2).getReplication(), (Matcher)CoreMatchers.is((Object)newRepFactor));
        }
        finally {
            if (shell != null) {
                shell.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileUsingTrash(boolean serverTrash, boolean clientTrash) throws Exception {
        HdfsConfiguration serverConf = new HdfsConfiguration();
        if (serverTrash) {
            serverConf.setLong("fs.trash.interval", 1L);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)serverConf).numDataNodes(1).format(true).build();
        Configuration clientConf = new Configuration((Configuration)serverConf);
        if (clientTrash) {
            clientConf.setLong("fs.trash.interval", 1L);
        } else {
            clientConf.setLong("fs.trash.interval", 0L);
        }
        FsShell shell = new FsShell(clientConf);
        DistributedFileSystem fs = null;
        try {
            fs = cluster.getFileSystem();
            String testdir = "/tmp/TestDFSShell-deleteFileUsingTrash-" + counter.getAndIncrement();
            TestDFSShell.writeFile((FileSystem)fs, new Path(testdir, "foo"));
            String testFile = testdir + "/foo";
            String trashFile = shell.getCurrentTrashDir() + "/" + testFile;
            String[] argv = new String[]{"-rm", testFile};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"rm failed", (long)0L, (long)res);
            if (serverTrash) {
                Assert.assertTrue((String)"File not in trash", (boolean)fs.exists(new Path(trashFile)));
            } else if (clientTrash) {
                Assert.assertTrue((String)"File not in trashed", (boolean)fs.exists(new Path(trashFile)));
            } else {
                Assert.assertFalse((String)"File was not removed", (boolean)fs.exists(new Path(testFile)));
                Assert.assertFalse((String)"File was trashed", (boolean)fs.exists(new Path(trashFile)));
            }
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testAppendToFile() throws Exception {
        int inputFileLength = 0x100000;
        File testRoot = new File(TEST_ROOT_DIR, "testAppendtoFileDir");
        testRoot.mkdirs();
        File file1 = new File(testRoot, "file1");
        File file2 = new File(testRoot, "file2");
        TestDFSShell.createLocalFileWithRandomData(0x100000, file1);
        TestDFSShell.createLocalFileWithRandomData(0x100000, file2);
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        try {
            DistributedFileSystem dfs = cluster.getFileSystem();
            Assert.assertTrue((String)("Not a HDFS: " + dfs.getUri()), (boolean)(dfs instanceof DistributedFileSystem));
            Path remoteFile = new Path("/remoteFile");
            FsShell shell = new FsShell();
            shell.setConf((Configuration)conf);
            String[] argv = new String[]{"-appendToFile", file1.toString(), file2.toString(), remoteFile.toString()};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertThat((Object)res, (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)dfs.getFileStatus(remoteFile).getLen(), (Matcher)CoreMatchers.is((Object)0x200000L));
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertThat((Object)res, (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)dfs.getFileStatus(remoteFile).getLen(), (Matcher)CoreMatchers.is((Object)0x400000L));
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test(timeout=300000L)
    public void testAppendToFileBadArgs() throws Exception {
        int inputFileLength = 0x100000;
        File testRoot = new File(TEST_ROOT_DIR, "testAppendToFileBadArgsDir");
        testRoot.mkdirs();
        File file1 = new File(testRoot, "file1");
        TestDFSShell.createLocalFileWithRandomData(0x100000, file1);
        FsShell shell = new FsShell();
        shell.setConf(dfs.getConf());
        String[] argv = new String[]{"-appendToFile", file1.toString()};
        int res = ToolRunner.run((Tool)shell, (String[])argv);
        Assert.assertThat((Object)res, (Matcher)CoreMatchers.not((Object)0));
        Path remoteFile = new Path("/remoteFile");
        argv = new String[]{"-appendToFile", file1.toString(), "-", remoteFile.toString()};
        res = ToolRunner.run((Tool)shell, (String[])argv);
        Assert.assertThat((Object)res, (Matcher)CoreMatchers.not((Object)0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(timeout=30000L)
    public void testSetXAttrPermission() throws Exception {
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        PrintStream bak = null;
        try {
            Path p = new Path("/foo");
            dfs.mkdirs(p);
            bak = System.err;
            final FsShell fshell = new FsShell(dfs.getConf());
            final ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setErr(new PrintStream(out));
            dfs.setPermission(p, new FsPermission(448));
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", TestDFSShell.USER_A1, "-v", "1234", "/foo"});
                    Assert.assertEquals((String)"Returned should be 1", (long)1L, (long)ret);
                    String str = out.toString();
                    Assert.assertTrue((String)"Permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                    out.reset();
                    return null;
                }
            });
            int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", USER_A1, "-v", "1234", "/foo"});
            Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
            out.reset();
            dfs.setPermission(p, new FsPermission(488));
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-getfattr", "-n", TestDFSShell.USER_A1, "/foo"});
                    Assert.assertEquals((String)"Returned should be 1", (long)1L, (long)ret);
                    String str = out.toString();
                    Assert.assertTrue((String)"Permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                    out.reset();
                    ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-x", TestDFSShell.USER_A1, "/foo"});
                    Assert.assertEquals((String)"Returned should be 1", (long)1L, (long)ret);
                    str = out.toString();
                    Assert.assertTrue((String)"Permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                    out.reset();
                    return null;
                }
            });
            if (bak == null) return;
        }
        catch (Throwable throwable) {
            if (bak == null) throw throwable;
            System.setErr(bak);
            throw throwable;
        }
        System.setErr(bak);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(timeout=30000L)
    public void testSetXAttrCaseSensitivity() throws Exception {
        PrintStream bak = null;
        try {
            Path p = new Path("/mydir");
            dfs.mkdirs(p);
            bak = System.err;
            FsShell fshell = new FsShell(dfs.getConf());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            this.doSetXattr(out, fshell, new String[]{"-setfattr", "-n", "User.Foo", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo"}, new String[0]);
            this.doSetXattr(out, fshell, new String[]{"-setfattr", "-n", "user.FOO", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo", "user.FOO"}, new String[0]);
            this.doSetXattr(out, fshell, new String[]{"-setfattr", "-n", "USER.foo", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo", "user.FOO", "user.foo"}, new String[0]);
            this.doSetXattr(out, fshell, new String[]{"-setfattr", "-n", "USER.fOo", "-v", "myval", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo", "user.FOO", "user.foo", "user.fOo=\"myval\""}, new String[]{"user.Foo=", "user.FOO=", "user.foo="});
            this.doSetXattr(out, fshell, new String[]{"-setfattr", "-x", "useR.foo", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo", "user.FOO"}, new String[]{"foo"});
            this.doSetXattr(out, fshell, new String[]{"-setfattr", "-x", "USER.FOO", "/mydir"}, new String[]{"-getfattr", "-d", "/mydir"}, new String[]{"user.Foo"}, new String[]{"FOO"});
            this.doSetXattr(out, fshell, new String[]{"-setfattr", "-x", "useR.Foo", "/mydir"}, new String[]{"-getfattr", "-n", "User.Foo", "/mydir"}, new String[0], new String[]{"Foo"});
            if (bak == null) return;
        }
        catch (Throwable throwable) {
            if (bak == null) throw throwable;
            System.setOut(bak);
            throw throwable;
        }
        System.setOut(bak);
    }

    private void doSetXattr(ByteArrayOutputStream out, FsShell fshell, String[] setOp, String[] getOp, String[] expectArr, String[] dontExpectArr) throws Exception {
        StringBuilder sb;
        int i;
        int ret = ToolRunner.run((Tool)fshell, (String[])setOp);
        out.reset();
        ret = ToolRunner.run((Tool)fshell, (String[])getOp);
        String str = out.toString();
        for (i = 0; i < expectArr.length; ++i) {
            String expect = expectArr[i];
            sb = new StringBuilder("Incorrect results from getfattr. Expected: ");
            sb.append(expect).append(" Full Result: ");
            sb.append(str);
            Assert.assertTrue((String)sb.toString(), (str.indexOf(expect) != -1 ? 1 : 0) != 0);
        }
        for (i = 0; i < dontExpectArr.length; ++i) {
            String dontExpect = dontExpectArr[i];
            sb = new StringBuilder("Incorrect results from getfattr. Didn't Expect: ");
            sb.append(dontExpect).append(" Full Result: ");
            sb.append(str);
            Assert.assertTrue((String)sb.toString(), (str.indexOf(dontExpect) == -1 ? 1 : 0) != 0);
        }
        out.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(timeout=30000L)
    public void testSetXAttrPermissionAsDifferentOwner() throws Exception {
        String root = "/testSetXAttrPermissionAsDifferentOwner";
        String USER1 = "user1";
        String GROUP1 = "supergroup";
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"supergroup"});
        UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])new String[]{"mygroup2"});
        UserGroupInformation SUPERUSER = UserGroupInformation.getCurrentUser();
        PrintStream bak = null;
        try {
            dfs.mkdirs(new Path("/testSetXAttrPermissionAsDifferentOwner"));
            dfs.setOwner(new Path("/testSetXAttrPermissionAsDifferentOwner"), "user1", "supergroup");
            bak = System.err;
            final FsShell fshell = new FsShell(dfs.getConf());
            final ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setErr(new PrintStream(out));
            user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-mkdir", "/testSetXAttrPermissionAsDifferentOwner/foo"});
                    Assert.assertEquals((String)"Return should be 0", (long)0L, (long)ret);
                    out.reset();
                    return null;
                }
            });
            user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-chmod", "707", "/testSetXAttrPermissionAsDifferentOwner/foo"});
                    Assert.assertEquals((String)"Return should be 0", (long)0L, (long)ret);
                    out.reset();
                    return null;
                }
            });
            user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", TestDFSShell.USER_A1, "-v", "1234", "/testSetXAttrPermissionAsDifferentOwner/foo"});
                    Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                    out.reset();
                    return null;
                }
            });
            user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", TestDFSShell.USER_A1, "-v", "1234", "/testSetXAttrPermissionAsDifferentOwner/foo"});
                    Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                    out.reset();
                    return null;
                }
            });
            user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-getfattr", "-n", TestDFSShell.USER_A1, "/testSetXAttrPermissionAsDifferentOwner/foo"});
                    Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                    out.reset();
                    ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-x", TestDFSShell.USER_A1, "/testSetXAttrPermissionAsDifferentOwner/foo"});
                    Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                    out.reset();
                    return null;
                }
            });
            user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return null;
                }
            });
            user1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-chmod", "700", "/testSetXAttrPermissionAsDifferentOwner/foo"});
                    Assert.assertEquals((String)"Return should be 0", (long)0L, (long)ret);
                    out.reset();
                    return null;
                }
            });
            user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", "user.a2", "/testSetXAttrPermissionAsDifferentOwner/foo"});
                    Assert.assertEquals((String)"Returned should be 1", (long)1L, (long)ret);
                    String str = out.toString();
                    Assert.assertTrue((String)"Permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                    out.reset();
                    return null;
                }
            });
            user2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-x", "user.a2", "/testSetXAttrPermissionAsDifferentOwner/foo"});
                    Assert.assertEquals((String)"Returned should be 1", (long)1L, (long)ret);
                    String str = out.toString();
                    Assert.assertTrue((String)"Permission denied printed", (str.indexOf("Permission denied") != -1 ? 1 : 0) != 0);
                    out.reset();
                    return null;
                }
            });
            SUPERUSER.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", "trusted.a3", "/testSetXAttrPermissionAsDifferentOwner/foo"});
                    Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
                    out.reset();
                    return null;
                }
            });
            if (bak == null) return;
        }
        catch (Throwable throwable) {
            if (bak == null) throw throwable;
            System.setErr(bak);
            throw throwable;
        }
        System.setErr(bak);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(timeout=120000L)
    public void testGetFAttrErrors() throws Exception {
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        PrintStream bakErr = null;
        try {
            final Path p = new Path("/testGetFAttrErrors");
            dfs.mkdirs(p);
            bakErr = System.err;
            final FsShell fshell = new FsShell(dfs.getConf());
            final ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setErr(new PrintStream(out));
            dfs.setPermission(p, new FsPermission(448));
            int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-setfattr", "-n", USER_A1, "-v", "1234", p.toString()});
            Assert.assertEquals((String)"Returned should be 0", (long)0L, (long)ret);
            out.reset();
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-getfattr", "-n", TestDFSShell.USER_A1, p.toString()});
                    String str = out.toString();
                    Assert.assertTrue((String)"xattr value was incorrectly returned", (str.indexOf("1234") == -1 ? 1 : 0) != 0);
                    out.reset();
                    return null;
                }
            });
            ret = ToolRunner.run((Tool)fshell, (String[])new String[]{"-getfattr", "-n", "user.nonexistent", p.toString()});
            String str = out.toString();
            Assert.assertTrue((String)"xattr value was incorrectly returned", (str.indexOf("getfattr: At least one of the attributes provided was not found") >= 0 ? 1 : 0) != 0);
            out.reset();
            if (bakErr == null) return;
        }
        catch (Throwable throwable) {
            if (bakErr == null) throw throwable;
            System.setErr(bakErr);
            throw throwable;
        }
        System.setErr(bakErr);
    }

    @Test(timeout=30000L)
    public void testServerConfigRespected() throws Exception {
        this.deleteFileUsingTrash(true, false);
    }

    @Test(timeout=30000L)
    public void testServerConfigRespectedWithClient() throws Exception {
        this.deleteFileUsingTrash(true, true);
    }

    @Test(timeout=30000L)
    public void testClientConfigRespected() throws Exception {
        this.deleteFileUsingTrash(false, true);
    }

    @Test(timeout=30000L)
    public void testNoTrashConfig() throws Exception {
        this.deleteFileUsingTrash(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testListReserved() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FsShell shell = new FsShell();
        shell.setConf((Configuration)conf);
        FileStatus test = fs.getFileStatus(new Path("/.reserved"));
        Assert.assertEquals((Object)".reserved", (Object)test.getPath().getName());
        FileStatus[] stats = fs.listStatus(new Path("/.reserved"));
        Assert.assertEquals((long)2L, (long)stats.length);
        Assert.assertEquals((Object)".inodes", (Object)stats[0].getPath().getName());
        Assert.assertEquals((Object)conf.get("dfs.permissions.superusergroup"), (Object)stats[0].getGroup());
        Assert.assertEquals((Object)"raw", (Object)stats[1].getPath().getName());
        Assert.assertEquals((Object)conf.get("dfs.permissions.superusergroup"), (Object)stats[1].getGroup());
        stats = fs.listStatus(new Path("/"));
        Assert.assertEquals((long)0L, (long)stats.length);
        PrintStream syserr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        System.setErr(ps);
        try {
            TestDFSShell.runCmd(shell, "-ls", "/.reserved");
            Assert.assertEquals((long)0L, (long)baos.toString().length());
            TestDFSShell.runCmd(shell, "-ls", "/.reserved/raw/.reserved");
            Assert.assertTrue((boolean)baos.toString().contains("No such file or directory"));
        }
        finally {
            System.setErr(syserr);
            cluster.shutdown();
        }
    }

    @Test(timeout=30000L)
    public void testMkdirReserved() throws IOException {
        try {
            dfs.mkdirs(new Path("/.reserved"));
            Assert.fail((String)"Can't mkdir /.reserved");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("\".reserved\" is reserved"));
        }
    }

    @Test(timeout=30000L)
    public void testRmReserved() throws IOException {
        try {
            dfs.delete(new Path("/.reserved"), true);
            Assert.fail((String)"Can't delete /.reserved");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid path name /.reserved"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyReserved() throws IOException {
        File localFile = new File(TEST_ROOT_DIR, "testFileForPut");
        localFile.createNewFile();
        String localfilepath = new Path(localFile.getAbsolutePath()).toUri().toString();
        try {
            dfs.copyFromLocalFile(new Path(localfilepath), new Path("/.reserved"));
            Assert.fail((String)"Can't copyFromLocal to /.reserved");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid path name /.reserved"));
        }
        String testdir = GenericTestUtils.getTempPath((String)"TestDFSShell-testCopyReserved");
        Path hdfsTestDir = new Path(testdir);
        TestDFSShell.writeFile((FileSystem)dfs, new Path(testdir, "testFileForPut"));
        Path src = new Path(hdfsTestDir, "srcfile");
        dfs.create(src).close();
        Assert.assertTrue((boolean)dfs.exists(src));
        PrintStream syserr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        System.setErr(ps);
        try {
            FsShell shell = new FsShell(dfs.getConf());
            TestDFSShell.runCmd(shell, "-cp", src.toString(), "/.reserved");
            Assert.assertTrue((boolean)baos.toString().contains("Invalid path name /.reserved"));
        }
        finally {
            System.setErr(syserr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testChmodReserved() throws IOException {
        PrintStream syserr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        System.setErr(ps);
        try {
            FsShell shell = new FsShell(dfs.getConf());
            TestDFSShell.runCmd(shell, "-chmod", "777", "/.reserved");
            Assert.assertTrue((boolean)baos.toString().contains("Invalid path name /.reserved"));
        }
        finally {
            System.setErr(syserr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testChownReserved() throws IOException {
        PrintStream syserr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        System.setErr(ps);
        try {
            FsShell shell = new FsShell(dfs.getConf());
            TestDFSShell.runCmd(shell, "-chown", "user1", "/.reserved");
            Assert.assertTrue((boolean)baos.toString().contains("Invalid path name /.reserved"));
        }
        finally {
            System.setErr(syserr);
        }
    }

    @Test(timeout=30000L)
    public void testSymLinkReserved() throws IOException {
        try {
            dfs.createSymlink(new Path("/.reserved"), new Path("/rl1"), false);
            Assert.fail((String)"Can't create symlink to /.reserved");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid target name: /.reserved"));
        }
    }

    @Test(timeout=30000L)
    public void testSnapshotReserved() throws IOException {
        Path reserved = new Path("/.reserved");
        try {
            dfs.allowSnapshot(reserved);
            Assert.fail((String)"Can't allow snapshot on /.reserved");
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Directory does not exist"));
        }
        try {
            dfs.createSnapshot(reserved, "snap");
            Assert.fail((String)"Can't create snapshot on /.reserved");
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Directory/File does not exist"));
        }
    }

    static interface TestGetRunner {
        public String run(int var1, String ... var2) throws IOException;
    }
}

