/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSStripedInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.ElasticByteBufferPool;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestDFSStripedInputStream {
    public static final Log LOG = LogFactory.getLog(TestDFSStripedInputStream.class);
    private MiniDFSCluster cluster;
    private Configuration conf = new Configuration();
    private DistributedFileSystem fs;
    private final Path dirPath = new Path("/striped");
    private Path filePath = new Path(this.dirPath, "file");
    private ErasureCodingPolicy ecPolicy;
    private short dataBlocks;
    private short parityBlocks;
    private int cellSize;
    private final int stripesPerBlock = 2;
    private int blockSize;
    private int blockGroupSize;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    public ErasureCodingPolicy getEcPolicy() {
        return StripedFileTestUtil.getDefaultECPolicy();
    }

    @Before
    public void setup() throws IOException {
        this.ecPolicy = this.getEcPolicy();
        this.dataBlocks = (short)this.ecPolicy.getNumDataUnits();
        this.parityBlocks = (short)this.ecPolicy.getNumParityUnits();
        this.cellSize = this.ecPolicy.getCellSize();
        this.blockSize = 2 * this.cellSize;
        this.blockGroupSize = this.dataBlocks * this.blockSize;
        System.out.println("EC policy = " + this.ecPolicy);
        this.conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.conf.setInt("dfs.namenode.replication.max-streams", 0);
        if (ErasureCodeNative.isNativeCodeLoaded()) {
            this.conf.set("io.erasurecode.codec.rs.rawcoders", "rs_native");
        }
        this.conf.set("hdfs.minidfs.basedir", GenericTestUtils.getRandomizedTempPath());
        SimulatedFSDataset.setFactory(this.conf);
        this.startUp();
    }

    private void startUp() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.dataBlocks + this.parityBlocks).build();
        this.cluster.waitActive();
        for (DataNode dn : this.cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
        }
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(this.getEcPolicy().getName());
        this.fs.mkdirs(this.dirPath);
        this.fs.getClient().setErasureCodingPolicy(this.dirPath.toString(), this.ecPolicy.getName());
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testRefreshBlock() throws Exception {
        int numBlocks = 4;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 4, 2, false, this.ecPolicy);
        LocatedBlocks lbs = this.fs.getClient().namenode.getBlockLocations(this.filePath.toString(), 0L, (long)(this.blockGroupSize * 4));
        DFSStripedInputStream in = new DFSStripedInputStream(this.fs.getClient(), this.filePath.toString(), false, this.ecPolicy, null);
        List lbList = lbs.getLocatedBlocks();
        for (LocatedBlock aLbList : lbList) {
            LocatedStripedBlock lsb = (LocatedStripedBlock)aLbList;
            LocatedBlock[] blks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)lsb, (int)this.cellSize, (int)this.dataBlocks, (int)this.parityBlocks);
            for (int j = 0; j < this.dataBlocks; ++j) {
                LocatedBlock refreshed = in.refreshLocatedBlock(blks[j]);
                Assert.assertEquals((Object)blks[j].getBlock(), (Object)refreshed.getBlock());
                Assert.assertEquals((long)blks[j].getStartOffset(), (long)refreshed.getStartOffset());
                Assert.assertArrayEquals((Object[])blks[j].getLocations(), (Object[])refreshed.getLocations());
            }
        }
    }

    @Test
    public void testPread() throws Exception {
        int[] startOffsets;
        int numBlocks = 2;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 2, 2, false, this.ecPolicy);
        LocatedBlocks lbs = this.fs.getClient().namenode.getBlockLocations(this.filePath.toString(), 0L, (long)(this.blockGroupSize * 2));
        int fileLen = this.blockGroupSize * 2;
        byte[] expected = new byte[fileLen];
        Assert.assertEquals((long)2L, (long)lbs.getLocatedBlocks().size());
        for (int bgIdx = 0; bgIdx < 2; ++bgIdx) {
            int i;
            LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(bgIdx);
            for (i = 0; i < this.dataBlocks; ++i) {
                Block blk = new Block(bg.getBlock().getBlockId() + (long)i, (long)(2 * this.cellSize), bg.getBlock().getGenerationStamp());
                blk.setGenerationStamp(bg.getBlock().getGenerationStamp());
                this.cluster.injectBlocks(i, Arrays.asList(blk), bg.getBlock().getBlockPoolId());
            }
            for (i = 0; i < 2; ++i) {
                for (int j = 0; j < this.dataBlocks; ++j) {
                    for (int k = 0; k < this.cellSize; ++k) {
                        int posInBlk = i * this.cellSize + k;
                        int posInFile = i * this.cellSize * this.dataBlocks + j * this.cellSize + k;
                        expected[bgIdx * this.blockGroupSize + posInFile] = SimulatedFSDataset.simulatedByte(new Block(bg.getBlock().getBlockId() + (long)j), posInBlk);
                    }
                }
            }
        }
        DFSStripedInputStream in = new DFSStripedInputStream(this.fs.getClient(), this.filePath.toString(), false, this.ecPolicy, null);
        for (int startOffset : startOffsets = new int[]{0, 1, this.cellSize - 102, this.cellSize, this.cellSize + 102, this.cellSize * this.dataBlocks, this.cellSize * this.dataBlocks + 102, this.blockGroupSize - 102, this.blockGroupSize, this.blockGroupSize + 102, fileLen - 1}) {
            startOffset = Math.max(0, Math.min(startOffset, fileLen - 1));
            int remaining = fileLen - startOffset;
            byte[] buf = new byte[fileLen];
            int ret = in.read((long)startOffset, buf, 0, fileLen);
            Assert.assertEquals((long)remaining, (long)ret);
            for (int i = 0; i < remaining; ++i) {
                Assert.assertEquals((String)("Byte at " + (startOffset + i) + " should be the same"), (long)expected[startOffset + i], (long)buf[i]);
            }
        }
        in.close();
    }

    @Test
    public void testPreadWithDNFailure() throws Exception {
        int i;
        int numBlocks = 4;
        int failedDNIdx = this.dataBlocks - 1;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 4, 2, false, this.ecPolicy);
        LocatedBlocks lbs = this.fs.getClient().namenode.getBlockLocations(this.filePath.toString(), 0L, (long)this.blockGroupSize);
        assert (lbs.get(0) instanceof LocatedStripedBlock);
        LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
        for (int i2 = 0; i2 < this.dataBlocks + this.parityBlocks; ++i2) {
            Block blk = new Block(bg.getBlock().getBlockId() + (long)i2, (long)(2 * this.cellSize), bg.getBlock().getGenerationStamp());
            blk.setGenerationStamp(bg.getBlock().getGenerationStamp());
            this.cluster.injectBlocks(i2, Arrays.asList(blk), bg.getBlock().getBlockPoolId());
        }
        DFSStripedInputStream in = new DFSStripedInputStream(this.fs.getClient(), this.filePath.toString(), false, this.ecPolicy, null);
        int readSize = this.blockGroupSize;
        byte[] readBuffer = new byte[readSize];
        byte[] expected = new byte[readSize];
        for (int i3 = 0; i3 < 2; ++i3) {
            for (int j = 0; j < this.dataBlocks; ++j) {
                for (int k = 0; k < this.cellSize; ++k) {
                    int posInBlk = i3 * this.cellSize + k;
                    int posInFile = i3 * this.cellSize * this.dataBlocks + j * this.cellSize + k;
                    expected[posInFile] = SimulatedFSDataset.simulatedByte(new Block(bg.getBlock().getBlockId() + (long)j), posInBlk);
                }
            }
        }
        ErasureCoderOptions coderOptions = new ErasureCoderOptions((int)this.dataBlocks, (int)this.parityBlocks);
        RawErasureDecoder rawDecoder = CodecUtil.createRawDecoder((Configuration)this.conf, (String)this.ecPolicy.getCodecName(), (ErasureCoderOptions)coderOptions);
        int[] missingBlkIdx = new int[this.parityBlocks];
        for (i = 0; i < missingBlkIdx.length; ++i) {
            missingBlkIdx[i] = i == 0 ? failedDNIdx : this.dataBlocks + i;
        }
        this.cluster.stopDataNode(failedDNIdx);
        for (i = 0; i < 2; ++i) {
            int j;
            byte[][] decodeInputs = new byte[this.dataBlocks + this.parityBlocks][this.cellSize];
            byte[][] decodeOutputs = new byte[missingBlkIdx.length][this.cellSize];
            for (j = 0; j < this.dataBlocks; ++j) {
                int posInBuf = i * this.cellSize * this.dataBlocks + j * this.cellSize;
                if (j == failedDNIdx) continue;
                System.arraycopy(expected, posInBuf, decodeInputs[j], 0, this.cellSize);
            }
            for (j = this.dataBlocks; j < this.dataBlocks + this.parityBlocks; ++j) {
                for (int k = 0; k < this.cellSize; ++k) {
                    int posInBlk = i * this.cellSize + k;
                    decodeInputs[j][k] = SimulatedFSDataset.simulatedByte(new Block(bg.getBlock().getBlockId() + (long)j), posInBlk);
                }
            }
            for (int m : missingBlkIdx) {
                decodeInputs[m] = null;
            }
            rawDecoder.decode(decodeInputs, missingBlkIdx, decodeOutputs);
            int posInBuf = i * this.cellSize * this.dataBlocks + failedDNIdx * this.cellSize;
            System.arraycopy(decodeOutputs[0], 0, expected, posInBuf, this.cellSize);
        }
        int delta = 10;
        int done = 0;
        Assert.assertEquals((long)delta, (long)(done += in.read(0L, readBuffer, 0, delta)));
        Assert.assertArrayEquals((byte[])Arrays.copyOf(expected, done), (byte[])Arrays.copyOf(readBuffer, done));
        Assert.assertEquals((long)(this.cellSize * (this.dataBlocks - 1) - delta), (long)(done += in.read((long)delta, readBuffer, delta, this.cellSize * (this.dataBlocks - 1) - 2 * delta)));
        Assert.assertArrayEquals((byte[])Arrays.copyOf(expected, done), (byte[])Arrays.copyOf(readBuffer, done));
        done += in.read((long)done, readBuffer, done, readSize - done);
        Assert.assertEquals((long)readSize, (long)done);
        Assert.assertArrayEquals((byte[])expected, (byte[])readBuffer);
    }

    @Test
    public void testStatefulRead() throws Exception {
        this.testStatefulRead(false, false);
        this.testStatefulRead(true, false);
        this.testStatefulRead(true, true);
    }

    private void testStatefulRead(boolean useByteBuffer, boolean cellMisalignPacket) throws Exception {
        Object readBuffer;
        int numBlocks = 2;
        int fileSize = 2 * this.blockGroupSize;
        if (cellMisalignPacket) {
            this.conf.setInt("io.file.buffer.size", 4097);
            this.tearDown();
            this.startUp();
        }
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 2, 2, false, this.ecPolicy);
        LocatedBlocks lbs = this.fs.getClient().namenode.getBlockLocations(this.filePath.toString(), 0L, (long)fileSize);
        assert (lbs.getLocatedBlocks().size() == 2);
        for (LocatedBlock lb : lbs.getLocatedBlocks()) {
            assert (lb instanceof LocatedStripedBlock);
            LocatedStripedBlock bg = (LocatedStripedBlock)lb;
            for (int i = 0; i < this.dataBlocks; ++i) {
                Block blk = new Block(bg.getBlock().getBlockId() + (long)i, (long)(2 * this.cellSize), bg.getBlock().getGenerationStamp());
                blk.setGenerationStamp(bg.getBlock().getGenerationStamp());
                this.cluster.injectBlocks(i, Arrays.asList(blk), bg.getBlock().getBlockPoolId());
            }
        }
        DFSStripedInputStream in = new DFSStripedInputStream(this.fs.getClient(), this.filePath.toString(), false, this.ecPolicy, null);
        byte[] expected = new byte[fileSize];
        for (LocatedBlock bg : lbs.getLocatedBlocks()) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < this.dataBlocks; ++j) {
                    for (int k = 0; k < this.cellSize; ++k) {
                        int posInBlk = i * this.cellSize + k;
                        int posInFile = (int)bg.getStartOffset() + i * this.cellSize * this.dataBlocks + j * this.cellSize + k;
                        expected[posInFile] = SimulatedFSDataset.simulatedByte(new Block(bg.getBlock().getBlockId() + (long)j), posInBlk);
                    }
                }
            }
        }
        if (useByteBuffer) {
            int ret;
            readBuffer = ByteBuffer.allocate(fileSize);
            for (int done = 0; done < fileSize; done += ret) {
                ret = in.read((ByteBuffer)readBuffer);
                Assert.assertTrue((ret > 0 ? 1 : 0) != 0);
            }
            Assert.assertArrayEquals((byte[])expected, (byte[])((ByteBuffer)readBuffer).array());
        } else {
            int ret;
            readBuffer = new byte[fileSize];
            for (int done = 0; done < fileSize; done += ret) {
                ret = in.read((byte[])readBuffer, done, fileSize - done);
                Assert.assertTrue((ret > 0 ? 1 : 0) != 0);
            }
            Assert.assertArrayEquals((byte[])expected, (byte[])readBuffer);
        }
        this.fs.delete(this.filePath, true);
    }

    @Test
    public void testStatefulReadWithDNFailure() throws Exception {
        int i;
        int numBlocks = 4;
        int failedDNIdx = this.dataBlocks - 1;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 4, 2, false, this.ecPolicy);
        LocatedBlocks lbs = this.fs.getClient().namenode.getBlockLocations(this.filePath.toString(), 0L, (long)this.blockGroupSize);
        assert (lbs.get(0) instanceof LocatedStripedBlock);
        LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
        for (int i2 = 0; i2 < this.dataBlocks + this.parityBlocks; ++i2) {
            Block blk = new Block(bg.getBlock().getBlockId() + (long)i2, (long)(2 * this.cellSize), bg.getBlock().getGenerationStamp());
            blk.setGenerationStamp(bg.getBlock().getGenerationStamp());
            this.cluster.injectBlocks(i2, Arrays.asList(blk), bg.getBlock().getBlockPoolId());
        }
        DFSStripedInputStream in = new DFSStripedInputStream(this.fs.getClient(), this.filePath.toString(), false, this.ecPolicy, null);
        int readSize = this.blockGroupSize;
        byte[] readBuffer = new byte[readSize];
        byte[] expected = new byte[readSize];
        for (int i3 = 0; i3 < 2; ++i3) {
            for (int j = 0; j < this.dataBlocks; ++j) {
                for (int k = 0; k < this.cellSize; ++k) {
                    int posInBlk = i3 * this.cellSize + k;
                    int posInFile = i3 * this.cellSize * this.dataBlocks + j * this.cellSize + k;
                    expected[posInFile] = SimulatedFSDataset.simulatedByte(new Block(bg.getBlock().getBlockId() + (long)j), posInBlk);
                }
            }
        }
        ErasureCoderOptions coderOptions = new ErasureCoderOptions((int)this.dataBlocks, (int)this.parityBlocks);
        RawErasureDecoder rawDecoder = CodecUtil.createRawDecoder((Configuration)this.conf, (String)this.ecPolicy.getCodecName(), (ErasureCoderOptions)coderOptions);
        int[] missingBlkIdx = new int[this.parityBlocks];
        for (i = 0; i < missingBlkIdx.length; ++i) {
            missingBlkIdx[i] = i == 0 ? failedDNIdx : this.dataBlocks + i;
        }
        this.cluster.stopDataNode(failedDNIdx);
        for (i = 0; i < 2; ++i) {
            int j;
            byte[][] decodeInputs = new byte[this.dataBlocks + this.parityBlocks][this.cellSize];
            byte[][] decodeOutputs = new byte[missingBlkIdx.length][this.cellSize];
            for (j = 0; j < this.dataBlocks; ++j) {
                int posInBuf = i * this.cellSize * this.dataBlocks + j * this.cellSize;
                if (j == failedDNIdx) continue;
                System.arraycopy(expected, posInBuf, decodeInputs[j], 0, this.cellSize);
            }
            for (j = this.dataBlocks; j < this.dataBlocks + this.parityBlocks; ++j) {
                for (int k = 0; k < this.cellSize; ++k) {
                    int posInBlk = i * this.cellSize + k;
                    decodeInputs[j][k] = SimulatedFSDataset.simulatedByte(new Block(bg.getBlock().getBlockId() + (long)j), posInBlk);
                }
            }
            for (int m : missingBlkIdx) {
                decodeInputs[m] = null;
            }
            rawDecoder.decode(decodeInputs, missingBlkIdx, decodeOutputs);
            int posInBuf = i * this.cellSize * this.dataBlocks + failedDNIdx * this.cellSize;
            System.arraycopy(decodeOutputs[0], 0, expected, posInBuf, this.cellSize);
        }
        int delta = 10;
        int done = 0;
        Assert.assertEquals((long)delta, (long)(done += in.read(readBuffer, 0, delta)));
        while (done < this.cellSize * (this.dataBlocks - 1) - 2 * delta) {
            int ret = in.read(readBuffer, delta, this.cellSize * (this.dataBlocks - 1) - 2 * delta);
            Assert.assertTrue((ret > 0 ? 1 : 0) != 0);
            done += ret;
        }
        Assert.assertEquals((long)(this.cellSize * (this.dataBlocks - 1) - delta), (long)done);
        int restSize = readSize - done;
        while (done < restSize) {
            int ret = in.read(readBuffer, done, restSize);
            Assert.assertTrue((ret > 0 ? 1 : 0) != 0);
            done += ret;
        }
        Assert.assertEquals((long)readSize, (long)done);
        Assert.assertArrayEquals((byte[])expected, (byte[])readBuffer);
    }

    @Test
    public void testIdempotentClose() throws Exception {
        int numBlocks = 2;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 2, 2, false, this.ecPolicy);
        try (DFSInputStream in = this.fs.getClient().open(this.filePath.toString());){
            Assert.assertTrue((boolean)(in instanceof DFSStripedInputStream));
            in.close();
        }
    }

    @Test
    public void testReadFailToGetCurrentBlock() throws Exception {
        DFSTestUtil.writeFile((FileSystem)this.cluster.getFileSystem(), this.filePath, "test");
        try (DFSStripedInputStream in = (DFSStripedInputStream)this.fs.getClient().open(this.filePath.toString());){
            DFSStripedInputStream spy = (DFSStripedInputStream)Mockito.spy((Object)in);
            String msg = "Injected exception for testReadNPE";
            ((DFSStripedInputStream)Mockito.doThrow((Throwable)new IOException("Injected exception for testReadNPE")).when((Object)spy)).blockSeekTo(Matchers.anyLong());
            Assert.assertNull((Object)in.getCurrentBlock());
            try {
                spy.read();
                Assert.fail((String)"read should have failed");
            }
            catch (IOException expected) {
                LOG.info((Object)"Exception caught", (Throwable)expected);
                GenericTestUtils.assertExceptionContains((String)"Injected exception for testReadNPE", (Throwable)expected);
            }
        }
    }

    @Test
    public void testCloseDoesNotAllocateNewBuffer() throws Exception {
        int numBlocks = 2;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 2, 2, false, this.ecPolicy);
        try (DFSInputStream in = this.fs.getClient().open(this.filePath.toString());){
            Assert.assertTrue((boolean)(in instanceof DFSStripedInputStream));
            DFSStripedInputStream stream = (DFSStripedInputStream)in;
            ElasticByteBufferPool ebbp = (ElasticByteBufferPool)stream.getBufferPool();
            LOG.info((Object)("Current pool size: direct: " + ebbp.size(true) + ", indirect: " + ebbp.size(false)));
            this.emptyBufferPoolForCurrentPolicy(ebbp, true);
            this.emptyBufferPoolForCurrentPolicy(ebbp, false);
            int startSizeDirect = ebbp.size(true);
            int startSizeIndirect = ebbp.size(false);
            stream.close();
            Assert.assertEquals((long)startSizeDirect, (long)ebbp.size(true));
            Assert.assertEquals((long)startSizeIndirect, (long)ebbp.size(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWhenLastIncompleteCellComeInToDecodeAlignedStripe() throws IOException {
        MiniDFSCluster.DataNodeProperties stopDataNode = null;
        try {
            this.cluster.waitActive();
            ErasureCodingPolicy policy = this.getEcPolicy();
            DistributedFileSystem filesystem = this.cluster.getFileSystem();
            filesystem.enableErasureCodingPolicy(policy.getName());
            Path dir = new Path("/tmp");
            filesystem.mkdirs(dir);
            filesystem.getClient().setErasureCodingPolicy(dir.toString(), policy.getName());
            Path f = new Path(dir, "file");
            long fileLength = policy.getCellSize() * policy.getNumDataUnits() - policy.getCellSize() / 2;
            DFSTestUtil.createFile((FileSystem)filesystem, f, fileLength, (short)1, 0L);
            LocatedBlocks lbs = this.cluster.getNameNodeRpc().getBlockLocations(f.toString(), 0L, fileLength);
            LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
            LocatedBlock[] blocks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)bg, (int)this.cellSize, (int)this.dataBlocks, (int)this.parityBlocks);
            this.cluster.stopDataNode(blocks[0].getLocations()[0].getName());
            try (FSDataInputStream in = filesystem.open(f);){
                DFSStripedInputStream stripedIn = (DFSStripedInputStream)in.getWrappedStream();
                byte[] b = new byte[policy.getCellSize()];
                stripedIn.read(0L, b, 0, policy.getCellSize());
            }
        }
        catch (HadoopIllegalArgumentException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (stopDataNode != null) {
                this.cluster.restartDataNode(stopDataNode, true);
            }
        }
    }

    private void emptyBufferPoolForCurrentPolicy(ElasticByteBufferPool ebbp, boolean direct) {
        int size;
        while ((size = ebbp.size(direct)) != 0) {
            ebbp.getBuffer(direct, this.ecPolicy.getCellSize() * this.ecPolicy.getNumDataUnits());
            if (size != ebbp.size(direct)) continue;
            break;
        }
    }

    @Test
    public void testUnbuffer() throws Exception {
        int ret;
        int numBlocks = 2;
        int fileSize = 2 * this.blockGroupSize;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 2, 2, false, this.ecPolicy);
        LocatedBlocks lbs = this.fs.getClient().namenode.getBlockLocations(this.filePath.toString(), 0L, (long)fileSize);
        for (LocatedBlock lb : lbs.getLocatedBlocks()) {
            assert (lb instanceof LocatedStripedBlock);
            LocatedStripedBlock bg = (LocatedStripedBlock)lb;
            for (int i = 0; i < this.dataBlocks; ++i) {
                Block blk = new Block(bg.getBlock().getBlockId() + (long)i, (long)(2 * this.cellSize), bg.getBlock().getGenerationStamp());
                blk.setGenerationStamp(bg.getBlock().getGenerationStamp());
                this.cluster.injectBlocks(i, Arrays.asList(blk), bg.getBlock().getBlockPoolId());
            }
        }
        DFSStripedInputStream in = new DFSStripedInputStream(this.fs.getClient(), this.filePath.toString(), false, this.ecPolicy, null);
        ByteBuffer readBuffer = ByteBuffer.allocate(fileSize);
        for (int done = 0; done < fileSize; done += ret) {
            ret = in.read(readBuffer);
            Assert.assertTrue((ret > 0 ? 1 : 0) != 0);
        }
        in.unbuffer();
        ByteBuffer curStripeBuf = in.getCurStripeBuf();
        Assert.assertNull((Object)curStripeBuf);
        Assert.assertNull((Object)in.parityBuf);
        in.close();
    }
}

