/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import java.io.File;
import java.util.Arrays;
import java.util.UUID;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.apache.hadoop.crypto.key.kms.LoadBalancingKMSClientProvider;
import org.apache.hadoop.crypto.key.kms.server.MiniKMS;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.TestEncryptionZones;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestEncryptionZonesWithKMS
extends TestEncryptionZones {
    private MiniKMS miniKMS;

    @Override
    protected String getKeyProviderURI() {
        return "kms://" + this.miniKMS.getKMSUrl().toExternalForm().replace("://", "@");
    }

    @Override
    @Before
    public void setup() throws Exception {
        File kmsDir = new File("target/test-classes/" + UUID.randomUUID().toString());
        Assert.assertTrue((boolean)kmsDir.mkdirs());
        MiniKMS.Builder miniKMSBuilder = new MiniKMS.Builder();
        this.miniKMS = miniKMSBuilder.setKmsConfDir(kmsDir).build();
        this.miniKMS.start();
        super.setup();
    }

    @Override
    @After
    public void teardown() {
        super.teardown();
        this.miniKMS.stop();
    }

    @Override
    protected void setProvider() {
    }

    private KMSClientProvider getKMSClientProvider() {
        LoadBalancingKMSClientProvider lbkmscp = (LoadBalancingKMSClientProvider)Whitebox.getInternalState((Object)this.cluster.getNamesystem().getProvider(), (String)"extension");
        assert (lbkmscp.getProviders().length == 1);
        return lbkmscp.getProviders()[0];
    }

    @Test(timeout=120000L)
    public void testCreateEZPopulatesEDEKCache() throws Exception {
        Path zonePath = new Path("/TestEncryptionZone");
        this.fsWrapper.mkdir(zonePath, FsPermission.getDirDefault(), false);
        this.dfsAdmin.createEncryptionZone(zonePath, "test_key", NO_TRASH);
        KMSClientProvider kcp = this.getKMSClientProvider();
        Assert.assertTrue((kcp.getEncKeyQueueSize("test_key") > 0 ? 1 : 0) != 0);
    }

    @Override
    @Test(timeout=120000L)
    public void testDelegationToken() throws Exception {
        String renewer = "JobTracker";
        UserGroupInformation.createRemoteUser((String)"JobTracker");
        Credentials creds = new Credentials();
        Token[] tokens = this.fs.addDelegationTokens("JobTracker", creds);
        DistributedFileSystem.LOG.debug((Object)("Delegation tokens: " + Arrays.asList(tokens)));
        Assert.assertEquals((long)2L, (long)tokens.length);
        Assert.assertEquals((long)2L, (long)creds.numberOfTokens());
        tokens = this.fs.addDelegationTokens("JobTracker", creds);
        Assert.assertEquals((long)0L, (long)tokens.length);
        Assert.assertEquals((long)2L, (long)creds.numberOfTokens());
    }

    @Test(timeout=120000L)
    public void testWarmupEDEKCacheOnStartup() throws Exception {
        Path zonePath = new Path("/TestEncryptionZone");
        this.fsWrapper.mkdir(zonePath, FsPermission.getDirDefault(), false);
        this.dfsAdmin.createEncryptionZone(zonePath, "test_key", NO_TRASH);
        String anotherKey = "k2";
        zonePath = new Path("/TestEncryptionZone2");
        DFSTestUtil.createKey("k2", this.cluster, this.conf);
        this.fsWrapper.mkdir(zonePath, FsPermission.getDirDefault(), false);
        this.dfsAdmin.createEncryptionZone(zonePath, "k2", NO_TRASH);
        KMSClientProvider spy = this.getKMSClientProvider();
        Assert.assertTrue((String)"key queue is empty after creating encryption zone", (spy.getEncKeyQueueSize("test_key") > 0 ? 1 : 0) != 0);
        this.conf.setInt("dfs.namenode.edekcacheloader.initial.delay.ms", 0);
        this.cluster.restartNameNode(true);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                KMSClientProvider kspy = TestEncryptionZonesWithKMS.this.getKMSClientProvider();
                return kspy.getEncKeyQueueSize("test_key") > 0;
            }
        }, (long)1000L, (long)60000L);
    }

    @Test
    public void addDelegationTokenFromWebhdfsFileSystem() throws Exception {
        UserGroupInformation.createRemoteUser((String)"JobTracker");
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystem(this.conf, "webhdfs");
        Credentials creds = new Credentials();
        Token[] tokens = webfs.addDelegationTokens("JobTracker", creds);
        Assert.assertEquals((long)2L, (long)tokens.length);
        Assert.assertEquals((Object)"kms-dt", (Object)tokens[1].getKind().toString());
        Assert.assertEquals((long)2L, (long)creds.numberOfTokens());
    }
}

