/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyRackFaultTolerant;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestErasureCodingMultipleRacks {
    public static final Logger LOG = LoggerFactory.getLogger(TestErasureCodingMultipleRacks.class);
    @Rule
    public Timeout globalTimeout = new Timeout(300000);
    private MiniDFSCluster cluster;
    private ErasureCodingPolicy ecPolicy;
    private Configuration conf;
    private DistributedFileSystem dfs;

    public ErasureCodingPolicy getPolicy() {
        return StripedFileTestUtil.getDefaultECPolicy();
    }

    @Before
    public void setup() {
        this.ecPolicy = this.getPolicy();
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
    }

    public void setupCluster(int numDatanodes, int numRacks, int numSingleDnRacks) throws Exception {
        int i;
        assert (numDatanodes > numRacks);
        assert (numRacks > numSingleDnRacks);
        assert (numSingleDnRacks >= 0);
        String[] racks = new String[numDatanodes];
        for (i = 0; i < numSingleDnRacks; ++i) {
            racks[i] = "/rack" + i;
        }
        for (i = numSingleDnRacks; i < numDatanodes; ++i) {
            racks[i] = "/rack" + (numSingleDnRacks + i % (numRacks - numSingleDnRacks));
        }
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(numDatanodes).racks(racks).build();
        this.dfs = this.cluster.getFileSystem();
        this.cluster.waitActive();
        this.dfs.setErasureCodingPolicy(new Path("/"), this.ecPolicy.getName());
    }

    @After
    public void teardown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testSkewedRack1() throws Exception {
        int dataUnits = this.ecPolicy.getNumDataUnits();
        int parityUnits = this.ecPolicy.getNumParityUnits();
        this.setupCluster(dataUnits + parityUnits, 2, 1);
        int filesize = this.ecPolicy.getNumDataUnits() * this.ecPolicy.getCellSize();
        byte[] contents = new byte[filesize];
        Path path = new Path("/testfile");
        LOG.info("Writing file " + path);
        DFSTestUtil.writeFile((FileSystem)this.dfs, path, contents);
        BlockLocation[] blocks = this.dfs.getFileBlockLocations(path, 0L, Long.MAX_VALUE);
        Assert.assertEquals((long)(this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits()), (long)blocks[0].getHosts().length);
    }

    @Test
    public void testSkewedRack2() throws Exception {
        int dataUnits = this.ecPolicy.getNumDataUnits();
        int parityUnits = this.ecPolicy.getNumParityUnits();
        this.setupCluster(dataUnits + parityUnits * 2, dataUnits, dataUnits - 1);
        int filesize = this.ecPolicy.getNumDataUnits() * this.ecPolicy.getCellSize();
        byte[] contents = new byte[filesize];
        Path path = new Path("/testfile");
        LOG.info("Writing file " + path);
        DFSTestUtil.writeFile((FileSystem)this.dfs, path, contents);
        BlockLocation[] blocks = this.dfs.getFileBlockLocations(path, 0L, Long.MAX_VALUE);
        Assert.assertEquals((long)(this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits()), (long)blocks[0].getHosts().length);
    }

    @Test
    public void testSkewedRack3() throws Exception {
        int dataUnits = this.ecPolicy.getNumDataUnits();
        int parityUnits = this.ecPolicy.getNumParityUnits();
        int numRacks = dataUnits - parityUnits + 2;
        this.setupCluster(dataUnits + parityUnits * 4, numRacks, dataUnits - parityUnits);
        int filesize = this.ecPolicy.getNumDataUnits() * this.ecPolicy.getCellSize();
        byte[] contents = new byte[filesize];
        for (int i = 0; i < 10; ++i) {
            Path path = new Path("/testfile" + i);
            LOG.info("Writing file " + path);
            DFSTestUtil.writeFile((FileSystem)this.dfs, path, contents);
            ExtendedBlock extendedBlock = DFSTestUtil.getFirstBlock((FileSystem)this.dfs, path);
            DFSTestUtil.waitForReplication(this.cluster, extendedBlock, numRacks, this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits(), 0);
            BlockLocation[] blocks = this.dfs.getFileBlockLocations(path, 0L, Long.MAX_VALUE);
            Assert.assertEquals((long)(this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits()), (long)blocks[0].getHosts().length);
            this.assertRackFailureTolerated(blocks[0].getTopologyPaths());
        }
    }

    private void assertRackFailureTolerated(String[] topologies) {
        HashMap<String, Integer> racksCount = new HashMap<String, Integer>();
        for (String t : topologies) {
            Integer count = (Integer)racksCount.get(this.getRackName(t));
            if (count == null) {
                racksCount.put(this.getRackName(t), 1);
                continue;
            }
            racksCount.put(this.getRackName(t), count + 1);
        }
        LOG.info("Rack count map is: {}", racksCount);
        for (Integer count : racksCount.values()) {
            Assert.assertTrue((count <= this.ecPolicy.getNumParityUnits() ? 1 : 0) != 0);
        }
    }

    private String getRackName(String topology) {
        assert (topology.indexOf(47, 1) > 0);
        return topology.substring(0, topology.indexOf(47, 1));
    }

    static {
        GenericTestUtils.setLogLevel((Logger)BlockPlacementPolicy.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)BlockPlacementPolicyDefault.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)BlockPlacementPolicyRackFaultTolerant.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)NetworkTopology.LOG, (Level)Level.DEBUG);
    }
}

