/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.net;

import com.google.common.collect.Sets;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.net.DFSNetworkTopology;
import org.apache.hadoop.hdfs.net.DFSTopologyNodeImpl;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.net.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestDFSNetworkTopology {
    private static final Log LOG = LogFactory.getLog(TestDFSNetworkTopology.class);
    private static final DFSNetworkTopology CLUSTER = DFSNetworkTopology.getInstance((Configuration)new Configuration());
    private DatanodeDescriptor[] dataNodes;
    @Rule
    public Timeout testTimeout = new Timeout(30000);

    @Before
    public void setupDatanodes() {
        String[] racks = new String[]{"/l1/d1/r1", "/l1/d1/r1", "/l1/d1/r2", "/l1/d1/r2", "/l1/d1/r2", "/l1/d2/r3", "/l1/d2/r3", "/l1/d2/r3", "/l2/d3/r1", "/l2/d3/r2", "/l2/d3/r3", "/l2/d3/r4", "/l2/d3/r5", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r1", "/l2/d4/r1"};
        String[] hosts = new String[]{"host1", "host2", "host3", "host4", "host5", "host6", "host7", "host8", "host9", "host10", "host11", "host12", "host13", "host14", "host15", "host16", "host17", "host18", "host19", "host20"};
        StorageType[] types = new StorageType[]{StorageType.ARCHIVE, StorageType.DISK, StorageType.ARCHIVE, StorageType.DISK, StorageType.DISK, StorageType.DISK, StorageType.RAM_DISK, StorageType.SSD, StorageType.DISK, StorageType.RAM_DISK, StorageType.DISK, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.DISK, StorageType.DISK, StorageType.RAM_DISK, StorageType.RAM_DISK, StorageType.ARCHIVE, StorageType.ARCHIVE, StorageType.SSD};
        DatanodeStorageInfo[] storages = DFSTestUtil.createDatanodeStorageInfos(20, racks, hosts, types);
        this.dataNodes = DFSTestUtil.toDatanodeDescriptor(storages);
        for (int i = 0; i < this.dataNodes.length; ++i) {
            CLUSTER.add((Node)this.dataNodes[i]);
        }
        this.dataNodes[9].setDecommissioned();
        this.dataNodes[10].setDecommissioned();
    }

    @Test
    public void testGetStorageTypeInfo() throws Exception {
        DFSTopologyNodeImpl d1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1/d1");
        HashMap d1info = d1.getChildrenStorageInfo();
        Assert.assertEquals((long)2L, (long)d1info.keySet().size());
        Assert.assertTrue((((EnumMap)d1info.get("r1")).size() == 2 && ((EnumMap)d1info.get("r2")).size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d1info.get("r1")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d1info.get("r1")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)d1info.get("r2")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d1info.get("r2")).get(StorageType.ARCHIVE)).intValue());
        DFSTopologyNodeImpl d2 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1/d2");
        HashMap d2info = d2.getChildrenStorageInfo();
        Assert.assertEquals((long)1L, (long)d2info.keySet().size());
        Assert.assertTrue((((EnumMap)d2info.get("r3")).size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d2info.get("r3")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d2info.get("r3")).get(StorageType.RAM_DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d2info.get("r3")).get(StorageType.SSD)).intValue());
        DFSTopologyNodeImpl d3 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l2/d3");
        HashMap d3info = d3.getChildrenStorageInfo();
        Assert.assertEquals((long)5L, (long)d3info.keySet().size());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d3info.get("r1")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d3info.get("r2")).get(StorageType.RAM_DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d3info.get("r3")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d3info.get("r4")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d3info.get("r5")).get(StorageType.ARCHIVE)).intValue());
        DFSTopologyNodeImpl d4 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l2/d4");
        HashMap d4info = d4.getChildrenStorageInfo();
        Assert.assertEquals((long)1L, (long)d4info.keySet().size());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)d4info.get("r1")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)d4info.get("r1")).get(StorageType.RAM_DISK)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)d4info.get("r1")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d4info.get("r1")).get(StorageType.SSD)).intValue());
        DFSTopologyNodeImpl l1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1");
        HashMap l1info = l1.getChildrenStorageInfo();
        Assert.assertEquals((long)2L, (long)l1info.keySet().size());
        Assert.assertTrue((((EnumMap)l1info.get("d1")).size() == 2 && ((EnumMap)l1info.get("d2")).size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)l1info.get("d1")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)((EnumMap)l1info.get("d1")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.RAM_DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.SSD)).intValue());
        DFSTopologyNodeImpl l2 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l2");
        HashMap l2info = l2.getChildrenStorageInfo();
        Assert.assertTrue((((EnumMap)l2info.get("d3")).size() == 3 && ((EnumMap)l2info.get("d4")).size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)l2info.keySet().size());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)l2info.get("d3")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)l2info.get("d3")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l2info.get("d3")).get(StorageType.RAM_DISK)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)l2info.get("d4")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)l2info.get("d4")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)l2info.get("d4")).get(StorageType.RAM_DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l2info.get("d4")).get(StorageType.SSD)).intValue());
    }

    @Test
    public void testAddAndRemoveTopology() throws Exception {
        String[] newRack = new String[]{"/l1/d1/r1", "/l1/d1/r3", "/l1/d3/r3", "/l1/d3/r3"};
        String[] newHost = new String[]{"nhost1", "nhost2", "nhost3", "nhost4"};
        String[] newips = new String[]{"30.30.30.30", "31.31.31.31", "32.32.32.32", "33.33.33.33"};
        StorageType[] newTypes = new StorageType[]{StorageType.DISK, StorageType.SSD, StorageType.SSD, StorageType.SSD};
        DatanodeDescriptor[] newDD = new DatanodeDescriptor[4];
        for (int i = 0; i < 4; ++i) {
            DatanodeStorageInfo dsi = DFSTestUtil.createDatanodeStorageInfo("s" + newHost[i], newips[i], newRack[i], newHost[i], newTypes[i], null);
            newDD[i] = dsi.getDatanodeDescriptor();
            CLUSTER.add((Node)newDD[i]);
        }
        DFSTopologyNodeImpl d1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1/d1");
        HashMap d1info = d1.getChildrenStorageInfo();
        Assert.assertEquals((long)3L, (long)d1info.keySet().size());
        Assert.assertTrue((((EnumMap)d1info.get("r1")).size() == 2 && ((EnumMap)d1info.get("r2")).size() == 2 && ((EnumMap)d1info.get("r3")).size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)d1info.get("r1")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d1info.get("r1")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)d1info.get("r2")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d1info.get("r2")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)d1info.get("r3")).get(StorageType.SSD)).intValue());
        DFSTopologyNodeImpl d3 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1/d3");
        HashMap d3info = d3.getChildrenStorageInfo();
        Assert.assertEquals((long)1L, (long)d3info.keySet().size());
        Assert.assertTrue((((EnumMap)d3info.get("r3")).size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)d3info.get("r3")).get(StorageType.SSD)).intValue());
        DFSTopologyNodeImpl l1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1");
        HashMap l1info = l1.getChildrenStorageInfo();
        Assert.assertEquals((long)3L, (long)l1info.keySet().size());
        Assert.assertTrue((((EnumMap)l1info.get("d1")).size() == 3 && ((EnumMap)l1info.get("d2")).size() == 3 && ((EnumMap)l1info.get("d3")).size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)((Integer)((EnumMap)l1info.get("d1")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)l1info.get("d1")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l1info.get("d1")).get(StorageType.SSD)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.SSD)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.RAM_DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)l1info.get("d3")).get(StorageType.SSD)).intValue());
        for (int i = 0; i < 4; ++i) {
            CLUSTER.remove((Node)newDD[i]);
        }
        DFSTopologyNodeImpl nd1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1/d1");
        HashMap nd1info = nd1.getChildrenStorageInfo();
        Assert.assertEquals((long)2L, (long)nd1info.keySet().size());
        Assert.assertTrue((((EnumMap)nd1info.get("r1")).size() == 2 && ((EnumMap)nd1info.get("r2")).size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)nd1info.get("r1")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)nd1info.get("r1")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)nd1info.get("r2")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)nd1info.get("r2")).get(StorageType.ARCHIVE)).intValue());
        DFSTopologyNodeImpl nl1 = (DFSTopologyNodeImpl)CLUSTER.getNode("/l1");
        HashMap nl1info = nl1.getChildrenStorageInfo();
        Assert.assertEquals((long)2L, (long)nl1info.keySet().size());
        Assert.assertTrue((((EnumMap)l1info.get("d1")).size() == 2 && ((EnumMap)l1info.get("d2")).size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)((Integer)((EnumMap)nl1info.get("d1")).get(StorageType.ARCHIVE)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)((EnumMap)nl1info.get("d1")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.RAM_DISK)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)((EnumMap)l1info.get("d2")).get(StorageType.SSD)).intValue());
        Assert.assertNull((Object)CLUSTER.getNode("/l1/d3"));
    }

    @Test
    public void testChooseRandomWithStorageType() throws Exception {
        HashSet diskUnderL1 = Sets.newHashSet((Object[])new String[]{"host2", "host4", "host5", "host6"});
        HashSet archiveUnderL1 = Sets.newHashSet((Object[])new String[]{"host1", "host3"});
        HashSet ramdiskUnderL1 = Sets.newHashSet((Object[])new String[]{"host7"});
        HashSet ssdUnderL1 = Sets.newHashSet((Object[])new String[]{"host8"});
        for (int i = 0; i < 10; ++i) {
            Node n = CLUSTER.chooseRandomWithStorageType("/l1", null, null, StorageType.DISK);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            DatanodeDescriptor dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)diskUnderL1.contains(dd.getHostName()));
            n = CLUSTER.chooseRandomWithStorageType("/l1", null, null, StorageType.RAM_DISK);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)ramdiskUnderL1.contains(dd.getHostName()));
            n = CLUSTER.chooseRandomWithStorageType("/l1", null, null, StorageType.ARCHIVE);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)archiveUnderL1.contains(dd.getHostName()));
            n = CLUSTER.chooseRandomWithStorageType("/l1", null, null, StorageType.SSD);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)ssdUnderL1.contains(dd.getHostName()));
        }
    }

    @Test
    public void testChooseRandomWithStorageTypeWithExcluded() throws Exception {
        DatanodeDescriptor dd;
        int i;
        Node n = CLUSTER.chooseRandomWithStorageType("/l2/d3/r4", null, null, StorageType.ARCHIVE);
        HashSet<Node> excluded = new HashSet<Node>();
        excluded.add(n);
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", null, null, StorageType.ARCHIVE);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((dd.getHostName().equals("host12") || dd.getHostName().equals("host13") ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", null, excluded, StorageType.ARCHIVE);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)dd.getHostName().equals("host13"));
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", "/l2/d3/r4", null, StorageType.ARCHIVE);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)dd.getHostName().equals("host13"));
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", "/l2/d3/r5", excluded, StorageType.ARCHIVE);
            Assert.assertNull((Object)n);
        }
        n = CLUSTER.chooseRandomWithStorageType("/l1/d2", null, null, StorageType.DISK);
        dd = (DatanodeDescriptor)n;
        Assert.assertEquals((Object)"host6", (Object)dd.getHostName());
        excluded.add(n);
        HashSet expectedSet = Sets.newHashSet((Object[])new String[]{"host4", "host5"});
        for (int i2 = 0; i2 < 10; ++i2) {
            n = CLUSTER.chooseRandomWithStorageType("/l1", "/l1/d1/r1", excluded, StorageType.DISK);
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)expectedSet.contains(dd.getHostName()));
        }
    }

    @Test
    public void testChooseRandomWithStorageTypeWithExcludedforNullCheck() throws Exception {
        HashSet<DatanodeInfo> excluded = new HashSet<DatanodeInfo>();
        excluded.add(new DatanodeInfo.DatanodeInfoBuilder().setNodeID(DatanodeID.EMPTY_DATANODE_ID).build());
        Node node = CLUSTER.chooseRandomWithStorageType("/", "/l1/d1/r1", excluded, StorageType.ARCHIVE);
        Assert.assertNotNull((Object)node);
    }

    @Test
    public void testChooseRandomWithStorageTypeWrapper() throws Exception {
        DatanodeDescriptor dd;
        int i;
        Node n = CLUSTER.chooseRandomWithStorageType("/l2/d3/r4", null, null, StorageType.ARCHIVE);
        HashSet<Node> excluded = new HashSet<Node>();
        excluded.add(n);
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", null, StorageType.ARCHIVE);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((dd.getHostName().equals("host12") || dd.getHostName().equals("host13") ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("/l2/d3", excluded, StorageType.ARCHIVE);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)dd.getHostName().equals("host13"));
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("~/l2/d4", null, StorageType.RAM_DISK);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((dd.getHostName().equals("host7") || dd.getHostName().equals("host10") ? 1 : 0) != 0);
        }
        n = CLUSTER.chooseRandomWithStorageType("/l2/d3/r2", null, null, StorageType.RAM_DISK);
        excluded.add(n);
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageType("~/l2/d4", excluded, StorageType.RAM_DISK);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)dd.getHostName().equals("host7"));
        }
    }

    @Test
    public void testNonExistingNode() throws Exception {
        Node n = CLUSTER.chooseRandomWithStorageType("/l100", null, null, StorageType.DISK);
        Assert.assertNull((Object)n);
        n = CLUSTER.chooseRandomWithStorageType("/l100/d100", null, null, StorageType.DISK);
        Assert.assertNull((Object)n);
        n = CLUSTER.chooseRandomWithStorageType("/l100/d100/r100", null, null, StorageType.DISK);
        Assert.assertNull((Object)n);
    }

    @Test
    public void testGetSubtreeStorageCount() throws Exception {
        Node l2 = CLUSTER.getNode("/l2");
        Node l2d3 = CLUSTER.getNode("/l2/d3");
        Node l2d3r1 = CLUSTER.getNode("/l2/d3/r1");
        Node l2d3r3 = CLUSTER.getNode("/l2/d3/r3");
        Assert.assertTrue((boolean)(l2 instanceof DFSTopologyNodeImpl));
        Assert.assertTrue((boolean)(l2d3 instanceof DFSTopologyNodeImpl));
        Assert.assertTrue((boolean)(l2d3r1 instanceof DFSTopologyNodeImpl));
        Assert.assertTrue((boolean)(l2d3r3 instanceof DFSTopologyNodeImpl));
        DFSTopologyNodeImpl innerl2 = (DFSTopologyNodeImpl)l2;
        DFSTopologyNodeImpl innerl2d3 = (DFSTopologyNodeImpl)l2d3;
        DFSTopologyNodeImpl innerl2d3r1 = (DFSTopologyNodeImpl)l2d3r1;
        DFSTopologyNodeImpl innerl2d3r3 = (DFSTopologyNodeImpl)l2d3r3;
        Assert.assertEquals((long)4L, (long)innerl2.getSubtreeStorageCount(StorageType.DISK));
        Assert.assertEquals((long)2L, (long)innerl2d3.getSubtreeStorageCount(StorageType.DISK));
        Assert.assertEquals((long)1L, (long)innerl2d3r1.getSubtreeStorageCount(StorageType.DISK));
        Assert.assertEquals((long)1L, (long)innerl2d3r3.getSubtreeStorageCount(StorageType.DISK));
        DatanodeStorageInfo storageInfo = DFSTestUtil.createDatanodeStorageInfo("StorageID", "1.2.3.4", "/l2/d3/r1", "newhost");
        DatanodeDescriptor newNode = storageInfo.getDatanodeDescriptor();
        CLUSTER.add((Node)newNode);
        Assert.assertEquals((long)5L, (long)innerl2.getSubtreeStorageCount(StorageType.DISK));
        Assert.assertEquals((long)3L, (long)innerl2d3.getSubtreeStorageCount(StorageType.DISK));
        Assert.assertEquals((long)2L, (long)innerl2d3r1.getSubtreeStorageCount(StorageType.DISK));
        Assert.assertEquals((long)1L, (long)innerl2d3r3.getSubtreeStorageCount(StorageType.DISK));
        CLUSTER.remove((Node)newNode);
        Assert.assertEquals((long)4L, (long)innerl2.getSubtreeStorageCount(StorageType.DISK));
        Assert.assertEquals((long)2L, (long)innerl2d3.getSubtreeStorageCount(StorageType.DISK));
        Assert.assertEquals((long)1L, (long)innerl2d3r1.getSubtreeStorageCount(StorageType.DISK));
        Assert.assertEquals((long)1L, (long)innerl2d3r3.getSubtreeStorageCount(StorageType.DISK));
    }

    @Test
    public void testChooseRandomWithStorageTypeTwoTrial() throws Exception {
        DatanodeDescriptor dd;
        int i;
        Node n = CLUSTER.chooseRandomWithStorageType("/l2/d3/r4", null, null, StorageType.ARCHIVE);
        HashSet<Node> excluded = new HashSet<Node>();
        excluded.add(n);
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageTypeTwoTrial("/l2/d3", null, StorageType.ARCHIVE);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((dd.getHostName().equals("host12") || dd.getHostName().equals("host13") ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageTypeTwoTrial("/l2/d3", excluded, StorageType.ARCHIVE);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)dd.getHostName().equals("host13"));
        }
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageTypeTwoTrial("~/l2/d4", null, StorageType.RAM_DISK);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((dd.getHostName().equals("host7") || dd.getHostName().equals("host10") ? 1 : 0) != 0);
        }
        n = CLUSTER.chooseRandomWithStorageType("/l2/d3/r2", null, null, StorageType.RAM_DISK);
        excluded.add(n);
        for (i = 0; i < 10; ++i) {
            n = CLUSTER.chooseRandomWithStorageTypeTwoTrial("~/l2/d4", excluded, StorageType.RAM_DISK);
            Assert.assertTrue((boolean)(n instanceof DatanodeDescriptor));
            dd = (DatanodeDescriptor)n;
            Assert.assertTrue((boolean)dd.getHostName().equals("host7"));
        }
    }

    @Test
    public void testChooseRandomWithStorageTypeNoAvlblNode() {
        DFSNetworkTopology dfsCluster = DFSNetworkTopology.getInstance((Configuration)new Configuration());
        String[] racks = new String[]{"/default/rack1", "/default/rack10"};
        String[] hosts = new String[]{"host1", "host2"};
        StorageType[] types = new StorageType[]{StorageType.DISK, StorageType.DISK};
        DatanodeStorageInfo[] storages = DFSTestUtil.createDatanodeStorageInfos(2, racks, hosts, types);
        DatanodeDescriptor[] dns = DFSTestUtil.toDatanodeDescriptor(storages);
        dfsCluster.add((Node)dns[0]);
        dfsCluster.add((Node)dns[1]);
        HashSet<DatanodeDescriptor> excluded = new HashSet<DatanodeDescriptor>();
        excluded.add(dns[1]);
        Node n = dfsCluster.chooseRandomWithStorageType("/default", "/default/rack1", excluded, StorageType.DISK);
        Assert.assertNull((String)"No node should have been selected.", (Object)n);
    }
}

