/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Supplier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class TestNameNodePrunesMissingStorages {
    static final Log LOG = LogFactory.getLog(TestNameNodePrunesMissingStorages.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTest(String testCaseName, boolean createFiles, int numInitialStorages, int expectedStoragesAfterTest) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).storagesPerDatanode(numInitialStorages).build();
            cluster.waitActive();
            DataNode dn0 = cluster.getDataNodes().get(0);
            DatanodeID dnId = dn0.getDatanodeId();
            DatanodeDescriptor dnDescriptor = cluster.getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dnId);
            Assert.assertThat((Object)dnDescriptor.getStorageInfos().length, (Matcher)Is.is((Object)numInitialStorages));
            String bpid = cluster.getNamesystem().getBlockPoolId();
            DatanodeRegistration dnReg = dn0.getDNRegistrationForBP(bpid);
            DataNodeTestUtils.triggerBlockReport(dn0);
            if (createFiles) {
                Path path = new Path("/", testCaseName);
                DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), path, 1024L, (short)1, 464346861L);
                DataNodeTestUtils.triggerBlockReport(dn0);
            }
            StorageReport[] reports = dn0.getFSDataset().getStorageReports(bpid);
            StorageReport[] prunedReports = new StorageReport[numInitialStorages - 1];
            System.arraycopy(reports, 0, prunedReports, 0, prunedReports.length);
            cluster.stopDataNode(0);
            cluster.getNameNodeRpc().sendHeartbeat(dnReg, prunedReports, 0L, 0L, 0, 0, 0, null, true, SlowPeerReports.EMPTY_REPORT, SlowDiskReports.EMPTY_REPORT);
            Assert.assertThat((Object)dnDescriptor.getStorageInfos().length, (Matcher)Is.is((Object)expectedStoragesAfterTest));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=300000L)
    public void testUnusedStorageIsPruned() throws IOException {
        TestNameNodePrunesMissingStorages.runTest(GenericTestUtils.getMethodName(), false, 1, 0);
    }

    @Test(timeout=300000L)
    public void testStorageWithBlocksIsNotPruned() throws IOException {
        TestNameNodePrunesMissingStorages.runTest(GenericTestUtils.getMethodName(), true, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRemovingStorageDoesNotProduceZombies() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        int NUM_STORAGES_PER_DN = 2;
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storagesPerDatanode(2).build();
        try {
            DataNode datanodeToRemoveStorageFrom;
            String datanodeUuid;
            String storageIdToRemove;
            cluster.waitActive();
            for (DataNode dn : cluster.getDataNodes()) {
                Assert.assertEquals((long)2L, (long)cluster.getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId()).getStorageInfos().length);
            }
            Path TEST_PATH = new Path("/foo1");
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 1024L, (short)3, -889271554L);
            for (DataNode dn : cluster.getDataNodes()) {
                DataNodeTestUtils.triggerBlockReport(dn);
            }
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, new Path("/foo1"));
            cluster.getNamesystem().writeLock();
            try {
                BlockInfo storedBlock = cluster.getNamesystem().getBlockManager().getStoredBlock(block.getLocalBlock());
                Iterator storageInfoIter = cluster.getNamesystem().getBlockManager().blocksMap.getStorages(storedBlock).iterator();
                Assert.assertTrue((boolean)storageInfoIter.hasNext());
                DatanodeStorageInfo info = (DatanodeStorageInfo)storageInfoIter.next();
                storageIdToRemove = info.getStorageID();
                datanodeUuid = info.getDatanodeDescriptor().getDatanodeUuid();
            }
            finally {
                cluster.getNamesystem().writeUnlock();
            }
            int datanodeToRemoveStorageFromIdx = 0;
            while (true) {
                if (datanodeToRemoveStorageFromIdx >= cluster.getDataNodes().size()) {
                    Assert.fail((String)("failed to find datanode with uuid " + datanodeUuid));
                    datanodeToRemoveStorageFrom = null;
                    break;
                }
                DataNode dn = cluster.getDataNodes().get(datanodeToRemoveStorageFromIdx);
                if (dn.getDatanodeUuid().equals(datanodeUuid)) {
                    datanodeToRemoveStorageFrom = dn;
                    break;
                }
                ++datanodeToRemoveStorageFromIdx;
            }
            StorageLocation volumeLocationToRemove = null;
            try (FsDatasetSpi.FsVolumeReferences volumes = datanodeToRemoveStorageFrom.getFSDataset().getFsVolumeReferences();){
                Assert.assertEquals((long)2L, (long)volumes.size());
                for (FsVolumeSpi volume : volumes) {
                    if (!volume.getStorageID().equals(storageIdToRemove)) continue;
                    volumeLocationToRemove = volume.getStorageLocation();
                }
            }
            Assert.assertNotNull(volumeLocationToRemove);
            datanodeToRemoveStorageFrom.shutdown();
            FileUtil.fullyDelete((File)new File(volumeLocationToRemove.getUri()));
            try (FileOutputStream fos = new FileOutputStream(new File(volumeLocationToRemove.getUri()));){
                fos.write(1);
            }
            cluster.restartDataNode(datanodeToRemoveStorageFromIdx);
            LOG.info((Object)("waiting for the datanode to remove " + storageIdToRemove));
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    DatanodeStorageInfo[] infos;
                    DatanodeDescriptor dnDescriptor = cluster.getNamesystem().getBlockManager().getDatanodeManager().getDatanode(datanodeToRemoveStorageFrom.getDatanodeUuid());
                    Assert.assertNotNull((Object)dnDescriptor);
                    for (DatanodeStorageInfo info : infos = dnDescriptor.getStorageInfos()) {
                        if (!info.getStorageID().equals(storageIdToRemove)) continue;
                        LOG.info((Object)("Still found storage " + storageIdToRemove + " on " + info + "."));
                        return false;
                    }
                    Assert.assertEquals((long)1L, (long)infos.length);
                    return true;
                }
            }, (long)1000L, (long)30000L);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rewriteVersionFile(File versionFile, String newStorageId) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(versionFile));
        File newVersionFile = new File(versionFile.getParent(), UUID.randomUUID().toString());
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newVersionFile), "UTF-8"));
        String STORAGE_ID = "storageID=";
        boolean success = false;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("storageID=")) {
                    out.write("storageID=" + newStorageId + "\n");
                    continue;
                }
                out.write(line + "\n");
            }
            in.close();
            in = null;
            ((Writer)out).close();
            out = null;
            success = versionFile.delete();
            success &= newVersionFile.renameTo(versionFile);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((Writer)out).close();
            }
            if (!success) {
                versionFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRenamingStorageIds() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 0);
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).storagesPerDatanode(1).build();
        GenericTestUtils.setLogLevel((Logger)BlockManager.LOG, (Level)Level.ALL);
        try {
            cluster.waitActive();
            Path TEST_PATH = new Path("/foo1");
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 1L, (short)1, -559038737L);
            DataNode dn = cluster.getDataNodes().get(0);
            final String newStorageId = DatanodeStorage.generateUuid();
            try (FsDatasetSpi.FsVolumeReferences volumeRefs = dn.getFSDataset().getFsVolumeReferences();){
                File currentDir = new File(new File(volumeRefs.get(0).getStorageLocation().getUri()), "current");
                File versionFile = new File(currentDir, "VERSION");
                TestNameNodePrunesMissingStorages.rewriteVersionFile(versionFile, newStorageId);
            }
            final ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, TEST_PATH);
            cluster.restartDataNodes();
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Boolean get() {
                    cluster.getNamesystem().writeLock();
                    try {
                        Iterator storageInfoIter = cluster.getNamesystem().getBlockManager().getStorages(block.getLocalBlock()).iterator();
                        if (!storageInfoIter.hasNext()) {
                            LOG.info((Object)("Expected to find a storage for " + block.getBlockName() + ", but nothing was found.  Continuing to wait."));
                            Boolean bl = false;
                            return bl;
                        }
                        DatanodeStorageInfo info = (DatanodeStorageInfo)storageInfoIter.next();
                        if (!newStorageId.equals(info.getStorageID())) {
                            LOG.info((Object)("Expected " + block.getBlockName() + " to be in storage id " + newStorageId + ", but it was in " + info.getStorageID() + ".  Continuing to wait."));
                            Boolean bl = false;
                            return bl;
                        }
                        LOG.info((Object)("Successfully found " + block.getBlockName() + " in be in storage id " + newStorageId));
                    }
                    finally {
                        cluster.getNamesystem().writeUnlock();
                    }
                    return true;
                }
            }, (long)20L, (long)100000L);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testNameNodePrunesUnreportedStorages() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).storagesPerDatanode(2).build();
        try {
            cluster.waitActive();
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), new Path("file1"), 102400, 102400L, 102400L, (short)1, 29021678L);
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), new Path("file2"), 102400, 102400L, 102400L, (short)1, 464346861L);
            DataNode dn = cluster.getDataNodes().get(0);
            BlockManager bm = cluster.getNameNode().getNamesystem().getBlockManager();
            DatanodeDescriptor dnDescriptor = bm.getDatanodeManager().getDatanode(cluster.getDataNodes().get(0).getDatanodeUuid());
            Object[] dnStoragesInfosBeforeRestart = dnDescriptor.getStorageInfos();
            ArrayList oldDirs = new ArrayList(dn.getConf().getTrimmedStringCollection("dfs.datanode.data.dir"));
            String newDirs = (String)oldDirs.iterator().next();
            conf.set("dfs.datanode.data.dir", newDirs);
            cluster.stopDataNode(0);
            cluster.startDataNodes((Configuration)conf, 1, false, null, null);
            dn = cluster.getDataNodes().get(0);
            cluster.waitActive();
            Assert.assertArrayEquals((Object[])dnStoragesInfosBeforeRestart, (Object[])dnDescriptor.getStorageInfos());
            int numFailedStoragesWithBlocks = 0;
            DatanodeStorageInfo failedStorageInfo = null;
            for (DatanodeStorageInfo dnStorageInfo : dnDescriptor.getStorageInfos()) {
                if (!dnStorageInfo.areBlocksOnFailedStorage()) continue;
                ++numFailedStoragesWithBlocks;
                failedStorageInfo = dnStorageInfo;
            }
            Assert.assertEquals((long)1L, (long)numFailedStoragesWithBlocks);
            bm.getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            Assert.assertTrue((!failedStorageInfo.areBlocksOnFailedStorage() ? 1 : 0) != 0);
            cluster.triggerHeartbeats();
            Assert.assertEquals((long)DataNode.getStorageLocations((Configuration)dn.getConf()).size(), (long)dnDescriptor.getStorageInfos().length);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

