/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Supplier;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.InvalidateBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.slf4j.Logger;

public class TestPendingInvalidateBlock {
    private static final int BLOCKSIZE = 1024;
    private static final short REPLICATION = 2;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;

    public TestPendingInvalidateBlock() {
        GenericTestUtils.setLogLevel((Logger)BlockManager.LOG, (Level)Level.DEBUG);
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.conf.setLong("dfs.namenode.startup.delay.block.deletion.sec", 5L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 2000L);
        this.conf.setLong("dfs.heartbeat.interval", 1L);
        this.conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        this.conf.setLong("ipc.ping.interval", 0L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testPendingDeletion() throws Exception {
        Path foo = new Path("/foo");
        DFSTestUtil.createFile((FileSystem)this.dfs, foo, 1024L, (short)2, 0L);
        DFSTestUtil.waitForReplication(this.dfs, foo, (short)2, 10000);
        this.cluster.restartNameNode(true);
        InvalidateBlocks invalidateBlocks = (InvalidateBlocks)Whitebox.getInternalState((Object)this.cluster.getNamesystem().getBlockManager(), (String)"invalidateBlocks");
        InvalidateBlocks mockIb = (InvalidateBlocks)Mockito.spy((Object)invalidateBlocks);
        ((InvalidateBlocks)Mockito.doReturn((Object)1L).when((Object)mockIb)).getInvalidationDelay();
        Whitebox.setInternalState((Object)this.cluster.getNamesystem().getBlockManager(), (String)"invalidateBlocks", (Object)mockIb);
        this.dfs.delete(foo, true);
        this.waitForNumPendingDeletionBlocks(2);
        Assert.assertEquals((long)0L, (long)this.cluster.getNamesystem().getBlocksTotal());
        Assert.assertEquals((long)2L, (long)this.cluster.getNamesystem().getPendingDeletionBlocks());
        Assert.assertEquals((long)2L, (long)this.dfs.getPendingDeletionBlocksCount());
        ((InvalidateBlocks)Mockito.doReturn((Object)0L).when((Object)mockIb)).getInvalidationDelay();
        this.waitForNumPendingDeletionBlocks(0);
        Assert.assertEquals((long)0L, (long)this.cluster.getNamesystem().getBlocksTotal());
        Assert.assertEquals((long)0L, (long)this.cluster.getNamesystem().getPendingDeletionBlocks());
        Assert.assertEquals((long)0L, (long)this.dfs.getPendingDeletionBlocksCount());
        long nnStarted = this.cluster.getNamesystem().getNNStartedTimeInMillis();
        long blockDeletionStartTime = this.cluster.getNamesystem().getBlockDeletionStartTime();
        Assert.assertTrue((String)String.format("Expect blockDeletionStartTime = %d > nnStarted = %d.", blockDeletionStartTime, nnStarted), (blockDeletionStartTime > nnStarted ? 1 : 0) != 0);
        Method method = DFSClient.class.getDeclaredMethod("getStateByIndex", Integer.TYPE);
        method.setAccessible(true);
        long validState = (Long)method.invoke((Object)this.dfs.getClient(), 8);
        long invalidState = (Long)method.invoke((Object)this.dfs.getClient(), 9);
        Assert.assertEquals((long)0L, (long)validState);
        Assert.assertEquals((long)-1L, (long)invalidState);
    }

    @Test
    public void testPendingDeleteUnknownBlocks() throws Exception {
        int i;
        int i2;
        int fileNum = 5;
        Path[] files = new Path[5];
        MiniDFSCluster.DataNodeProperties[] dnprops = new MiniDFSCluster.DataNodeProperties[2];
        for (i2 = 0; i2 < 5; ++i2) {
            files[i2] = new Path("/file" + i2);
            DFSTestUtil.createFile((FileSystem)this.dfs, files[i2], 1024L, (short)2, i2);
        }
        this.waitForReplication();
        for (i2 = 1; i2 >= 0; --i2) {
            dnprops[i2] = this.cluster.stopDataNode(i2);
        }
        Thread.sleep(2000L);
        for (i2 = 0; i2 < 2; ++i2) {
            this.dfs.delete(files[i2], true);
        }
        this.cluster.restartNameNode(false);
        InvalidateBlocks invalidateBlocks = (InvalidateBlocks)Whitebox.getInternalState((Object)this.cluster.getNamesystem().getBlockManager(), (String)"invalidateBlocks");
        InvalidateBlocks mockIb = (InvalidateBlocks)Mockito.spy((Object)invalidateBlocks);
        ((InvalidateBlocks)Mockito.doReturn((Object)1L).when((Object)mockIb)).getInvalidationDelay();
        Whitebox.setInternalState((Object)this.cluster.getNamesystem().getBlockManager(), (String)"invalidateBlocks", (Object)mockIb);
        Assert.assertEquals((long)0L, (long)this.cluster.getNamesystem().getPendingDeletionBlocks());
        for (i = 0; i < 2; ++i) {
            this.cluster.restartDataNode(dnprops[i]);
        }
        this.cluster.waitActive();
        for (i = 0; i < 2; ++i) {
            DataNodeTestUtils.triggerBlockReport(this.cluster.getDataNodes().get(i));
        }
        Thread.sleep(2000L);
        Assert.assertEquals((long)3L, (long)this.cluster.getNamesystem().getBlocksTotal());
        Assert.assertEquals((long)4L, (long)this.cluster.getNamesystem().getPendingDeletionBlocks());
        this.cluster.restartNameNode(true);
        this.waitForNumPendingDeletionBlocks(0);
        Assert.assertEquals((long)3L, (long)this.cluster.getNamesystem().getBlocksTotal());
        Assert.assertEquals((long)0L, (long)this.cluster.getNamesystem().getPendingDeletionBlocks());
    }

    private long waitForReplication() throws Exception {
        for (int i = 0; i < 10; ++i) {
            long ur = this.cluster.getNamesystem().getUnderReplicatedBlocks();
            if (ur == 0L) {
                return 0L;
            }
            Thread.sleep(1000L);
        }
        return this.cluster.getNamesystem().getUnderReplicatedBlocks();
    }

    private void waitForNumPendingDeletionBlocks(final int numBlocks) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    TestPendingInvalidateBlock.this.cluster.triggerBlockReports();
                    if (TestPendingInvalidateBlock.this.cluster.getNamesystem().getPendingDeletionBlocks() == (long)numBlocks) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }, (long)6000L, (long)60000L);
    }
}

