/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.qjournal.server.JournalTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStandbyInProgressTail {
    private static final Log LOG = LogFactory.getLog(TestStandbyInProgressTail.class);
    private Configuration conf;
    private MiniQJMHACluster qjmhaCluster;
    private MiniDFSCluster cluster;
    private NameNode nn0;
    private NameNode nn1;

    @Before
    public void startUp() throws IOException {
        this.conf = new Configuration();
        this.conf.setInt("dfs.ha.tail-edits.period", 1200);
        this.conf.setBoolean("dfs.ha.tail-edits.in-progress", true);
        this.conf.setInt("dfs.qjournal.select-input-streams.timeout.ms", 500);
        this.conf.setInt("dfs.ha.tail-edits.qjm.rpc.max-txns", 3);
        HAUtil.setAllowStandbyReads((Configuration)this.conf, (boolean)true);
        this.qjmhaCluster = new MiniQJMHACluster.Builder(this.conf).build();
        this.cluster = this.qjmhaCluster.getDfsCluster();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
    }

    @After
    public void tearDown() throws IOException {
        if (this.qjmhaCluster != null) {
            this.qjmhaCluster.shutdown();
        }
    }

    @Test
    public void testDefault() throws Exception {
        if (this.qjmhaCluster != null) {
            this.qjmhaCluster.shutdown();
        }
        this.conf = new Configuration();
        this.conf.setInt("dfs.ha.tail-edits.period", 1200);
        this.conf.setBoolean("dfs.ha.tail-edits.in-progress", false);
        HAUtil.setAllowStandbyReads((Configuration)this.conf, (boolean)true);
        this.qjmhaCluster = new MiniQJMHACluster.Builder(this.conf).build();
        this.cluster = this.qjmhaCluster.getDfsCluster();
        try {
            ArrayList allDirs = Lists.newArrayList();
            allDirs.addAll(this.cluster.getNameDirs(0));
            allDirs.addAll(this.cluster.getNameDirs(1));
            TestStandbyInProgressTail.assertNoEditFiles(allDirs);
            this.cluster.transitionToActive(0);
            TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
            TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
            this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
            this.cluster.getNameNode(1).getNamesystem().getEditLogTailer().doTailEdits();
            Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true, false, false));
            this.cluster.restartNameNode(1);
            TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
            TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
            Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true, false, false));
            this.cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
            this.cluster.restartNameNode(0);
            this.cluster.transitionToActive(1);
            Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true, false, false));
            Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test2", true, false, false));
        }
        finally {
            if (this.qjmhaCluster != null) {
                this.qjmhaCluster.shutdown();
            }
        }
    }

    @Test
    public void testSetup() throws Exception {
        ArrayList allDirs = Lists.newArrayList();
        allDirs.addAll(this.cluster.getNameDirs(0));
        allDirs.addAll(this.cluster.getNameDirs(1));
        TestStandbyInProgressTail.assertNoEditFiles(allDirs);
        this.cluster.transitionToActive(0);
        TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
        TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test");
        this.cluster.restartNameNode(1);
        TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
        TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true, false, false));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
        this.cluster.restartNameNode(0);
        this.cluster.transitionToActive(1);
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test", true, false, false));
        Assert.assertNotNull((Object)NameNodeAdapter.getFileInfo(this.cluster.getNameNode(1), "/test2", true, false, false));
    }

    @Test
    public void testHalfStartInProgressTail() throws Exception {
        this.cluster.transitionToActive(0);
        TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
        TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test");
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
        this.nn0.getRpcServer().rollEditLog();
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test2");
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test3", FsPermission.createImmutable((short)493), true);
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test", "/test2", "/test3");
    }

    @Test
    public void testInitStartInProgressTail() throws Exception {
        this.cluster.transitionToActive(0);
        TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
        TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
        this.nn0.getRpcServer().rollEditLog();
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test3", FsPermission.createImmutable((short)493), true);
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test", true, false, false));
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test2", true, false, false));
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/test3", true, false, false));
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test", "/test2", "/test3");
    }

    @Test
    public void testNewStartInProgressTail() throws Exception {
        this.cluster.transitionToActive(0);
        TestStandbyInProgressTail.assertEditFiles(this.cluster.getNameDirs(0), NNStorage.getInProgressEditsFileName((long)1L));
        TestStandbyInProgressTail.assertNoEditFiles(this.cluster.getNameDirs(1));
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test2", FsPermission.createImmutable((short)493), true);
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test", "/test2");
        this.nn0.getRpcServer().rollEditLog();
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test3", FsPermission.createImmutable((short)493), true);
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test", "/test2", "/test3");
    }

    @Test
    public void testUndertailingWhileFailover() throws Exception {
        this.cluster.transitionToActive(0);
        this.cluster.waitActive(0);
        String p = "/testFailoverWhileTailingWithoutCache/";
        TestStandbyInProgressTail.mkdirs(this.nn0, p + 0, p + 1, p + 2, p + 3, p + 4);
        this.nn0.getRpcServer().rollEditLog();
        TestStandbyInProgressTail.mkdirs(this.nn0, p + 5, p + 6, p + 7, p + 8, p + 9);
        this.nn0.getRpcServer().rollEditLog();
        TestStandbyInProgressTail.mkdirs(this.nn0, p + 10, p + 11, p + 12, p + 13, p + 14);
        this.nn0.getRpcServer().rollEditLog();
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        this.cluster.waitActive(1);
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, p + 0, p + 1, p + 14);
    }

    @Test
    public void testNonUniformConfig() throws Exception {
        Configuration newConf = this.cluster.getNameNode(0).getConf();
        newConf.setBoolean("dfs.ha.tail-edits.in-progress", false);
        this.cluster.restartNameNode(0);
        this.cluster.transitionToActive(0);
        this.cluster.getNameNode(0).getRpcServer().mkdirs("/test", FsPermission.createImmutable((short)493), true);
        this.cluster.getNameNode(0).getRpcServer().rollEdits();
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test");
    }

    @Test
    public void testEditsServedViaCache() throws Exception {
        this.cluster.transitionToActive(0);
        this.cluster.waitActive(0);
        TestStandbyInProgressTail.mkdirs(this.nn0, "/test", "/test2");
        this.nn0.getRpcServer().rollEditLog();
        for (int idx = 0; idx < this.qjmhaCluster.getJournalCluster().getNumNodes(); ++idx) {
            File[] startingEditFile = this.qjmhaCluster.getJournalCluster().getCurrentDir(idx, DFSUtil.getNamenodeNameServiceId((Configuration)this.conf)).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("edits_0+1-[0-9]+");
                }
            });
            Assert.assertNotNull((Object)startingEditFile);
            Assert.assertEquals((long)1L, (long)startingEditFile.length);
            startingEditFile[0].delete();
        }
        Assert.assertNull((Object)NameNodeAdapter.getFileInfo(this.nn1, "/tmp0", false, false, false));
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test", "/test2");
    }

    @Test
    public void testCorruptJournalCache() throws Exception {
        this.cluster.transitionToActive(0);
        this.cluster.waitActive(0);
        this.qjmhaCluster.getJournalCluster().getJournalNode(0).stopAndJoin(0);
        TestStandbyInProgressTail.mkdirs(this.nn0, "/test", "/test2");
        JournalTestUtil.corruptJournaledEditsCache(1L, this.qjmhaCluster.getJournalCluster().getJournalNode(1).getJournal(DFSUtil.getNamenodeNameServiceId((Configuration)this.conf)));
        this.nn0.getRpcServer().rollEditLog();
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test", "/test2");
        TestStandbyInProgressTail.mkdirs(this.nn0, "/test3", "/test4");
        JournalTestUtil.corruptJournaledEditsCache(3L, this.qjmhaCluster.getJournalCluster().getJournalNode(2).getJournal(DFSUtil.getNamenodeNameServiceId((Configuration)this.conf)));
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test3", "/test4");
    }

    @Test
    public void testTailWithoutCache() throws Exception {
        this.qjmhaCluster.shutdown();
        this.conf.setInt("dfs.journalnode.edit-cache-size.bytes", 1);
        this.qjmhaCluster = new MiniQJMHACluster.Builder(this.conf).build();
        this.cluster = this.qjmhaCluster.getDfsCluster();
        this.cluster.transitionToActive(0);
        this.cluster.waitActive(0);
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
        TestStandbyInProgressTail.mkdirs(this.nn0, "/test", "/test2");
        this.nn0.getRpcServer().rollEditLog();
        TestStandbyInProgressTail.mkdirs(this.nn0, "/test3", "/test4");
        TestStandbyInProgressTail.waitForFileInfo(this.nn1, "/test", "/test2", "/test3");
    }

    private static void assertNoEditFiles(Iterable<URI> dirs) throws IOException {
        TestStandbyInProgressTail.assertEditFiles(dirs, new String[0]);
    }

    private static void assertEditFiles(Iterable<URI> dirs, String ... files) throws IOException {
        for (URI u : dirs) {
            File editDirRoot = new File(u.getPath());
            File editDir = new File(editDirRoot, "current");
            GenericTestUtils.assertExists((File)editDir);
            if (files.length == 0) {
                LOG.info((Object)("Checking no edit files exist in " + editDir));
            } else {
                LOG.info((Object)("Checking for following edit files in " + editDir + ": " + Joiner.on((String)",").join((Object[])files)));
            }
            GenericTestUtils.assertGlobEquals((File)editDir, (String)"edits_.*", (String[])files);
        }
    }

    private static void mkdirs(NameNode nameNode, String ... dirNames) throws Exception {
        for (String dirName : dirNames) {
            nameNode.getRpcServer().mkdirs(dirName, FsPermission.createImmutable((short)493), true);
        }
    }

    private static void waitForFileInfo(final NameNode standbyNN, String ... fileNames) throws Exception {
        final ArrayList remainingFiles = Lists.newArrayList((Object[])fileNames);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    standbyNN.getNamesystem().getEditLogTailer().doTailEdits();
                    Iterator it = remainingFiles.iterator();
                    while (it.hasNext()) {
                        if (NameNodeAdapter.getFileInfo(standbyNN, (String)it.next(), true, false, false) == null) {
                            return false;
                        }
                        it.remove();
                    }
                    return true;
                }
                catch (IOException | InterruptedException e) {
                    throw new AssertionError((Object)("Exception while waiting: " + e));
                }
            }
        }, (long)10L, (long)1000L);
    }
}

