/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import io.netty.bootstrap.ChannelFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.nio.channels.ServerSocketChannel;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.web.RestCsrfPreventionFilterHandler;
import org.apache.hadoop.hdfs.server.datanode.web.URLDispatcher;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.DataNodeUGIProvider;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;
import org.apache.hadoop.security.ssl.SSLFactory;

public class DatanodeHttpServer
implements Closeable {
    private final HttpServer2 infoServer;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ServerSocketChannel externalHttpChannel;
    private final ServerBootstrap httpServer;
    private final SSLFactory sslFactory;
    private final ServerBootstrap httpsServer;
    private final Configuration conf;
    private final Configuration confForCreate;
    private final RestCsrfPreventionFilter restCsrfPreventionFilter;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;
    static final Log LOG = LogFactory.getLog(DatanodeHttpServer.class);
    private static final int HTTP_SELECTOR_THREADS = 1;
    private static final int HTTP_ACCEPTOR_THREADS = 1;
    private static final int HTTP_MAX_THREADS = 4;

    public DatanodeHttpServer(final Configuration conf, DataNode datanode, final ServerSocketChannel externalHttpChannel) throws IOException {
        this.restCsrfPreventionFilter = DatanodeHttpServer.createRestCsrfPreventionFilter(conf);
        this.conf = conf;
        Configuration confForInfoServer = new Configuration(conf);
        confForInfoServer.setInt("hadoop.http.max.threads", 4);
        confForInfoServer.setInt("hadoop.http.selector.count", 1);
        confForInfoServer.setInt("hadoop.http.acceptor.count", 1);
        int proxyPort = confForInfoServer.getInt("dfs.datanode.http.internal-proxy.port", 0);
        HttpServer2.Builder builder = new HttpServer2.Builder().setName("datanode").setConf(confForInfoServer).setACL(new AccessControlList(conf.get("dfs.cluster.administrators", " "))).hostName(DatanodeHttpServer.getHostnameForSpnegoPrincipal(confForInfoServer)).addEndpoint(URI.create("http://localhost:" + proxyPort)).setFindPort(true);
        boolean xFrameEnabled = conf.getBoolean("dfs.xframe.enabled", true);
        String xFrameOptionValue = conf.getTrimmed("dfs.xframe.value", "SAMEORIGIN");
        builder.configureXFrame(xFrameEnabled).setXFrameOption(xFrameOptionValue);
        this.infoServer = builder.build();
        this.infoServer.setAttribute("hadoop.conf", (Object)conf);
        this.infoServer.setAttribute("datanode", (Object)datanode);
        this.infoServer.setAttribute("current.conf", (Object)conf);
        this.infoServer.addServlet(null, "/blockScannerReport", BlockScanner.Servlet.class);
        DataNodeUGIProvider.init(conf);
        this.infoServer.start();
        final InetSocketAddress jettyAddr = this.infoServer.getConnectorAddress(0);
        this.confForCreate = new Configuration(conf);
        this.confForCreate.set("fs.permissions.umask-mode", "000");
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.externalHttpChannel = externalHttpChannel;
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        if (policy.isHttpEnabled()) {
            this.httpServer = new ServerBootstrap().group(this.bossGroup, this.workerGroup).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new HttpRequestDecoder(), new HttpResponseEncoder()});
                    if (DatanodeHttpServer.this.restCsrfPreventionFilter != null) {
                        p.addLast(new ChannelHandler[]{new RestCsrfPreventionFilterHandler(DatanodeHttpServer.this.restCsrfPreventionFilter)});
                    }
                    p.addLast(new ChannelHandler[]{new ChunkedWriteHandler(), new URLDispatcher(jettyAddr, conf, DatanodeHttpServer.this.confForCreate)});
                }
            });
            this.httpServer.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)conf.getInt("dfs.webhdfs.netty.high.watermark", 65535));
            this.httpServer.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)conf.getInt("dfs.webhdfs.netty.low.watermark", 32768));
            if (externalHttpChannel == null) {
                this.httpServer.channel(NioServerSocketChannel.class);
            } else {
                this.httpServer.channelFactory((ChannelFactory)new ChannelFactory<NioServerSocketChannel>(){

                    public NioServerSocketChannel newChannel() {
                        return new NioServerSocketChannel(externalHttpChannel){

                            protected void doBind(SocketAddress localAddress) throws Exception {
                            }
                        };
                    }
                });
            }
        } else {
            this.httpServer = null;
        }
        if (policy.isHttpsEnabled()) {
            this.sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
            try {
                this.sslFactory.init();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.httpsServer = ((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new SslHandler(DatanodeHttpServer.this.sslFactory.createSSLEngine()), new HttpRequestDecoder(), new HttpResponseEncoder()});
                    if (DatanodeHttpServer.this.restCsrfPreventionFilter != null) {
                        p.addLast(new ChannelHandler[]{new RestCsrfPreventionFilterHandler(DatanodeHttpServer.this.restCsrfPreventionFilter)});
                    }
                    p.addLast(new ChannelHandler[]{new ChunkedWriteHandler(), new URLDispatcher(jettyAddr, conf, DatanodeHttpServer.this.confForCreate)});
                }
            });
        } else {
            this.httpsServer = null;
            this.sslFactory = null;
        }
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }

    public void start() throws IOException {
        ChannelFuture f;
        if (this.httpServer != null) {
            InetSocketAddress infoAddr = DataNode.getInfoAddr(this.conf);
            f = this.httpServer.bind((SocketAddress)infoAddr);
            try {
                f.syncUninterruptibly();
            }
            catch (Throwable e) {
                if (e instanceof BindException) {
                    throw NetUtils.wrapException(null, (int)0, (String)infoAddr.getHostName(), (int)infoAddr.getPort(), (IOException)((SocketException)e));
                }
                throw e;
            }
            this.httpAddress = (InetSocketAddress)f.channel().localAddress();
            LOG.info((Object)("Listening HTTP traffic on " + this.httpAddress));
        }
        if (this.httpsServer != null) {
            InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr((String)this.conf.getTrimmed("dfs.datanode.https.address", "0.0.0.0:9865"));
            f = this.httpsServer.bind((SocketAddress)secInfoSocAddr);
            try {
                f.syncUninterruptibly();
            }
            catch (Throwable e) {
                if (e instanceof BindException) {
                    throw NetUtils.wrapException(null, (int)0, (String)secInfoSocAddr.getHostName(), (int)secInfoSocAddr.getPort(), (IOException)((SocketException)e));
                }
                throw e;
            }
            this.httpsAddress = (InetSocketAddress)f.channel().localAddress();
            LOG.info((Object)("Listening HTTPS traffic on " + this.httpsAddress));
        }
    }

    @Override
    public void close() throws IOException {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        if (this.sslFactory != null) {
            this.sslFactory.destroy();
        }
        if (this.externalHttpChannel != null) {
            this.externalHttpChannel.close();
        }
        try {
            this.infoServer.stop();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static String getHostnameForSpnegoPrincipal(Configuration conf) {
        String addr = conf.getTrimmed("dfs.datanode.http.address", null);
        if (addr == null) {
            addr = conf.getTrimmed("dfs.datanode.https.address", "0.0.0.0:9865");
        }
        InetSocketAddress inetSocker = NetUtils.createSocketAddr((String)addr);
        return inetSocker.getHostString();
    }

    private static RestCsrfPreventionFilter createRestCsrfPreventionFilter(Configuration conf) {
        if (!conf.getBoolean("dfs.webhdfs.rest-csrf.enabled", false)) {
            return null;
        }
        String restCsrfClassName = RestCsrfPreventionFilter.class.getName();
        Map restCsrfParams = RestCsrfPreventionFilter.getFilterParams((Configuration)conf, (String)"dfs.webhdfs.rest-csrf.");
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        try {
            filter.init((FilterConfig)new MapBasedFilterConfig(restCsrfClassName, restCsrfParams));
        }
        catch (ServletException e) {
            throw new IllegalStateException("Failed to initialize RestCsrfPreventionFilter.", e);
        }
        return filter;
    }

    private static final class MapBasedFilterConfig
    implements FilterConfig {
        private final String filterName;
        private final Map<String, String> parameters;

        public MapBasedFilterConfig(String filterName, Map<String, String> parameters) {
            this.filterName = filterName;
            this.parameters = parameters;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String getInitParameter(String name) {
            return this.parameters.get(name);
        }

        public Enumeration<String> getInitParameterNames() {
            throw this.notImplemented();
        }

        public ServletContext getServletContext() {
            throw this.notImplemented();
        }

        private UnsupportedOperationException notImplemented() {
            return new UnsupportedOperationException(this.getClass().getSimpleName() + " does not implement this method.");
        }
    }
}

