/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.InvalidateBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.TestProvidedImpl;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.TestINodeFile;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.HAState;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.LightWeightGSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestBlockManager {
    private DatanodeStorageInfo[] storages;
    private List<DatanodeDescriptor> nodes;
    private List<DatanodeDescriptor> rackA;
    private List<DatanodeDescriptor> rackB;
    private static final int NUM_TEST_ITERS = 30;
    private static final int BLOCK_SIZE = 65536;
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockManager.class);
    private FSNamesystem fsn;
    private BlockManager bm;
    private long mockINodeId;

    @Before
    public void setupMockCluster() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("net.topology.script.file.name", "need to set a dummy value here so it assumes a multi-rack cluster");
        this.fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).hasWriteLock();
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).hasReadLock();
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isRunning();
        HAContext haContext = (HAContext)Mockito.mock(HAContext.class);
        HAState haState = (HAState)Mockito.mock(HAState.class);
        Mockito.when((Object)haContext.getState()).thenReturn((Object)haState);
        Mockito.when((Object)haState.shouldPopulateReplQueues()).thenReturn((Object)true);
        Mockito.when((Object)this.fsn.getHAContext()).thenReturn((Object)haContext);
        this.bm = new BlockManager((Namesystem)this.fsn, false, (Configuration)conf);
        CacheManager cm = (CacheManager)Mockito.mock(CacheManager.class);
        ((FSNamesystem)Mockito.doReturn((Object)cm).when((Object)this.fsn)).getCacheManager();
        LightWeightGSet cb = new LightWeightGSet(1);
        Mockito.when((Object)cm.getCachedBlocks()).thenReturn((Object)cb);
        String[] racks = new String[]{"/rackA", "/rackA", "/rackA", "/rackB", "/rackB", "/rackB"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        this.nodes = Arrays.asList(DFSTestUtil.toDatanodeDescriptor(this.storages));
        this.rackA = this.nodes.subList(0, 3);
        this.rackB = this.nodes.subList(3, 6);
        this.mockINodeId = 16386L;
    }

    private void addNodes(Iterable<DatanodeDescriptor> nodesToAdd) {
        NetworkTopology cluster = this.bm.getDatanodeManager().getNetworkTopology();
        for (DatanodeDescriptor dn : nodesToAdd) {
            cluster.add((Node)dn);
            dn.getStorageInfos()[0].setUtilizationForTesting(131072L, 0L, 131072L, 0L);
            dn.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dn), 0L, 0L, 0, 0, null);
            this.bm.getDatanodeManager().checkIfClusterIsNowMultiRack(dn);
        }
    }

    private void removeNode(DatanodeDescriptor deadNode) {
        NetworkTopology cluster = this.bm.getDatanodeManager().getNetworkTopology();
        cluster.remove((Node)deadNode);
        this.bm.removeBlocksAssociatedTo(deadNode);
    }

    @Test
    public void testBasicReplication() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doBasicTest(i);
        }
    }

    private void doBasicTest(int testIndex) {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        DatanodeStorageInfo[] pipeline = this.scheduleSingleReplication(blockInfo);
        Assert.assertEquals((long)2L, (long)pipeline.length);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertTrue((String)("Destination of replication should be on the other rack. Was: " + pipeline[1]), (boolean)this.rackB.contains(pipeline[1].getDatanodeDescriptor()));
    }

    @Test
    public void testTwoOfThreeNodesDecommissioned() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestTwoOfThreeNodesDecommissioned(i);
        }
    }

    private void doTestTwoOfThreeNodesDecommissioned(int testIndex) throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1, 3);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        List<DatanodeDescriptor> decomNodes = this.startDecommission(0, 1);
        Object[] pipeline = this.scheduleSingleReplication(blockInfo);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertEquals((String)"Should have three targets", (long)3L, (long)pipeline.length);
        boolean foundOneOnRackA = false;
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeDescriptor target = pipeline[i].getDatanodeDescriptor();
            if (this.rackA.contains(target)) {
                foundOneOnRackA = true;
            }
            Assert.assertFalse((boolean)decomNodes.contains(target));
            Assert.assertFalse((boolean)origNodes.contains(target));
        }
        Assert.assertTrue((String)("Should have at least one target on rack A. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackA);
    }

    @Test
    public void testAllNodesHoldingReplicasDecommissioned() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestAllNodesHoldingReplicasDecommissioned(i);
        }
    }

    private void doTestAllNodesHoldingReplicasDecommissioned(int testIndex) throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1, 3);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        List<DatanodeDescriptor> decomNodes = this.startDecommission(0, 1, 3);
        Object[] pipeline = this.scheduleSingleReplication(blockInfo);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertEquals((String)"Should have three targets", (long)4L, (long)pipeline.length);
        boolean foundOneOnRackA = false;
        boolean foundOneOnRackB = false;
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeDescriptor target = pipeline[i].getDatanodeDescriptor();
            if (this.rackA.contains(target)) {
                foundOneOnRackA = true;
            } else if (this.rackB.contains(target)) {
                foundOneOnRackB = true;
            }
            Assert.assertFalse((boolean)decomNodes.contains(target));
            Assert.assertFalse((boolean)origNodes.contains(target));
        }
        Assert.assertTrue((String)("Should have at least one target on rack A. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackA);
        Assert.assertTrue((String)("Should have at least one target on rack B. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackB);
    }

    @Test
    public void testOneOfTwoRacksDecommissioned() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestOneOfTwoRacksDecommissioned(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestOneOfTwoRacksDecommissioned(int testIndex) throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1, 3);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        List<DatanodeDescriptor> decomNodes = this.startDecommission(0, 1, 2);
        Object[] pipeline = this.scheduleSingleReplication(blockInfo);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origStorages.contains(pipeline[0]));
        Assert.assertEquals((String)"Should have two targets", (long)2L, (long)pipeline.length);
        boolean foundOneOnRackB = false;
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeDescriptor target = pipeline[i].getDatanodeDescriptor();
            if (this.rackB.contains(target)) {
                foundOneOnRackB = true;
            }
            Assert.assertFalse((boolean)decomNodes.contains(target));
            Assert.assertFalse((boolean)origNodes.contains(target));
        }
        Assert.assertTrue((String)("Should have at least one target on rack B. Pipeline: " + Joiner.on((String)",").join(pipeline)), (boolean)foundOneOnRackB);
        this.fulfillPipeline(blockInfo, (DatanodeStorageInfo[])pipeline);
        DatanodeDescriptor rackCNode = DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/rackC");
        rackCNode.updateStorage(new DatanodeStorage(DatanodeStorage.generateUuid()));
        this.addNodes((Iterable<DatanodeDescriptor>)ImmutableList.of((Object)rackCNode));
        try {
            DatanodeStorageInfo[] pipeline2 = this.scheduleSingleReplication(blockInfo);
            Assert.assertEquals((long)2L, (long)pipeline2.length);
            Assert.assertEquals((Object)rackCNode, (Object)pipeline2[1].getDatanodeDescriptor());
        }
        finally {
            this.removeNode(rackCNode);
        }
    }

    @Test
    public void testSufficientlyReplBlocksUsesNewRack() throws Exception {
        this.addNodes(this.nodes);
        for (int i = 0; i < 30; ++i) {
            this.doTestSufficientlyReplBlocksUsesNewRack(i);
        }
    }

    private void doTestSufficientlyReplBlocksUsesNewRack(int testIndex) {
        List<DatanodeDescriptor> origNodes = this.rackA;
        BlockInfo blockInfo = this.addBlockOnNodes(testIndex, origNodes);
        DatanodeStorageInfo[] pipeline = this.scheduleSingleReplication(blockInfo);
        Assert.assertEquals((long)2L, (long)pipeline.length);
        Assert.assertTrue((String)("Source of replication should be one of the nodes the block was on. Was: " + pipeline[0]), (boolean)origNodes.contains(pipeline[0].getDatanodeDescriptor()));
        Assert.assertTrue((String)("Destination of replication should be on the other rack. Was: " + pipeline[1]), (boolean)this.rackB.contains(pipeline[1].getDatanodeDescriptor()));
    }

    @Test
    public void testBlocksAreNotUnderreplicatedInSingleRack() throws Exception {
        ImmutableList nodes = ImmutableList.of((Object)BlockManagerTestUtil.getDatanodeDescriptor("1.1.1.1", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("2.2.2.2", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("3.3.3.3", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("4.4.4.4", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("5.5.5.5", "/rackA", true), (Object)BlockManagerTestUtil.getDatanodeDescriptor("6.6.6.6", "/rackA", true));
        this.addNodes((Iterable<DatanodeDescriptor>)nodes);
        List<DatanodeDescriptor> origNodes = nodes.subList(0, 3);
        for (int i = 0; i < 30; ++i) {
            this.doTestSingleRackClusterHasSufficientRedundancy(i, origNodes);
        }
    }

    private void doTestSingleRackClusterHasSufficientRedundancy(int testIndex, List<DatanodeDescriptor> origNodes) throws Exception {
        Assert.assertEquals((long)0L, (long)this.bm.numOfUnderReplicatedBlocks());
        BlockInfo block = this.addBlockOnNodes(testIndex, origNodes);
        Assert.assertFalse((boolean)this.bm.isNeededReconstruction(block, this.bm.countNodes(block, this.fsn.isInStartupSafeMode())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNeededReconstructionWhileAppending() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String src = "/test-file";
        Path file = new Path(src);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            BlockManager bm = cluster.getNamesystem().getBlockManager();
            DistributedFileSystem fs = cluster.getFileSystem();
            NamenodeProtocols namenode = cluster.getNameNodeRpc();
            DFSOutputStream out = null;
            try {
                out = (DFSOutputStream)fs.create(file).getWrappedStream();
                out.write(1);
                out.hflush();
                out.close();
                FSDataInputStream in = null;
                ExtendedBlock oldBlock = null;
                try {
                    in = fs.open(file);
                    oldBlock = DFSTestUtil.getAllBlocks(in).get(0).getBlock();
                }
                finally {
                    IOUtils.closeStream((Closeable)in);
                }
                String clientName = fs.getClient().getClientName();
                namenode.append(src, clientName, new EnumSetWritable(EnumSet.of(CreateFlag.APPEND)));
                LocatedBlock newLocatedBlock = namenode.updateBlockForPipeline(oldBlock, clientName);
                ExtendedBlock newBlock = new ExtendedBlock(oldBlock.getBlockPoolId(), oldBlock.getBlockId(), oldBlock.getNumBytes(), newLocatedBlock.getBlock().getGenerationStamp());
                namenode.updatePipeline(clientName, oldBlock, newBlock, (DatanodeID[])newLocatedBlock.getLocations(), newLocatedBlock.getStorageIDs());
                BlockInfo bi = bm.getStoredBlock(newBlock.getLocalBlock());
                Assert.assertFalse((boolean)bm.isNeededReconstruction(bi, bm.countNodes(bi, cluster.getNamesystem().isInStartupSafeMode())));
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)out);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void fulfillPipeline(BlockInfo blockInfo, DatanodeStorageInfo[] pipeline) throws IOException {
        for (int i = 1; i < pipeline.length; ++i) {
            DatanodeStorageInfo storage = pipeline[i];
            this.bm.addBlock(storage, (Block)blockInfo, null);
            blockInfo.addStorage(storage, (Block)blockInfo);
        }
    }

    private BlockInfo blockOnNodes(long blkId, List<DatanodeDescriptor> nodes) {
        Block block = new Block(blkId);
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(block, 3);
        for (DatanodeDescriptor dn : nodes) {
            for (DatanodeStorageInfo storage : dn.getStorageInfos()) {
                blockInfo.addStorage(storage, (Block)blockInfo);
            }
        }
        return blockInfo;
    }

    private List<DatanodeDescriptor> getNodes(int ... indexes) {
        ArrayList ret = Lists.newArrayList();
        for (int idx : indexes) {
            ret.add(this.nodes.get(idx));
        }
        return ret;
    }

    private List<DatanodeDescriptor> getNodes(List<DatanodeStorageInfo> storages) {
        ArrayList ret = Lists.newArrayList();
        for (DatanodeStorageInfo s : storages) {
            ret.add(s.getDatanodeDescriptor());
        }
        return ret;
    }

    private List<DatanodeStorageInfo> getStorages(int ... indexes) {
        ArrayList ret = Lists.newArrayList();
        for (int idx : indexes) {
            ret.add(this.storages[idx]);
        }
        return ret;
    }

    private List<DatanodeDescriptor> startDecommission(int ... indexes) {
        List<DatanodeDescriptor> nodes = this.getNodes(indexes);
        for (DatanodeDescriptor node : nodes) {
            node.startDecommission();
        }
        return nodes;
    }

    private BlockInfo addBlockOnNodes(long blockId, List<DatanodeDescriptor> nodes) {
        long inodeId = ++this.mockINodeId;
        INodeFile bc = TestINodeFile.createINodeFile(inodeId);
        BlockInfo blockInfo = this.blockOnNodes(blockId, nodes);
        blockInfo.setReplication((short)3);
        blockInfo.setBlockCollectionId(inodeId);
        ((FSNamesystem)Mockito.doReturn((Object)bc).when((Object)this.fsn)).getBlockCollection(inodeId);
        this.bm.blocksMap.addBlockCollection(blockInfo, (BlockCollection)bc);
        return blockInfo;
    }

    private BlockInfo addCorruptBlockOnNodes(long blockId, List<DatanodeDescriptor> nodes) throws IOException {
        long inodeId = ++this.mockINodeId;
        INodeFile bc = TestINodeFile.createINodeFile(inodeId);
        BlockInfo blockInfo = this.blockOnNodes(blockId, nodes);
        blockInfo.setReplication((short)3);
        blockInfo.setBlockCollectionId(inodeId);
        ((FSNamesystem)Mockito.doReturn((Object)bc).when((Object)this.fsn)).getBlockCollection(inodeId);
        this.bm.blocksMap.addBlockCollection(blockInfo, (BlockCollection)bc);
        this.bm.markBlockReplicasAsCorrupt((Block)blockInfo, blockInfo, blockInfo.getGenerationStamp() + 1L, blockInfo.getNumBytes(), new DatanodeStorageInfo[]{nodes.get(0).getStorageInfos()[0]});
        return blockInfo;
    }

    private DatanodeStorageInfo[] scheduleSingleReplication(BlockInfo block) {
        ArrayList<BlockInfo> list_p1 = new ArrayList<BlockInfo>();
        list_p1.add(block);
        ArrayList list_all = new ArrayList();
        list_all.add(new ArrayList());
        list_all.add(list_p1);
        Assert.assertEquals((String)"Block not initially pending reconstruction", (long)0L, (long)this.bm.pendingReconstruction.getNumReplicas(block));
        Assert.assertEquals((String)"computeBlockReconstructionWork should indicate reconstruction is needed", (long)1L, (long)this.bm.computeReconstructionWorkForBlocks(list_all));
        Assert.assertTrue((String)"reconstruction is pending after work is computed", (this.bm.pendingReconstruction.getNumReplicas(block) > 0 ? 1 : 0) != 0);
        LinkedListMultimap<DatanodeStorageInfo, DatanodeDescriptor.BlockTargetPair> repls = this.getAllPendingReconstruction();
        Assert.assertEquals((long)1L, (long)repls.size());
        Map.Entry repl = (Map.Entry)repls.entries().iterator().next();
        DatanodeStorageInfo[] targets = ((DatanodeDescriptor.BlockTargetPair)repl.getValue()).targets;
        DatanodeStorageInfo[] pipeline = new DatanodeStorageInfo[1 + targets.length];
        pipeline[0] = (DatanodeStorageInfo)repl.getKey();
        System.arraycopy(targets, 0, pipeline, 1, targets.length);
        return pipeline;
    }

    private LinkedListMultimap<DatanodeStorageInfo, DatanodeDescriptor.BlockTargetPair> getAllPendingReconstruction() {
        LinkedListMultimap repls = LinkedListMultimap.create();
        for (DatanodeDescriptor dn : this.nodes) {
            List thisRepls = dn.getReplicationCommand(10);
            if (thisRepls == null) continue;
            for (DatanodeStorageInfo storage : dn.getStorageInfos()) {
                repls.putAll((Object)storage, (Iterable)thisRepls);
            }
        }
        return repls;
    }

    @Test
    public void testHighestPriReplSrcChosenDespiteMaxReplLimit() throws Exception {
        this.bm.maxReplicationStreams = 0;
        this.bm.replicationStreamsHardLimit = 1;
        long blockId = 42L;
        Block aBlock = new Block(blockId, 0L, 0L);
        List<DatanodeDescriptor> origNodes = this.getNodes(0, 1);
        this.addBlockOnNodes(blockId, origNodes.subList(0, 1));
        LinkedList cntNodes = new LinkedList();
        LinkedList liveNodes = new LinkedList();
        Assert.assertNotNull((String)"Chooses source node for a highest-priority replication even if all available source nodes have reached their replication limits below the hard limit.", (Object)this.bm.chooseSourceDatanodes(this.bm.getStoredBlock(aBlock), cntNodes, liveNodes, new NumberReplicas(), new ArrayList(), 0)[0]);
        Assert.assertEquals((String)"Does not choose a source node for a less-than-highest-priority replication since all available source nodes have reached their replication limits.", (long)0L, (long)this.bm.chooseSourceDatanodes(this.bm.getStoredBlock(aBlock), cntNodes, liveNodes, new NumberReplicas(), new ArrayList(), 1).length);
        DatanodeStorageInfo[] targets = new DatanodeStorageInfo[]{origNodes.get(1).getStorageInfos()[0]};
        origNodes.get(0).addBlockToBeReplicated(aBlock, targets);
        Assert.assertEquals((String)"Does not choose a source node for a highest-priority replication when all available nodes exceed the hard limit.", (long)0L, (long)this.bm.chooseSourceDatanodes(this.bm.getStoredBlock(aBlock), cntNodes, liveNodes, new NumberReplicas(), new ArrayList(), 0).length);
    }

    @Test
    public void testChooseSrcDatanodesWithDupEC() throws Exception {
        this.bm.maxReplicationStreams = 4;
        long blockId = -9223372036854775776L;
        Block aBlock = new Block(blockId, 0L, 0L);
        ECSchema rsSchema = new ECSchema("rs", 3, 2);
        String policyName = "RS-3-2-128k";
        int cellSize = 131072;
        ErasureCodingPolicy ecPolicy = new ErasureCodingPolicy(policyName, rsSchema, cellSize, -1);
        BlockInfoStriped aBlockInfoStriped = new BlockInfoStriped(aBlock, ecPolicy);
        DatanodeStorageInfo ds1 = DFSTestUtil.createDatanodeStorageInfo("storage1", "1.1.1.1", "rack1", "host1");
        DatanodeStorageInfo ds2 = DFSTestUtil.createDatanodeStorageInfo("storage2", "2.2.2.2", "rack2", "host2");
        DatanodeStorageInfo ds3 = DFSTestUtil.createDatanodeStorageInfo("storage3", "3.3.3.3", "rack3", "host3");
        DatanodeStorageInfo ds4 = DFSTestUtil.createDatanodeStorageInfo("storage4", "4.4.4.4", "rack4", "host4");
        DatanodeStorageInfo ds5 = DFSTestUtil.createDatanodeStorageInfo("storage5", "5.5.5.5", "rack5", "host5");
        aBlockInfoStriped.addStorage(ds1, aBlock);
        aBlockInfoStriped.addStorage(ds2, new Block(blockId + 1L, 0L, 0L));
        aBlockInfoStriped.addStorage(ds3, new Block(blockId + 2L, 0L, 0L));
        aBlockInfoStriped.addStorage(ds4, new Block(blockId + 3L, 0L, 0L));
        aBlockInfoStriped.addStorage(ds5, new Block(blockId + 3L, 0L, 0L));
        for (int i = 0; i < 4; ++i) {
            ds4.getDatanodeDescriptor().incrementPendingReplicationWithoutTargets();
        }
        this.addEcBlockToBM(blockId, ecPolicy);
        LinkedList cntNodes = new LinkedList();
        LinkedList liveNodes = new LinkedList();
        NumberReplicas numReplicas = new NumberReplicas();
        ArrayList liveBlockIndices = new ArrayList();
        this.bm.chooseSourceDatanodes((BlockInfo)aBlockInfoStriped, cntNodes, liveNodes, numReplicas, liveBlockIndices, 0);
        Assert.assertEquals((String)"Choose the source node for reconstruction with one node reach the MAX maxReplicationStreams, the numReplicas still return the correct live replicas.", (long)4L, (long)numReplicas.liveReplicas());
        Assert.assertEquals((String)"Choose the source node for reconstruction with one node reach the MAX maxReplicationStreams, the numReplicas should return the correct redundant Internal Blocks.", (long)1L, (long)numReplicas.redundantInternalBlocks());
    }

    @Test
    public void testChooseSrcDNWithDupECInDecommissioningNode() throws Exception {
        long blockId = -9223372036854775776L;
        Block aBlock = new Block(blockId, 0L, 0L);
        ErasureCodingPolicy ecPolicy = (ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(1);
        BlockInfoStriped aBlockInfoStriped = new BlockInfoStriped(aBlock, ecPolicy);
        DatanodeStorageInfo ds1 = DFSTestUtil.createDatanodeStorageInfo("storage1", "1.1.1.1", "rack1", "host1");
        DatanodeStorageInfo ds2 = DFSTestUtil.createDatanodeStorageInfo("storage2", "2.2.2.2", "rack2", "host2");
        DatanodeStorageInfo ds3 = DFSTestUtil.createDatanodeStorageInfo("storage3", "3.3.3.3", "rack3", "host3");
        DatanodeStorageInfo ds4 = DFSTestUtil.createDatanodeStorageInfo("storage4", "4.4.4.4", "rack4", "host4");
        DatanodeStorageInfo ds5 = DFSTestUtil.createDatanodeStorageInfo("storage5", "5.5.5.5", "rack5", "host5");
        DatanodeStorageInfo ds6 = DFSTestUtil.createDatanodeStorageInfo("storage6", "6.6.6.6", "rack6", "host6");
        aBlockInfoStriped.addStorage(ds1, aBlock);
        aBlockInfoStriped.addStorage(ds2, new Block(blockId + 1L, 0L, 0L));
        aBlockInfoStriped.addStorage(ds3, new Block(blockId + 2L, 0L, 0L));
        aBlockInfoStriped.addStorage(ds4, new Block(blockId + 3L, 0L, 0L));
        aBlockInfoStriped.addStorage(ds5, new Block(blockId + 4L, 0L, 0L));
        aBlockInfoStriped.addStorage(ds6, aBlock);
        this.addEcBlockToBM(blockId, ecPolicy);
        ds1.getDatanodeDescriptor().startDecommission();
        LinkedList containingNodes = new LinkedList();
        LinkedList nodesContainingLiveReplicas = new LinkedList();
        NumberReplicas numReplicas = new NumberReplicas();
        ArrayList liveBlockIndices = new ArrayList();
        this.bm.chooseSourceDatanodes((BlockInfo)aBlockInfoStriped, containingNodes, nodesContainingLiveReplicas, numReplicas, liveBlockIndices, 0);
        Assert.assertEquals((String)"There are 5 live replicas in [ds2, ds3, ds4, ds5, ds6] datanodes ", (long)5L, (long)numReplicas.liveReplicas());
        Assert.assertEquals((String)"The ds1 datanode is in decommissioning, so there is no redundant replica", (long)0L, (long)numReplicas.redundantInternalBlocks());
    }

    @Test
    public void testFavorDecomUntilHardLimit() throws Exception {
        this.bm.maxReplicationStreams = 0;
        this.bm.replicationStreamsHardLimit = 1;
        long blockId = 42L;
        Block aBlock = new Block(blockId, 0L, 0L);
        List<DatanodeDescriptor> origNodes = this.getNodes(0, 1);
        this.addBlockOnNodes(blockId, origNodes.subList(0, 1));
        origNodes.get(0).startDecommission();
        LinkedList cntNodes = new LinkedList();
        LinkedList liveNodes = new LinkedList();
        Assert.assertNotNull((String)"Chooses decommissioning source node for a normal replication if all available source nodes have reached their replication limits below the hard limit.", (Object)this.bm.chooseSourceDatanodes(this.bm.getStoredBlock(aBlock), cntNodes, liveNodes, new NumberReplicas(), new LinkedList(), 2)[0]);
        DatanodeStorageInfo[] targets = new DatanodeStorageInfo[]{origNodes.get(1).getStorageInfos()[0]};
        origNodes.get(0).addBlockToBeReplicated(aBlock, targets);
        Assert.assertEquals((String)"Does not choose a source decommissioning node for a normal replication when all available nodes exceed the hard limit.", (long)0L, (long)this.bm.chooseSourceDatanodes(this.bm.getStoredBlock(aBlock), cntNodes, liveNodes, new NumberReplicas(), new LinkedList(), 2).length);
    }

    @Test
    public void testSafeModeIBR() throws Exception {
        DatanodeDescriptor node = (DatanodeDescriptor)Mockito.spy((Object)this.nodes.get(0));
        DatanodeStorageInfo ds = node.getStorageInfos()[0];
        node.setAlive(true);
        DatanodeRegistration nodeReg = new DatanodeRegistration((DatanodeID)node, null, null, "");
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isInStartupSafeMode();
        this.bm.getDatanodeManager().registerDatanode(nodeReg);
        this.bm.getDatanodeManager().addDatanode(node);
        Assert.assertEquals((Object)node, (Object)this.bm.getDatanodeManager().getDatanode((DatanodeID)node));
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockListAsLongs.EMPTY, null);
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockListAsLongs.EMPTY, null);
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
        this.bm.getDatanodeManager().removeDatanode((DatanodeID)node);
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        this.bm.getDatanodeManager().registerDatanode(nodeReg);
        ((DatanodeDescriptor)Mockito.verify((Object)node)).updateRegInfo((DatanodeID)nodeReg);
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockListAsLongs.EMPTY, null);
        ds = node.getStorageInfos()[0];
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
    }

    @Test
    public void testSafeModeIBRAfterIncremental() throws Exception {
        DatanodeDescriptor node = (DatanodeDescriptor)Mockito.spy((Object)this.nodes.get(0));
        DatanodeStorageInfo ds = node.getStorageInfos()[0];
        node.setAlive(true);
        DatanodeRegistration nodeReg = new DatanodeRegistration((DatanodeID)node, null, null, "");
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isInStartupSafeMode();
        this.bm.getDatanodeManager().registerDatanode(nodeReg);
        this.bm.getDatanodeManager().addDatanode(node);
        Assert.assertEquals((Object)node, (Object)this.bm.getDatanodeManager().getDatanode((DatanodeID)node));
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        Mockito.reset((Object[])new DatanodeDescriptor[]{node});
        ((DatanodeDescriptor)Mockito.doReturn((Object)1).when((Object)node)).numBlocks();
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), BlockListAsLongs.EMPTY, null);
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
    }

    @Test
    public void testSafeModeIBRBeforeFirstFullBR() throws Exception {
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isInStartupSafeMode();
        DatanodeDescriptor node = this.nodes.get(0);
        DatanodeStorageInfo ds = node.getStorageInfos()[0];
        node.setAlive(true);
        DatanodeRegistration nodeReg = new DatanodeRegistration((DatanodeID)node, null, null, "");
        this.bm.getDatanodeManager().registerDatanode(nodeReg);
        this.bm.getDatanodeManager().addDatanode(node);
        Assert.assertEquals((Object)node, (Object)this.bm.getDatanodeManager().getDatanode((DatanodeID)node));
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        ArrayList<ReceivedDeletedBlockInfo> rdbiList = new ArrayList<ReceivedDeletedBlockInfo>();
        BlockListAsLongs.Builder builder = BlockListAsLongs.builder();
        long receivedBlockId = 42L;
        BlockInfo receivedBlock = this.addBlockToBM(receivedBlockId);
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block((Block)receivedBlock), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null));
        builder.add((Replica)new FinalizedReplica((Block)receivedBlock, null, null));
        long receivingBlockId = 43L;
        BlockInfo receivingBlock = this.addUcBlockToBM(receivingBlockId);
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block((Block)receivingBlock), ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK, null));
        builder.add((Replica)new ReplicaBeingWritten((Block)receivingBlock, null, null, null));
        long receivingReceivedBlockId = 44L;
        BlockInfo receivingReceivedBlock = this.addBlockToBM(receivingReceivedBlockId);
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block((Block)receivingReceivedBlock), ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK, null));
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block((Block)receivingReceivedBlock), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null));
        builder.add((Replica)new FinalizedReplica((Block)receivingReceivedBlock, null, null));
        long ReceivedDeletedBlockId = 45L;
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block(ReceivedDeletedBlockId), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null));
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block(ReceivedDeletedBlockId), ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK, null));
        long existedBlockId = 46L;
        BlockInfo existedBlock = this.addBlockToBM(existedBlockId);
        builder.add((Replica)new FinalizedReplica((Block)existedBlock, null, null));
        StorageReceivedDeletedBlocks srdb = new StorageReceivedDeletedBlocks(new DatanodeStorage(ds.getStorageID()), rdbiList.toArray(new ReceivedDeletedBlockInfo[rdbiList.size()]));
        this.bm.processIncrementalBlockReport((DatanodeID)node, srdb);
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), builder.build(), new BlockReportContext(1, 0, System.nanoTime(), 0L, true));
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
        Assert.assertTrue((this.bm.getStoredBlock(new Block(receivedBlockId)).findStorageInfo(ds) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.bm.getStoredBlock(new Block(receivingBlockId)).getUnderConstructionFeature().getNumExpectedLocations() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.bm.getStoredBlock(new Block(receivingReceivedBlockId)).findStorageInfo(ds) >= 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.bm.getStoredBlock(new Block(ReceivedDeletedBlockId)));
        Assert.assertTrue((this.bm.getStoredBlock(new Block((Block)existedBlock)).findStorageInfo(ds) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSafeModeWithProvidedStorageBR() throws Exception {
        DatanodeDescriptor node0 = (DatanodeDescriptor)Mockito.spy((Object)this.nodes.get(0));
        DatanodeStorageInfo ds0 = node0.getStorageInfos()[0];
        node0.setAlive(true);
        DatanodeDescriptor node1 = (DatanodeDescriptor)Mockito.spy((Object)this.nodes.get(1));
        DatanodeStorageInfo ds1 = node1.getStorageInfos()[0];
        node1.setAlive(true);
        String providedStorageID = "DS-PROVIDED";
        DatanodeStorage providedStorage = new DatanodeStorage(providedStorageID, DatanodeStorage.State.NORMAL, StorageType.PROVIDED);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.provided.enabled", true);
        conf.setClass("dfs.provided.aliasmap.class", TestProvidedImpl.TestFileRegionBlockAliasMap.class, BlockAliasMap.class);
        BlockManager bmPs = new BlockManager((Namesystem)this.fsn, false, (Configuration)conf);
        bmPs.setBlockPoolId("BP-12344-10.1.1.2-12344");
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isInStartupSafeMode();
        DatanodeRegistration nodeReg0 = new DatanodeRegistration((DatanodeID)node0, null, null, "");
        bmPs.getDatanodeManager().registerDatanode(nodeReg0);
        bmPs.getDatanodeManager().addDatanode(node0);
        DatanodeRegistration nodeReg1 = new DatanodeRegistration((DatanodeID)node1, null, null, "");
        bmPs.getDatanodeManager().registerDatanode(nodeReg1);
        bmPs.getDatanodeManager().addDatanode(node1);
        bmPs.processReport((DatanodeID)node0, providedStorage, BlockListAsLongs.EMPTY, null);
        bmPs.processReport((DatanodeID)node0, new DatanodeStorage(ds0.getStorageID()), BlockListAsLongs.EMPTY, null);
        bmPs.processReport((DatanodeID)node1, providedStorage, BlockListAsLongs.EMPTY, null);
        bmPs.processReport((DatanodeID)node1, new DatanodeStorage(ds1.getStorageID()), BlockListAsLongs.EMPTY, null);
        DatanodeStorageInfo dsPs = bmPs.getProvidedStorageMap().getProvidedStorageInfo();
        Assert.assertEquals((long)2L, (long)dsPs.getBlockReportCount());
        Assert.assertEquals((long)1L, (long)ds0.getBlockReportCount());
        Assert.assertEquals((long)1L, (long)ds1.getBlockReportCount());
    }

    @Test
    public void testFullBR() throws Exception {
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isRunning();
        DatanodeDescriptor node = this.nodes.get(0);
        DatanodeStorageInfo ds = node.getStorageInfos()[0];
        node.setAlive(true);
        DatanodeRegistration nodeReg = new DatanodeRegistration((DatanodeID)node, null, null, "");
        this.bm.getDatanodeManager().registerDatanode(nodeReg);
        this.bm.getDatanodeManager().addDatanode(node);
        Assert.assertEquals((Object)node, (Object)this.bm.getDatanodeManager().getDatanode((DatanodeID)node));
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        ArrayList<BlockInfo> blocks = new ArrayList<BlockInfo>();
        for (int id = 24; id > 0; --id) {
            blocks.add(this.addBlockToBM(id));
        }
        Assert.assertEquals((long)0L, (long)ds.getBlockReportCount());
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), this.generateReport(blocks), new BlockReportContext(1, 0, System.nanoTime(), 0L, false));
        Assert.assertEquals((long)1L, (long)ds.getBlockReportCount());
        for (BlockInfo block : blocks) {
            Assert.assertTrue((this.bm.getStoredBlock((Block)block).findStorageInfo(ds) >= 0 ? 1 : 0) != 0);
        }
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), this.generateReport(blocks), new BlockReportContext(1, 0, System.nanoTime(), 0L, false));
        Assert.assertEquals((long)2L, (long)ds.getBlockReportCount());
        for (BlockInfo block : blocks) {
            Assert.assertTrue((this.bm.getStoredBlock((Block)block).findStorageInfo(ds) >= 0 ? 1 : 0) != 0);
        }
        Collections.sort(blocks);
        this.bm.processReport((DatanodeID)node, new DatanodeStorage(ds.getStorageID()), this.generateReport(blocks), new BlockReportContext(1, 0, System.nanoTime(), 0L, true));
        Assert.assertEquals((long)3L, (long)ds.getBlockReportCount());
        for (BlockInfo block : blocks) {
            Assert.assertTrue((this.bm.getStoredBlock((Block)block).findStorageInfo(ds) >= 0 ? 1 : 0) != 0);
        }
    }

    private BlockListAsLongs generateReport(List<BlockInfo> blocks) {
        BlockListAsLongs.Builder builder = BlockListAsLongs.builder();
        for (BlockInfo block : blocks) {
            builder.add((Replica)new FinalizedReplica((Block)block, null, null));
        }
        return builder.build();
    }

    @Test
    public void testUCBlockNotConsideredMissing() throws Exception {
        DatanodeDescriptor node = this.nodes.get(0);
        DatanodeStorageInfo ds = node.getStorageInfos()[0];
        node.setAlive(true);
        DatanodeRegistration nodeReg = new DatanodeRegistration((DatanodeID)node, null, null, "");
        this.bm.getDatanodeManager().registerDatanode(nodeReg);
        this.bm.getDatanodeManager().addDatanode(node);
        ArrayList<ReceivedDeletedBlockInfo> rdbiList = new ArrayList<ReceivedDeletedBlockInfo>();
        long blockId = 42L;
        BlockInfo receivedBlock = this.addUcBlockToBM(blockId);
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block((Block)receivedBlock), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null));
        rdbiList.add(new ReceivedDeletedBlockInfo(new Block(blockId), ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK, null));
        StorageReceivedDeletedBlocks srdb = new StorageReceivedDeletedBlocks(new DatanodeStorage(ds.getStorageID()), rdbiList.toArray(new ReceivedDeletedBlockInfo[rdbiList.size()]));
        this.bm.setInitializedReplQueues(true);
        this.bm.processIncrementalBlockReport((DatanodeID)node, srdb);
        Assert.assertEquals((String)"UC block was incorrectly added to needed Replications", (long)0L, (long)this.bm.neededReconstruction.size());
        this.bm.setInitializedReplQueues(false);
    }

    private BlockInfo addEcBlockToBM(long blkId, ErasureCodingPolicy ecPolicy) {
        Block block = new Block(blkId);
        BlockInfoStriped blockInfo = new BlockInfoStriped(block, ecPolicy);
        long inodeId = ++this.mockINodeId;
        INodeFile bc = TestINodeFile.createINodeFile(inodeId);
        this.bm.blocksMap.addBlockCollection((BlockInfo)blockInfo, (BlockCollection)bc);
        blockInfo.setBlockCollectionId(inodeId);
        ((FSNamesystem)Mockito.doReturn((Object)bc).when((Object)this.fsn)).getBlockCollection(inodeId);
        return blockInfo;
    }

    private BlockInfo addBlockToBM(long blkId) {
        Block block = new Block(blkId);
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(block, 3);
        long inodeId = ++this.mockINodeId;
        INodeFile bc = TestINodeFile.createINodeFile(inodeId);
        this.bm.blocksMap.addBlockCollection((BlockInfo)blockInfo, (BlockCollection)bc);
        blockInfo.setBlockCollectionId(inodeId);
        ((FSNamesystem)Mockito.doReturn((Object)bc).when((Object)this.fsn)).getBlockCollection(inodeId);
        return blockInfo;
    }

    private BlockInfo addUcBlockToBM(long blkId) {
        Block block = new Block(blkId);
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(block, 3);
        blockInfo.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        long inodeId = ++this.mockINodeId;
        INodeFile bc = TestINodeFile.createINodeFile(inodeId);
        blockInfo.setBlockCollectionId(inodeId);
        this.bm.blocksMap.addBlockCollection((BlockInfo)blockInfo, (BlockCollection)bc);
        ((FSNamesystem)Mockito.doReturn((Object)bc).when((Object)this.fsn)).getBlockCollection(inodeId);
        return blockInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStorageWithRemainingCapacity() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path file1 = null;
        try {
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            String poolId = namesystem.getBlockPoolId();
            DatanodeRegistration nodeReg = InternalDataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(0), poolId);
            DatanodeDescriptor dd = NameNodeAdapter.getDatanode(namesystem, (DatanodeID)nodeReg);
            for (DatanodeStorageInfo storage : dd.getStorageInfos()) {
                storage.setUtilizationForTesting(65536L, 0L, 65536L, 0L);
            }
            dd.setRemaining(131072L);
            file1 = new Path("testRemainingStorage.dat");
            try {
                DFSTestUtil.createFile(fs, file1, 102400, 102400L, 102400L, (short)1, 464346861L);
            }
            catch (RemoteException re) {
                GenericTestUtils.assertExceptionContains((String)"of the 1 minReplication", (Throwable)re);
            }
        }
        catch (Throwable throwable) {
            Assert.assertTrue((boolean)fs.exists(file1));
            fs.delete(file1, true);
            Assert.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)fs.exists(file1));
        fs.delete(file1, true);
        Assert.assertTrue((!fs.exists(file1) ? 1 : 0) != 0);
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testUseDelHint() {
        DatanodeStorageInfo delHint = new DatanodeStorageInfo(DFSTestUtil.getLocalDatanodeDescriptor(), new DatanodeStorage("id"));
        List<DatanodeStorageInfo> moreThan1Racks = Arrays.asList(delHint);
        ArrayList<StorageType> excessTypes = new ArrayList<StorageType>();
        BlockPlacementPolicyDefault policyDefault = (BlockPlacementPolicyDefault)this.bm.getBlockPlacementPolicy();
        excessTypes.add(StorageType.DEFAULT);
        Assert.assertTrue((boolean)policyDefault.useDelHint(delHint, null, moreThan1Racks, null, excessTypes));
        excessTypes.remove(0);
        excessTypes.add(StorageType.SSD);
        Assert.assertFalse((boolean)policyDefault.useDelHint(delHint, null, moreThan1Racks, null, excessTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockReportQueueing() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            final BlockManager bm = fsn.getBlockManager();
            ExecutorService executor = Executors.newCachedThreadPool();
            final CyclicBarrier startBarrier = new CyclicBarrier(2);
            final CountDownLatch endLatch = new CountDownLatch(3);
            final CountDownLatch doneLatch = new CountDownLatch(1);
            FutureTask<Void> blockingOp = new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    bm.runBlockOp((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws InterruptedException, BrokenBarrierException {
                            startBarrier.await();
                            endLatch.countDown();
                            return null;
                        }
                    });
                    doneLatch.countDown();
                    return null;
                }
            });
            Callable<Void> asyncOp = new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    bm.enqueueBlockOp(new Runnable(){

                        @Override
                        public void run() {
                            endLatch.countDown();
                        }
                    });
                    return null;
                }
            };
            Future<?> blockedFuture = executor.submit(blockingOp);
            boolean isBlocked = false;
            try {
                blockedFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException te) {
                isBlocked = true;
            }
            Assert.assertTrue((boolean)isBlocked);
            executor.submit(asyncOp).get(1L, TimeUnit.SECONDS);
            executor.submit(asyncOp).get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)bm.getBlockOpQueueLength());
            Assert.assertFalse((boolean)blockedFuture.isDone());
            startBarrier.await(1L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)endLatch.await(1L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)bm.getBlockOpQueueLength());
            Assert.assertTrue((boolean)doneLatch.await(1L, TimeUnit.SECONDS));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncIBR() throws Exception {
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger((String)"ROOT"), (Level)Level.WARN);
        int blkSize = 4096;
        int fileSize = 409600;
        final byte[] buf = new byte[8192];
        int numWriters = 4;
        int repl = 3;
        final CyclicBarrier barrier = new CyclicBarrier(4);
        final CountDownLatch writeLatch = new CountDownLatch(4);
        final AtomicBoolean failure = new AtomicBoolean();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.getLong("dfs.namenode.fs-limits.min-block-size", 4096L);
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(8).build();
        try {
            MetricsRecordBuilder rb;
            cluster.waitActive();
            Thread[] writers = new Thread[4];
            for (int i = 0; i < writers.length; ++i) {
                final Path p = new Path("/writer" + i);
                writers[i] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DistributedFileSystem fs = cluster.getFileSystem();
                            FSDataOutputStream os = fs.create(p, true, buf.length, (short)3, 4096L);
                            barrier.await();
                            for (int remaining = 409600; remaining > 0; remaining -= buf.length) {
                                os.write(buf);
                            }
                            os.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            failure.set(true);
                        }
                        writeLatch.countDown();
                    }
                });
                writers[i].start();
            }
            boolean sawQueued = false;
            while (!writeLatch.await(10L, TimeUnit.MILLISECONDS)) {
                Assert.assertFalse((boolean)failure.get());
                rb = MetricsAsserts.getMetrics((String)"NameNodeActivity");
                long queued = MetricsAsserts.getIntGauge((String)"BlockOpsQueued", (MetricsRecordBuilder)rb);
                sawQueued |= queued > 0L;
            }
            Assert.assertFalse((boolean)failure.get());
            Assert.assertTrue((boolean)sawQueued);
            rb = MetricsAsserts.getMetrics((String)"NameNodeActivity");
            long batched = MetricsAsserts.getLongCounter((String)"BlockOpsBatched", (MetricsRecordBuilder)rb);
            Assert.assertTrue((batched > 0L ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testBlockManagerMachinesArray() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        try {
            cluster.waitActive();
            BlockManager blockManager = cluster.getNamesystem().getBlockManager();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path filePath = new Path("/tmp.txt");
            long fileLen = 1L;
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)3, 1L);
            DFSTestUtil.waitForReplication(fs, filePath, (short)3, 60000);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)4L);
            FSNamesystem ns = cluster.getNamesystem();
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File storageDir = cluster.getInstanceStorageDir(0, 0);
            File dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            Assert.assertTrue((String)"Data directory does not exist", (boolean)dataDir.exists());
            BlockInfo blockInfo = (BlockInfo)blockManager.blocksMap.getBlocks().iterator().next();
            ExtendedBlock blk = new ExtendedBlock(bpid, blockInfo.getBlockId(), blockInfo.getNumBytes(), blockInfo.getGenerationStamp());
            DatanodeDescriptor failedStorageDataNode = blockManager.getStoredBlock((Block)blockInfo).getDatanode(0);
            DatanodeDescriptor corruptStorageDataNode = blockManager.getStoredBlock((Block)blockInfo).getDatanode(1);
            ArrayList<StorageReport> reports = new ArrayList<StorageReport>();
            block3: for (int i = 0; i < failedStorageDataNode.getStorageInfos().length; ++i) {
                DatanodeStorageInfo storageInfo = failedStorageDataNode.getStorageInfos()[i];
                DatanodeStorage dns = new DatanodeStorage(failedStorageDataNode.getStorageInfos()[i].getStorageID(), DatanodeStorage.State.FAILED, failedStorageDataNode.getStorageInfos()[i].getStorageType());
                while (storageInfo.getBlockIterator().hasNext()) {
                    BlockInfo blockInfo1 = (BlockInfo)storageInfo.getBlockIterator().next();
                    if (!blockInfo1.equals((Object)blockInfo)) continue;
                    StorageReport report = new StorageReport(dns, true, storageInfo.getCapacity(), storageInfo.getDfsUsed(), storageInfo.getRemaining(), storageInfo.getBlockPoolUsed(), 0L);
                    reports.add(report);
                    continue block3;
                }
            }
            failedStorageDataNode.updateHeartbeat(reports.toArray(StorageReport.EMPTY_ARRAY), 0L, 0L, 0, 0, null);
            ns.writeLock();
            DatanodeStorageInfo corruptStorageInfo = null;
            for (int i = 0; i < corruptStorageDataNode.getStorageInfos().length; ++i) {
                BlockInfo blockInfo1;
                corruptStorageInfo = corruptStorageDataNode.getStorageInfos()[i];
                while (corruptStorageInfo.getBlockIterator().hasNext() && !(blockInfo1 = (BlockInfo)corruptStorageInfo.getBlockIterator().next()).equals((Object)blockInfo)) {
                }
            }
            blockManager.findAndMarkBlockAsCorrupt(blk, (DatanodeInfo)corruptStorageDataNode, corruptStorageInfo.getStorageID(), CorruptReplicasMap.Reason.ANY.toString());
            ns.writeUnlock();
            BlockInfo[] blockInfos = new BlockInfo[]{blockInfo};
            ns.readLock();
            LocatedBlocks locatedBlocks = blockManager.createLocatedBlocks(blockInfos, 3L, false, 0L, 3L, false, false, null, null);
            Assert.assertTrue((String)"Located Blocks should exclude corruptreplicas and failed storages", (locatedBlocks.getLocatedBlocks().size() == 1 ? 1 : 0) != 0);
            ns.readUnlock();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaSaveCorruptBlocks() throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        this.addCorruptBlockOnNodes(0L, origNodes);
        File file = new File("test.log");
        PrintWriter out = new PrintWriter(file);
        this.bm.metaSave(out);
        out.flush();
        FileInputStream fstream = new FileInputStream(file);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        Boolean foundIt = false;
        try {
            String corruptBlocksLine;
            while ((corruptBlocksLine = reader.readLine()) != null) {
                if (corruptBlocksLine.compareTo("Corrupt Blocks:") != 0) continue;
                foundIt = true;
                break;
            }
            Assert.assertTrue((String)"Unexpected text in metasave,was expecting corrupt blocks section!", (boolean)foundIt);
            corruptBlocksLine = reader.readLine();
            String regex = "Block=blk_[0-9]+_[0-9]+\\tSize=.*\\tNode=.*\\tStorageID=.*\\tStorageState.*\\tTotalReplicas=.*\\tReason=GENSTAMP_MISMATCH";
            Assert.assertTrue((String)"Unexpected corrupt block section in metasave!", (boolean)corruptBlocksLine.matches(regex));
            corruptBlocksLine = reader.readLine();
            regex = "Metasave: Number of datanodes.*";
            Assert.assertTrue((String)"Unexpected corrupt block section in metasave!", (boolean)corruptBlocksLine.matches(regex));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            file.delete();
        }
    }

    @Test
    public void testIsReplicaCorruptCall() throws Exception {
        BlockManager spyBM = (BlockManager)Mockito.spy((Object)this.bm);
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1, 3);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo blockInfo = this.addBlockOnNodes(0L, origNodes);
        spyBM.createLocatedBlocks(new BlockInfo[]{blockInfo}, 3L, false, 0L, 3L, false, false, null, null);
        ((BlockManager)Mockito.verify((Object)spyBM, (VerificationMode)Mockito.atLeast((int)0))).isReplicaCorrupt((BlockInfo)Matchers.any(BlockInfo.class), (DatanodeDescriptor)Matchers.any(DatanodeDescriptor.class));
        this.addCorruptBlockOnNodes(0L, origNodes);
        spyBM.createLocatedBlocks(new BlockInfo[]{blockInfo}, 3L, false, 0L, 3L, false, false, null, null);
        ((BlockManager)Mockito.verify((Object)spyBM, (VerificationMode)Mockito.atLeast((int)1))).isReplicaCorrupt((BlockInfo)Matchers.any(BlockInfo.class), (DatanodeDescriptor)Matchers.any(DatanodeDescriptor.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testPlacementPolicySatisfied() throws Exception {
        LOG.info("Starting testPlacementPolicySatisfied.");
        String[] initialRacks = new String[]{"/rack0", "/rack1", "/rack2", "/rack3", "/rack4", "/rack5"};
        String[] initialHosts = new String[]{"host0", "host1", "host2", "host3", "host4", "host5"};
        int numDataBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumDataUnits();
        int numParityBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumParityUnits();
        long blockSize = 0x600000L;
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 0x600000L);
        conf.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).racks(initialRacks).hosts(initialHosts).numDataNodes(initialRacks.length).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path ecDir = new Path("/ec");
            Path testFileUnsatisfied = new Path(ecDir, "test1");
            Path testFileSatisfied = new Path(ecDir, "test2");
            dfs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            cluster.getFileSystem().getClient().mkdirs(ecDir.toString(), null, true);
            cluster.getFileSystem().getClient().setErasureCodingPolicy(ecDir.toString(), StripedFileTestUtil.getDefaultECPolicy().getName());
            long fileLen = 0x600000L * (long)numDataBlocks;
            DFSTestUtil.createFile((FileSystem)dfs, testFileUnsatisfied, fileLen, (short)1, 1L);
            this.verifyPlacementPolicy(cluster, testFileUnsatisfied, true);
            LOG.info("Adding 3 new hosts in the existing racks.");
            cluster.startDataNodes(conf, 3, true, null, new String[]{"/rack3", "/rack4", "/rack5"}, new String[]{"host3-2", "host4-2", "host5-2"}, null);
            cluster.triggerHeartbeats();
            LOG.info("Waiting for EC reconstruction to complete.");
            DFSTestUtil.waitForReplication(dfs, testFileUnsatisfied, (short)(numDataBlocks + numParityBlocks), 30000);
            this.verifyPlacementPolicy(cluster, testFileUnsatisfied, true);
            LOG.info("Adding 3 new hosts in 3 new racks.");
            cluster.startDataNodes(conf, 3, true, null, new String[]{"/rack6", "/rack7", "/rack8"}, new String[]{"host6", "host7", "host8"}, null);
            cluster.triggerHeartbeats();
            this.verifyPlacementPolicy(cluster, testFileUnsatisfied, false);
            DFSTestUtil.createFile((FileSystem)dfs, testFileSatisfied, fileLen, (short)1, 1L);
            this.verifyPlacementPolicy(cluster, testFileUnsatisfied, false);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void verifyPlacementPolicy(MiniDFSCluster cluster, Path file, boolean isBlockPlacementSatisfied) throws IOException {
        DistributedFileSystem dfs = cluster.getFileSystem();
        BlockManager blockManager = cluster.getNamesystem().getBlockManager();
        LocatedBlock lb = DFSTestUtil.getAllBlocks((FileSystem)dfs, file).get(0);
        BlockInfo blockInfo = blockManager.getStoredBlock(lb.getBlock().getLocalBlock());
        Iterator itr = blockInfo.getStorageInfos();
        LOG.info("Block " + blockInfo + " storages: ");
        while (itr.hasNext()) {
            DatanodeStorageInfo dn = (DatanodeStorageInfo)itr.next();
            LOG.info(" Rack: " + dn.getDatanodeDescriptor().getNetworkLocation() + ", DataNode: " + dn.getDatanodeDescriptor().getXferAddr());
        }
        if (isBlockPlacementSatisfied) {
            Assert.assertTrue((String)("Block group of " + file + "should be placement policy satisfied, currently!"), (boolean)blockManager.isPlacementPolicySatisfied(blockInfo));
        } else {
            Assert.assertFalse((String)("Block group of " + file + " should be placement policy unsatisfied, currently!"), (boolean)blockManager.isPlacementPolicySatisfied(blockInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaSavePostponedMisreplicatedBlocks() throws IOException {
        this.bm.postponeBlock(new Block());
        File file = new File("test.log");
        PrintWriter out = new PrintWriter(file);
        this.bm.metaSave(out);
        out.flush();
        FileInputStream fstream = new FileInputStream(file);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            String output = buffer.toString();
            Assert.assertTrue((String)"Metasave output should not have null block ", (boolean)output.contains("Block blk_0_0 is Null"));
        }
        finally {
            reader.close();
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaSaveMissingReplicas() throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo block = this.makeBlockReplicasMissing(0L, origNodes);
        File file = new File("test.log");
        PrintWriter out = new PrintWriter(file);
        this.bm.metaSave(out);
        out.flush();
        FileInputStream fstream = new FileInputStream(file);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            String output = buffer.toString();
            Assert.assertTrue((String)"Metasave output should have reported missing blocks.", (boolean)output.contains("Metasave: Blocks currently missing: 1"));
            Assert.assertTrue((String)"There should be 0 blocks waiting for reconstruction", (boolean)output.contains("Metasave: Blocks waiting for reconstruction: 0"));
            String blockNameGS = block.getBlockName() + "_" + block.getGenerationStamp();
            Assert.assertTrue((String)("Block " + blockNameGS + " should be MISSING."), (boolean)output.contains(blockNameGS + " MISSING"));
        }
        finally {
            reader.close();
            file.delete();
        }
    }

    private BlockInfo makeBlockReplicasMissing(long blockId, List<DatanodeDescriptor> nodesList) throws IOException {
        long inodeId = ++this.mockINodeId;
        INodeFile bc = TestINodeFile.createINodeFile(inodeId);
        BlockInfo blockInfo = this.blockOnNodes(blockId, nodesList);
        blockInfo.setReplication((short)3);
        blockInfo.setBlockCollectionId(inodeId);
        ((FSNamesystem)Mockito.doReturn((Object)bc).when((Object)this.fsn)).getBlockCollection(inodeId);
        this.bm.blocksMap.addBlockCollection(blockInfo, (BlockCollection)bc);
        this.bm.markBlockReplicasAsCorrupt((Block)blockInfo, blockInfo, blockInfo.getGenerationStamp() + 1L, blockInfo.getNumBytes(), new DatanodeStorageInfo[0]);
        BlockCollection mockedBc = (BlockCollection)Mockito.mock(BlockCollection.class);
        Mockito.when((Object)mockedBc.getBlocks()).thenReturn((Object)new BlockInfo[]{blockInfo});
        this.bm.checkRedundancy(mockedBc);
        return blockInfo;
    }

    private BlockInfo makeBlockReplicasMaintenance(long blockId, List<DatanodeDescriptor> nodesList) throws IOException {
        long inodeId = ++this.mockINodeId;
        INodeFile bc = TestINodeFile.createINodeFile(inodeId);
        BlockInfo blockInfo = this.blockOnNodes(blockId, nodesList);
        blockInfo.setReplication((short)3);
        blockInfo.setBlockCollectionId(inodeId);
        ((FSNamesystem)Mockito.doReturn((Object)bc).when((Object)this.fsn)).getBlockCollection(inodeId);
        this.bm.blocksMap.addBlockCollection(blockInfo, (BlockCollection)bc);
        nodesList.get(0).setInMaintenance();
        BlockCollection mockedBc = (BlockCollection)Mockito.mock(BlockCollection.class);
        Mockito.when((Object)mockedBc.getBlocks()).thenReturn((Object)new BlockInfo[]{blockInfo});
        this.bm.checkRedundancy(mockedBc);
        return blockInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaSaveInMaintenanceReplicas() throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo block = this.makeBlockReplicasMaintenance(0L, origNodes);
        File file = new File("test.log");
        PrintWriter out = new PrintWriter(file);
        this.bm.metaSave(out);
        out.flush();
        FileInputStream fstream = new FileInputStream(file);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                System.out.println(line);
            }
            String output = buffer.toString();
            Assert.assertTrue((String)"Metasave output should not have reported missing blocks.", (boolean)output.contains("Metasave: Blocks currently missing: 0"));
            Assert.assertTrue((String)"There should be 1 block waiting for reconstruction", (boolean)output.contains("Metasave: Blocks waiting for reconstruction: 1"));
            String blockNameGS = block.getBlockName() + "_" + block.getGenerationStamp();
            Assert.assertTrue((String)("Block " + blockNameGS + " should be list as maintenance."), (boolean)output.contains(blockNameGS + " (replicas: live: 1 decommissioning and decommissioned: 0 corrupt: 0 in excess: 0 maintenance mode: 1)"));
        }
        finally {
            reader.close();
            file.delete();
        }
    }

    private BlockInfo makeBlockReplicasDecommission(long blockId, List<DatanodeDescriptor> nodesList) throws IOException {
        long inodeId = ++this.mockINodeId;
        INodeFile bc = TestINodeFile.createINodeFile(inodeId);
        BlockInfo blockInfo = this.blockOnNodes(blockId, nodesList);
        blockInfo.setReplication((short)3);
        blockInfo.setBlockCollectionId(inodeId);
        ((FSNamesystem)Mockito.doReturn((Object)bc).when((Object)this.fsn)).getBlockCollection(inodeId);
        this.bm.blocksMap.addBlockCollection(blockInfo, (BlockCollection)bc);
        nodesList.get(0).startDecommission();
        BlockCollection mockedBc = (BlockCollection)Mockito.mock(BlockCollection.class);
        Mockito.when((Object)mockedBc.getBlocks()).thenReturn((Object)new BlockInfo[]{blockInfo});
        this.bm.checkRedundancy(mockedBc);
        return blockInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaSaveDecommissioningReplicas() throws Exception {
        List<DatanodeStorageInfo> origStorages = this.getStorages(0, 1);
        List<DatanodeDescriptor> origNodes = this.getNodes(origStorages);
        BlockInfo block = this.makeBlockReplicasDecommission(0L, origNodes);
        File file = new File("test.log");
        PrintWriter out = new PrintWriter(file);
        this.bm.metaSave(out);
        out.flush();
        FileInputStream fstream = new FileInputStream(file);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            String output = buffer.toString();
            Assert.assertTrue((String)"Metasave output should not have reported missing blocks.", (boolean)output.contains("Metasave: Blocks currently missing: 0"));
            Assert.assertTrue((String)"There should be 1 block waiting for reconstruction", (boolean)output.contains("Metasave: Blocks waiting for reconstruction: 1"));
            String blockNameGS = block.getBlockName() + "_" + block.getGenerationStamp();
            Assert.assertTrue((String)("Block " + blockNameGS + " should be list as maintenance."), (boolean)output.contains(blockNameGS + " (replicas: live: 1 decommissioning and decommissioned: 1 corrupt: 0 in excess: 0 maintenance mode: 0)"));
        }
        finally {
            reader.close();
            file.delete();
        }
    }

    @Test
    public void testLegacyBlockInInvalidateBlocks() {
        long legancyGenerationStampLimit = 10000L;
        BlockIdManager bim = (BlockIdManager)Mockito.mock(BlockIdManager.class);
        Mockito.when((Object)bim.getLegacyGenerationStampLimit()).thenReturn((Object)10000L);
        Mockito.when((Object)bim.isStripedBlock((Block)Matchers.any(Block.class))).thenCallRealMethod();
        Mockito.when((Object)bim.isLegacyBlock((Block)Matchers.any(Block.class))).thenCallRealMethod();
        InvalidateBlocks ibs = new InvalidateBlocks(100, 30000L, bim);
        Block legacy = new Block(-1L, 10L, 1000L);
        Block striped = new Block(this.bm.nextBlockId(BlockType.STRIPED), 10L, 10010L);
        DatanodeInfo legacyDnInfo = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo stripedDnInfo = DFSTestUtil.getLocalDatanodeInfo();
        ibs.add(legacy, legacyDnInfo, false);
        Assert.assertEquals((long)1L, (long)ibs.getBlocks());
        Assert.assertEquals((long)0L, (long)ibs.getECBlocks());
        ibs.add(striped, stripedDnInfo, false);
        Assert.assertEquals((long)1L, (long)ibs.getBlocks());
        Assert.assertEquals((long)1L, (long)ibs.getECBlocks());
        ibs.remove(legacyDnInfo);
        Assert.assertEquals((long)0L, (long)ibs.getBlocks());
        Assert.assertEquals((long)1L, (long)ibs.getECBlocks());
        ibs.remove(stripedDnInfo);
        Assert.assertEquals((long)0L, (long)ibs.getBlocks());
        Assert.assertEquals((long)0L, (long)ibs.getECBlocks());
    }
}

