/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImplBuilder;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeList;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReservedSpaceCalculator;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFsVolumeList {
    private Configuration conf;
    private VolumeChoosingPolicy<FsVolumeImpl> blockChooser = new RoundRobinVolumeChoosingPolicy();
    private FsDatasetImpl dataset = null;
    private String baseDir;
    private BlockScanner blockScanner;

    @Before
    public void setUp() {
        this.dataset = (FsDatasetImpl)Mockito.mock(FsDatasetImpl.class);
        this.baseDir = new FileSystemTestHelper().getTestRootDir();
        Configuration blockScannerConf = new Configuration();
        blockScannerConf.setInt("dfs.datanode.scan.period.hours", -1);
        this.blockScanner = new BlockScanner(null, blockScannerConf);
        this.conf = new Configuration();
    }

    @Test(timeout=30000L)
    public void testGetNextVolumeWithClosedVolume() throws IOException {
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), this.blockScanner, this.blockChooser);
        final ArrayList<FsVolumeImpl> volumes = new ArrayList<FsVolumeImpl>();
        for (int i = 0; i < 3; ++i) {
            File curDir = new File(this.baseDir, "nextvolume-" + i);
            curDir.mkdirs();
            FsVolumeImpl volume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)curDir.getPath()))).build();
            volume.setCapacityForTesting(0x40000000L);
            volumes.add(volume);
            volumeList.addVolume(volume.obtainReference());
        }
        ((FsVolumeImpl)volumes.get(1)).setClosed();
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return ((FsVolumeImpl)volumes.get(1)).checkClosed();
                }
            }, (long)100L, (long)3000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"timed out while waiting for volume to be removed.");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        for (int i = 0; i < 10; ++i) {
            try (FsVolumeReference ref = volumeList.getNextVolume(StorageType.DEFAULT, null, 128L);){
                Assert.assertNotEquals((Object)ref.getVolume(), volumes.get(1));
                continue;
            }
        }
    }

    @Test(timeout=30000L)
    public void testReleaseVolumeRefIfNoBlockScanner() throws IOException {
        FsVolumeList volumeList = new FsVolumeList(Collections.emptyList(), null, this.blockChooser);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        FsVolumeImpl volume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)volDir.getPath()))).build();
        FsVolumeReference ref = volume.obtainReference();
        volumeList.addVolume(ref);
        Assert.assertNull((Object)ref.getVolume());
    }

    @Test
    public void testDfsReservedForDifferentStorageTypes() throws IOException {
        Configuration conf = new Configuration();
        conf.setLong("dfs.datanode.du.reserved", 100L);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        FsVolumeImpl volume = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[RAM_DISK]" + volDir.getPath())))).setStorageID("storage-id").setConf(conf).build();
        Assert.assertEquals((String)"", (long)100L, (long)volume.getReserved());
        conf.setLong("dfs.datanode.du.reserved." + StringUtils.toLowerCase((String)StorageType.RAM_DISK.toString()), 1L);
        conf.setLong("dfs.datanode.du.reserved." + StringUtils.toLowerCase((String)StorageType.SSD.toString()), 2L);
        FsVolumeImpl volume1 = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[RAM_DISK]" + volDir.getPath())))).setStorageID("storage-id").setConf(conf).build();
        Assert.assertEquals((String)"", (long)1L, (long)volume1.getReserved());
        FsVolumeImpl volume2 = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[SSD]" + volDir.getPath())))).setStorageID("storage-id").setConf(conf).build();
        Assert.assertEquals((String)"", (long)2L, (long)volume2.getReserved());
        FsVolumeImpl volume3 = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[DISK]" + volDir.getPath())))).setStorageID("storage-id").setConf(conf).build();
        Assert.assertEquals((String)"", (long)100L, (long)volume3.getReserved());
        FsVolumeImpl volume4 = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)volDir.getPath()))).setStorageID("storage-id").setConf(conf).build();
        Assert.assertEquals((String)"", (long)100L, (long)volume4.getReserved());
    }

    @Test
    public void testNonDfsUsedMetricForVolume() throws Exception {
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        long diskCapacity = 1000L;
        long duReserved = 100L;
        long dfsUsage = 200L;
        long actualNonDfsUsage = 300L;
        long reservedForReplicas = 50L;
        this.conf.setLong("dfs.datanode.du.reserved", duReserved);
        FsVolumeImpl volume = new FsVolumeImplBuilder().setDataset(this.dataset).setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)volDir.getPath()))).setStorageID("storage-id").setConf(this.conf).build();
        FsVolumeImpl spyVolume = (FsVolumeImpl)Mockito.spy((Object)volume);
        long testCapacity = diskCapacity - duReserved;
        spyVolume.setCapacityForTesting(testCapacity);
        long dfAvailable = diskCapacity - dfsUsage - actualNonDfsUsage;
        ((FsVolumeImpl)Mockito.doReturn((Object)dfAvailable).when((Object)spyVolume)).getDfAvailable();
        ((FsVolumeImpl)Mockito.doReturn((Object)dfsUsage).when((Object)spyVolume)).getDfsUsed();
        ((FsVolumeImpl)Mockito.doReturn((Object)reservedForReplicas).when((Object)spyVolume)).getReservedForReplicas();
        ((FsVolumeImpl)Mockito.doReturn((Object)actualNonDfsUsage).when((Object)spyVolume)).getActualNonDfsUsed();
        long expectedNonDfsUsage = actualNonDfsUsage - duReserved;
        Assert.assertEquals((long)expectedNonDfsUsage, (long)spyVolume.getNonDfsUsed());
    }

    @Test
    public void testDfsReservedPercentageForDifferentStorageTypes() throws IOException {
        this.conf.setClass("dfs.datanode.du.reserved.calculator", ReservedSpaceCalculator.ReservedSpaceCalculatorPercentage.class, ReservedSpaceCalculator.class);
        this.conf.setLong("dfs.datanode.du.reserved.pct", 15L);
        File volDir = new File(this.baseDir, "volume-0");
        volDir.mkdirs();
        DF usage = (DF)Mockito.mock(DF.class);
        Mockito.when((Object)usage.getCapacity()).thenReturn((Object)4000L);
        Mockito.when((Object)usage.getAvailable()).thenReturn((Object)1000L);
        FsVolumeImpl volume = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[RAM_DISK]" + volDir.getPath())))).setUsage(usage).build();
        Assert.assertEquals((long)600L, (long)volume.getReserved());
        Assert.assertEquals((long)3400L, (long)volume.getCapacity());
        Assert.assertEquals((long)400L, (long)volume.getAvailable());
        this.conf.setLong("dfs.datanode.du.reserved.pct." + StringUtils.toLowerCase((String)StorageType.RAM_DISK.toString()), 10L);
        this.conf.setLong("dfs.datanode.du.reserved.pct." + StringUtils.toLowerCase((String)StorageType.SSD.toString()), 50L);
        FsVolumeImpl volume1 = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[RAM_DISK]" + volDir.getPath())))).setUsage(usage).build();
        Assert.assertEquals((long)400L, (long)volume1.getReserved());
        Assert.assertEquals((long)3600L, (long)volume1.getCapacity());
        Assert.assertEquals((long)600L, (long)volume1.getAvailable());
        FsVolumeImpl volume2 = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[SSD]" + volDir.getPath())))).setUsage(usage).build();
        Assert.assertEquals((long)2000L, (long)volume2.getReserved());
        Assert.assertEquals((long)2000L, (long)volume2.getCapacity());
        Assert.assertEquals((long)0L, (long)volume2.getAvailable());
        FsVolumeImpl volume3 = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)("[DISK]" + volDir.getPath())))).setUsage(usage).build();
        Assert.assertEquals((long)600L, (long)volume3.getReserved());
        FsVolumeImpl volume4 = new FsVolumeImplBuilder().setConf(this.conf).setDataset(this.dataset).setStorageID("storage-id").setStorageDirectory(new Storage.StorageDirectory(StorageLocation.parse((String)volDir.getPath()))).setUsage(usage).build();
        Assert.assertEquals((long)600L, (long)volume4.getReserved());
    }

    @Test(timeout=60000L)
    public void testAddRplicaProcessorForAddingReplicaInMap() throws Exception {
        BlockPoolSlice.reInitializeAddReplicaThreadPool();
        Configuration cnf = new Configuration();
        int poolSize = 5;
        cnf.setInt("dfs.replication", 1);
        cnf.setInt("dfs.datanode.volumes.replica-add.threadpool.size", poolSize);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(cnf).numDataNodes(1).storagesPerDatanode(1).build();
        final DistributedFileSystem fs = cluster.getFileSystem();
        ExecutorService pool = Executors.newFixedThreadPool(10);
        ArrayList futureList = new ArrayList();
        for (int i = 0; i < 100; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    for (int j = 0; j < 10; ++j) {
                        try {
                            DFSTestUtil.createFile((FileSystem)fs, new Path("File_" + this.getName() + j), 10L, (short)1, 0L);
                            continue;
                        }
                        catch (IOException | IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            thread.setName("FileWriter" + i);
            futureList.add(pool.submit(thread));
        }
        for (Future future : futureList) {
            future.get();
        }
        fs.close();
        FsDatasetImpl fsDataset = (FsDatasetImpl)cluster.getDataNodes().get(0).getFSDataset();
        ReplicaMap replicaMap = new ReplicaMap(new AutoCloseableLock());
        RamDiskReplicaTracker ramDiskReplicaMap = RamDiskReplicaTracker.getInstance((Configuration)this.conf, (FsDatasetImpl)fsDataset);
        FsVolumeImpl vol = (FsVolumeImpl)fsDataset.getFsVolumeReferences().get(0);
        String bpid = cluster.getNamesystem().getBlockPoolId();
        vol.getVolumeMap(bpid, replicaMap, ramDiskReplicaMap);
        Assert.assertTrue((String)"Failed to add all the replica to map", (replicaMap.replicas(bpid).size() == 1000 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Fork pool should be initialize with configured pool size", (long)poolSize, (long)BlockPoolSlice.getAddReplicaForkPoolSize());
    }

    @Test(timeout=60000L)
    public void testInstanceOfAddReplicaThreadPool() throws Exception {
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(1).build();){
            cluster.waitActive();
            FsDatasetImpl fsDataset = (FsDatasetImpl)cluster.getDataNodes().get(0).getFSDataset();
            FsVolumeImpl vol = (FsVolumeImpl)fsDataset.getFsVolumeReferences().get(0);
            ForkJoinPool threadPool1 = vol.getBlockPoolSlice(cluster.getNamesystem(0).getBlockPoolId()).getAddReplicaThreadPool();
            ForkJoinPool threadPool2 = vol.getBlockPoolSlice(cluster.getNamesystem(1).getBlockPoolId()).getAddReplicaThreadPool();
            Assert.assertEquals((String)"Thread pool instance should be same in all the BlockPoolSlice", (Object)threadPool1, (Object)threadPool2);
        }
    }
}

