/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithUpgradeDomain;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.CombinedHostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUpgradeDomainBlockPlacementPolicy {
    private static final short REPLICATION_FACTOR = 3;
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    static final String[] racks = new String[]{"/RACK1", "/RACK1", "/RACK1", "/RACK2", "/RACK2", "/RACK2"};
    static final String[] hosts = new String[]{"host1", "host2", "host3", "host4", "host5", "host6"};
    static final String[] upgradeDomains = new String[]{"ud5", "ud2", "ud3", "ud1", "ud2", "ud4"};
    static final Set<DatanodeID> expectedDatanodeIDs = new HashSet<DatanodeID>();
    private MiniDFSCluster cluster = null;
    private NamenodeProtocols nameNodeRpc = null;
    private FSNamesystem namesystem = null;
    private PermissionStatus perm = null;
    private HostsFileWriter hostsFileWriter = new HostsFileWriter();

    @Before
    public void setup() throws IOException {
        StaticMapping.resetMap();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.bytes-per-checksum", 512);
        conf.setClass("dfs.block.replicator.classname", BlockPlacementPolicyWithUpgradeDomain.class, BlockPlacementPolicy.class);
        conf.setClass("dfs.namenode.hosts.provider.classname", CombinedHostFileManager.class, HostConfigManager.class);
        this.hostsFileWriter.initialize((Configuration)conf, "temp/upgradedomainpolicy");
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(6).racks(racks).hosts(hosts).build();
        this.cluster.waitActive();
        this.nameNodeRpc = this.cluster.getNameNodeRpc();
        this.namesystem = this.cluster.getNamesystem();
        this.perm = new PermissionStatus("TestDefaultBlockPlacementPolicy", null, FsPermission.getDefault());
        this.refreshDatanodeAdminProperties();
    }

    @After
    public void teardown() throws IOException {
        this.hostsFileWriter.cleanup();
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void refreshDatanodeAdminProperties() throws IOException {
        DatanodeAdminProperties[] datanodes = new DatanodeAdminProperties[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            datanodes[i] = new DatanodeAdminProperties();
            DatanodeID datanodeID = this.cluster.getDataNodes().get(i).getDatanodeId();
            datanodes[i].setHostName(datanodeID.getIpAddr());
            datanodes[i].setPort(datanodeID.getXferPort());
            datanodes[i].setUpgradeDomain(upgradeDomains[i]);
        }
        datanodes[0].setAdminState(DatanodeInfo.AdminStates.DECOMMISSIONED);
        datanodes[5].setAdminState(DatanodeInfo.AdminStates.DECOMMISSIONED);
        this.hostsFileWriter.initIncludeHosts(datanodes);
        this.cluster.getFileSystem().refreshNodes();
        expectedDatanodeIDs.clear();
        expectedDatanodeIDs.add(this.cluster.getDataNodes().get(2).getDatanodeId());
        expectedDatanodeIDs.add(this.cluster.getDataNodes().get(3).getDatanodeId());
    }

    private void refreshDatanodeAdminProperties2() throws IOException {
        DatanodeAdminProperties[] datanodes = new DatanodeAdminProperties[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            datanodes[i] = new DatanodeAdminProperties();
            DatanodeID datanodeID = this.cluster.getDataNodes().get(i).getDatanodeId();
            datanodes[i].setHostName(datanodeID.getIpAddr());
            datanodes[i].setPort(datanodeID.getXferPort());
            datanodes[i].setUpgradeDomain(upgradeDomains[i]);
        }
        datanodes[2].setAdminState(DatanodeInfo.AdminStates.DECOMMISSIONED);
        datanodes[3].setAdminState(DatanodeInfo.AdminStates.DECOMMISSIONED);
        this.hostsFileWriter.initIncludeHosts(datanodes);
        this.cluster.getFileSystem().refreshNodes();
        expectedDatanodeIDs.clear();
        expectedDatanodeIDs.add(this.cluster.getDataNodes().get(0).getDatanodeId());
        expectedDatanodeIDs.add(this.cluster.getDataNodes().get(5).getDatanodeId());
    }

    @Test
    public void testPlacement() throws Exception {
        long fileSize = 5120L;
        String testFile = new String("/testfile");
        Path path = new Path(testFile);
        DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(), path, 5120L, (short)3, 1000L);
        LocatedBlocks locatedBlocks = this.cluster.getFileSystem().getClient().getLocatedBlocks(path.toString(), 0L, 5120L);
        for (LocatedBlock block : locatedBlocks.getLocatedBlocks()) {
            HashSet<DatanodeInfo> locs = new HashSet<DatanodeInfo>();
            for (DatanodeInfo datanodeInfo : block.getLocations()) {
                if (datanodeInfo.getAdminState() != DatanodeInfo.AdminStates.NORMAL) continue;
                locs.add(datanodeInfo);
            }
            for (DatanodeID datanodeID : expectedDatanodeIDs) {
                Assert.assertTrue((boolean)locs.contains(datanodeID));
            }
        }
    }

    @Test(timeout=300000L)
    public void testPlacementAfterDecommission() throws Exception {
        long fileSize = 5120L;
        String testFile = new String("/testfile");
        final Path path = new Path(testFile);
        DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(), path, 5120L, (short)3, 1000L);
        this.refreshDatanodeAdminProperties2();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                LocatedBlocks locatedBlocks;
                boolean successful = true;
                try {
                    locatedBlocks = TestUpgradeDomainBlockPlacementPolicy.this.cluster.getFileSystem().getClient().getLocatedBlocks(path.toString(), 0L, 5120L);
                }
                catch (IOException ioe) {
                    return false;
                }
                for (LocatedBlock block : locatedBlocks.getLocatedBlocks()) {
                    HashSet<DatanodeInfo> locs = new HashSet<DatanodeInfo>();
                    for (DatanodeInfo datanodeInfo : block.getLocations()) {
                        if (datanodeInfo.getAdminState() != DatanodeInfo.AdminStates.NORMAL) continue;
                        locs.add(datanodeInfo);
                    }
                    for (DatanodeID datanodeID : expectedDatanodeIDs) {
                        successful = successful && locs.contains(datanodeID);
                    }
                }
                return successful;
            }
        }, (long)1000L, (long)60000L);
        LocatedBlocks locatedBlocks = this.cluster.getFileSystem().getClient().getLocatedBlocks(path.toString(), 0L, 5120L);
        for (LocatedBlock block : locatedBlocks.getLocatedBlocks()) {
            BlockPlacementStatus status = this.cluster.getNamesystem().getBlockManager().getBlockPlacementPolicy().verifyBlockPlacement(block.getLocations(), 3);
            Assert.assertTrue((boolean)status.isPlacementPolicySatisfied());
        }
    }
}

