/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.log.LogThrottlingHelper;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;
import org.apache.hadoop.util.Timer;

class FSNamesystemLock {
    @VisibleForTesting
    protected ReentrantReadWriteLock coarseLock;
    private final boolean metricsEnabled;
    private final MutableRatesWithAggregation detailedHoldTimeMetrics;
    private final Timer timer;
    private final long lockSuppressWarningIntervalMs;
    private final long writeLockReportingThresholdMs;
    private long writeLockHeldTimeStampNanos;
    private final LogThrottlingHelper writeLockReportLogger;
    private final long readLockReportingThresholdMs;
    private final ThreadLocal<Long> readLockHeldTimeStampNanos = new ThreadLocal<Long>(){

        @Override
        public Long initialValue() {
            return Long.MAX_VALUE;
        }
    };
    private final AtomicInteger numReadLockWarningsSuppressed = new AtomicInteger(0);
    private final AtomicLong timeStampOfLastReadLockReportMs = new AtomicLong(0L);
    private final AtomicLong longestReadLockHeldIntervalMs = new AtomicLong(0L);
    @VisibleForTesting
    static final String OP_NAME_OTHER = "OTHER";
    private static final String READ_LOCK_METRIC_PREFIX = "FSNReadLock";
    private static final String WRITE_LOCK_METRIC_PREFIX = "FSNWriteLock";
    private static final String LOCK_METRIC_SUFFIX = "Nanos";
    private static final String OVERALL_METRIC_NAME = "Overall";

    FSNamesystemLock(Configuration conf, MutableRatesWithAggregation detailedHoldTimeMetrics) {
        this(conf, detailedHoldTimeMetrics, new Timer());
    }

    @VisibleForTesting
    FSNamesystemLock(Configuration conf, MutableRatesWithAggregation detailedHoldTimeMetrics, Timer timer) {
        boolean fair = conf.getBoolean("dfs.namenode.fslock.fair", true);
        FSNamesystem.LOG.info("fsLock is fair: " + fair);
        this.coarseLock = new ReentrantReadWriteLock(fair);
        this.timer = timer;
        this.writeLockReportingThresholdMs = conf.getLong("dfs.namenode.write-lock-reporting-threshold-ms", 5000L);
        this.readLockReportingThresholdMs = conf.getLong("dfs.namenode.read-lock-reporting-threshold-ms", 5000L);
        this.lockSuppressWarningIntervalMs = conf.getTimeDuration("dfs.lock.suppress.warning.interval", 10000L, TimeUnit.MILLISECONDS);
        this.writeLockReportLogger = new LogThrottlingHelper(this.lockSuppressWarningIntervalMs);
        this.metricsEnabled = conf.getBoolean("dfs.namenode.lock.detailed-metrics.enabled", false);
        FSNamesystem.LOG.info("Detailed lock hold time metrics enabled: " + this.metricsEnabled);
        this.detailedHoldTimeMetrics = detailedHoldTimeMetrics;
    }

    public void readLock() {
        this.doLock(false);
    }

    public void readLockInterruptibly() throws InterruptedException {
        this.doLockInterruptibly(false);
    }

    public void readUnlock() {
        this.readUnlock(OP_NAME_OTHER);
    }

    public void readUnlock(String opName) {
        boolean needReport = this.coarseLock.getReadHoldCount() == 1;
        long readLockIntervalNanos = this.timer.monotonicNowNanos() - this.readLockHeldTimeStampNanos.get();
        this.coarseLock.readLock().unlock();
        if (needReport) {
            this.addMetric(opName, readLockIntervalNanos, false);
            this.readLockHeldTimeStampNanos.remove();
        }
        long readLockIntervalMs = TimeUnit.NANOSECONDS.toMillis(readLockIntervalNanos);
        if (needReport && readLockIntervalMs >= this.readLockReportingThresholdMs) {
            long nowMs;
            long localTimeStampOfLastReadLockReport;
            long localLongestReadLock;
            while ((localLongestReadLock = this.longestReadLockHeldIntervalMs.get()) - readLockIntervalMs < 0L && !this.longestReadLockHeldIntervalMs.compareAndSet(localLongestReadLock, readLockIntervalMs)) {
            }
            do {
                if ((nowMs = this.timer.monotonicNow()) - (localTimeStampOfLastReadLockReport = this.timeStampOfLastReadLockReportMs.get()) >= this.lockSuppressWarningIntervalMs) continue;
                this.numReadLockWarningsSuppressed.incrementAndGet();
                return;
            } while (!this.timeStampOfLastReadLockReportMs.compareAndSet(localTimeStampOfLastReadLockReport, nowMs));
            int numSuppressedWarnings = this.numReadLockWarningsSuppressed.getAndSet(0);
            long longestLockHeldIntervalMs = this.longestReadLockHeldIntervalMs.getAndSet(0L);
            FSNamesystem.LOG.info("FSNamesystem read lock held for " + readLockIntervalMs + " ms via\n" + org.apache.hadoop.util.StringUtils.getStackTrace((Thread)Thread.currentThread()) + "\tNumber of suppressed read-lock reports: " + numSuppressedWarnings + "\n\tLongest read-lock held interval: " + longestLockHeldIntervalMs);
        }
    }

    public void writeLock() {
        this.doLock(true);
    }

    public void writeLockInterruptibly() throws InterruptedException {
        this.doLockInterruptibly(true);
    }

    public void writeUnlock() {
        this.writeUnlock(OP_NAME_OTHER, false);
    }

    public void writeUnlock(String opName) {
        this.writeUnlock(opName, false);
    }

    public void writeUnlock(String opName, boolean suppressWriteLockReport) {
        boolean needReport = !suppressWriteLockReport && this.coarseLock.getWriteHoldCount() == 1 && this.coarseLock.isWriteLockedByCurrentThread();
        long currentTimeNanos = this.timer.monotonicNowNanos();
        long writeLockIntervalNanos = currentTimeNanos - this.writeLockHeldTimeStampNanos;
        long currentTimeMs = TimeUnit.NANOSECONDS.toMillis(currentTimeNanos);
        long writeLockIntervalMs = TimeUnit.NANOSECONDS.toMillis(writeLockIntervalNanos);
        LogThrottlingHelper.LogAction logAction = LogThrottlingHelper.DO_NOT_LOG;
        if (needReport && writeLockIntervalMs >= this.writeLockReportingThresholdMs) {
            logAction = this.writeLockReportLogger.record("write", currentTimeMs, new double[]{writeLockIntervalMs});
        }
        this.coarseLock.writeLock().unlock();
        if (needReport) {
            this.addMetric(opName, writeLockIntervalNanos, true);
        }
        if (logAction.shouldLog()) {
            FSNamesystem.LOG.info("FSNamesystem write lock held for {} ms via {}\tNumber of suppressed write-lock reports: {}\n\tLongest write-lock held interval: {} \n\tTotal suppressed write-lock held time: {}", new Object[]{writeLockIntervalMs, org.apache.hadoop.util.StringUtils.getStackTrace((Thread)Thread.currentThread()), logAction.getCount() - 1, logAction.getStats(0).getMax(), logAction.getStats(0).getSum() - (double)writeLockIntervalMs});
        }
    }

    public int getReadHoldCount() {
        return this.coarseLock.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.coarseLock.getWriteHoldCount();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.coarseLock.isWriteLockedByCurrentThread();
    }

    public Condition newWriteLockCondition() {
        return this.coarseLock.writeLock().newCondition();
    }

    public int getQueueLength() {
        return this.coarseLock.getQueueLength();
    }

    private void addMetric(String operationName, long value, boolean isWrite) {
        if (this.metricsEnabled) {
            String opMetric = FSNamesystemLock.getMetricName(operationName, isWrite);
            this.detailedHoldTimeMetrics.add(opMetric, value);
            String overallMetric = FSNamesystemLock.getMetricName(OVERALL_METRIC_NAME, isWrite);
            this.detailedHoldTimeMetrics.add(overallMetric, value);
        }
        FSNamesystemLock.updateProcessingDetails(isWrite ? ProcessingDetails.Timing.LOCKEXCLUSIVE : ProcessingDetails.Timing.LOCKSHARED, value);
    }

    private void doLock(boolean isWrite) {
        long startNanos = this.timer.monotonicNowNanos();
        if (isWrite) {
            this.coarseLock.writeLock().lock();
        } else {
            this.coarseLock.readLock().lock();
        }
        this.updateLockWait(startNanos, isWrite);
    }

    private void doLockInterruptibly(boolean isWrite) throws InterruptedException {
        long startNanos = this.timer.monotonicNowNanos();
        if (isWrite) {
            this.coarseLock.writeLock().lockInterruptibly();
        } else {
            this.coarseLock.readLock().lockInterruptibly();
        }
        this.updateLockWait(startNanos, isWrite);
    }

    private void updateLockWait(long startNanos, boolean isWrite) {
        long now = this.timer.monotonicNowNanos();
        FSNamesystemLock.updateProcessingDetails(ProcessingDetails.Timing.LOCKWAIT, now - startNanos);
        if (isWrite) {
            if (this.coarseLock.getWriteHoldCount() == 1) {
                this.writeLockHeldTimeStampNanos = now;
            }
        } else if (this.coarseLock.getReadHoldCount() == 1) {
            this.readLockHeldTimeStampNanos.set(now);
        }
    }

    private static void updateProcessingDetails(ProcessingDetails.Timing type, long deltaNanos) {
        Server.Call call = (Server.Call)Server.getCurCall().get();
        if (call != null) {
            call.getProcessingDetails().add(type, deltaNanos, TimeUnit.NANOSECONDS);
        }
    }

    private static String getMetricName(String operationName, boolean isWrite) {
        return (isWrite ? WRITE_LOCK_METRIC_PREFIX : READ_LOCK_METRIC_PREFIX) + StringUtils.capitalize((String)operationName) + LOCK_METRIC_SUFFIX;
    }
}

