/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.junit.Test;

public class TestDFSStripedOutputStreamUpdatePipeline {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSStripedOutputStreamUpdatePipeline() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 0x100000L);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(5).build();){
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/test");
            dfs.mkdirs(dir);
            dfs.enableErasureCodingPolicy("RS-3-2-1024k");
            dfs.setErasureCodingPolicy(dir, "RS-3-2-1024k");
            Path filePath = new Path("/test/file");
            FSDataOutputStream out = dfs.create(filePath);
            try {
                int i = 0;
                while ((long)i < Long.MAX_VALUE) {
                    out.write(i);
                    if (i == 0x500000) {
                        cluster.stopDataNode(0);
                        cluster.stopDataNode(1);
                        cluster.stopDataNode(2);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                dfs.delete(filePath, true);
            }
            finally {
                IOUtils.closeStream((Closeable)out);
            }
        }
    }
}

