/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeRpcServer;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.security.authorize.Service;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestHDFSPolicyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestHDFSPolicyProvider.class);
    private static Set<Class<?>> policyProviderProtocols;
    private static final Comparator<Class<?>> CLASS_NAME_COMPARATOR;
    @Rule
    public TestName testName = new TestName();
    private final Class<?> rpcServerClass;

    @BeforeClass
    public static void initialize() {
        Service[] services = new HDFSPolicyProvider().getServices();
        policyProviderProtocols = new HashSet(services.length);
        for (Service service : services) {
            policyProviderProtocols.add(service.getProtocol());
        }
    }

    public TestHDFSPolicyProvider(Class<?> rpcServerClass) {
        this.rpcServerClass = rpcServerClass;
    }

    @Parameterized.Parameters(name="protocolsForServer-{0}")
    public static List<Class<?>[]> data() {
        return Arrays.asList({NameNodeRpcServer.class}, {DataNode.class}, {JournalNodeRpcServer.class});
    }

    @Test
    public void testPolicyProviderForServer() {
        List ifaces = ClassUtils.getAllInterfaces(this.rpcServerClass);
        HashSet<Class> serverProtocols = new HashSet<Class>(ifaces.size());
        for (Object obj : ifaces) {
            Class iface = (Class)obj;
            if (!iface.getSimpleName().endsWith("Protocol")) continue;
            serverProtocols.add(iface);
        }
        LOG.info("Running test {} for RPC server {}.  Found server protocols {} and policy provider protocols {}.", new Object[]{this.testName.getMethodName(), this.rpcServerClass.getName(), serverProtocols, policyProviderProtocols});
        Assert.assertFalse((String)"Expected to find at least one protocol in server.", (boolean)serverProtocols.isEmpty());
        Sets.SetView differenceSet = Sets.difference(serverProtocols, policyProviderProtocols);
        Assert.assertTrue((String)String.format("Following protocols for server %s are not defined in %s: %s", this.rpcServerClass.getName(), HDFSPolicyProvider.class.getName(), Arrays.toString(differenceSet.toArray())), (boolean)differenceSet.isEmpty());
    }

    static {
        CLASS_NAME_COMPARATOR = new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> lhs, Class<?> rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        };
    }
}

