/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.blockaliasmap.impl;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMap;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryLevelDBAliasMapServer;
import org.apache.hadoop.hdfs.server.common.BlockAlias;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.impl.InMemoryLevelDBAliasMapClient;
import org.assertj.core.api.AssertionsForClassTypes;
import org.iq80.leveldb.DBException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLevelDbMockAliasMapClient {
    private InMemoryLevelDBAliasMapServer levelDBAliasMapServer;
    private InMemoryLevelDBAliasMapClient inMemoryLevelDBAliasMapClient;
    private File tempDir;
    private Configuration conf;
    private InMemoryAliasMap aliasMapMock;
    private final String bpid = "BPID-0";

    @Before
    public void setUp() throws IOException {
        this.aliasMapMock = (InMemoryAliasMap)Mockito.mock(InMemoryAliasMap.class);
        Mockito.when((Object)this.aliasMapMock.getBlockPoolId()).thenReturn((Object)"BPID-0");
        this.levelDBAliasMapServer = new InMemoryLevelDBAliasMapServer((config, blockPoolID) -> this.aliasMapMock, "BPID-0");
        this.conf = new Configuration();
        int port = 9877;
        this.conf.set("dfs.provided.aliasmap.inmemory.dnrpc-address", "localhost:" + port);
        this.tempDir = Files.createTempDir();
        this.conf.set("dfs.provided.aliasmap.inmemory.leveldb.dir", this.tempDir.getAbsolutePath());
        this.levelDBAliasMapServer.setConf(this.conf);
        this.levelDBAliasMapServer.start();
        this.inMemoryLevelDBAliasMapClient = new InMemoryLevelDBAliasMapClient();
        this.inMemoryLevelDBAliasMapClient.setConf(this.conf);
    }

    @After
    public void tearDown() throws IOException {
        this.levelDBAliasMapServer.close();
        this.inMemoryLevelDBAliasMapClient.close();
        FileUtils.deleteDirectory((File)this.tempDir);
    }

    @Test
    public void readFailure() throws Exception {
        Block block = new Block(42L, 43L, 44L);
        ((InMemoryAliasMap)Mockito.doThrow((Throwable)new IOException()).doThrow((Throwable)new DBException()).when((Object)this.aliasMapMock)).read(block);
        AssertionsForClassTypes.assertThatExceptionOfType(IOException.class).isThrownBy(() -> this.inMemoryLevelDBAliasMapClient.getReader(null, "BPID-0").resolve(block));
        AssertionsForClassTypes.assertThatExceptionOfType(IOException.class).isThrownBy(() -> this.inMemoryLevelDBAliasMapClient.getReader(null, "BPID-0").resolve(block));
    }

    @Test
    public void writeFailure() throws IOException {
        Block block = new Block(42L, 43L, 44L);
        byte[] nonce = new byte[]{};
        Path path = new Path("koekoek");
        ProvidedStorageLocation providedStorageLocation = new ProvidedStorageLocation(path, 45L, 46L, nonce);
        ((InMemoryAliasMap)Mockito.doThrow((Throwable)new IOException()).when((Object)this.aliasMapMock)).write(block, providedStorageLocation);
        AssertionsForClassTypes.assertThatExceptionOfType(IOException.class).isThrownBy(() -> this.inMemoryLevelDBAliasMapClient.getWriter(null, "BPID-0").store((BlockAlias)new FileRegion(block, providedStorageLocation)));
        AssertionsForClassTypes.assertThatExceptionOfType(IOException.class).isThrownBy(() -> this.inMemoryLevelDBAliasMapClient.getWriter(null, "BPID-0").store((BlockAlias)new FileRegion(block, providedStorageLocation)));
    }
}

