/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.test.GenericTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class TestLazyPersistLockedMemory
extends LazyPersistTestCase {
    @Test
    public void testWithNoLockedMemory() throws IOException, TimeoutException, InterruptedException {
        this.getClusterBuilder().setNumDatanodes(1).setMaxLockedMemory(0L).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path, StorageType.DEFAULT);
    }

    @Test
    public void testReservation() throws IOException, TimeoutException, InterruptedException {
        this.getClusterBuilder().setNumDatanodes(1).setMaxLockedMemory(0x500000L).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        FsDatasetSpi fsd = this.cluster.getDataNodes().get(0).getFSDataset();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        Assert.assertThat((Object)fsd.getCacheUsed(), (Matcher)Is.is((Object)0x500000L));
    }

    @Test
    public void testReleaseOnFileDeletion() throws IOException, TimeoutException, InterruptedException {
        this.getClusterBuilder().setNumDatanodes(1).setMaxLockedMemory(0x500000L).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        FsDatasetSpi fsd = this.cluster.getDataNodes().get(0).getFSDataset();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        Assert.assertThat((Object)fsd.getCacheUsed(), (Matcher)Is.is((Object)0x500000L));
        this.fs.delete(path, false);
        DataNodeTestUtils.triggerBlockReport(this.cluster.getDataNodes().get(0));
        this.waitForLockedBytesUsed(fsd, 0L);
    }

    @Test
    public void testReleaseOnEviction() throws Exception {
        this.getClusterBuilder().setNumDatanodes(1).setMaxLockedMemory(0x500000L).setRamDiskReplicaCapacity(0x9FFFFF).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        FsDatasetImpl fsd = (FsDatasetImpl)this.cluster.getDataNodes().get(0).getFSDataset();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        Assert.assertThat((Object)fsd.getCacheUsed(), (Matcher)Is.is((Object)0x500000L));
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        fsd.evictLazyPersistBlocks(Long.MAX_VALUE);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvicted", 1L);
        this.waitForLockedBytesUsed((FsDatasetSpi<?>)fsd, 0L);
    }

    @Test
    public void testShortBlockFinalized() throws IOException, TimeoutException, InterruptedException {
        this.getClusterBuilder().setNumDatanodes(1).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        FsDatasetSpi fsd = this.cluster.getDataNodes().get(0).getFSDataset();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 1L, true);
        Assert.assertThat((Object)fsd.getCacheUsed(), (Matcher)Is.is((Object)this.osPageSize));
        this.fs.delete(path, false);
        this.waitForLockedBytesUsed(fsd, 0L);
    }

    @Test
    public void testWritePipelineFailure() throws IOException, TimeoutException, InterruptedException {
        this.getClusterBuilder().setNumDatanodes(1).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        FsDatasetSpi fsd = this.cluster.getDataNodes().get(0).getFSDataset();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        EnumSet<CreateFlag> createFlags = EnumSet.of(CreateFlag.CREATE, CreateFlag.LAZY_PERSIST);
        FSDataOutputStream fos = this.fs.create(path, FsPermission.getFileDefault(), createFlags, 4096, (short)1, 0x500000L, null);
        fos.write(new byte[1]);
        fos.hsync();
        DFSTestUtil.abortStream((DFSOutputStream)fos.getWrappedStream());
        this.waitForLockedBytesUsed(fsd, this.osPageSize);
        this.fs.delete(path, false);
        DataNodeTestUtils.triggerBlockReport(this.cluster.getDataNodes().get(0));
        this.waitForLockedBytesUsed(fsd, 0L);
    }

    private void waitForLockedBytesUsed(final FsDatasetSpi<?> fsd, final long expectedLockedBytes) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                long cacheUsed = fsd.getCacheUsed();
                LazyPersistTestCase.LOG.info("cacheUsed=" + cacheUsed + ", waiting for it to be " + expectedLockedBytes);
                if (cacheUsed < 0L) {
                    throw new IllegalStateException("cacheUsed unpexpectedly negative");
                }
                return cacheUsed == expectedLockedBytes;
            }
        }, (long)1000L, (long)300000L);
    }
}

