/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.tools.JMXGet;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class LazyPersistTestCase {
    static final byte LAZY_PERSIST_POLICY_ID = 15;
    protected static final Logger LOG;
    protected static final int BLOCK_SIZE = 0x500000;
    protected static final int BUFFER_LENGTH = 4096;
    protected static final int LAZY_WRITE_FILE_SCRUBBER_INTERVAL_SEC = 3;
    protected static final int LAZY_WRITER_INTERVAL_SEC = 1;
    protected static final short REPL_FACTOR = 1;
    private static final String JMX_RAM_DISK_METRICS_PATTERN = "^RamDisk";
    private static final String JMX_SERVICE_NAME = "DataNode";
    private static final long HEARTBEAT_INTERVAL_SEC = 1L;
    private static final int HEARTBEAT_RECHECK_INTERVAL_MS = 500;
    private static final long WAIT_FOR_FBR_MS;
    private static final long WAIT_FOR_STORAGE_TYPES_MS;
    private static final long WAIT_FOR_ASYNC_DELETE_MS;
    private static final long WAIT_FOR_DN_SHUTDOWN_MS;
    private static final long WAIT_FOR_REDUNDANCY_MS;
    private static final long WAIT_FOR_LAZY_SCRUBBER_MS;
    private static final long WAIT_POLL_INTERVAL_MS = 10L;
    private static final long WAIT_POLL_INTERVAL_LARGE_MS = 20L;
    protected final long osPageSize = NativeIO.POSIX.getCacheManipulator().getOperatingSystemPageSize();
    protected MiniDFSCluster cluster;
    protected DistributedFileSystem fs;
    protected DFSClient client;
    protected JMXGet jmx;
    protected TemporarySocketDirectory sockDir;
    @Rule
    public Timeout timeout = Timeout.seconds((long)300L);

    @After
    public void shutDownCluster() throws Exception {
        this.printRamDiskJMXMetrics();
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
            this.client = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdownDataNodes();
            this.cluster.shutdown();
            this.cluster = null;
        }
        if (this.jmx != null) {
            this.jmx = null;
        }
        IOUtils.closeQuietly((Closeable)this.sockDir);
        this.sockDir = null;
    }

    protected final LocatedBlocks ensureFileReplicasOnStorageType(Path path, StorageType storageType) throws IOException, TimeoutException, InterruptedException {
        LOG.info("Ensure path: {} is on StorageType: {}", (Object)path, (Object)storageType);
        Assert.assertThat((Object)this.fs.exists(path), (Matcher)Is.is((Object)true));
        long fileLength = this.client.getFileInfo(path.toString()).getLen();
        GenericTestUtils.waitFor(() -> {
            try {
                LocatedBlocks locatedBlocks = this.client.getLocatedBlocks(path.toString(), 0L, fileLength);
                for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
                    if (locatedBlock.getStorageTypes()[0] == storageType) continue;
                    return false;
                }
                return true;
            }
            catch (IOException ioe) {
                LOG.warn("Exception got in ensureFileReplicasOnStorageType()", (Throwable)ioe);
                return false;
            }
        }, (long)10L, (long)WAIT_FOR_STORAGE_TYPES_MS);
        return this.client.getLocatedBlocks(path.toString(), 0L, fileLength);
    }

    protected final void ensureLazyPersistBlocksAreSaved(LocatedBlocks locatedBlocks) throws IOException, InterruptedException, TimeoutException {
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        HashSet persistedBlockIds = new HashSet();
        try (FsDatasetSpi.FsVolumeReferences volumes = this.cluster.getDataNodes().get(0).getFSDataset().getFsVolumeReferences();){
            GenericTestUtils.waitFor(() -> {
                for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                    for (FsVolumeSpi v : volumes) {
                        File lazyPersistDir;
                        if (v.isTransientStorage()) continue;
                        FsVolumeImpl volume = (FsVolumeImpl)v;
                        try {
                            lazyPersistDir = volume.getBlockPoolSlice(bpid).getLazypersistDir();
                        }
                        catch (IOException ioe) {
                            return false;
                        }
                        long blockId = lb.getBlock().getBlockId();
                        File targetDir = DatanodeUtil.idToBlockDir((File)lazyPersistDir, (long)blockId);
                        File blockFile = new File(targetDir, lb.getBlock().getBlockName());
                        if (!blockFile.exists()) continue;
                        persistedBlockIds.add(blockId);
                    }
                }
                return persistedBlockIds.size() == locatedBlocks.getLocatedBlocks().size();
            }, (long)20L, (long)WAIT_FOR_STORAGE_TYPES_MS);
        }
    }

    protected final void makeRandomTestFile(Path path, long length, boolean isLazyPersist, long seed) throws IOException {
        DFSTestUtil.createFile((FileSystem)this.fs, path, isLazyPersist, 4096, length, 0x500000L, (short)1, seed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void makeTestFile(Path path, long length, boolean isLazyPersist) throws IOException {
        EnumSet<CreateFlag> createFlags = EnumSet.of(CreateFlag.CREATE);
        if (isLazyPersist) {
            createFlags.add(CreateFlag.LAZY_PERSIST);
        }
        FSDataOutputStream fos = null;
        try {
            fos = this.fs.create(path, FsPermission.getFileDefault(), createFlags, 4096, (short)1, 0x500000L, null);
            byte[] buffer = new byte[4096];
            int bytesWritten = 0;
            while ((long)bytesWritten < length) {
                fos.write(buffer, 0, buffer.length);
                bytesWritten += buffer.length;
            }
            if (length > 0L) {
                fos.hsync();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    protected final void startUpCluster(int numDatanodes, boolean hasTransientStorage, StorageType[] storageTypes, int ramDiskReplicaCapacity, long ramDiskStorageLimit, long maxLockedMemory, boolean useSCR, boolean useLegacyBlockReaderLocal, boolean disableScrubber) throws IOException {
        StorageType[] storageTypeArray;
        LazyPersistTestCase.initCacheManipulator();
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 0x500000L);
        if (disableScrubber) {
            conf.setInt("dfs.namenode.lazypersist.file.scrub.interval.sec", 0);
        } else {
            conf.setInt("dfs.namenode.lazypersist.file.scrub.interval.sec", 3);
        }
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setInt("dfs.datanode.lazywriter.interval.sec", 1);
        conf.setInt("dfs.namenode.safemode.min.datanodes", 1);
        conf.setLong("dfs.datanode.max.locked.memory", maxLockedMemory);
        if (useSCR) {
            conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
            conf.set("dfs.client.context", UUID.randomUUID().toString());
            conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
            if (useLegacyBlockReaderLocal) {
                conf.setBoolean("dfs.client.use.legacy.blockreader.local", true);
            } else {
                this.sockDir = new TemporarySocketDirectory();
                conf.set("dfs.domain.socket.path", new File(this.sockDir.getDir(), this.getClass().getSimpleName() + "._PORT.sock").getAbsolutePath());
            }
        }
        Preconditions.checkState((ramDiskReplicaCapacity < 0 || ramDiskStorageLimit < 0L ? 1 : 0) != 0, (Object)"Cannot specify non-default values for both ramDiskReplicaCapacity and ramDiskStorageLimit");
        if (hasTransientStorage && ramDiskReplicaCapacity >= 0) {
            ramDiskStorageLimit = (long)ramDiskReplicaCapacity * 0x500000L + 0x4FFFFFL;
        }
        long[] capacities = new long[]{ramDiskStorageLimit, -1L};
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf).numDataNodes(numDatanodes).storageCapacities(capacities);
        if (storageTypes != null) {
            storageTypeArray = storageTypes;
        } else if (hasTransientStorage) {
            StorageType[] storageTypeArray2 = new StorageType[2];
            storageTypeArray2[0] = StorageType.RAM_DISK;
            storageTypeArray = storageTypeArray2;
            storageTypeArray2[1] = StorageType.DEFAULT;
        } else {
            storageTypeArray = null;
        }
        this.cluster = builder.storageTypes(storageTypeArray).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.client = this.fs.getClient();
        try {
            this.jmx = this.initJMX();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed initialize JMX for testing: " + e));
        }
        LOG.info("Cluster startup complete");
    }

    public static void initCacheManipulator() {
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)new NativeIO.POSIX.CacheManipulator(){

            public void mlock(String identifier, ByteBuffer mmap, long length) throws IOException {
                LOG.info("LazyPersistTestCase: faking mlock of {} bytes.", (Object)identifier);
            }

            public long getMemlockLimit() {
                LOG.info("LazyPersistTestCase: fake return {}", (Object)Long.MAX_VALUE);
                return Long.MAX_VALUE;
            }

            public boolean verifyCanMlock() {
                LOG.info("LazyPersistTestCase: fake return {}", (Object)true);
                return true;
            }
        });
    }

    ClusterWithRamDiskBuilder getClusterBuilder() {
        return new ClusterWithRamDiskBuilder();
    }

    protected final void triggerBlockReport() throws InterruptedException, TimeoutException, IOException {
        HashMap<DatanodeStorageInfo, Integer> reportCountsBefore = new HashMap<DatanodeStorageInfo, Integer>();
        FSNamesystem fsn = this.cluster.getNamesystem();
        for (DataNode dn : this.cluster.getDataNodes()) {
            DatanodeDescriptor dnd = NameNodeAdapter.getDatanode(fsn, dn.getDatanodeId());
            DatanodeStorageInfo storage = dnd.getStorageInfos()[0];
            reportCountsBefore.put(storage, storage.getBlockReportCount());
            DataNodeTestUtils.triggerBlockReport(dn);
        }
        GenericTestUtils.waitFor(() -> {
            for (Map.Entry reportEntry : reportCountsBefore.entrySet()) {
                int currentCnt;
                DatanodeStorageInfo dnStorageInfo = (DatanodeStorageInfo)reportEntry.getKey();
                int cntBefore = (Integer)reportEntry.getValue();
                if (cntBefore != (currentCnt = dnStorageInfo.getBlockReportCount())) continue;
                return false;
            }
            return true;
        }, (long)10L, (long)WAIT_FOR_FBR_MS);
    }

    protected final boolean verifyBlockDeletedFromDir(File dir, LocatedBlocks locatedBlocks) {
        for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
            File targetDir = DatanodeUtil.idToBlockDir((File)dir, (long)lb.getBlock().getBlockId());
            File blockFile = new File(targetDir, lb.getBlock().getBlockName());
            if (blockFile.exists()) {
                return false;
            }
            File metaFile = new File(targetDir, DatanodeUtil.getMetaName((String)lb.getBlock().getBlockName(), (long)lb.getBlock().getGenerationStamp()));
            if (!metaFile.exists()) continue;
            return false;
        }
        return true;
    }

    protected final boolean verifyDeletedBlocks(LocatedBlocks locatedBlocks) throws Exception {
        LOG.info("Verifying replica has no saved copy after deletion.");
        this.triggerBlockReport();
        DataNode dn = this.cluster.getDataNodes().get(0);
        GenericTestUtils.waitFor(() -> {
            for (DataNode dn1 : this.cluster.getDataNodes()) {
                if (this.cluster.getFsDatasetTestUtils(dn1).getPendingAsyncDeletions() <= 0L) continue;
                return false;
            }
            return true;
        }, (long)10L, (long)WAIT_FOR_ASYNC_DELETE_MS);
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        FsDatasetSpi dataset = dn.getFSDataset();
        try (FsDatasetSpi.FsVolumeReferences volumes = dataset.getFsVolumeReferences();){
            GenericTestUtils.waitFor(() -> {
                try {
                    for (FsVolumeSpi vol : volumes) {
                        FsVolumeImpl volume = (FsVolumeImpl)vol;
                        File targetDir = volume.isTransientStorage() ? volume.getBlockPoolSlice(bpid).getFinalizedDir() : volume.getBlockPoolSlice(bpid).getLazypersistDir();
                        if (this.verifyBlockDeletedFromDir(targetDir, locatedBlocks)) continue;
                        return false;
                    }
                    return true;
                }
                catch (IOException ie) {
                    return false;
                }
            }, (long)10L, (long)WAIT_FOR_ASYNC_DELETE_MS);
        }
        return true;
    }

    protected final void verifyRamDiskJMXMetric(String metricName, long expectedValue) throws Exception {
        this.waitForMetric(metricName, (int)expectedValue);
        Assert.assertEquals((long)expectedValue, (long)Integer.parseInt(this.jmx.getValue(metricName)));
    }

    protected final boolean verifyReadRandomFile(Path path, int fileLength, int seed) throws IOException {
        byte[] contents = DFSTestUtil.readFileBuffer((FileSystem)this.fs, path);
        byte[] expected = DFSTestUtil.calculateFileContentsFromSeed(seed, fileLength);
        return Arrays.equals(contents, expected);
    }

    private JMXGet initJMX() throws Exception {
        JMXGet jmx = new JMXGet();
        jmx.setService(JMX_SERVICE_NAME);
        jmx.init();
        return jmx;
    }

    private void printRamDiskJMXMetrics() {
        try {
            if (this.jmx != null) {
                this.jmx.printAllMatchedAttributes(JMX_RAM_DISK_METRICS_PATTERN);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void waitForMetric(String metricName, int expectedValue) throws TimeoutException, InterruptedException {
        DFSTestUtil.waitForMetric(this.jmx, metricName, expectedValue);
    }

    protected void triggerEviction(DataNode dn) {
        FsDatasetImpl fsDataset = (FsDatasetImpl)dn.getFSDataset();
        fsDataset.evictLazyPersistBlocks(Long.MAX_VALUE);
    }

    protected void shutdownDataNodes() throws TimeoutException, InterruptedException {
        this.cluster.shutdownDataNodes();
        GenericTestUtils.waitFor(() -> {
            try {
                DatanodeInfo[] info = this.client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
                return info.length == 0;
            }
            catch (IOException e) {
                return false;
            }
        }, (long)20L, (long)WAIT_FOR_DN_SHUTDOWN_MS);
    }

    protected void waitForCorruptBlock(long corruptCnt) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> {
            Iterator bInfoIter = this.cluster.getNameNode().getNamesystem().getBlockManager().getCorruptReplicaBlockIterator();
            int count = 0;
            while (bInfoIter.hasNext()) {
                bInfoIter.next();
                ++count;
            }
            return corruptCnt == (long)count;
        }, (long)40L, (long)WAIT_FOR_REDUNDANCY_MS);
    }

    protected void waitForScrubberCycle() throws TimeoutException, InterruptedException {
        FSNamesystem fsn = this.cluster.getNamesystem();
        long lastTimeStamp = fsn.getLazyPersistFileScrubberTS();
        if (lastTimeStamp == -1L) {
            return;
        }
        GenericTestUtils.waitFor(() -> lastTimeStamp != fsn.getLazyPersistFileScrubberTS(), (long)40L, (long)WAIT_FOR_LAZY_SCRUBBER_MS);
    }

    protected void waitForRedundancyMonitorCycle() throws TimeoutException, InterruptedException {
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        long lastRedundancyTS = bm.getLastRedundancyMonitorTS();
        GenericTestUtils.waitFor(() -> lastRedundancyTS != bm.getLastRedundancyMonitorTS(), (long)40L, (long)WAIT_FOR_REDUNDANCY_MS);
    }

    protected void waitForLowRedundancyCount(long cnt) throws TimeoutException, InterruptedException {
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        GenericTestUtils.waitFor(() -> cnt == bm.getLowRedundancyBlocksCount(), (long)40L, (long)WAIT_FOR_REDUNDANCY_MS);
    }

    protected void waitForFile(Path path, boolean expected) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> {
            try {
                return expected == this.fs.exists(path);
            }
            catch (IOException e) {
                return false;
            }
        }, (long)10L, (long)WAIT_FOR_STORAGE_TYPES_MS);
    }

    static {
        DFSTestUtil.setNameNodeLogLevel(Level.DEBUG);
        GenericTestUtils.setLogLevel((Logger)FsDatasetImpl.LOG, (Level)Level.DEBUG);
        LOG = LoggerFactory.getLogger(LazyPersistTestCase.class);
        WAIT_FOR_FBR_MS = TimeUnit.SECONDS.toMillis(10L);
        WAIT_FOR_STORAGE_TYPES_MS = TimeUnit.SECONDS.toMillis(30L);
        WAIT_FOR_ASYNC_DELETE_MS = TimeUnit.SECONDS.toMillis(10L);
        WAIT_FOR_DN_SHUTDOWN_MS = TimeUnit.SECONDS.toMillis(30L);
        WAIT_FOR_REDUNDANCY_MS = TimeUnit.SECONDS.toMillis(6L);
        WAIT_FOR_LAZY_SCRUBBER_MS = TimeUnit.SECONDS.toMillis(6L);
    }

    class ClusterWithRamDiskBuilder {
        private int numDatanodes = 1;
        private StorageType[] storageTypes = null;
        private int ramDiskReplicaCapacity = -1;
        private long ramDiskStorageLimit = -1L;
        private long maxLockedMemory = Shell.getMemlockLimit((Long)Long.MAX_VALUE);
        private boolean hasTransientStorage = true;
        private boolean useScr = false;
        private boolean useLegacyBlockReaderLocal = false;
        private boolean disableScrubber = false;

        ClusterWithRamDiskBuilder() {
        }

        public ClusterWithRamDiskBuilder setNumDatanodes(int numDatanodes) {
            this.numDatanodes = numDatanodes;
            return this;
        }

        public ClusterWithRamDiskBuilder setStorageTypes(StorageType[] storageTypes) {
            this.storageTypes = storageTypes;
            return this;
        }

        public ClusterWithRamDiskBuilder setRamDiskReplicaCapacity(int ramDiskReplicaCapacity) {
            this.ramDiskReplicaCapacity = ramDiskReplicaCapacity;
            return this;
        }

        public ClusterWithRamDiskBuilder setRamDiskStorageLimit(long ramDiskStorageLimit) {
            this.ramDiskStorageLimit = ramDiskStorageLimit;
            return this;
        }

        public ClusterWithRamDiskBuilder setMaxLockedMemory(long maxLockedMemory) {
            this.maxLockedMemory = maxLockedMemory;
            return this;
        }

        public ClusterWithRamDiskBuilder setUseScr(boolean useScr) {
            this.useScr = useScr;
            return this;
        }

        public ClusterWithRamDiskBuilder setHasTransientStorage(boolean hasTransientStorage) {
            this.hasTransientStorage = hasTransientStorage;
            return this;
        }

        public ClusterWithRamDiskBuilder setUseLegacyBlockReaderLocal(boolean useLegacyBlockReaderLocal) {
            this.useLegacyBlockReaderLocal = useLegacyBlockReaderLocal;
            return this;
        }

        public ClusterWithRamDiskBuilder disableScrubber() {
            this.disableScrubber = true;
            return this;
        }

        public void build() throws IOException {
            LazyPersistTestCase.this.startUpCluster(this.numDatanodes, this.hasTransientStorage, this.storageTypes, this.ramDiskReplicaCapacity, this.ramDiskStorageLimit, this.maxLockedMemory, this.useScr, this.useLegacyBlockReaderLocal, this.disableScrubber);
        }
    }
}

