/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHASafeMode {
    private static final Logger LOG = LoggerFactory.getLogger(TestHASafeMode.class);
    private static final int BLOCK_SIZE = 1024;
    private NameNode nn0;
    private NameNode nn1;
    private FileSystem fs;
    private MiniDFSCluster cluster;

    @Before
    public void setupCluster() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.blocksize", 1024);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).waitSafeMode(false).build();
        this.cluster.waitActive();
        this.nn0 = this.cluster.getNameNode(0);
        this.nn1 = this.cluster.getNameNode(1);
        this.fs = HATestUtil.configureFailoverFs(this.cluster, conf);
        this.cluster.transitionToActive(0);
    }

    @After
    public void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testClientRetrySafeMode() throws Exception {
        final Map results = Collections.synchronizedMap(new HashMap());
        final Path test = new Path("/test");
        this.cluster.getConfiguration(0).setInt("dfs.namenode.safemode.min.datanodes", 3);
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        Whitebox.setInternalState((Object)this.nn0.getNamesystem(), (String)"manualSafeMode", (Object)false);
        BlockManagerTestUtil.setStartupSafeModeForTest(this.nn0.getNamesystem().getBlockManager());
        Assert.assertTrue((boolean)this.nn0.getNamesystem().isInStartupSafeMode());
        LOG.info("enter safemode");
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean mkdir = TestHASafeMode.this.fs.mkdirs(test);
                    LOG.info("mkdir finished, result is " + mkdir);
                    TestHASafeMode testHASafeMode = TestHASafeMode.this;
                    synchronized (testHASafeMode) {
                        results.put(test, mkdir);
                        TestHASafeMode.this.notifyAll();
                    }
                }
                catch (Exception e) {
                    LOG.info("Got Exception while calling mkdir", (Throwable)e);
                }
            }
        }.start();
        Assert.assertFalse((String)"The directory should not be created while NN in safemode", (boolean)this.fs.exists(test));
        Thread.sleep(1000L);
        NameNodeAdapter.leaveSafeMode(this.nn0);
        LOG.info("leave safemode");
        TestHASafeMode testHASafeMode = this;
        synchronized (testHASafeMode) {
            while (!results.containsKey(test)) {
                this.wait();
            }
            Assert.assertTrue((boolean)((Boolean)results.get(test)));
        }
    }

    private void restartStandby() throws IOException {
        this.cluster.shutdownNameNode(1);
        this.cluster.getConfiguration(1).setInt("dfs.namenode.safemode.extension", 30000);
        this.cluster.getConfiguration(1).setInt("dfs.ha.tail-edits.period", 1);
        this.cluster.restartNameNode(1);
        this.nn1 = this.cluster.getNameNode(1);
        Assert.assertEquals((long)this.nn1.getNamesystem().getTransactionsSinceLastLogRoll(), (long)0L);
    }

    @Test
    public void testEnterSafeModeInANNShouldNotThrowNPE() throws Exception {
        TestHASafeMode.banner("Restarting active");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        this.restartActive();
        this.nn0.getRpcServer().transitionToActive(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER));
        FSNamesystem namesystem = this.nn0.getNamesystem();
        String status = namesystem.getSafemode();
        Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON."));
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        Assert.assertTrue((String)"Failed to enter into safemode in active", (boolean)namesystem.isInSafeMode());
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        Assert.assertTrue((String)"Failed to enter into safemode in active", (boolean)namesystem.isInSafeMode());
    }

    @Test
    public void testEnterSafeModeInSBNShouldNotThrowNPE() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Creating some blocks that won't be in the edit log");
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 5120L, (short)3, 1L);
        TestHASafeMode.banner("Deleting the original blocks");
        this.fs.delete(new Path("/test"), true);
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        FSNamesystem namesystem = this.nn1.getNamesystem();
        String status = namesystem.getSafemode();
        Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON."));
        NameNodeAdapter.enterSafeMode(this.nn1, false);
        Assert.assertTrue((String)"Failed to enter into safemode in standby", (boolean)namesystem.isInSafeMode());
        NameNodeAdapter.enterSafeMode(this.nn1, false);
        Assert.assertTrue((String)"Failed to enter into safemode in standby", (boolean)namesystem.isInSafeMode());
    }

    private void restartActive() throws IOException {
        this.cluster.shutdownNameNode(0);
        this.cluster.getConfiguration(0).setInt("dfs.namenode.safemode.extension", 30000);
        this.cluster.restartNameNode(0);
        this.nn0 = this.cluster.getNameNode(0);
    }

    @Test
    public void testBlocksAddedBeforeStandbyRestart() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Creating some blocks that won't be in the edit log");
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 5120L, (short)3, 1L);
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        TestHASafeMode.assertSafeMode(this.nn1, 3, 3, 3, 0);
        TestHASafeMode.banner("Waiting for standby to catch up to active namespace");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        TestHASafeMode.assertSafeMode(this.nn1, 8, 8, 3, 0);
    }

    @Test
    public void testBlocksAddedWhileInSafeMode() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        TestHASafeMode.assertSafeMode(this.nn1, 3, 3, 3, 0);
        TestHASafeMode.banner("Creating some blocks while SBN is in safe mode");
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 5120L, (short)3, 1L);
        TestHASafeMode.banner("Waiting for standby to catch up to active namespace");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        TestHASafeMode.assertSafeMode(this.nn1, 8, 8, 3, 0);
    }

    @Test
    public void testBlocksRemovedBeforeStandbyRestart() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 5120L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Removing the blocks without rolling the edit log");
        this.fs.delete(new Path("/test"), true);
        BlockManagerTestUtil.computeAllPendingWork(this.nn0.getNamesystem().getBlockManager());
        this.cluster.triggerHeartbeats();
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        TestHASafeMode.assertSafeMode(this.nn1, 0, 5, 3, 0);
        TestHASafeMode.banner("Waiting for standby to catch up to active namespace");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        TestHASafeMode.assertSafeMode(this.nn1, 0, 0, 3, 0);
    }

    @Test
    public void testBlocksRemovedWhileInSafeMode() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 10240L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        TestHASafeMode.assertSafeMode(this.nn1, 10, 10, 3, 0);
        TestHASafeMode.banner("Removing the blocks without rolling the edit log");
        this.fs.delete(new Path("/test"), true);
        BlockManagerTestUtil.computeAllPendingWork(this.nn0.getNamesystem().getBlockManager());
        TestHASafeMode.banner("Triggering deletions on DNs and Deletion Reports");
        this.cluster.triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.cluster);
        this.cluster.triggerDeletionReports();
        TestHASafeMode.assertSafeMode(this.nn1, 10, 10, 3, 0);
        TestHASafeMode.banner("Waiting for standby to catch up to active namespace");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        TestHASafeMode.assertSafeMode(this.nn1, 0, 0, 3, 0);
    }

    @Test
    public void testAppendWhileInSafeMode() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 4608L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        TestHASafeMode.assertSafeMode(this.nn1, 5, 5, 3, 0);
        FSDataOutputStream stm = this.fs.append(new Path("/test"));
        try {
            TestHASafeMode.assertSafeMode(this.nn1, 5, 5, 3, 0);
            HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
            TestHASafeMode.assertSafeMode(this.nn1, 4, 4, 3, 0);
        }
        finally {
            IOUtils.closeStream((Closeable)stm);
        }
        TestHASafeMode.banner("Removing the blocks without rolling the edit log");
        this.fs.delete(new Path("/test"), true);
        BlockManagerTestUtil.computeAllPendingWork(this.nn0.getNamesystem().getBlockManager());
        TestHASafeMode.banner("Triggering deletions on DNs and Deletion Reports");
        this.cluster.triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.cluster);
        this.cluster.triggerDeletionReports();
        TestHASafeMode.assertSafeMode(this.nn1, 4, 4, 3, 0);
        TestHASafeMode.banner("Waiting for standby to catch up to active namespace");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        TestHASafeMode.assertSafeMode(this.nn1, 0, 0, 3, 0);
    }

    @Test
    public void testBlocksDeletedInEditLog() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 4096L, (short)3, 1L);
        NameNodeAdapter.enterSafeMode(this.nn0, false);
        NameNodeAdapter.saveNamespace(this.nn0);
        NameNodeAdapter.leaveSafeMode(this.nn0);
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 2048L, (short)3, 1L);
        this.fs.delete(new Path("/test"), true);
        this.restartActive();
    }

    private static void assertSafeMode(NameNode nn, int safe, int total, int numNodes, int nodeThresh) {
        String status = nn.getNamesystem().getSafemode();
        if (total == 0 && nodeThresh == 0) {
            Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (status.isEmpty() || status.startsWith("Safe mode is ON. The reported blocks 0 has reached the threshold 0.9990 of total blocks 0. The minimum number of live datanodes is not required. In safe mode extension. Safe mode will be turned off automatically in 0 seconds.") ? 1 : 0) != 0);
        } else if (safe == total) {
            if (nodeThresh == 0) {
                Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON. The reported blocks " + safe + " has reached the threshold 0.9990 of total blocks " + total + ". The minimum number of live datanodes is not required. In safe mode extension. Safe mode will be turned off automatically"));
            } else {
                Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON. The reported blocks " + safe + " has reached the threshold 0.9990 of total blocks " + total + ". The number of live datanodes " + numNodes + " has reached the minimum number " + nodeThresh + ". In safe mode extension. Safe mode will be turned off automatically"));
            }
        } else {
            int additional = (int)((double)total * 0.999) - safe;
            Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON. The reported blocks " + safe + " needs additional " + additional + " blocks"));
        }
    }

    @Test
    public void testComplexFailoverIntoSafemode() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Creating some blocks that won't be in the edit log");
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 5120L, (short)3, 1L);
        TestHASafeMode.banner("Deleting the original blocks");
        this.fs.delete(new Path("/test"), true);
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        TestHASafeMode.assertSafeMode(this.nn1, 3, 3, 3, 0);
        TestHASafeMode.banner("Initiating a failover into NN1 in safemode");
        NameNodeAdapter.abortEditLogs(this.nn0);
        this.cluster.transitionToActive(1);
        TestHASafeMode.assertSafeMode(this.nn1, 5, 5, 3, 0);
    }

    @Test
    public void testBlocksRemovedWhileInSafeModeEditsArriveFirst() throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some blocks");
        DFSTestUtil.createFile(this.fs, new Path("/test"), 10240L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        TestHASafeMode.banner("Restarting standby");
        this.restartStandby();
        String status = this.nn1.getNamesystem().getSafemode();
        Assert.assertTrue((String)("Bad safemode status: '" + status + "'"), (boolean)status.startsWith("Safe mode is ON. The reported blocks 10 has reached the threshold 0.9990 of total blocks 10. The minimum number of live datanodes is not required. In safe mode extension. Safe mode will be turned off automatically"));
        TestHASafeMode.banner("Removing the blocks without rolling the edit log");
        this.fs.delete(new Path("/test"), true);
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        TestHASafeMode.assertSafeMode(this.nn1, 0, 0, 3, 0);
        TestHASafeMode.banner("Triggering sending deletions to DNs and Deletion Reports");
        BlockManagerTestUtil.computeAllPendingWork(this.nn0.getNamesystem().getBlockManager());
        this.cluster.triggerHeartbeats();
        HATestUtil.waitForDNDeletions(this.cluster);
        this.cluster.triggerDeletionReports();
        TestHASafeMode.assertSafeMode(this.nn1, 0, 0, 3, 0);
    }

    @Test
    public void testSafeBlockTracking() throws Exception {
        this.testSafeBlockTracking(false);
    }

    @Test
    public void testSafeBlockTracking2() throws Exception {
        this.testSafeBlockTracking(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSafeBlockTracking(boolean noFirstBlockReport) throws Exception {
        TestHASafeMode.banner("Starting with NN0 active and NN1 standby, creating some UC blocks plus some other blocks to force safemode");
        DFSTestUtil.createFile(this.fs, new Path("/other-blocks"), 10240L, (short)3, 1L);
        ArrayList stms = Lists.newArrayList();
        try {
            for (int i = 0; i < 5; ++i) {
                FSDataOutputStream stm = this.fs.create(new Path("/test-uc-" + i));
                stms.add(stm);
                stm.write(1);
                stm.hflush();
            }
            this.nn0.getRpcServer().rollEditLog();
        }
        finally {
            if (noFirstBlockReport) {
                this.cluster.shutdownNameNode(1);
            }
            for (FSDataOutputStream stm : stms) {
                IOUtils.closeStream((Closeable)stm);
            }
        }
        TestHASafeMode.banner("Restarting SBN");
        this.restartStandby();
        TestHASafeMode.assertSafeMode(this.nn1, 10, 10, 3, 0);
        TestHASafeMode.banner("Allowing SBN to catch up");
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        TestHASafeMode.assertSafeMode(this.nn1, 15, 15, 3, 0);
    }

    @Test
    public void testBlocksAddedWhileStandbyIsDown() throws Exception {
        DFSTestUtil.createFile(this.fs, new Path("/test"), 3072L, (short)3, 1L);
        TestHASafeMode.banner("Stopping standby");
        this.cluster.shutdownNameNode(1);
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 3072L, (short)3, 1L);
        TestHASafeMode.banner("Rolling edit log so standby gets all edits on restart");
        this.nn0.getRpcServer().rollEditLog();
        this.restartStandby();
        TestHASafeMode.assertSafeMode(this.nn1, 6, 6, 3, 0);
    }

    @Test
    public void testNoPopulatingReplQueuesWhenExitingSafemode() throws Exception {
        DFSTestUtil.createFile(this.fs, new Path("/test"), 15360L, (short)3, 1L);
        HATestUtil.waitForStandbyToCatchUp(this.nn0, this.nn1);
        this.nn1.getRpcServer().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        NameNodeAdapter.saveNamespace(this.nn1);
        this.nn1.getRpcServer().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 15360L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        this.cluster.stopDataNode(1);
        this.cluster.shutdownNameNode(1);
        this.cluster.restartNameNode(1, false, new String[0]);
        this.nn1 = this.cluster.getNameNode(1);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return !TestHASafeMode.this.nn1.isInSafeMode();
            }
        }, (long)100L, (long)10000L);
        BlockManagerTestUtil.updateState(this.nn1.getNamesystem().getBlockManager());
        Assert.assertEquals((long)0L, (long)this.nn1.getNamesystem().getUnderReplicatedBlocks());
        Assert.assertEquals((long)0L, (long)this.nn1.getNamesystem().getPendingReplicationBlocks());
    }

    @Test
    public void testNoPopulatingReplQueuesWhenStartingActiveInSafeMode() throws IOException {
        DFSTestUtil.createFile(this.fs, new Path("/test"), 15360L, (short)3, 1L);
        this.cluster.stopDataNode(1);
        this.cluster.restartNameNode(0, false, new String[0]);
        this.cluster.transitionToActive(0);
        Assert.assertTrue((boolean)this.cluster.getNameNode(0).isInSafeMode());
        Assert.assertEquals((long)0L, (long)this.cluster.getNamesystem(0).getMissingBlocksCount());
    }

    static void banner(String string) {
        LOG.info("\n\n\n\n================================================\n" + string + "\n==================================================\n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsInSafemode() throws Exception {
        block7: {
            NameNode nn2 = this.cluster.getNameNode(1);
            Assert.assertTrue((String)"nn2 should be in standby state", (boolean)nn2.isStandbyState());
            InetSocketAddress nameNodeAddress = nn2.getNameNodeAddress();
            Configuration conf = new Configuration();
            DistributedFileSystem dfs = new DistributedFileSystem();
            try {
                dfs.initialize(URI.create("hdfs://" + nameNodeAddress.getHostName() + ":" + nameNodeAddress.getPort()), conf);
                dfs.isInSafeMode();
                Assert.fail((String)"StandBy should throw exception for isInSafeMode");
            }
            catch (IOException e) {
                if (e instanceof RemoteException) {
                    Assert.assertEquals((String)"RPC Error code should indicate app failure.", (Object)RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto.ERROR_APPLICATION, (Object)((RemoteException)((Object)e)).getErrorCode());
                    IOException sbExcpetion = ((RemoteException)((Object)e)).unwrapRemoteException();
                    Assert.assertTrue((String)"StandBy nn should not support isInSafeMode", (boolean)(sbExcpetion instanceof StandbyException));
                    break block7;
                }
                throw e;
            }
            finally {
                if (null != dfs) {
                    dfs.close();
                }
            }
        }
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        this.cluster.getNameNodeRpc(1).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        DistributedFileSystem dfsWithFailOver = (DistributedFileSystem)this.fs;
        Assert.assertTrue((String)"ANN should be in SafeMode", (boolean)dfsWithFailOver.isInSafeMode());
        this.cluster.getNameNodeRpc(1).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
        Assert.assertFalse((String)"ANN should be out of SafeMode", (boolean)dfsWithFailOver.isInSafeMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testOpenFileWhenNNAndClientCrashAfterAddBlock() throws Exception {
        this.cluster.getConfiguration(0).set("dfs.namenode.safemode.threshold-pct", "1.0f");
        String testData = "testData";
        this.cluster.getConfiguration(0).setInt("io.bytes.per.checksum", testData.length());
        this.cluster.restartNameNode(0);
        try {
            this.cluster.waitActive();
            this.cluster.transitionToActive(0);
            this.cluster.transitionToStandby(1);
            DistributedFileSystem dfs = this.cluster.getFileSystem(0);
            String pathString = "/tmp1.txt";
            Path filePath = new Path(pathString);
            FSDataOutputStream create = dfs.create(filePath, FsPermission.getDefault(), true, 1024, (short)3, (long)testData.length(), null);
            create.write(testData.getBytes());
            create.hflush();
            long fileId = ((DFSOutputStream)create.getWrappedStream()).getFileId();
            FileStatus fileStatus = dfs.getFileStatus(filePath);
            DFSClient client = DFSClientAdapter.getClient(dfs);
            ExtendedBlock previousBlock = DFSClientAdapter.getPreviousBlock(client, fileId);
            DFSClientAdapter.getNamenode(client).addBlock(pathString, client.getClientName(), new ExtendedBlock(previousBlock), new DatanodeInfo[0], DFSClientAdapter.getFileId((DFSOutputStream)create.getWrappedStream()), null, null);
            this.cluster.restartNameNode(0, true, new String[0]);
            this.cluster.restartDataNode(0);
            this.cluster.transitionToActive(0);
            Thread.sleep(2000L);
            FSDataInputStream is = dfs.open(filePath);
            is.close();
            dfs.recoverLease(filePath);
            Assert.assertTrue((String)"Recovery also should be success", (boolean)dfs.recoverLease(filePath));
        }
        finally {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testSafeModeExitAfterTransition() throws Exception {
        DFSTestUtil.createFile(this.fs, new Path("/test"), 5120L, (short)3, 1L);
        TestHASafeMode.banner("Stopping standby");
        this.cluster.shutdownNameNode(1);
        DFSTestUtil.createFile(this.fs, new Path("/test2"), 3072L, (short)3, 1L);
        this.nn0.getRpcServer().rollEditLog();
        this.fs.delete(new Path("/test"), true);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return TestHASafeMode.this.cluster.getNamesystem(0).getBlockManager().getPendingDeletionBlocksCount() == 0L;
            }
        }, (long)1000L, (long)10000L);
        this.restartStandby();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return TestHASafeMode.this.cluster.getNamesystem(1).getNumLiveDataNodes() == 3;
            }
        }, (long)1000L, (long)10000L);
        this.cluster.triggerBlockReports();
        NameNodeAdapter.abortEditLogs(this.nn0);
        this.cluster.shutdownNameNode(0);
        TestHASafeMode.banner(this.nn1.getNamesystem().getSafemode());
        this.cluster.transitionToActive(1);
        TestHASafeMode.assertSafeMode(this.nn1, 3, 3, 3, 0);
    }

    @Test
    public void testTransitionToActiveWhenSafeMode() throws Exception {
        Configuration config = new Configuration();
        config.setBoolean("dfs.ha.nn.not-become-active-in-safemode", true);
        try (MiniDFSCluster miniCluster = new MiniDFSCluster.Builder(config, new File(GenericTestUtils.getRandomizedTempPath())).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();){
            miniCluster.waitActive();
            miniCluster.transitionToStandby(0);
            miniCluster.transitionToStandby(1);
            NameNode namenode0 = miniCluster.getNameNode(0);
            NameNode namenode1 = miniCluster.getNameNode(1);
            NameNodeAdapter.enterSafeMode(namenode0, false);
            NameNodeAdapter.enterSafeMode(namenode1, false);
            LambdaTestUtils.intercept(ServiceFailedException.class, (String)"NameNode still not leave safemode", () -> miniCluster.transitionToActive(0));
        }
    }

    static {
        DFSTestUtil.setNameNodeLogLevel(Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)FSImage.LOG, (org.slf4j.event.Level)org.slf4j.event.Level.TRACE);
    }
}

