/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.TestBlockManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGetBlocks {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockManager.class);
    private static final int BLOCK_SIZE = 8192;
    private static final String[] RACKS = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
    private static final int NUM_DATA_NODES = RACKS.length;

    private DataNode stopDataNodeHeartbeat(MiniDFSCluster cluster, String hostName) {
        for (DataNode dn : cluster.getDataNodes()) {
            if (!dn.getDatanodeId().getHostName().equals(hostName)) continue;
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
            return dn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadSelectNonStaleDatanode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        long staleInterval = 1800000L;
        conf.setLong("dfs.namenode.stale.datanode.interval", staleInterval);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(NUM_DATA_NODES).racks(RACKS).build();
        cluster.waitActive();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        List nodeInfoList = cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanodeListForReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Unexpected number of datanodes", (long)NUM_DATA_NODES, (long)nodeInfoList.size());
        DistributedFileSystem fileSys = cluster.getFileSystem();
        FSDataOutputStream stm = null;
        try {
            Path fileName = new Path("/file1");
            stm = fileSys.create(fileName, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)3, 8192L);
            stm.write(new byte[12288]);
            stm.hflush();
            LocatedBlocks blocks = client.getNamenode().getBlockLocations(fileName.toString(), 0L, 8192L);
            DatanodeInfoWithStorage[] nodes = blocks.get(0).getLocations();
            Assert.assertEquals((long)nodes.length, (long)3L);
            DataNode staleNode = null;
            DatanodeDescriptor staleNodeInfo = null;
            staleNode = this.stopDataNodeHeartbeat(cluster, nodes[0].getHostName());
            Assert.assertNotNull((Object)staleNode);
            staleNodeInfo = cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(staleNode.getDatanodeId());
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)staleNodeInfo, -(staleInterval + 1L));
            LocatedBlocks blocksAfterStale = client.getNamenode().getBlockLocations(fileName.toString(), 0L, 8192L);
            DatanodeInfoWithStorage[] nodesAfterStale = blocksAfterStale.get(0).getLocations();
            Assert.assertEquals((long)nodesAfterStale.length, (long)3L);
            Assert.assertEquals((Object)nodesAfterStale[2].getHostName(), (Object)nodes[0].getHostName());
            DataNodeTestUtils.setHeartbeatsDisabledForTests(staleNode, false);
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)staleNodeInfo, 0L);
            LocatedBlock lastBlock = client.getLocatedBlocks(fileName.toString(), 0L, Long.MAX_VALUE).getLastLocatedBlock();
            nodes = lastBlock.getLocations();
            Assert.assertEquals((long)nodes.length, (long)3L);
            staleNode = this.stopDataNodeHeartbeat(cluster, nodes[0].getHostName());
            Assert.assertNotNull((Object)staleNode);
            DatanodeDescriptor dnDesc = cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(staleNode.getDatanodeId());
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dnDesc, -(staleInterval + 1L));
            LocatedBlock lastBlockAfterStale = client.getLocatedBlocks(fileName.toString(), 0L, Long.MAX_VALUE).getLastLocatedBlock();
            nodesAfterStale = lastBlockAfterStale.getLocations();
            Assert.assertEquals((long)nodesAfterStale.length, (long)3L);
            Assert.assertEquals((Object)nodesAfterStale[2].getHostName(), (Object)nodes[0].getHostName());
        }
        finally {
            if (stm != null) {
                stm.close();
            }
            client.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBlocks() throws Exception {
        DistributedFileSystem fs = null;
        Path testFile = null;
        int blkSize = 1024;
        String filePath = "/tmp.txt";
        int blkLocsSize = 13;
        long fileLen = 12289L;
        int replicationFactor = 2;
        HdfsConfiguration config = new HdfsConfiguration();
        config.setLong("dfs.blocksize", 1024L);
        config.setLong("dfs.balancer.getBlocks.min-block-size", 1024L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(2).storagesPerDatanode(4).build();
        try {
            cluster.waitActive();
            testFile = new Path("/tmp.txt");
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), testFile, fileLen, (short)2, 0L);
            fs = cluster.getFileSystem();
            DFSTestUtil.waitForReplication(fs, testFile, (short)2, 60000);
            RemoteIterator it = fs.listLocatedStatus(testFile);
            LocatedFileStatus stat = (LocatedFileStatus)it.next();
            BlockLocation[] blockLocations = stat.getBlockLocations();
            Assert.assertEquals((long)13L, (long)blockLocations.length);
            HdfsDataInputStream dis = (HdfsDataInputStream)fs.open(testFile);
            List dinfo = dis.getAllBlocks();
            dis.close();
            DatanodeInfoWithStorage[] dataNodes = ((LocatedBlock)dinfo.iterator().next()).getLocations();
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            NamenodeProtocol namenode = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)config, (URI)DFSUtilClient.getNNUri((InetSocketAddress)addr), NamenodeProtocol.class).getProxy();
            BlocksWithLocations.BlockWithLocations[] locs = namenode.getBlocks((DatanodeInfo)dataNodes[0], fileLen, 0L).getBlocks();
            Assert.assertEquals((long)13L, (long)locs.length);
            Assert.assertEquals((long)locs[0].getStorageIDs().length, (long)2L);
            Assert.assertEquals((long)locs[1].getStorageIDs().length, (long)2L);
            locs = namenode.getBlocks((DatanodeInfo)dataNodes[0], fileLen, 1024L).getBlocks();
            Assert.assertEquals((long)12L, (long)locs.length);
            Assert.assertEquals((long)locs[0].getStorageIDs().length, (long)2L);
            Assert.assertEquals((long)locs[1].getStorageIDs().length, (long)2L);
            locs = namenode.getBlocks((DatanodeInfo)dataNodes[0], 1024L, 1024L).getBlocks();
            Assert.assertEquals((long)locs.length, (long)1L);
            Assert.assertEquals((long)locs[0].getStorageIDs().length, (long)2L);
            locs = namenode.getBlocks((DatanodeInfo)dataNodes[0], 1L, 1L).getBlocks();
            Assert.assertEquals((long)locs.length, (long)1L);
            Assert.assertEquals((long)locs[0].getStorageIDs().length, (long)2L);
            this.getBlocksWithException(namenode, (DatanodeInfo)dataNodes[0], 0L, 0L, RemoteException.class, "IllegalArgumentException");
            this.getBlocksWithException(namenode, (DatanodeInfo)dataNodes[0], -1L, 0L, RemoteException.class, "IllegalArgumentException");
            this.getBlocksWithException(namenode, (DatanodeInfo)dataNodes[0], 1024L, -1L, RemoteException.class, "IllegalArgumentException");
            DatanodeInfo info = DFSTestUtil.getDatanodeInfo("1.2.3.4");
            this.getBlocksWithException(namenode, info, 2L, 0L, RemoteException.class, "HadoopIllegalArgumentException");
            this.testBlockIterator(cluster);
            locs = namenode.getBlocks((DatanodeInfo)dataNodes[0], fileLen, 0L).getBlocks();
            Assert.assertEquals((long)13L, (long)locs.length);
            Assert.assertFalse((boolean)fs.isInSafeMode());
            LOG.info("Entering safe mode");
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            LOG.info("Entered safe mode");
            Assert.assertTrue((boolean)fs.isInSafeMode());
            this.getBlocksWithException(namenode, info, 2L, 0L, RemoteException.class, "Cannot execute getBlocks. Name node is in safe mode.");
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            Assert.assertFalse((boolean)fs.isInSafeMode());
        }
        finally {
            if (fs != null) {
                fs.delete(testFile, true);
                fs.close();
            }
            cluster.shutdown();
        }
    }

    private void getBlocksWithException(NamenodeProtocol namenode, DatanodeInfo datanode, long size, long minBlkSize, Class exClass, String msg) throws Exception {
        LambdaTestUtils.intercept((Class)exClass, (String)msg, () -> namenode.getBlocks(datanode, size, minBlkSize));
    }

    void testBlockIterator(MiniDFSCluster cluster) {
        FSNamesystem ns = cluster.getNamesystem();
        String dId = cluster.getDataNodes().get(0).getDatanodeUuid();
        DatanodeDescriptor dnd = BlockManagerTestUtil.getDatanode(ns, dId);
        DatanodeStorageInfo[] storages = dnd.getStorageInfos();
        Assert.assertEquals((String)"DataNode should have 4 storages", (long)4L, (long)storages.length);
        Iterator<BlockInfo> dnBlockIt = null;
        try {
            dnBlockIt = BlockManagerTestUtil.getBlockIterator(cluster.getNamesystem(), dId, -1);
            Assert.assertTrue((String)"Should throw IllegalArgumentException", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((String)"Iterator should be null", dnBlockIt);
        int numBlocks = dnd.numBlocks();
        BlockInfo[] allBlocks = new BlockInfo[numBlocks];
        int idx = 0;
        for (DatanodeStorageInfo s : storages) {
            Iterator<BlockInfo> storageBlockIt = BlockManagerTestUtil.getBlockIterator(s);
            while (storageBlockIt.hasNext()) {
                allBlocks[idx++] = storageBlockIt.next();
                try {
                    storageBlockIt.remove();
                    Assert.assertTrue((String)"BlockInfo iterator should have been unmodifiable", (boolean)false);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        for (int i = 0; i < allBlocks.length; ++i) {
            dnBlockIt = BlockManagerTestUtil.getBlockIterator(ns, dId, i);
            Assert.assertTrue((String)"Block iterator should have next block", (boolean)dnBlockIt.hasNext());
            for (int j = i; j < allBlocks.length; ++j) {
                Assert.assertEquals((String)"Wrong block order", (Object)allBlocks[j], (Object)dnBlockIt.next());
            }
        }
        dnBlockIt = BlockManagerTestUtil.getBlockIterator(ns, dId, allBlocks.length + 1);
        Assert.assertFalse((String)"Iterator should not have next block", (boolean)dnBlockIt.hasNext());
    }

    @Test
    public void testBlockKey() {
        int i;
        HashMap<Block, Long> map = new HashMap<Block, Long>();
        Random RAN = new Random();
        long seed = RAN.nextLong();
        System.out.println("seed=" + seed);
        RAN.setSeed(seed);
        long[] blkids = new long[10];
        for (i = 0; i < blkids.length; ++i) {
            blkids[i] = 1000L + (long)RAN.nextInt(100000);
            map.put(new Block(blkids[i], 0L, blkids[i]), blkids[i]);
        }
        System.out.println("map=" + ((Object)map).toString().replace(",", "\n  "));
        for (i = 0; i < blkids.length; ++i) {
            Block b = new Block(blkids[i], 0L, 0L);
            Long v = (Long)map.get(b);
            System.out.println(b + " => " + v);
            Assert.assertEquals((long)blkids[i], (long)v);
        }
    }
}

