/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.CheckpointFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.TestFileTruncate;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRollingUpgrade {
    private static final Logger LOG = LoggerFactory.getLogger(TestRollingUpgrade.class);

    public static void runCmd(DFSAdmin dfsadmin, boolean success, String ... args) throws Exception {
        if (success) {
            Assert.assertEquals((long)0L, (long)dfsadmin.run(args));
        } else {
            Assert.assertTrue((dfsadmin.run(args) != 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSAdminRollingUpgradeCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            Path foo = new Path("/foo");
            Path bar = new Path("/bar");
            Path baz = new Path("/baz");
            DistributedFileSystem dfs = cluster.getFileSystem();
            DFSAdmin dfsadmin = new DFSAdmin((Configuration)conf);
            dfs.mkdirs(foo);
            TestRollingUpgrade.runCmd(dfsadmin, false, "-rollingUpgrade", "abc");
            TestRollingUpgrade.checkMxBeanIsNull();
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade");
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "prepare");
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "query");
            TestRollingUpgrade.checkMxBean();
            dfs.mkdirs(bar);
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "finalize");
            Assert.assertNull((Object)dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
            TestRollingUpgrade.checkMxBeanIsNull();
            dfs.mkdirs(baz);
            TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade");
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertTrue((boolean)dfs.exists(bar));
            Assert.assertTrue((boolean)dfs.exists(baz));
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            dfs.saveNamespace();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            cluster.restartNameNode(new String[0]);
            dfs = cluster.getFileSystem();
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertTrue((boolean)dfs.exists(bar));
            Assert.assertTrue((boolean)dfs.exists(baz));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static Configuration setConf(Configuration conf, File dir, MiniJournalCluster mjc) {
        conf.set("dfs.namenode.name.dir", dir.getAbsolutePath());
        conf.set("dfs.namenode.edits.dir", mjc.getQuorumJournalURI("myjournal").toString());
        conf.setLong("dfs.namenode.checkpoint.txns", 0L);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRollingUpgradeWithQJM() throws Exception {
        String nnDirPrefix = MiniDFSCluster.getBaseDirectory() + "/nn/";
        File nn1Dir = new File(nnDirPrefix + "image1");
        File nn2Dir = new File(nnDirPrefix + "image2");
        LOG.info("nn1Dir=" + nn1Dir);
        LOG.info("nn2Dir=" + nn2Dir);
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniJournalCluster mjc = new MiniJournalCluster.Builder((Configuration)conf).build();
        mjc.waitActive();
        TestRollingUpgrade.setConf((Configuration)conf, nn1Dir, mjc);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).manageNameDfsDirs(false).checkExitOnShutdown(false).build();
        cluster.shutdown();
        MiniDFSCluster cluster2 = null;
        try {
            FileUtil.fullyDelete((File)nn2Dir);
            FileUtil.copy((File)nn1Dir, (FileSystem)FileSystem.getLocal((Configuration)conf).getRaw(), (Path)new Path(nn2Dir.getAbsolutePath()), (boolean)false, (Configuration)conf);
            MiniDFSCluster cluster3 = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).manageNameDfsDirs(false).checkExitOnShutdown(false).build();
            Path foo = new Path("/foo");
            Path bar = new Path("/bar");
            Path baz = new Path("/baz");
            DistributedFileSystem dfs = cluster3.getFileSystem();
            dfs.mkdirs(foo);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            RollingUpgradeInfo info1 = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            LOG.info("START\n" + info1);
            Assert.assertEquals((Object)info1, (Object)dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
            dfs.mkdirs(bar);
            cluster3.shutdown();
            Configuration conf2 = TestRollingUpgrade.setConf(new Configuration(), nn2Dir, mjc);
            cluster2 = new MiniDFSCluster.Builder(conf2).numDataNodes(0).format(false).manageNameDfsDirs(false).build();
            DistributedFileSystem dfs2 = cluster2.getFileSystem();
            Assert.assertTrue((boolean)dfs2.exists(foo));
            Assert.assertTrue((boolean)dfs2.exists(bar));
            Assert.assertFalse((boolean)dfs2.exists(baz));
            Assert.assertEquals((Object)info1, (Object)dfs2.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
            dfs2.mkdirs(baz);
            LOG.info("RESTART cluster 2");
            cluster2.restartNameNode(new String[0]);
            Assert.assertEquals((Object)info1, (Object)dfs2.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
            Assert.assertTrue((boolean)dfs2.exists(foo));
            Assert.assertTrue((boolean)dfs2.exists(bar));
            Assert.assertTrue((boolean)dfs2.exists(baz));
            try {
                cluster2.restartNameNode("-upgrade");
            }
            catch (IOException e) {
                LOG.info("The exception is expected.", (Throwable)e);
            }
            LOG.info("RESTART cluster 2 again");
            cluster2.restartNameNode(new String[0]);
            Assert.assertEquals((Object)info1, (Object)dfs2.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
            Assert.assertTrue((boolean)dfs2.exists(foo));
            Assert.assertTrue((boolean)dfs2.exists(bar));
            Assert.assertTrue((boolean)dfs2.exists(baz));
            RollingUpgradeInfo finalize = dfs2.rollingUpgrade(HdfsConstants.RollingUpgradeAction.FINALIZE);
            Assert.assertTrue((boolean)finalize.isFinalized());
            LOG.info("RESTART cluster 2 with regular startup option");
            cluster2.getNameNodeInfos()[0].setStartOpt(HdfsServerConstants.StartupOption.REGULAR);
            cluster2.restartNameNode(new String[0]);
            Assert.assertTrue((boolean)dfs2.exists(foo));
            Assert.assertTrue((boolean)dfs2.exists(bar));
            Assert.assertTrue((boolean)dfs2.exists(baz));
        }
        finally {
            if (cluster2 != null) {
                cluster2.shutdown();
            }
        }
    }

    private static CompositeDataSupport getBean() throws MalformedObjectNameException, MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
        return (CompositeDataSupport)mbs.getAttribute(mxbeanName, "RollingUpgradeStatus");
    }

    private static void checkMxBeanIsNull() throws Exception {
        CompositeDataSupport ruBean = TestRollingUpgrade.getBean();
        Assert.assertNull((Object)ruBean);
    }

    private static void checkMxBean() throws Exception {
        CompositeDataSupport ruBean = TestRollingUpgrade.getBean();
        Assert.assertNotEquals((Object)0L, (Object)ruBean.get("startTime"));
        Assert.assertEquals((Object)0L, (Object)ruBean.get("finalizeTime"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollback() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            Path foo = new Path("/foo");
            Path bar = new Path("/bar");
            cluster.getFileSystem().mkdirs(foo);
            Path file = new Path(foo, "file");
            byte[] data = new byte[1024];
            ThreadLocalRandom.current().nextBytes(data);
            FSDataOutputStream out = cluster.getFileSystem().create(file);
            out.write(data, 0, data.length);
            out.close();
            TestRollingUpgrade.checkMxBeanIsNull();
            TestRollingUpgrade.startRollingUpgrade(foo, bar, file, data, cluster);
            TestRollingUpgrade.checkMxBean();
            cluster.getFileSystem().rollEdits();
            cluster.getFileSystem().rollEdits();
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, file, data, cluster);
            TestRollingUpgrade.checkMxBeanIsNull();
            TestRollingUpgrade.startRollingUpgrade(foo, bar, file, data, cluster);
            cluster.getFileSystem().rollEdits();
            cluster.getFileSystem().rollEdits();
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, file, data, cluster);
            TestRollingUpgrade.startRollingUpgrade(foo, bar, file, data, cluster);
            cluster.restartNameNode(new String[0]);
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, file, data, cluster);
            TestRollingUpgrade.startRollingUpgrade(foo, bar, file, data, cluster);
            cluster.restartNameNode(new String[0]);
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, file, data, cluster);
            TestRollingUpgrade.startRollingUpgrade(foo, bar, file, data, cluster);
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, file, data, cluster);
            TestRollingUpgrade.startRollingUpgrade(foo, bar, file, data, cluster);
            TestRollingUpgrade.rollbackRollingUpgrade(foo, bar, file, data, cluster);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void startRollingUpgrade(Path foo, Path bar, Path file, byte[] data, MiniDFSCluster cluster) throws IOException {
        DistributedFileSystem dfs = cluster.getFileSystem();
        dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
        dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        dfs.mkdirs(bar);
        Assert.assertTrue((boolean)dfs.exists(foo));
        Assert.assertTrue((boolean)dfs.exists(bar));
        int newLength = ThreadLocalRandom.current().nextInt(data.length - 1) + 1;
        dfs.truncate(file, (long)newLength);
        TestFileTruncate.checkBlockRecovery(file, dfs);
        AppendTestUtil.checkFullFile((FileSystem)dfs, file, newLength, data);
    }

    private static void rollbackRollingUpgrade(Path foo, Path bar, Path file, byte[] data, MiniDFSCluster cluster) throws IOException {
        MiniDFSCluster.DataNodeProperties dnprop = cluster.stopDataNode(0);
        cluster.restartNameNode("-rollingUpgrade", "rollback");
        cluster.restartDataNode(dnprop, true);
        DistributedFileSystem dfs = cluster.getFileSystem();
        Assert.assertTrue((boolean)dfs.exists(foo));
        Assert.assertFalse((boolean)dfs.exists(bar));
        AppendTestUtil.checkFullFile((FileSystem)dfs, file, data.length, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSAdminDatanodeUpgradeControlCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DFSAdmin dfsadmin = new DFSAdmin((Configuration)conf);
            DataNode dn = cluster.getDataNodes().get(0);
            String dnAddr = dn.getDatanodeId().getIpcAddr(false);
            String[] args1 = new String[]{"-getDatanodeInfo", dnAddr};
            TestRollingUpgrade.runCmd(dfsadmin, true, args1);
            String[] args2 = new String[]{"-shutdownDatanode", dnAddr, "upgrade"};
            TestRollingUpgrade.runCmd(dfsadmin, true, args2);
            GenericTestUtils.waitForThreadTermination((String)"Async datanode shutdown thread", (int)100, (int)10000);
            Assert.assertFalse((String)"DataNode should exit", (boolean)dn.isDatanodeUp());
            Assert.assertEquals((long)-1L, (long)dfsadmin.run(args1));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=300000L)
    public void testFinalize() throws Exception {
        this.testFinalize(2);
    }

    @Test(timeout=300000L)
    public void testFinalizeWithMultipleNN() throws Exception {
        this.testFinalize(3);
    }

    @Test(timeout=300000L)
    public void testFinalizeWithDeltaCheck() throws Exception {
        this.testFinalize(2, true);
    }

    @Test(timeout=300000L)
    public void testFinalizeWithMultipleNNDeltaCheck() throws Exception {
        this.testFinalize(3, true);
    }

    private void testFinalize(int nnCount) throws Exception {
        this.testFinalize(nnCount, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFinalize(int nnCount, boolean skipImageDeltaCheck) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster cluster = null;
        Path foo = new Path("/foo");
        Path bar = new Path("/bar");
        try {
            cluster = new MiniQJMHACluster.Builder((Configuration)conf).setNumNameNodes(nnCount).build();
            MiniDFSCluster dfsCluster = cluster.getDfsCluster();
            dfsCluster.waitActive();
            for (int i = 1; i < nnCount; ++i) {
                dfsCluster.getConfiguration(i).setInt("dfs.ha.tail-edits.period", 1);
            }
            dfsCluster.restartNameNodes();
            dfsCluster.transitionToActive(0);
            dfsCluster.getNameNode(0).getHttpServer().setAttribute("recent.image.check.enabled", (Object)skipImageDeltaCheck);
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            dfs.mkdirs(foo);
            FSImage fsimage = dfsCluster.getNamesystem(0).getFSImage();
            RollingUpgradeInfo info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            Assert.assertTrue((boolean)info.isStarted());
            dfs.mkdirs(bar);
            TestRollingUpgrade.queryForPreparation(dfs);
            Assert.assertTrue((boolean)fsimage.hasRollbackFSImage());
            info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.FINALIZE);
            Assert.assertTrue((boolean)info.isFinalized());
            Assert.assertTrue((boolean)dfs.exists(foo));
            Assert.assertFalse((boolean)fsimage.hasRollbackFSImage());
            dfsCluster.restartNameNode(0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=300000L)
    public void testQuery() throws Exception {
        this.testQuery(2);
    }

    @Test(timeout=300000L)
    public void testQueryWithMultipleNN() throws Exception {
        this.testQuery(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testQuery(int nnCount) throws Exception {
        Configuration conf = new Configuration();
        MiniQJMHACluster cluster = null;
        try {
            cluster = new MiniQJMHACluster.Builder(conf).setNumNameNodes(nnCount).build();
            MiniDFSCluster dfsCluster = cluster.getDfsCluster();
            dfsCluster.waitActive();
            dfsCluster.transitionToActive(0);
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            for (int i = 1; i < nnCount; ++i) {
                dfsCluster.shutdownNameNode(i);
            }
            RollingUpgradeInfo info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            Assert.assertTrue((boolean)info.isStarted());
            info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY);
            Assert.assertFalse((boolean)info.createdRollbackImages());
            for (int i = 1; i < nnCount; ++i) {
                dfsCluster.restartNameNode(i);
            }
            TestRollingUpgrade.queryForPreparation(dfs);
            Assert.assertTrue((boolean)dfsCluster.getNamesystem(0).getFSImage().hasRollbackFSImage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testQueryAfterRestart() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            TestRollingUpgrade.queryForPreparation(dfs);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            dfs.saveNamespace();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            cluster.restartNameNodes();
            dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test(timeout=300000L)
    public void testCheckpoint() throws IOException, InterruptedException {
        this.testCheckpoint(2);
    }

    @Test(timeout=300000L)
    public void testCheckpointWithMultipleNN() throws IOException, InterruptedException {
        this.testCheckpoint(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRollBackImage() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.checkpoint.txns", 10);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.namenode.checkpoint.check.period", 2);
        MiniQJMHACluster cluster = null;
        CheckpointFaultInjector old = CheckpointFaultInjector.getInstance();
        try {
            cluster = new MiniQJMHACluster.Builder(conf).setNumNameNodes(2).build();
            MiniDFSCluster dfsCluster = cluster.getDfsCluster();
            dfsCluster.waitActive();
            dfsCluster.transitionToActive(0);
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            for (int i = 0; i <= 10; ++i) {
                Path foo = new Path("/foo" + i);
                dfs.mkdirs(foo);
            }
            cluster.getDfsCluster().getNameNodeRpc(0).rollEdits();
            final CountDownLatch ruEdit = new CountDownLatch(1);
            CheckpointFaultInjector.set((CheckpointFaultInjector)new CheckpointFaultInjector(){

                public void duringUploadInProgess() throws IOException, InterruptedException {
                    if (ruEdit.getCount() == 1L) {
                        ruEdit.countDown();
                        Thread.sleep(180000L);
                    }
                }
            });
            ruEdit.await();
            RollingUpgradeInfo info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            Assert.assertTrue((boolean)info.isStarted());
            FSImage fsimage = dfsCluster.getNamesystem(0).getFSImage();
            TestRollingUpgrade.queryForPreparation(dfs);
            Assert.assertTrue((boolean)fsimage.hasRollbackFSImage());
        }
        finally {
            CheckpointFaultInjector.set((CheckpointFaultInjector)old);
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCheckpoint(int nnCount) throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.namenode.checkpoint.period", 1);
        MiniQJMHACluster cluster = null;
        Path foo = new Path("/foo");
        try {
            cluster = new MiniQJMHACluster.Builder(conf).setNumNameNodes(nnCount).build();
            MiniDFSCluster dfsCluster = cluster.getDfsCluster();
            dfsCluster.waitActive();
            dfsCluster.transitionToActive(0);
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            RollingUpgradeInfo info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            Assert.assertTrue((boolean)info.isStarted());
            TestRollingUpgrade.queryForPreparation(dfs);
            dfs.mkdirs(foo);
            long txid = dfs.rollEdits();
            Assert.assertTrue((txid > 0L ? 1 : 0) != 0);
            for (int i = 1; i < nnCount; ++i) {
                this.verifyNNCheckpoint(dfsCluster, txid, i);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void verifyNNCheckpoint(MiniDFSCluster dfsCluster, long txid, int nnIndex) throws InterruptedException {
        int retries = 0;
        while (++retries < 5) {
            NNStorage storage = dfsCluster.getNamesystem(nnIndex).getFSImage().getStorage();
            if (storage.getFsImageName(txid - 1L) != null) {
                return;
            }
            Thread.sleep(1000L);
        }
        Assert.fail((String)"new checkpoint does not exist");
    }

    static void queryForPreparation(DistributedFileSystem dfs) throws IOException, InterruptedException {
        RollingUpgradeInfo info;
        int retries = 0;
        while (++retries < 10 && !(info = dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY)).createdRollbackImages()) {
            Thread.sleep(1000L);
        }
        if (retries >= 10) {
            Assert.fail((String)"Query return false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointWithSNN() throws Exception {
        MiniDFSCluster cluster = null;
        DistributedFileSystem dfs = null;
        SecondaryNameNode snn = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            cluster.waitActive();
            conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
            snn = new SecondaryNameNode((Configuration)conf);
            dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/test/foo"));
            snn.doCheckpoint();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            dfs.mkdirs(new Path("/test/bar"));
            snn.doCheckpoint();
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{dfs});
            if (snn != null) {
                snn.shutdown();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{dfs});
        if (snn != null) {
            snn.shutdown();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }
}

