/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestSecureNNWithQJM {
    private static final Path TEST_PATH = new Path("/test-dir");
    private static final Path TEST_PATH_2 = new Path("/test-dir-2");
    private static final String PREFIX = "hadoop.http.authentication.";
    private static HdfsConfiguration baseConf;
    private static File baseDir;
    private static String keystoresDir;
    private static String sslConfDir;
    private static MiniKdc kdc;
    private MiniDFSCluster cluster;
    private HdfsConfiguration conf;
    private FileSystem fs;
    private MiniJournalCluster mjc;
    @Rule
    public Timeout timeout = new Timeout(180000);

    @BeforeClass
    public static void init() throws Exception {
        baseDir = GenericTestUtils.getTestDir((String)TestSecureNNWithQJM.class.getSimpleName());
        FileUtil.fullyDelete((File)baseDir);
        Assert.assertTrue((boolean)baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, baseDir);
        kdc.start();
        baseConf = new HdfsConfiguration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)baseConf);
        UserGroupInformation.setConfiguration((Configuration)baseConf);
        Assert.assertTrue((String)"Expected configuration to enable security", (boolean)UserGroupInformation.isSecurityEnabled());
        String userName = UserGroupInformation.getLoginUser().getShortUserName();
        File keytabFile = new File(baseDir, userName + ".keytab");
        String keytab = keytabFile.getAbsolutePath();
        String krbInstance = Path.WINDOWS ? "127.0.0.1" : "localhost";
        kdc.createPrincipal(keytabFile, new String[]{userName + "/" + krbInstance, "HTTP/" + krbInstance});
        String hdfsPrincipal = userName + "/" + krbInstance + "@" + kdc.getRealm();
        String spnegoPrincipal = "HTTP/" + krbInstance + "@" + kdc.getRealm();
        baseConf.set("hadoop.http.filter.initializers", AuthenticationFilterInitializer.class.getName());
        baseConf.set("hadoop.http.authentication.type", "kerberos");
        baseConf.set("hadoop.http.authentication.kerberos.keytab", keytab);
        baseConf.set("hadoop.http.authentication.kerberos.principal", spnegoPrincipal);
        baseConf.set("dfs.namenode.kerberos.principal", hdfsPrincipal);
        baseConf.set("dfs.namenode.keytab.file", keytab);
        baseConf.set("dfs.datanode.kerberos.principal", hdfsPrincipal);
        baseConf.set("dfs.datanode.keytab.file", keytab);
        baseConf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        baseConf.set("dfs.journalnode.keytab.file", keytab);
        baseConf.set("dfs.journalnode.kerberos.principal", hdfsPrincipal);
        baseConf.set("dfs.journalnode.kerberos.internal.spnego.principal", spnegoPrincipal);
        baseConf.setBoolean("dfs.block.access.token.enable", true);
        baseConf.set("dfs.data.transfer.protection", "authentication");
        baseConf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        baseConf.set("dfs.namenode.https-address", "localhost:0");
        baseConf.set("dfs.datanode.https.address", "localhost:0");
        baseConf.set("dfs.journalnode.https-address", "localhost:0");
        baseConf.setInt("ipc.client.connect.max.retries.on.sasl", 10);
        keystoresDir = baseDir.getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSecureNNWithQJM.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)baseConf, (boolean)false);
        baseConf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        baseConf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
    }

    @AfterClass
    public static void destroy() throws Exception {
        if (kdc != null) {
            kdc.stop();
        }
        FileUtil.fullyDelete((File)baseDir);
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
        UserGroupInformation.reset();
    }

    @Before
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration((Configuration)baseConf);
    }

    @After
    public void shutdown() throws IOException {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.fs});
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        if (this.mjc != null) {
            this.mjc.shutdown();
            this.mjc = null;
        }
    }

    @Test
    public void testSecureMode() throws Exception {
        this.doNNWithQJMTest();
    }

    @Test
    public void testSecondaryNameNodeHttpAddressNotNeeded() throws Exception {
        this.conf.set("dfs.namenode.secondary.http-address", "null");
        this.doNNWithQJMTest();
    }

    private void doNNWithQJMTest() throws IOException {
        this.startCluster();
        Assert.assertTrue((boolean)this.fs.mkdirs(TEST_PATH));
        this.restartNameNode();
        Assert.assertTrue((boolean)this.fs.exists(TEST_PATH));
        Assert.assertTrue((boolean)this.fs.mkdirs(TEST_PATH_2));
        this.restartNameNode();
        Assert.assertTrue((boolean)this.fs.exists(TEST_PATH));
        Assert.assertTrue((boolean)this.fs.exists(TEST_PATH_2));
    }

    private void restartNameNode() throws IOException {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.fs});
        this.cluster.restartNameNode(new String[0]);
        this.fs = this.cluster.getFileSystem();
    }

    private void startCluster() throws IOException {
        this.mjc = new MiniJournalCluster.Builder((Configuration)this.conf).build();
        this.mjc.waitActive();
        this.conf.set("dfs.namenode.edits.dir", this.mjc.getQuorumJournalURI("myjournal").toString());
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
    }
}

