/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KMSACLs
implements Runnable,
KeyAuthorizationKeyProvider.KeyACLs {
    private static final Logger LOG = LoggerFactory.getLogger(KMSACLs.class);
    private static final String UNAUTHORIZED_MSG_WITH_KEY = "User:%s not allowed to do '%s' on '%s'";
    private static final String UNAUTHORIZED_MSG_WITHOUT_KEY = "User:%s not allowed to do '%s'";
    public static final String ACL_DEFAULT = "*";
    public static final int RELOADER_SLEEP_MILLIS = 1000;
    private volatile Map<Type, AccessControlList> acls;
    private volatile Map<Type, AccessControlList> blacklistedAcls;
    private volatile Map<String, HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>> keyAcls;
    private final Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> defaultKeyAcls = new HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>();
    private ScheduledExecutorService executorService;
    private long lastReload;

    KMSACLs(Configuration conf) {
        if (conf == null) {
            conf = this.loadACLs();
        }
        this.setKMSACLs(conf);
        this.setKeyACLs(conf);
    }

    public KMSACLs() {
        this(null);
    }

    private void setKMSACLs(Configuration conf) {
        HashMap<Type, AccessControlList> tempAcls = new HashMap<Type, AccessControlList>();
        HashMap<Type, AccessControlList> tempBlacklist = new HashMap<Type, AccessControlList>();
        for (Type aclType : Type.values()) {
            String aclStr = conf.get(aclType.getAclConfigKey(), ACL_DEFAULT);
            tempAcls.put(aclType, new AccessControlList(aclStr));
            String blacklistStr = conf.get(aclType.getBlacklistConfigKey());
            if (blacklistStr != null) {
                tempBlacklist.put(aclType, new AccessControlList(blacklistStr));
                LOG.info("'{}' Blacklist '{}'", (Object)aclType, (Object)blacklistStr);
            }
            LOG.info("'{}' ACL '{}'", (Object)aclType, (Object)aclStr);
        }
        this.acls = tempAcls;
        this.blacklistedAcls = tempBlacklist;
    }

    private void setKeyACLs(Configuration conf) {
        String aclStr;
        HashMap<String, HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>> tempKeyAcls = new HashMap<String, HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>>();
        Map allKeyACLS = conf.getValByRegex(Pattern.quote("key.acl."));
        for (Map.Entry keyAcl : allKeyACLS.entrySet()) {
            int keyNameEnds;
            String k = (String)keyAcl.getKey();
            int keyNameStarts = "key.acl.".length();
            if (keyNameStarts >= (keyNameEnds = k.lastIndexOf("."))) {
                LOG.warn("Invalid key name '{}'", (Object)k);
                continue;
            }
            aclStr = (String)keyAcl.getValue();
            String keyName = k.substring(keyNameStarts, keyNameEnds);
            String keyOp = k.substring(keyNameEnds + 1);
            KeyAuthorizationKeyProvider.KeyOpType aclType = null;
            try {
                aclType = KeyAuthorizationKeyProvider.KeyOpType.valueOf(keyOp);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Invalid key Operation '{}'", (Object)keyOp);
            }
            if (aclType == null) continue;
            HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> aclMap = (HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>)tempKeyAcls.get(keyName);
            if (aclMap == null) {
                aclMap = new HashMap<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>();
                tempKeyAcls.put(keyName, aclMap);
            }
            aclMap.put(aclType, new AccessControlList(aclStr));
            LOG.info("KEY_NAME '{}' KEY_OP '{}' ACL '{}'", new Object[]{keyName, aclType, aclStr});
        }
        this.keyAcls = tempKeyAcls;
        for (KeyAuthorizationKeyProvider.KeyOpType keyOp : KeyAuthorizationKeyProvider.KeyOpType.values()) {
            String confKey;
            if (this.defaultKeyAcls.containsKey((Object)keyOp) || (aclStr = conf.get(confKey = "default.key.acl." + (Object)((Object)keyOp))) == null) continue;
            if (aclStr.equals(ACL_DEFAULT)) {
                LOG.info("Default Key ACL for  KEY_OP '{}' is set to '*'", (Object)keyOp);
            }
            this.defaultKeyAcls.put(keyOp, new AccessControlList(aclStr));
        }
    }

    @Override
    public void run() {
        try {
            if (KMSConfiguration.isACLsFileNewer(this.lastReload)) {
                this.setKMSACLs(this.loadACLs());
                this.setKeyACLs(this.loadACLs());
            }
        }
        catch (Exception ex) {
            LOG.warn(String.format("Could not reload ACLs file: '%s'", ex.toString()), (Throwable)ex);
        }
    }

    public synchronized void startReloader() {
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1);
            this.executorService.scheduleAtFixedRate(this, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stopReloader() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private Configuration loadACLs() {
        LOG.debug("Loading ACLs file");
        this.lastReload = System.currentTimeMillis();
        Configuration conf = KMSConfiguration.getACLsConf();
        conf.get(Type.CREATE.getAclConfigKey());
        return conf;
    }

    public boolean hasAccess(Type type, UserGroupInformation ugi) {
        boolean access = this.acls.get((Object)type).isUserAllowed(ugi);
        if (access) {
            AccessControlList blacklist = this.blacklistedAcls.get((Object)type);
            access = blacklist == null || !blacklist.isUserInList(ugi);
        }
        return access;
    }

    public void assertAccess(Type aclType, UserGroupInformation ugi, KMS.KMSOp operation, String key) throws AccessControlException {
        if (!KMSWebApp.getACLs().hasAccess(aclType, ugi)) {
            KMSWebApp.getUnauthorizedCallsMeter().mark();
            KMSWebApp.getKMSAudit().unauthorized(ugi, operation, key);
            throw new AuthorizationException(String.format(key != null ? UNAUTHORIZED_MSG_WITH_KEY : UNAUTHORIZED_MSG_WITHOUT_KEY, new Object[]{ugi.getShortUserName(), operation, key}));
        }
    }

    @Override
    public boolean hasAccessToKey(String keyName, UserGroupInformation ugi, KeyAuthorizationKeyProvider.KeyOpType opType) {
        AccessControlList acl;
        Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList> keyAcl = (Map<KeyAuthorizationKeyProvider.KeyOpType, AccessControlList>)this.keyAcls.get(keyName);
        if (keyAcl == null) {
            keyAcl = this.defaultKeyAcls;
        }
        if ((acl = keyAcl.get((Object)opType)) == null) {
            return false;
        }
        return acl.isUserAllowed(ugi);
    }

    @Override
    public boolean isACLPresent(String keyName, KeyAuthorizationKeyProvider.KeyOpType opType) {
        return this.keyAcls.containsKey(keyName) || this.defaultKeyAcls.containsKey((Object)opType);
    }

    public static enum Type {
        CREATE,
        DELETE,
        ROLLOVER,
        GET,
        GET_KEYS,
        GET_METADATA,
        SET_KEY_MATERIAL,
        GENERATE_EEK,
        DECRYPT_EEK;


        public String getAclConfigKey() {
            return "hadoop.kms.acl." + this.toString();
        }

        public String getBlacklistConfigKey() {
            return "hadoop.kms.blacklist." + this.toString();
        }
    }
}

