/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;

public class KeyAuthorizationKeyProvider
extends KeyProviderCryptoExtension {
    public static final String KEY_ACL = "key.acl.";
    private static final String KEY_ACL_NAME = "key.acl.name";
    private final KeyProviderCryptoExtension provider;
    private final KeyACLs acls;

    public KeyAuthorizationKeyProvider(KeyProviderCryptoExtension keyProvider, KeyACLs acls) {
        super((KeyProvider)keyProvider, null);
        this.provider = keyProvider;
        this.acls = acls;
    }

    private void authorizeCreateKey(String keyName, KeyProvider.Options options, UserGroupInformation ugi) throws IOException {
        Preconditions.checkNotNull((Object)ugi, (Object)"UserGroupInformation cannot be null");
        Map attributes = options.getAttributes();
        String aclName = (String)attributes.get(KEY_ACL_NAME);
        boolean success = false;
        if (Strings.isNullOrEmpty((String)aclName)) {
            if (this.acls.isACLPresent(keyName, KeyOpType.MANAGEMENT)) {
                options.setAttributes((Map)ImmutableMap.builder().putAll(attributes).put((Object)KEY_ACL_NAME, (Object)keyName).build());
                success = this.acls.hasAccessToKey(keyName, ugi, KeyOpType.MANAGEMENT) || this.acls.hasAccessToKey(keyName, ugi, KeyOpType.ALL);
            } else {
                success = false;
            }
        } else {
            boolean bl = success = this.acls.isACLPresent(aclName, KeyOpType.MANAGEMENT) && (this.acls.hasAccessToKey(aclName, ugi, KeyOpType.MANAGEMENT) || this.acls.hasAccessToKey(aclName, ugi, KeyOpType.ALL));
        }
        if (!success) {
            throw new AuthorizationException(String.format("User [%s] is not authorized to create key !!", ugi.getShortUserName()));
        }
    }

    private void checkAccess(String aclName, UserGroupInformation ugi, KeyOpType opType) throws AuthorizationException {
        Preconditions.checkNotNull((Object)aclName, (Object)"Key ACL name cannot be null");
        Preconditions.checkNotNull((Object)ugi, (Object)"UserGroupInformation cannot be null");
        if (this.acls.isACLPresent(aclName, KeyOpType.MANAGEMENT) && (this.acls.hasAccessToKey(aclName, ugi, opType) || this.acls.hasAccessToKey(aclName, ugi, KeyOpType.ALL))) {
            return;
        }
        throw new AuthorizationException(String.format("User [%s] is not authorized to perform [%s] on key with ACL name [%s]!!", new Object[]{ugi.getShortUserName(), opType, aclName}));
    }

    public KeyProvider.KeyVersion createKey(String name, KeyProvider.Options options) throws NoSuchAlgorithmException, IOException {
        this.authorizeCreateKey(name, options, this.getUser());
        return this.provider.createKey(name, options);
    }

    public KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options options) throws IOException {
        this.authorizeCreateKey(name, options, this.getUser());
        return this.provider.createKey(name, material, options);
    }

    public KeyProvider.KeyVersion rollNewVersion(String name) throws NoSuchAlgorithmException, IOException {
        this.doAccessCheck(name, KeyOpType.MANAGEMENT);
        return this.provider.rollNewVersion(name);
    }

    public void deleteKey(String name) throws IOException {
        this.doAccessCheck(name, KeyOpType.MANAGEMENT);
        this.provider.deleteKey(name);
    }

    public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
        this.doAccessCheck(name, KeyOpType.MANAGEMENT);
        return this.provider.rollNewVersion(name, material);
    }

    public void warmUpEncryptedKeys(String ... names) throws IOException {
        for (String name : names) {
            this.doAccessCheck(name, KeyOpType.GENERATE_EEK);
        }
        this.provider.warmUpEncryptedKeys(names);
    }

    public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
        this.doAccessCheck(encryptionKeyName, KeyOpType.GENERATE_EEK);
        return this.provider.generateEncryptedKey(encryptionKeyName);
    }

    private void verifyKeyVersionBelongsToKey(KeyProviderCryptoExtension.EncryptedKeyVersion ekv) throws IOException {
        String kn = ekv.getEncryptionKeyName();
        String kvn = ekv.getEncryptionKeyVersionName();
        KeyProvider.KeyVersion kv = this.provider.getKeyVersion(kvn);
        if (!kv.getName().equals(kn)) {
            throw new IllegalArgumentException(String.format("KeyVersion '%s' does not belong to the key '%s'", kvn, kn));
        }
    }

    public KeyProvider.KeyVersion decryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
        this.verifyKeyVersionBelongsToKey(encryptedKeyVersion);
        this.doAccessCheck(encryptedKeyVersion.getEncryptionKeyName(), KeyOpType.DECRYPT_EEK);
        return this.provider.decryptEncryptedKey(encryptedKeyVersion);
    }

    public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
        KeyProvider.KeyVersion keyVersion = this.provider.getKeyVersion(versionName);
        if (keyVersion != null) {
            this.doAccessCheck(keyVersion.getName(), KeyOpType.READ);
        }
        return keyVersion;
    }

    public List<String> getKeys() throws IOException {
        return this.provider.getKeys();
    }

    public List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
        this.doAccessCheck(name, KeyOpType.READ);
        return this.provider.getKeyVersions(name);
    }

    public KeyProvider.Metadata getMetadata(String name) throws IOException {
        this.doAccessCheck(name, KeyOpType.READ);
        return this.provider.getMetadata(name);
    }

    public KeyProvider.Metadata[] getKeysMetadata(String ... names) throws IOException {
        for (String name : names) {
            this.doAccessCheck(name, KeyOpType.READ);
        }
        return this.provider.getKeysMetadata(names);
    }

    public KeyProvider.KeyVersion getCurrentKey(String name) throws IOException {
        this.doAccessCheck(name, KeyOpType.READ);
        return this.provider.getCurrentKey(name);
    }

    public void flush() throws IOException {
        this.provider.flush();
    }

    public boolean isTransient() {
        return this.provider.isTransient();
    }

    private void doAccessCheck(String keyName, KeyOpType opType) throws IOException {
        KeyProvider.Metadata metadata = this.provider.getMetadata(keyName);
        if (metadata != null) {
            String aclName = (String)metadata.getAttributes().get(KEY_ACL_NAME);
            this.checkAccess(aclName == null ? keyName : aclName, this.getUser(), opType);
        }
    }

    private UserGroupInformation getUser() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    protected KeyProvider getKeyProvider() {
        return this;
    }

    public String toString() {
        return this.provider.toString();
    }

    public static interface KeyACLs {
        public boolean hasAccessToKey(String var1, UserGroupInformation var2, KeyOpType var3);

        public boolean isACLPresent(String var1, KeyOpType var2);
    }

    public static enum KeyOpType {
        ALL,
        READ,
        MANAGEMENT,
        GENERATE_EEK,
        DECRYPT_EEK;

    }
}

