/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.ssl.SslSocketConnectorSecure;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

public class MiniKMS {
    private String kmsConfDir;
    private String log4jConfFile;
    private String keyStore;
    private String keyStorePassword;
    private Server jetty;
    private int inPort;
    private URL kmsURL;

    private static Server createJettyServer(String keyStore, String password, int inPort) {
        try {
            boolean ssl = keyStore != null;
            InetAddress localhost = InetAddress.getByName("localhost");
            String host = "localhost";
            ServerSocket ss = new ServerSocket(inPort < 0 ? 0 : inPort, 50, localhost);
            int port = ss.getLocalPort();
            ss.close();
            Server server = new Server(0);
            if (!ssl) {
                server.getConnectors()[0].setHost(host);
                server.getConnectors()[0].setPort(port);
            } else {
                SslSocketConnectorSecure c = new SslSocketConnectorSecure();
                c.setHost(host);
                c.setPort(port);
                c.setNeedClientAuth(false);
                c.setKeystore(keyStore);
                c.setKeystoreType("jks");
                c.setKeyPassword(password);
                server.setConnectors(new Connector[]{c});
            }
            return server;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not start embedded servlet container, " + ex.getMessage(), ex);
        }
    }

    private static URL getJettyURL(Server server) {
        boolean ssl = server.getConnectors()[0].getClass() == SslSocketConnectorSecure.class;
        try {
            String scheme = ssl ? "https" : "http";
            return new URL(scheme + "://" + server.getConnectors()[0].getHost() + ":" + server.getConnectors()[0].getPort());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("It should never happen, " + ex.getMessage(), ex);
        }
    }

    public MiniKMS(String kmsConfDir, String log4ConfFile, String keyStore, String password, int inPort) {
        this.kmsConfDir = kmsConfDir;
        this.log4jConfFile = log4ConfFile;
        this.keyStore = keyStore;
        this.keyStorePassword = password;
        this.inPort = inPort;
    }

    public void start() throws Exception {
        String webappPath;
        File kmsFile;
        File coreFile;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        System.setProperty("kms.config.dir", this.kmsConfDir);
        File aclsFile = new File(this.kmsConfDir, "kms-acls.xml");
        if (!aclsFile.exists()) {
            InputStream is = cl.getResourceAsStream("mini-kms-acls-default.xml");
            FileOutputStream os = new FileOutputStream(aclsFile);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            is.close();
            ((OutputStream)os).close();
        }
        if (!(coreFile = new File(this.kmsConfDir, "core-site.xml")).exists()) {
            Configuration core = new Configuration();
            FileWriter writer = new FileWriter(coreFile);
            core.writeXml((Writer)writer);
            ((Writer)writer).close();
        }
        if (!(kmsFile = new File(this.kmsConfDir, "kms-site.xml")).exists()) {
            Configuration kms = new Configuration(false);
            kms.set("hadoop.kms.key.provider.uri", "jceks://file@" + new Path(this.kmsConfDir, "kms.keystore").toUri());
            kms.set("hadoop.kms.authentication.type", "simple");
            FileWriter writer = new FileWriter(kmsFile);
            kms.writeXml((Writer)writer);
            ((Writer)writer).close();
        }
        System.setProperty("log4j.configuration", this.log4jConfFile);
        this.jetty = MiniKMS.createJettyServer(this.keyStore, this.keyStorePassword, this.inPort);
        URL webXmlUrl = cl.getResource("kms-webapp/WEB-INF/web.xml");
        if (webXmlUrl == null) {
            throw new RuntimeException("Could not find kms-webapp/ dir in test classpath");
        }
        boolean webXmlInJar = webXmlUrl.getPath().contains(".jar!/");
        if (webXmlInJar) {
            File webInf = new File("target/" + UUID.randomUUID().toString() + "/kms-webapp/WEB-INF");
            webInf.mkdirs();
            new File(webInf, "web.xml").delete();
            InputStream is = cl.getResourceAsStream("kms-webapp/WEB-INF/web.xml");
            FileOutputStream os = new FileOutputStream(new File(webInf, "web.xml"));
            IOUtils.copy((InputStream)is, (OutputStream)os);
            is.close();
            ((OutputStream)os).close();
            webappPath = webInf.getParentFile().getAbsolutePath();
        } else {
            webappPath = cl.getResource("kms-webapp").getPath();
        }
        WebAppContext context = new WebAppContext(webappPath, "/kms");
        if (webXmlInJar) {
            context.setClassLoader(cl);
        }
        this.jetty.addHandler((Handler)context);
        this.jetty.start();
        this.kmsURL = new URL(MiniKMS.getJettyURL(this.jetty), "kms");
    }

    public URL getKMSUrl() {
        return this.kmsURL;
    }

    public void stop() {
        if (this.jetty != null && this.jetty.isRunning()) {
            try {
                this.jetty.stop();
                this.jetty = null;
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not stop MiniKMS embedded Jetty, " + ex.getMessage(), ex);
            }
        }
    }

    public static class Builder {
        private File kmsConfDir = new File("target/test-classes").getAbsoluteFile();
        private String log4jConfFile = "kms-log4j.properties";
        private File keyStoreFile;
        private String keyStorePassword;
        private int inPort = -1;

        public Builder setKmsConfDir(File confDir) {
            Preconditions.checkNotNull((Object)confDir, (Object)"KMS conf dir is NULL");
            Preconditions.checkArgument((boolean)confDir.exists(), (Object)"KMS conf dir does not exist");
            this.kmsConfDir = confDir;
            return this;
        }

        public Builder setLog4jConfFile(String log4jConfFile) {
            Preconditions.checkNotNull((Object)log4jConfFile, (Object)"log4jconf file is NULL");
            this.log4jConfFile = log4jConfFile;
            return this;
        }

        public Builder setPort(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"input port must be greater than 0");
            this.inPort = port;
            return this;
        }

        public Builder setSslConf(File keyStoreFile, String keyStorePassword) {
            Preconditions.checkNotNull((Object)keyStoreFile, (Object)"keystore file is NULL");
            Preconditions.checkNotNull((Object)keyStorePassword, (Object)"keystore password is NULL");
            Preconditions.checkArgument((boolean)keyStoreFile.exists(), (Object)"keystore file does not exist");
            this.keyStoreFile = keyStoreFile;
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public MiniKMS build() {
            Preconditions.checkArgument((boolean)this.kmsConfDir.exists(), (Object)"KMS conf dir does not exist");
            return new MiniKMS(this.kmsConfDir.getAbsolutePath(), this.log4jConfFile, this.keyStoreFile != null ? this.keyStoreFile.getAbsolutePath() : null, this.keyStorePassword, this.inPort);
        }
    }
}

