/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMSACLs;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;

public class TestKMSACLs {
    @Test
    public void testDefaults() {
        KMSACLs acls = new KMSACLs(new Configuration(false));
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            Assert.assertTrue((boolean)acls.hasAccess(type, UserGroupInformation.createRemoteUser((String)"foo")));
        }
    }

    @Test
    public void testCustom() {
        Configuration conf = new Configuration(false);
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            conf.set(type.getAclConfigKey(), type.toString() + " ");
        }
        KMSACLs acls = new KMSACLs(conf);
        for (KMSACLs.Type type : KMSACLs.Type.values()) {
            Assert.assertTrue((boolean)acls.hasAccess(type, UserGroupInformation.createRemoteUser((String)type.toString())));
            Assert.assertFalse((boolean)acls.hasAccess(type, UserGroupInformation.createRemoteUser((String)"foo")));
        }
    }
}

