/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ConfigurationWithLogging;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KMSWebServer {
    private static final Logger LOG = LoggerFactory.getLogger(KMSWebServer.class);
    private static final String NAME = "kms";
    private static final String SERVLET_PATH = "/kms";
    private final HttpServer2 httpServer;
    private final String scheme;

    KMSWebServer(Configuration cnf) throws Exception {
        ConfigurationWithLogging conf = new ConfigurationWithLogging(cnf);
        conf.addResource(conf.get("hadoop.ssl.server.conf", "ssl-server.xml"));
        KMSWebServer.deprecateEnv("KMS_TEMP", (Configuration)conf, "hadoop.http.temp.dir", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_HTTP_PORT", (Configuration)conf, "hadoop.kms.http.port", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_MAX_THREADS", (Configuration)conf, "hadoop.http.max.threads", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_MAX_HTTP_HEADER_SIZE", (Configuration)conf, "hadoop.http.max.request.header.size", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_MAX_HTTP_HEADER_SIZE", (Configuration)conf, "hadoop.http.max.response.header.size", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_SSL_ENABLED", (Configuration)conf, "hadoop.kms.ssl.enabled", "kms-site.xml");
        KMSWebServer.deprecateEnv("KMS_SSL_KEYSTORE_FILE", (Configuration)conf, "ssl.server.keystore.location", "ssl-server.xml");
        KMSWebServer.deprecateEnv("KMS_SSL_KEYSTORE_PASS", (Configuration)conf, "ssl.server.keystore.password", "ssl-server.xml");
        boolean sslEnabled = conf.getBoolean("hadoop.kms.ssl.enabled", false);
        this.scheme = sslEnabled ? "https" : "http";
        String host = conf.get("hadoop.kms.http.host", "0.0.0.0");
        int port = conf.getInt("hadoop.kms.http.port", 9600);
        URI endpoint = new URI(this.scheme, null, host, port, null, null, null);
        this.httpServer = new HttpServer2.Builder().setName(NAME).setConf((Configuration)conf).setSSLConf((Configuration)conf).authFilterConfigurationPrefix("hadoop.kms.authentication.").addEndpoint(endpoint).build();
    }

    private static void deprecateEnv(String varName, Configuration conf, String propName, String confFile) {
        String value = System.getenv(varName);
        if (value == null) {
            return;
        }
        String propValue = conf.get(propName);
        LOG.warn("Environment variable {} = '{}' is deprecated and overriding property {} = '{}', please set the property in {} instead.", new Object[]{varName, value, propName, propValue, confFile});
        conf.set(propName, value, "environment variable " + varName);
    }

    public void start() throws IOException {
        this.httpServer.start();
    }

    public boolean isRunning() {
        return this.httpServer.isAlive();
    }

    public void join() throws InterruptedException {
        this.httpServer.join();
    }

    public void stop() throws Exception {
        this.httpServer.stop();
    }

    public URL getKMSUrl() {
        InetSocketAddress addr = this.httpServer.getConnectorAddress(0);
        if (null == addr) {
            return null;
        }
        try {
            return new URL(this.scheme, addr.getHostName(), addr.getPort(), SERVLET_PATH);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("It should never happen: " + ex.getMessage(), ex);
        }
    }

    public static void main(String[] args) throws Exception {
        StringUtils.startupShutdownMessage(KMSWebServer.class, (String[])args, (Logger)LOG);
        Configuration conf = KMSConfiguration.getKMSConf();
        KMSWebServer kmsWebServer = new KMSWebServer(conf);
        kmsWebServer.start();
        kmsWebServer.join();
    }
}

