/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletion;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobUnsuccessfulCompletionEvent
implements HistoryEvent {
    private JobUnsuccessfulCompletion datum = new JobUnsuccessfulCompletion();

    public JobUnsuccessfulCompletionEvent(JobID id, long finishTime, int finishedMaps, int finishedReduces, String status) {
        this.datum.jobid = new Utf8(id.toString());
        this.datum.finishTime = finishTime;
        this.datum.finishedMaps = finishedMaps;
        this.datum.finishedReduces = finishedReduces;
        this.datum.jobStatus = new Utf8(status);
    }

    JobUnsuccessfulCompletionEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobUnsuccessfulCompletion)((Object)datum);
    }

    public JobID getJobId() {
        return JobID.forName(((Object)this.datum.jobid).toString());
    }

    public long getFinishTime() {
        return this.datum.finishTime;
    }

    public int getFinishedMaps() {
        return this.datum.finishedMaps;
    }

    public int getFinishedReduces() {
        return this.datum.finishedReduces;
    }

    public String getStatus() {
        return ((Object)this.datum.jobStatus).toString();
    }

    @Override
    public EventType getEventType() {
        if ("FAILED".equals(this.getStatus())) {
            return EventType.JOB_FAILED;
        }
        return EventType.JOB_KILLED;
    }
}

