/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.launcher;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.TestContainerLauncher;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.HadoopYarnProtoRPC;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestContainerLauncher {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    Configuration conf;
    Server server;
    static final Log LOG = LogFactory.getLog(TestContainerLauncher.class);

    @Test
    public void testPoolSize() throws InterruptedException {
        TaskAttemptId taskAttemptId;
        ApplicationId appId = BuilderUtils.newApplicationId((long)12345L, (int)67);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)3);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)8);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)9, (TaskType)TaskType.MAP);
        AppContext context = (AppContext)Mockito.mock(AppContext.class);
        CustomContainerLauncher containerLauncher = new CustomContainerLauncher(this, context, null);
        containerLauncher.init(new Configuration());
        containerLauncher.start();
        ThreadPoolExecutor threadPool = containerLauncher.getThreadPool();
        Assert.assertEquals((int)0, (int)threadPool.getPoolSize());
        Assert.assertEquals((int)10, (int)threadPool.getCorePoolSize());
        Assert.assertNull((Object)CustomContainerLauncher.access$100((CustomContainerLauncher)containerLauncher));
        CustomContainerLauncher.access$202((CustomContainerLauncher)containerLauncher, (int)10);
        for (int i = 0; i < 10; ++i) {
            ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (int)i);
            taskAttemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)i);
            containerLauncher.handle(new ContainerLauncherEvent(taskAttemptId, containerId, "host" + i + ":1234", null, ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH));
        }
        this.waitForEvents(containerLauncher, 10);
        Assert.assertEquals((int)10, (int)threadPool.getPoolSize());
        Assert.assertNull((Object)CustomContainerLauncher.access$100((CustomContainerLauncher)containerLauncher));
        CustomContainerLauncher.access$302((CustomContainerLauncher)containerLauncher, (boolean)true);
        int timeOut = 0;
        while (CustomContainerLauncher.access$400((CustomContainerLauncher)containerLauncher).get() < 10 && timeOut++ < 200) {
            LOG.info((Object)("Waiting for number of events processed to become 10. It is now " + CustomContainerLauncher.access$400((CustomContainerLauncher)containerLauncher).get() + ". Timeout is " + timeOut));
            Thread.sleep(1000L);
        }
        Assert.assertEquals((int)10, (int)CustomContainerLauncher.access$400((CustomContainerLauncher)containerLauncher).get());
        CustomContainerLauncher.access$302((CustomContainerLauncher)containerLauncher, (boolean)false);
        for (int i = 0; i < 10; ++i) {
            ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (int)(i + 10));
            TaskAttemptId taskAttemptId2 = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)(i + 10));
            containerLauncher.handle(new ContainerLauncherEvent(taskAttemptId2, containerId, "host" + i + ":1234", null, ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH));
        }
        this.waitForEvents(containerLauncher, 20);
        Assert.assertEquals((int)10, (int)threadPool.getPoolSize());
        Assert.assertNull((Object)CustomContainerLauncher.access$100((CustomContainerLauncher)containerLauncher));
        CustomContainerLauncher.access$202((CustomContainerLauncher)containerLauncher, (int)21);
        CustomContainerLauncher.access$302((CustomContainerLauncher)containerLauncher, (boolean)false);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (int)21);
        taskAttemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)21);
        containerLauncher.handle(new ContainerLauncherEvent(taskAttemptId, containerId, "host11:1234", null, ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH));
        this.waitForEvents(containerLauncher, 21);
        Assert.assertEquals((int)11, (int)threadPool.getPoolSize());
        Assert.assertNull((Object)CustomContainerLauncher.access$100((CustomContainerLauncher)containerLauncher));
        containerLauncher.stop();
    }

    @Test
    public void testPoolLimits() throws InterruptedException {
        int i;
        ApplicationId appId = BuilderUtils.newApplicationId((long)12345L, (int)67);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)3);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)8);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)9, (TaskType)TaskType.MAP);
        TaskAttemptId taskAttemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)0);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (int)10);
        AppContext context = (AppContext)Mockito.mock(AppContext.class);
        CustomContainerLauncher containerLauncher = new CustomContainerLauncher(this, context, null);
        Configuration conf = new Configuration();
        conf.setInt("yarn.app.mapreduce.am.containerlauncher.thread-count-limit", 12);
        containerLauncher.init(conf);
        containerLauncher.start();
        ThreadPoolExecutor threadPool = containerLauncher.getThreadPool();
        CustomContainerLauncher.access$202((CustomContainerLauncher)containerLauncher, (int)10);
        for (i = 0; i < 10; ++i) {
            containerLauncher.handle(new ContainerLauncherEvent(taskAttemptId, containerId, "host" + i + ":1234", null, ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH));
        }
        this.waitForEvents(containerLauncher, 10);
        Assert.assertEquals((int)10, (int)threadPool.getPoolSize());
        Assert.assertNull((Object)CustomContainerLauncher.access$100((CustomContainerLauncher)containerLauncher));
        CustomContainerLauncher.access$202((CustomContainerLauncher)containerLauncher, (int)12);
        for (i = 1; i <= 4; ++i) {
            containerLauncher.handle(new ContainerLauncherEvent(taskAttemptId, containerId, "host1" + i + ":1234", null, ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH));
        }
        this.waitForEvents(containerLauncher, 12);
        Assert.assertEquals((int)12, (int)threadPool.getPoolSize());
        Assert.assertNull((Object)CustomContainerLauncher.access$100((CustomContainerLauncher)containerLauncher));
        CustomContainerLauncher.access$302((CustomContainerLauncher)containerLauncher, (boolean)true);
        this.waitForEvents(containerLauncher, 14);
        Assert.assertEquals((int)12, (int)threadPool.getPoolSize());
        Assert.assertNull((Object)CustomContainerLauncher.access$100((CustomContainerLauncher)containerLauncher));
        containerLauncher.stop();
    }

    private void waitForEvents(CustomContainerLauncher containerLauncher, int expectedNumEvents) throws InterruptedException {
        int timeOut = 0;
        while (CustomContainerLauncher.access$500((CustomContainerLauncher)containerLauncher).get() < expectedNumEvents && timeOut++ < 20) {
            LOG.info((Object)("Waiting for number of events to become " + expectedNumEvents + ". It is now " + CustomContainerLauncher.access$500((CustomContainerLauncher)containerLauncher).get()));
            Thread.sleep(1000L);
        }
        Assert.assertEquals((int)expectedNumEvents, (int)CustomContainerLauncher.access$500((CustomContainerLauncher)containerLauncher).get());
    }

    @Test
    public void testSlowNM() throws Exception {
        this.test();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() throws Exception {
        this.conf = new Configuration();
        int maxAttempts = 1;
        this.conf.setInt("mapreduce.map.maxattempts", maxAttempts);
        this.conf.setBoolean("mapreduce.job.ubertask.enable", false);
        this.conf.setInt("yarn.rpc.nm-command-timeout", 3000);
        this.conf.set("yarn.ipc.rpc.class", HadoopYarnProtoRPC.class.getName());
        YarnRPC rpc = YarnRPC.create((Configuration)this.conf);
        String bindAddr = "localhost:0";
        InetSocketAddress addr = NetUtils.createSocketAddr((String)bindAddr);
        this.server = rpc.getServer(ContainerManager.class, (Object)new DummyContainerManager(this), addr, this.conf, null, 1);
        this.server.start();
        MRAppWithSlowNM app = new MRAppWithSlowNM(this);
        try {
            Job job = app.submit(this.conf);
            app.waitForState(job, JobState.RUNNING);
            Map tasks = job.getTasks();
            Assert.assertEquals((String)"Num tasks is not correct", (int)1, (int)tasks.size());
            Task task = (Task)tasks.values().iterator().next();
            app.waitForState(task, TaskState.SCHEDULED);
            Map attempts = ((Task)tasks.values().iterator().next()).getAttempts();
            Assert.assertEquals((String)"Num attempts is not correct", (int)maxAttempts, (int)attempts.size());
            TaskAttempt attempt = (TaskAttempt)attempts.values().iterator().next();
            app.waitForState(attempt, TaskAttemptState.ASSIGNED);
            app.waitForState(job, JobState.FAILED);
            String diagnostics = attempt.getDiagnostics().toString();
            LOG.info((Object)("attempt.getDiagnostics: " + diagnostics));
            Assert.assertTrue((boolean)diagnostics.contains("Container launch failed for container_0_0000_01_000000 : "));
            Assert.assertTrue((boolean)diagnostics.contains("java.net.SocketTimeoutException: 3000 millis timeout while waiting for channel"));
        }
        finally {
            this.server.stop();
            app.stop();
        }
    }

    static /* synthetic */ RecordFactory access$700() {
        return recordFactory;
    }
}

