/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.taskclean;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.taskclean.TaskCleaner;
import org.apache.hadoop.mapreduce.v2.app.taskclean.TaskCleanupEvent;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.service.AbstractService;

public class TaskCleanerImpl
extends AbstractService
implements TaskCleaner {
    private static final Log LOG = LogFactory.getLog(TaskCleanerImpl.class);
    private final AppContext context;
    private ThreadPoolExecutor launcherPool;
    private Thread eventHandlingThread;
    private BlockingQueue<TaskCleanupEvent> eventQueue = new LinkedBlockingQueue();

    public TaskCleanerImpl(AppContext context) {
        super("TaskCleaner");
        this.context = context;
    }

    public void start() {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("TaskCleaner #%d").build();
        this.launcherPool = new ThreadPoolExecutor(5, 5, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
        this.eventHandlingThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.eventHandlingThread.setName("TaskCleaner Event Handler");
        this.eventHandlingThread.start();
        super.start();
    }

    public void stop() {
        this.eventHandlingThread.interrupt();
        this.launcherPool.shutdown();
        super.stop();
    }

    public void handle(TaskCleanupEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnException((Throwable)e);
        }
    }

    static /* synthetic */ BlockingQueue access$000(TaskCleanerImpl x0) {
        return x0.eventQueue;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ ThreadPoolExecutor access$200(TaskCleanerImpl x0) {
        return x0.launcherPool;
    }

    static /* synthetic */ AppContext access$300(TaskCleanerImpl x0) {
        return x0.context;
    }
}

