/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.app.webapp.TestAMWebServices;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServices
extends JerseyTest {
    private static Configuration conf = new Configuration();
    private static TestAppContext appContext;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestAMWebServices() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.app.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testAM() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testAMSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testAMDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce/").get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testAMXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        this.verifyAMInfoXML(xml, appContext);
    }

    @Test
    public void testInfo() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("info").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testInfoSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("info/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testInfoDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("info/").get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testInfoXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("info/").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        this.verifyAMInfoXML(xml, appContext);
    }

    @Test
    public void testInvalidUri() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("mapreduce").path("bogus").accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidUri2() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("invalid").accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidAccept() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("mapreduce").accept(new String[]{"text/plain"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.INTERNAL_SERVER_ERROR, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    public void verifyAMInfo(JSONObject info, TestAppContext ctx) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)5L, (long)info.length());
        this.verifyAMInfoGeneric(ctx, info.getString("appId"), info.getString("user"), info.getString("name"), info.getLong("startedOn"), info.getLong("elapsedTime"));
    }

    public void verifyAMInfoXML(String xml, TestAppContext ctx) throws JSONException, Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("info");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyAMInfoGeneric(ctx, WebServicesTestUtils.getXmlString((Element)element, (String)"appId"), WebServicesTestUtils.getXmlString((Element)element, (String)"user"), WebServicesTestUtils.getXmlString((Element)element, (String)"name"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startedOn"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"));
        }
    }

    public void verifyAMInfoGeneric(TestAppContext ctx, String id, String user, String name, long startedOn, long elapsedTime) {
        WebServicesTestUtils.checkStringMatch((String)"id", (String)ctx.getApplicationID().toString(), (String)id);
        WebServicesTestUtils.checkStringMatch((String)"user", (String)((Object)ctx.getUser()).toString(), (String)user);
        WebServicesTestUtils.checkStringMatch((String)"name", (String)ctx.getApplicationName(), (String)name);
        Assert.assertEquals((String)"startedOn incorrect", (long)ctx.getStartTime(), (long)startedOn);
        Assert.assertTrue((String)"elapsedTime not greater then 0", (elapsedTime > 0L ? 1 : 0) != 0);
    }

    static /* synthetic */ TestAppContext access$002(TestAppContext x0) {
        appContext = x0;
        return appContext;
    }

    static /* synthetic */ TestAppContext access$000() {
        return appContext;
    }

    static /* synthetic */ Configuration access$100() {
        return conf;
    }

    static /* synthetic */ Injector access$200(TestAMWebServices x0) {
        return x0.injector;
    }
}

