/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TestTaskAttemptListenerImpl;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.yarn.SystemClock;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTaskAttemptListenerImpl {
    @Test(timeout=20000L)
    public void testGetTask() throws IOException {
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        JobTokenSecretManager secret = (JobTokenSecretManager)Mockito.mock(JobTokenSecretManager.class);
        RMHeartbeatHandler rmHeartbeatHandler = (RMHeartbeatHandler)Mockito.mock(RMHeartbeatHandler.class);
        TaskHeartbeatHandler hbHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        MockTaskAttemptListenerImpl listener = new MockTaskAttemptListenerImpl(appCtx, secret, rmHeartbeatHandler, hbHandler);
        Configuration conf = new Configuration();
        listener.init(conf);
        listener.start();
        JVMId id = new JVMId("foo", 1, true, 1);
        WrappedJvmID wid = new WrappedJvmID(id.getJobId(), id.isMap, id.getId());
        JvmContext context = new JvmContext();
        context.jvmId = id;
        JvmTask result = listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        TaskAttemptId attemptID = (TaskAttemptId)Mockito.mock(TaskAttemptId.class);
        Task task = (Task)Mockito.mock(Task.class);
        listener.registerPendingTask(task, wid);
        result = listener.getTask(context);
        Assert.assertNull((Object)result);
        listener.unregister(attemptID, wid);
        listener.registerPendingTask(task, wid);
        listener.registerLaunchedTask(attemptID, wid);
        ((TaskHeartbeatHandler)Mockito.verify((Object)hbHandler)).register(attemptID);
        result = listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.shouldDie);
        result = listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        listener.unregister(attemptID, wid);
        result = listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        listener.stop();
        JVMId jvmid = JVMId.forName((String)"jvm_001_002_m_004");
        Assert.assertNotNull((Object)jvmid);
        try {
            JVMId.forName((String)"jvm_001_002_m_004_006");
            junit.framework.Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"TaskId string : jvm_001_002_m_004_006 is not properly formed");
        }
    }

    @Test
    public void testJVMId() {
        JVMId jvmid = new JVMId("test", 1, true, 2);
        JVMId jvmid1 = JVMId.forName((String)"jvm_test_0001_m_000002");
        Assert.assertEquals((long)0L, (long)jvmid.compareTo((ID)jvmid1));
    }

    @Test(timeout=20000L)
    public void testGetMapCompletionEvents() throws IOException {
        TaskAttemptCompletionEvent[] empty = new TaskAttemptCompletionEvent[]{};
        TaskAttemptCompletionEvent[] taskEvents = new TaskAttemptCompletionEvent[]{TestTaskAttemptListenerImpl.createTce((int)0, (boolean)true, (TaskAttemptCompletionEventStatus)TaskAttemptCompletionEventStatus.OBSOLETE), TestTaskAttemptListenerImpl.createTce((int)1, (boolean)false, (TaskAttemptCompletionEventStatus)TaskAttemptCompletionEventStatus.FAILED), TestTaskAttemptListenerImpl.createTce((int)2, (boolean)true, (TaskAttemptCompletionEventStatus)TaskAttemptCompletionEventStatus.SUCCEEDED), TestTaskAttemptListenerImpl.createTce((int)3, (boolean)false, (TaskAttemptCompletionEventStatus)TaskAttemptCompletionEventStatus.FAILED)};
        TaskAttemptCompletionEvent[] mapEvents = new TaskAttemptCompletionEvent[]{taskEvents[0], taskEvents[2]};
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getTaskAttemptCompletionEvents(0, 100)).thenReturn((Object)taskEvents);
        Mockito.when((Object)mockJob.getTaskAttemptCompletionEvents(0, 2)).thenReturn((Object)Arrays.copyOfRange(taskEvents, 0, 2));
        Mockito.when((Object)mockJob.getTaskAttemptCompletionEvents(2, 100)).thenReturn((Object)Arrays.copyOfRange(taskEvents, 2, 4));
        Mockito.when((Object)mockJob.getMapAttemptCompletionEvents(0, 100)).thenReturn((Object)TypeConverter.fromYarn((TaskAttemptCompletionEvent[])mapEvents));
        Mockito.when((Object)mockJob.getMapAttemptCompletionEvents(0, 2)).thenReturn((Object)TypeConverter.fromYarn((TaskAttemptCompletionEvent[])mapEvents));
        Mockito.when((Object)mockJob.getMapAttemptCompletionEvents(2, 100)).thenReturn((Object)TypeConverter.fromYarn((TaskAttemptCompletionEvent[])empty));
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appCtx.getJob((JobId)Matchers.any(JobId.class))).thenReturn((Object)mockJob);
        JobTokenSecretManager secret = (JobTokenSecretManager)Mockito.mock(JobTokenSecretManager.class);
        RMHeartbeatHandler rmHeartbeatHandler = (RMHeartbeatHandler)Mockito.mock(RMHeartbeatHandler.class);
        TaskHeartbeatHandler hbHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        Configuration conf = new Configuration();
        listener.init(conf);
        listener.start();
        JobID jid = new JobID("12345", 1);
        TaskAttemptID tid = new TaskAttemptID("12345", 1, TaskType.REDUCE, 1, 0);
        MapTaskCompletionEventsUpdate update = listener.getMapCompletionEvents(jid, 0, 100, tid);
        Assert.assertEquals((long)2L, (long)update.events.length);
        update = listener.getMapCompletionEvents(jid, 0, 2, tid);
        Assert.assertEquals((long)2L, (long)update.events.length);
        update = listener.getMapCompletionEvents(jid, 2, 100, tid);
        Assert.assertEquals((long)0L, (long)update.events.length);
    }

    private static TaskAttemptCompletionEvent createTce(int eventId, boolean isMap, TaskAttemptCompletionEventStatus status) {
        JobId jid = MRBuilderUtils.newJobId((long)12345L, (int)1, (int)1);
        TaskId tid = MRBuilderUtils.newTaskId((JobId)jid, (int)0, (org.apache.hadoop.mapreduce.v2.api.records.TaskType)(isMap ? org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP : org.apache.hadoop.mapreduce.v2.api.records.TaskType.REDUCE));
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)0);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        TaskAttemptCompletionEvent tce = (TaskAttemptCompletionEvent)recordFactory.newRecordInstance(TaskAttemptCompletionEvent.class);
        tce.setEventId(eventId);
        tce.setAttemptId(attemptId);
        tce.setStatus(status);
        return tce;
    }

    @Test(timeout=2000L)
    public void testCommitWindow() throws IOException {
        SystemClock clock = new SystemClock();
        org.apache.hadoop.mapreduce.v2.app.job.Task mockTask = (org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.mock(org.apache.hadoop.mapreduce.v2.app.job.Task.class);
        Mockito.when((Object)mockTask.canCommit((TaskAttemptId)Matchers.any(TaskAttemptId.class))).thenReturn((Object)true);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getTask((TaskId)Matchers.any(TaskId.class))).thenReturn((Object)mockTask);
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appCtx.getJob((JobId)Matchers.any(JobId.class))).thenReturn((Object)mockJob);
        Mockito.when((Object)appCtx.getClock()).thenReturn((Object)clock);
        JobTokenSecretManager secret = (JobTokenSecretManager)Mockito.mock(JobTokenSecretManager.class);
        RMHeartbeatHandler rmHeartbeatHandler = (RMHeartbeatHandler)Mockito.mock(RMHeartbeatHandler.class);
        TaskHeartbeatHandler hbHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        2 listener = new /* Unavailable Anonymous Inner Class!! */;
        Configuration conf = new Configuration();
        listener.init(conf);
        listener.start();
        TaskAttemptID tid = new TaskAttemptID("12345", 1, TaskType.REDUCE, 1, 0);
        boolean canCommit = listener.canCommit(tid);
        Assert.assertFalse((boolean)canCommit);
        ((org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.never())).canCommit((TaskAttemptId)Matchers.any(TaskAttemptId.class));
        Mockito.when((Object)rmHeartbeatHandler.getLastHeartbeatTime()).thenReturn((Object)clock.getTime());
        canCommit = listener.canCommit(tid);
        Assert.assertTrue((boolean)canCommit);
        ((org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)1))).canCommit((TaskAttemptId)Matchers.any(TaskAttemptId.class));
        listener.stop();
    }
}

