/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.junit.Assert;
import org.mockito.Mockito;

class MRAppMasterTest
extends MRAppMaster {
    Path stagingDirPath;
    private Configuration conf;
    private boolean overrideInitAndStart;
    ContainerAllocator mockContainerAllocator;

    public MRAppMasterTest(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String host, int port, int httpPort, long submitTime) {
        this(applicationAttemptId, containerId, host, port, httpPort, submitTime, true);
    }

    public MRAppMasterTest(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String host, int port, int httpPort, long submitTime, boolean overrideInitAndStart) {
        super(applicationAttemptId, containerId, host, port, httpPort, submitTime);
        this.overrideInitAndStart = overrideInitAndStart;
        this.mockContainerAllocator = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
    }

    public void init(Configuration conf) {
        if (this.overrideInitAndStart) {
            this.conf = conf;
        } else {
            super.init(conf);
        }
    }

    protected void downloadTokensAndSetupUGI(Configuration conf) {
        try {
            this.currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
    }

    protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
        return this.mockContainerAllocator;
    }

    public void start() {
        if (this.overrideInitAndStart) {
            try {
                String user = UserGroupInformation.getCurrentUser().getShortUserName();
                this.stagingDirPath = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        } else {
            super.start();
        }
    }
}

