/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.KeyGenerator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.TaskAttemptListenerImpl;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapreduce.CryptoUtils;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryCopyService;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.JobEndNotifier;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptFinishingMonitor;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.client.MRClientService;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEvent;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventHandler;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobStartEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.app.speculate.Speculator;
import org.apache.hadoop.mapreduce.v2.app.speculate.SpeculatorEvent;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;

/*
 * Exception performing whole class analysis ignored.
 */
public class MRAppMaster
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(MRAppMaster.class);
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    public static final String INTERMEDIATE_DATA_ENCRYPTION_ALGO = "HmacSHA1";
    private Clock clock;
    private final long startTime;
    private final long appSubmitTime;
    private String appName;
    private final ApplicationAttemptId appAttemptID;
    private final ContainerId containerID;
    private final String nmHost;
    private final int nmPort;
    private final int nmHttpPort;
    protected final MRAppMetrics metrics;
    private Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun;
    private List<AMInfo> amInfos;
    private AppContext context;
    private Dispatcher dispatcher;
    private ClientService clientService;
    private ContainerAllocator containerAllocator;
    private ContainerLauncher containerLauncher;
    private EventHandler<CommitterEvent> committerEventHandler;
    private Speculator speculator;
    private TaskAttemptListener taskAttemptListener;
    private JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    private JobId jobId;
    private boolean newApiCommitter;
    private ClassLoader jobClassLoader;
    private OutputCommitter committer;
    private JobEventDispatcher jobEventDispatcher;
    private JobHistoryEventHandler jobHistoryEventHandler;
    private SpeculatorEventDispatcher speculatorEventDispatcher;
    private byte[] encryptedSpillKey;
    private TaskAttemptFinishingMonitor taskAttemptFinishingMonitor;
    private Job job;
    private Credentials jobCredentials = new Credentials();
    protected UserGroupInformation currentUser;
    @VisibleForTesting
    protected volatile boolean isLastAMRetry = false;
    boolean errorHappenedShutDown = false;
    private String shutDownMessage = null;
    JobStateInternal forcedState = null;
    private final ScheduledExecutorService logSyncer;
    private long recoveredJobStartTime = -1L;
    private static boolean mainStarted = false;
    @VisibleForTesting
    protected AtomicBoolean successfullyUnregistered = new AtomicBoolean(false);

    public MRAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, long appSubmitTime) {
        this(applicationAttemptId, containerId, nmHost, nmPort, nmHttpPort, (Clock)SystemClock.getInstance(), appSubmitTime);
    }

    public MRAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, Clock clock, long appSubmitTime) {
        super(MRAppMaster.class.getName());
        this.clock = clock;
        this.startTime = clock.getTime();
        this.appSubmitTime = appSubmitTime;
        this.appAttemptID = applicationAttemptId;
        this.containerID = containerId;
        this.nmHost = nmHost;
        this.nmPort = nmPort;
        this.nmHttpPort = nmHttpPort;
        this.metrics = MRAppMetrics.create();
        this.logSyncer = TaskLog.createLogSyncer();
        LOG.info((Object)("Created MRAppMaster for application " + applicationAttemptId));
    }

    protected TaskAttemptFinishingMonitor createTaskAttemptFinishingMonitor(EventHandler eventHandler) {
        TaskAttemptFinishingMonitor monitor = new TaskAttemptFinishingMonitor(eventHandler);
        return monitor;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.createJobClassLoader(conf);
        conf.setBoolean("yarn.dispatcher.exit-on-error", true);
        this.initJobCredentialsAndUGI(conf);
        this.dispatcher = this.createDispatcher();
        this.addIfService((Object)this.dispatcher);
        this.taskAttemptFinishingMonitor = this.createTaskAttemptFinishingMonitor(this.dispatcher.getEventHandler());
        this.addIfService((Object)this.taskAttemptFinishingMonitor);
        this.context = new RunningAppContext(this, conf, this.taskAttemptFinishingMonitor);
        this.appName = conf.get("mapreduce.job.name", "<missing app name>");
        conf.setInt("mapreduce.job.application.attempt.id", this.appAttemptID.getAttemptId());
        this.newApiCommitter = false;
        this.jobId = MRBuilderUtils.newJobId((ApplicationId)this.appAttemptID.getApplicationId(), (int)this.appAttemptID.getApplicationId().getId());
        int numReduceTasks = conf.getInt("mapreduce.job.reduces", 0);
        if (numReduceTasks > 0 && conf.getBoolean("mapred.reducer.new-api", false) || numReduceTasks == 0 && conf.getBoolean("mapred.mapper.new-api", false)) {
            this.newApiCommitter = true;
            LOG.info((Object)"Using mapred newApiCommitter.");
        }
        boolean copyHistory = false;
        this.committer = this.createOutputCommitter(conf);
        try {
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            Path stagingDir = MRApps.getStagingAreaDir((Configuration)conf, (String)user);
            FileSystem fs = this.getFileSystem(conf);
            boolean stagingExists = fs.exists(stagingDir);
            Path startCommitFile = MRApps.getStartJobCommitFile((Configuration)conf, (String)user, (JobId)this.jobId);
            boolean commitStarted = fs.exists(startCommitFile);
            Path endCommitSuccessFile = MRApps.getEndJobCommitSuccessFile((Configuration)conf, (String)user, (JobId)this.jobId);
            boolean commitSuccess = fs.exists(endCommitSuccessFile);
            Path endCommitFailureFile = MRApps.getEndJobCommitFailureFile((Configuration)conf, (String)user, (JobId)this.jobId);
            boolean commitFailure = fs.exists(endCommitFailureFile);
            if (!stagingExists) {
                this.isLastAMRetry = true;
                LOG.info((Object)("Attempt num: " + this.appAttemptID.getAttemptId() + " is last retry: " + this.isLastAMRetry + " because the staging dir doesn't exist."));
                this.errorHappenedShutDown = true;
                this.forcedState = JobStateInternal.ERROR;
                this.shutDownMessage = "Staging dir does not exist " + stagingDir;
                LOG.fatal((Object)this.shutDownMessage);
            } else if (commitStarted) {
                this.errorHappenedShutDown = true;
                this.isLastAMRetry = true;
                LOG.info((Object)("Attempt num: " + this.appAttemptID.getAttemptId() + " is last retry: " + this.isLastAMRetry + " because a commit was started."));
                copyHistory = true;
                if (commitSuccess) {
                    this.shutDownMessage = "Job commit succeeded in a prior MRAppMaster attempt before it crashed. Recovering.";
                    this.forcedState = JobStateInternal.SUCCEEDED;
                } else if (commitFailure) {
                    this.shutDownMessage = "Job commit failed in a prior MRAppMaster attempt before it crashed. Not retrying.";
                    this.forcedState = JobStateInternal.FAILED;
                } else if (this.isCommitJobRepeatable()) {
                    this.errorHappenedShutDown = false;
                    this.cleanupInterruptedCommit(conf, fs, startCommitFile);
                } else {
                    this.shutDownMessage = "Job commit from a prior MRAppMaster attempt is potentially in progress. Preventing multiple commit executions";
                    this.forcedState = JobStateInternal.ERROR;
                }
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Error while initializing", (Throwable)e);
        }
        if (this.errorHappenedShutDown) {
            NoopEventHandler eater = new NoopEventHandler(null);
            this.dispatcher.register(JobEventType.class, (EventHandler)eater);
            EventHandler historyService = null;
            if (copyHistory) {
                historyService = this.createJobHistoryHandler(this.context);
                this.dispatcher.register(EventType.class, historyService);
            } else {
                this.dispatcher.register(EventType.class, (EventHandler)eater);
            }
            if (copyHistory) {
                this.addService((Service)this.createStagingDirCleaningService());
            }
            this.containerAllocator = this.createContainerAllocator(null, this.context);
            this.addIfService((Object)this.containerAllocator);
            this.dispatcher.register(ContainerAllocator.EventType.class, (EventHandler)this.containerAllocator);
            if (copyHistory) {
                this.addIfService((Object)historyService);
                JobHistoryCopyService cpHist = new JobHistoryCopyService(this.appAttemptID, this.dispatcher.getEventHandler());
                this.addIfService((Object)cpHist);
            }
        } else {
            this.clientService = this.createClientService(this.context);
            this.clientService.init(conf);
            this.containerAllocator = this.createContainerAllocator(this.clientService, this.context);
            this.committerEventHandler = this.createCommitterEventHandler(this.context, this.committer);
            this.addIfService((Object)this.committerEventHandler);
            this.taskAttemptListener = this.createTaskAttemptListener(this.context);
            this.addIfService((Object)this.taskAttemptListener);
            EventHandler historyService = this.createJobHistoryHandler(this.context);
            this.dispatcher.register(EventType.class, historyService);
            this.jobEventDispatcher = new JobEventDispatcher(this, null);
            this.dispatcher.register(JobEventType.class, (EventHandler)this.jobEventDispatcher);
            this.dispatcher.register(TaskEventType.class, (EventHandler)new TaskEventDispatcher(this, null));
            this.dispatcher.register(TaskAttemptEventType.class, (EventHandler)new TaskAttemptEventDispatcher(this, null));
            this.dispatcher.register(CommitterEventType.class, this.committerEventHandler);
            if (conf.getBoolean("mapreduce.map.speculative", false) || conf.getBoolean("mapreduce.reduce.speculative", false)) {
                this.speculator = this.createSpeculator(conf, this.context);
                this.addIfService((Object)this.speculator);
            }
            this.speculatorEventDispatcher = new SpeculatorEventDispatcher(this, conf);
            this.dispatcher.register(Speculator.EventType.class, (EventHandler)this.speculatorEventDispatcher);
            this.addService((Service)this.createStagingDirCleaningService());
            this.addIfService((Object)this.containerAllocator);
            this.dispatcher.register(ContainerAllocator.EventType.class, (EventHandler)this.containerAllocator);
            this.containerLauncher = this.createContainerLauncher(this.context);
            this.addIfService((Object)this.containerLauncher);
            this.dispatcher.register(ContainerLauncher.EventType.class, (EventHandler)this.containerLauncher);
            this.addIfService((Object)historyService);
        }
        super.serviceInit(conf);
    }

    protected Dispatcher createDispatcher() {
        return new AsyncDispatcher();
    }

    private boolean isCommitJobRepeatable() throws IOException {
        boolean isRepeatable = false;
        Configuration conf = this.getConfig();
        if (this.committer != null) {
            JobContext jobContext = this.getJobContextFromConf(conf);
            isRepeatable = (Boolean)this.callWithJobClassLoader(conf, (ExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        return isRepeatable;
    }

    private JobContext getJobContextFromConf(Configuration conf) {
        if (this.newApiCommitter) {
            return new org.apache.hadoop.mapreduce.task.JobContextImpl(conf, (JobID)TypeConverter.fromYarn((JobId)this.getJobId()));
        }
        return new JobContextImpl(new JobConf(conf), (JobID)TypeConverter.fromYarn((JobId)this.getJobId()));
    }

    private void cleanupInterruptedCommit(Configuration conf, FileSystem fs, Path startCommitFile) throws IOException {
        LOG.info((Object)"Delete startJobCommitFile in case commit is not finished as successful or failed.");
        fs.delete(startCommitFile, false);
    }

    private OutputCommitter createOutputCommitter(Configuration conf) {
        return (OutputCommitter)this.callWithJobClassLoader(conf, (Action)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isJobNamePatternMatch(JobConf conf, String jobTempDir) {
        if (conf.getKeepTaskFilesPattern() != null && jobTempDir != null) {
            String jobFileName = Paths.get(jobTempDir, new String[0]).getFileName().toString();
            Pattern pattern = Pattern.compile(conf.getKeepTaskFilesPattern());
            Matcher matcher = pattern.matcher(jobFileName);
            return matcher.find();
        }
        return false;
    }

    private boolean isKeepFailedTaskFiles(JobConf conf) {
        return conf.getKeepFailedTaskFiles();
    }

    protected boolean keepJobFiles(JobConf conf, String jobTempDir) {
        return this.isJobNamePatternMatch(conf, jobTempDir) || this.isKeepFailedTaskFiles(conf);
    }

    protected FileSystem getFileSystem(Configuration conf) throws IOException {
        return FileSystem.get((Configuration)conf);
    }

    protected Credentials getCredentials() {
        return this.jobCredentials;
    }

    public void cleanupStagingDir() throws IOException {
        String jobTempDir = this.getConfig().get("mapreduce.job.dir");
        FileSystem fs = this.getFileSystem(this.getConfig());
        try {
            if (!this.keepJobFiles(new JobConf(this.getConfig()), jobTempDir)) {
                jobTempDir = this.getConfig().get("mapreduce.job.dir");
                if (jobTempDir == null) {
                    LOG.warn((Object)"Job Staging directory is null");
                    return;
                }
                Path jobTempDirPath = new Path(jobTempDir);
                LOG.info((Object)("Deleting staging directory " + FileSystem.getDefaultUri((Configuration)this.getConfig()) + " " + jobTempDir));
                fs.delete(jobTempDirPath, true);
            }
        }
        catch (IOException io) {
            LOG.error((Object)("Failed to cleanup staging dir " + jobTempDir), (Throwable)io);
        }
    }

    protected void sysexit() {
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void shutDownJob() {
        JobEndNotifier notifier = null;
        if (this.getConfig().get("mapreduce.job.end-notification.url") != null) {
            notifier = new JobEndNotifier();
            notifier.setConf(this.getConfig());
        }
        try {
            if (!this.isLastAMRetry && ((JobImpl)this.job).getInternalState() != JobStateInternal.REBOOT) {
                LOG.info((Object)"Job finished cleanly, recording last MRAppMaster retry");
                this.isLastAMRetry = true;
            }
            this.notifyIsLastAMRetry(this.isLastAMRetry);
            LOG.info((Object)"Calling stop for all the services");
            this.stop();
            if (this.isLastAMRetry && notifier != null) {
                this.sendJobEndNotify(notifier);
                notifier = null;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.clientService.stop();
        }
        catch (Throwable t) {
            LOG.warn((Object)"Graceful stop failed. Exiting.. ", t);
            this.exitMRAppMaster(1, t);
        }
        finally {
            if (this.isLastAMRetry && notifier != null) {
                this.sendJobEndNotify(notifier);
            }
        }
        this.exitMRAppMaster(0, null);
    }

    private void sendJobEndNotify(JobEndNotifier notifier) {
        try {
            LOG.info((Object)("Job end notification started for jobID : " + this.job.getReport().getJobId()));
            JobReport report = this.job.getReport();
            if (!this.context.hasSuccessfullyUnregistered()) {
                report.setJobState(JobState.FAILED);
            }
            notifier.notify(report);
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)("Job end notification interrupted for jobID : " + this.job.getReport().getJobId()), (Throwable)ie);
        }
    }

    private void exitMRAppMaster(int status, Throwable t) {
        if (!mainStarted) {
            ExitUtil.disableSystemExit();
        }
        try {
            if (t != null) {
                ExitUtil.terminate((int)status, (Throwable)t);
            } else {
                ExitUtil.terminate((int)status);
            }
        }
        catch (ExitUtil.ExitException exitException) {
            // empty catch block
        }
    }

    protected EventHandler<JobFinishEvent> createJobFinishEventHandler() {
        return new JobFinishEventHandler(this, null);
    }

    protected Job createJob(Configuration conf, JobStateInternal forcedState, String diagnostic) {
        JobImpl newJob = new JobImpl(this.jobId, this.appAttemptID, conf, this.dispatcher.getEventHandler(), this.taskAttemptListener, this.jobTokenSecretManager, this.jobCredentials, this.clock, this.completedTasksFromPreviousRun, this.metrics, this.committer, this.newApiCommitter, this.currentUser.getUserName(), this.appSubmitTime, this.amInfos, this.context, forcedState, diagnostic);
        RunningAppContext.access$900((RunningAppContext)((RunningAppContext)this.context)).put(newJob.getID(), newJob);
        this.dispatcher.register(JobFinishEvent.Type.class, this.createJobFinishEventHandler());
        return newJob;
    }

    protected void initJobCredentialsAndUGI(Configuration conf) {
        try {
            this.currentUser = UserGroupInformation.getCurrentUser();
            this.jobCredentials = ((JobConf)conf).getCredentials();
            if (CryptoUtils.isEncryptedSpillEnabled((Configuration)conf)) {
                int keyLen = conf.getInt("mapreduce.job.encrypted-intermediate-data-key-size-bits", 128);
                KeyGenerator keyGen = KeyGenerator.getInstance("HmacSHA1");
                keyGen.init(keyLen);
                this.encryptedSpillKey = keyGen.generateKey().getEncoded();
            } else {
                this.encryptedSpillKey = new byte[]{0};
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
        this.jobHistoryEventHandler = new JobHistoryEventHandler(context, this.getStartCount());
        return this.jobHistoryEventHandler;
    }

    protected AbstractService createStagingDirCleaningService() {
        return new StagingDirCleaningService(this);
    }

    protected Speculator createSpeculator(Configuration conf, AppContext context) {
        return (Speculator)this.callWithJobClassLoader(conf, (Action)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected TaskAttemptListener createTaskAttemptListener(AppContext context) {
        TaskAttemptListenerImpl lis = new TaskAttemptListenerImpl(context, this.jobTokenSecretManager, this.getRMHeartbeatHandler(), this.encryptedSpillKey);
        return lis;
    }

    protected EventHandler<CommitterEvent> createCommitterEventHandler(AppContext context, OutputCommitter committer) {
        return new CommitterEventHandler(context, committer, this.getRMHeartbeatHandler(), this.jobClassLoader);
    }

    protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
        return new ContainerAllocatorRouter(this, clientService, context);
    }

    protected RMHeartbeatHandler getRMHeartbeatHandler() {
        return (RMHeartbeatHandler)this.containerAllocator;
    }

    protected ContainerLauncher createContainerLauncher(AppContext context) {
        return new ContainerLauncherRouter(this, context);
    }

    protected ClientService createClientService(AppContext context) {
        return new MRClientService(context);
    }

    public ApplicationId getAppID() {
        return this.appAttemptID.getApplicationId();
    }

    public ApplicationAttemptId getAttemptID() {
        return this.appAttemptID;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public OutputCommitter getCommitter() {
        return this.committer;
    }

    public boolean isNewApiCommitter() {
        return this.newApiCommitter;
    }

    public int getStartCount() {
        return this.appAttemptID.getAttemptId();
    }

    public AppContext getContext() {
        return this.context;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Map<TaskId, JobHistoryParser.TaskInfo> getCompletedTaskFromPreviousRun() {
        return this.completedTasksFromPreviousRun;
    }

    public List<AMInfo> getAllAMInfos() {
        return this.amInfos;
    }

    public ContainerAllocator getContainerAllocator() {
        return this.containerAllocator;
    }

    public ContainerLauncher getContainerLauncher() {
        return this.containerLauncher;
    }

    public TaskAttemptListener getTaskAttemptListener() {
        return this.taskAttemptListener;
    }

    public Boolean isLastAMRetry() {
        return this.isLastAMRetry;
    }

    protected void serviceStart() throws Exception {
        this.amInfos = new LinkedList();
        this.completedTasksFromPreviousRun = new HashMap();
        this.processRecovery();
        this.cleanUpPreviousJobOutput();
        AMInfo amInfo = MRBuilderUtils.newAMInfo((ApplicationAttemptId)this.appAttemptID, (long)this.startTime, (ContainerId)this.containerID, (String)this.nmHost, (int)this.nmPort, (int)this.nmHttpPort);
        this.job = this.createJob(this.getConfig(), this.forcedState, this.shutDownMessage);
        for (AMInfo info : this.amInfos) {
            this.dispatcher.getEventHandler().handle((Event)new JobHistoryEvent(this.job.getID(), (HistoryEvent)new AMStartedEvent(info.getAppAttemptId(), info.getStartTime(), info.getContainerId(), info.getNodeManagerHost(), info.getNodeManagerPort(), info.getNodeManagerHttpPort(), this.appSubmitTime)));
        }
        this.dispatcher.getEventHandler().handle((Event)new JobHistoryEvent(this.job.getID(), (HistoryEvent)new AMStartedEvent(amInfo.getAppAttemptId(), amInfo.getStartTime(), amInfo.getContainerId(), amInfo.getNodeManagerHost(), amInfo.getNodeManagerPort(), amInfo.getNodeManagerHttpPort(), this.forcedState == null ? null : this.forcedState.toString(), this.appSubmitTime)));
        this.amInfos.add(amInfo);
        DefaultMetricsSystem.initialize((String)"MRAppMaster");
        boolean initFailed = false;
        if (!this.errorHappenedShutDown) {
            JobEvent initJobEvent = new JobEvent(this.job.getID(), JobEventType.JOB_INIT);
            this.jobEventDispatcher.handle(initJobEvent);
            boolean bl = initFailed = ((JobImpl)this.job).getInternalState() != JobStateInternal.INITED;
            if (this.job.isUber()) {
                this.speculatorEventDispatcher.disableSpeculation();
                LOG.info((Object)("MRAppMaster uberizing job " + this.job.getID() + " in local container (\"uber-AM\") on node " + this.nmHost + ":" + this.nmPort + "."));
            } else {
                this.dispatcher.getEventHandler().handle((Event)new SpeculatorEvent(this.job.getID(), this.clock.getTime()));
                LOG.info((Object)("MRAppMaster launching normal, non-uberized, multi-container job " + this.job.getID() + "."));
            }
            this.clientService.start();
        }
        super.serviceStart();
        MRApps.setClassLoader((ClassLoader)this.jobClassLoader, (Configuration)this.getConfig());
        if (initFailed) {
            JobEvent initFailedEvent = new JobEvent(this.job.getID(), JobEventType.JOB_INIT_FAILED);
            this.jobEventDispatcher.handle(initFailedEvent);
        } else {
            this.startJobs();
        }
    }

    public void stop() {
        super.stop();
    }

    private boolean isRecoverySupported() throws IOException {
        boolean isSupported = false;
        Configuration conf = this.getConfig();
        if (this.committer != null) {
            JobContext _jobContext = this.getJobContextFromConf(conf);
            isSupported = (Boolean)this.callWithJobClassLoader(conf, (ExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        return isSupported;
    }

    private void processRecovery() throws IOException {
        boolean attemptRecovery = this.shouldAttemptRecovery();
        boolean recoverySucceeded = true;
        if (attemptRecovery) {
            LOG.info((Object)"Attempting to recover.");
            try {
                this.parsePreviousJobHistory();
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to parse prior job history, aborting recovery", (Throwable)e);
                recoverySucceeded = false;
            }
        }
        if (!(this.isFirstAttempt() || attemptRecovery && recoverySucceeded)) {
            this.amInfos.addAll(this.readJustAMInfos());
        }
    }

    private boolean isFirstAttempt() {
        return this.appAttemptID.getAttemptId() == 1;
    }

    private boolean shouldAttemptRecovery() throws IOException {
        boolean shuffleKeyValidForRecovery;
        if (this.isFirstAttempt()) {
            return false;
        }
        boolean recoveryEnabled = this.getConfig().getBoolean("yarn.app.mapreduce.am.job.recovery.enable", true);
        if (!recoveryEnabled) {
            LOG.info((Object)"Not attempting to recover. Recovery disabled. To enable recovery, set yarn.app.mapreduce.am.job.recovery.enable");
            return false;
        }
        boolean recoverySupportedByCommitter = this.isRecoverySupported();
        if (!recoverySupportedByCommitter) {
            LOG.info((Object)("Not attempting to recover. Recovery is not supported by " + this.committer.getClass() + ". Use an OutputCommitter that supports" + " recovery."));
            return false;
        }
        int reducerCount = this.getConfig().getInt("mapreduce.job.reduces", 0);
        boolean bl = shuffleKeyValidForRecovery = TokenCache.getShuffleSecretKey((Credentials)this.jobCredentials) != null;
        if (reducerCount > 0 && !shuffleKeyValidForRecovery) {
            LOG.info((Object)"Not attempting to recover. The shuffle key is invalid for recovery.");
            return false;
        }
        boolean spillEncrypted = CryptoUtils.isEncryptedSpillEnabled((Configuration)this.getConfig());
        if (reducerCount > 0 && spillEncrypted) {
            LOG.info((Object)"Not attempting to recover. Intermediate spill encryption is enabled.");
            return false;
        }
        return true;
    }

    private void cleanUpPreviousJobOutput() {
        if (!this.isFirstAttempt() && !this.recovered()) {
            JobContext jobContext = this.getJobContextFromConf(this.getConfig());
            try {
                LOG.info((Object)"Starting to clean up previous job's temporary files");
                this.committer.abortJob(jobContext, JobStatus.State.FAILED);
                LOG.info((Object)"Finished cleaning up previous job temporary files");
            }
            catch (FileNotFoundException e) {
                LOG.info((Object)"Previous job temporary files do not exist, no clean up was necessary.");
            }
            catch (Exception e) {
                LOG.error((Object)"Error while trying to clean up previous job's temporary files", (Throwable)e);
            }
        }
    }

    private static FSDataInputStream getPreviousJobHistoryStream(Configuration conf, ApplicationAttemptId appAttemptId) throws IOException {
        Path historyFile = JobHistoryUtils.getPreviousJobHistoryPath((Configuration)conf, (ApplicationAttemptId)appAttemptId);
        LOG.info((Object)("Previous history file is at " + historyFile));
        return historyFile.getFileSystem(conf).open(historyFile);
    }

    private void parsePreviousJobHistory() throws IOException {
        FSDataInputStream in = MRAppMaster.getPreviousJobHistoryStream((Configuration)this.getConfig(), (ApplicationAttemptId)this.appAttemptID);
        JobHistoryParser parser = new JobHistoryParser(in);
        JobHistoryParser.JobInfo jobInfo = parser.parse();
        IOException parseException = parser.getParseException();
        if (parseException != null) {
            LOG.info((Object)"Got an error parsing job-history file, ignoring incomplete events.", (Throwable)parseException);
        }
        Map taskInfos = jobInfo.getAllTasks();
        for (JobHistoryParser.TaskInfo taskInfo : taskInfos.values()) {
            if (!TaskState.SUCCEEDED.toString().equals(taskInfo.getTaskStatus())) continue;
            Iterator taskAttemptIterator = taskInfo.getAllTaskAttempts().entrySet().iterator();
            while (taskAttemptIterator.hasNext()) {
                Map.Entry currentEntry = taskAttemptIterator.next();
                if (jobInfo.getAllCompletedTaskAttempts().containsKey(currentEntry.getKey())) continue;
                taskAttemptIterator.remove();
            }
            this.completedTasksFromPreviousRun.put(TypeConverter.toYarn((TaskID)taskInfo.getTaskId()), taskInfo);
            LOG.info((Object)("Read from history task " + TypeConverter.toYarn((TaskID)taskInfo.getTaskId())));
        }
        LOG.info((Object)("Read completed tasks from history " + this.completedTasksFromPreviousRun.size()));
        this.recoveredJobStartTime = jobInfo.getLaunchTime();
        List jhAmInfoList = jobInfo.getAMInfos();
        if (jhAmInfoList != null) {
            for (JobHistoryParser.AMInfo jhAmInfo : jhAmInfoList) {
                AMInfo amInfo = MRBuilderUtils.newAMInfo((ApplicationAttemptId)jhAmInfo.getAppAttemptId(), (long)jhAmInfo.getStartTime(), (ContainerId)jhAmInfo.getContainerId(), (String)jhAmInfo.getNodeManagerHost(), (int)jhAmInfo.getNodeManagerPort(), (int)jhAmInfo.getNodeManagerHttpPort());
                this.amInfos.add(amInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AMInfo> readJustAMInfos() {
        ArrayList<AMInfo> amInfos = new ArrayList<AMInfo>();
        FSDataInputStream inputStream = null;
        try {
            HistoryEvent event;
            inputStream = MRAppMaster.getPreviousJobHistoryStream((Configuration)this.getConfig(), (ApplicationAttemptId)this.appAttemptID);
            EventReader jobHistoryEventReader = new EventReader((DataInputStream)inputStream);
            boolean amStartedEventsBegan = false;
            while ((event = jobHistoryEventReader.getNextEvent()) != null) {
                if (event.getEventType() == EventType.AM_STARTED) {
                    if (!amStartedEventsBegan) {
                        amStartedEventsBegan = true;
                    }
                    AMStartedEvent amStartedEvent = (AMStartedEvent)event;
                    amInfos.add(MRBuilderUtils.newAMInfo((ApplicationAttemptId)amStartedEvent.getAppAttemptId(), (long)amStartedEvent.getStartTime(), (ContainerId)amStartedEvent.getContainerId(), (String)StringInterner.weakIntern((String)amStartedEvent.getNodeManagerHost()), (int)amStartedEvent.getNodeManagerPort(), (int)amStartedEvent.getNodeManagerHttpPort()));
                    continue;
                }
                if (!amStartedEventsBegan) continue;
                break;
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Could not parse the old history file. Will not have old AMinfos ", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return amInfos;
    }

    public boolean recovered() {
        return this.recoveredJobStartTime > 0L;
    }

    protected void startJobs() {
        JobStartEvent startJobEvent = new JobStartEvent(this.job.getID(), this.recoveredJobStartTime);
        this.dispatcher.getEventHandler().handle((Event)startJobEvent);
    }

    private static void validateInputParam(String value, String param) throws IOException {
        if (value == null) {
            String msg = param + " is null";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    public static void main(String[] args) {
        try {
            mainStarted = true;
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            String containerIdStr = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
            String nodeHostString = System.getenv(ApplicationConstants.Environment.NM_HOST.name());
            String nodePortString = System.getenv(ApplicationConstants.Environment.NM_PORT.name());
            String nodeHttpPortString = System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name());
            String appSubmitTimeStr = System.getenv("APP_SUBMIT_TIME_ENV");
            MRAppMaster.validateInputParam((String)containerIdStr, (String)ApplicationConstants.Environment.CONTAINER_ID.name());
            MRAppMaster.validateInputParam((String)nodeHostString, (String)ApplicationConstants.Environment.NM_HOST.name());
            MRAppMaster.validateInputParam((String)nodePortString, (String)ApplicationConstants.Environment.NM_PORT.name());
            MRAppMaster.validateInputParam((String)nodeHttpPortString, (String)ApplicationConstants.Environment.NM_HTTP_PORT.name());
            MRAppMaster.validateInputParam((String)appSubmitTimeStr, (String)"APP_SUBMIT_TIME_ENV");
            ContainerId containerId = ContainerId.fromString((String)containerIdStr);
            ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
            if (applicationAttemptId != null) {
                CallerContext.setCurrent((CallerContext)new CallerContext.Builder("mr_appmaster_" + applicationAttemptId.toString()).build());
            }
            long appSubmitTime = Long.parseLong(appSubmitTimeStr);
            MRAppMaster appMaster = new MRAppMaster(applicationAttemptId, containerId, nodeHostString, Integer.parseInt(nodePortString), Integer.parseInt(nodeHttpPortString), appSubmitTime);
            ShutdownHookManager.get().addShutdownHook((Runnable)new MRAppMasterShutdownHook(appMaster), 30);
            JobConf conf = new JobConf((Configuration)new YarnConfiguration());
            conf.addResource(new Path("job.xml"));
            MRWebAppUtil.initialize((Configuration)conf);
            String systemPropsToLog = MRApps.getSystemPropertiesToLog((Configuration)conf);
            if (systemPropsToLog != null) {
                LOG.info((Object)systemPropsToLog);
            }
            String jobUserName = System.getenv(ApplicationConstants.Environment.USER.name());
            conf.set("mapreduce.job.user.name", jobUserName);
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (JobConf)conf, (String)jobUserName);
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting MRAppMaster", t);
            ExitUtil.terminate((int)1, (Throwable)t);
        }
    }

    public void notifyIsLastAMRetry(boolean isLastAMRetry) {
        if (this.containerAllocator instanceof ContainerAllocatorRouter) {
            LOG.info((Object)("Notify RMCommunicator isAMLastRetry: " + isLastAMRetry));
            ((ContainerAllocatorRouter)this.containerAllocator).setShouldUnregister(isLastAMRetry);
        }
        if (this.jobHistoryEventHandler != null) {
            LOG.info((Object)("Notify JHEH isAMLastRetry: " + isLastAMRetry));
            this.jobHistoryEventHandler.setForcejobCompletion(isLastAMRetry);
        }
    }

    protected static void initAndStartAppMaster(MRAppMaster appMaster, JobConf conf, String jobUserName) throws IOException, InterruptedException {
        UserGroupInformation.setConfiguration((Configuration)conf);
        SecurityUtil.setConfiguration((Configuration)conf);
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        LOG.info((Object)"Executing with tokens:");
        for (Token token : credentials.getAllTokens()) {
            LOG.info((Object)token);
        }
        UserGroupInformation appMasterUgi = UserGroupInformation.createRemoteUser((String)jobUserName);
        appMasterUgi.addCredentials(credentials);
        Iterator iter = credentials.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        conf.getCredentials().addAll(credentials);
        appMasterUgi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createJobClassLoader(Configuration conf) throws IOException {
        this.jobClassLoader = MRApps.createJobClassLoader((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T callWithJobClassLoader(Configuration conf, Action<T> action) {
        boolean setJobClassLoader;
        ClassLoader currentClassLoader = conf.getClassLoader();
        boolean bl = setJobClassLoader = this.jobClassLoader != null && currentClassLoader != this.jobClassLoader;
        if (setJobClassLoader) {
            MRApps.setClassLoader((ClassLoader)this.jobClassLoader, (Configuration)conf);
        }
        try {
            Object object = action.call(conf);
            return (T)object;
        }
        finally {
            if (setJobClassLoader) {
                MRApps.setClassLoader((ClassLoader)currentClassLoader, (Configuration)conf);
            }
        }
    }

    <T> T callWithJobClassLoader(Configuration conf, ExceptionAction<T> action) throws IOException {
        boolean setJobClassLoader;
        ClassLoader currentClassLoader = conf.getClassLoader();
        boolean bl = setJobClassLoader = this.jobClassLoader != null && currentClassLoader != this.jobClassLoader;
        if (setJobClassLoader) {
            MRApps.setClassLoader((ClassLoader)this.jobClassLoader, (Configuration)conf);
        }
        try {
            Object object = action.call(conf);
            return (T)object;
        }
        catch (IOException e) {
            throw e;
        }
        catch (YarnRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        finally {
            if (setJobClassLoader) {
                MRApps.setClassLoader((ClassLoader)currentClassLoader, (Configuration)conf);
            }
        }
    }

    protected void serviceStop() throws Exception {
        super.serviceStop();
    }

    public ClientService getClientService() {
        return this.clientService;
    }

    static /* synthetic */ OutputCommitter access$400(MRAppMaster x0) {
        return x0.committer;
    }

    static /* synthetic */ Log access$500() {
        return LOG;
    }

    static /* synthetic */ boolean access$600(MRAppMaster x0) {
        return x0.newApiCommitter;
    }

    static /* synthetic */ JobId access$700(MRAppMaster x0) {
        return x0.jobId;
    }

    static /* synthetic */ Job access$1000(MRAppMaster x0) {
        return x0.job;
    }

    static /* synthetic */ String access$1100(MRAppMaster x0) {
        return x0.nmHost;
    }

    static /* synthetic */ int access$1200(MRAppMaster x0) {
        return x0.nmPort;
    }

    static /* synthetic */ int access$1300(MRAppMaster x0) {
        return x0.nmHttpPort;
    }

    static /* synthetic */ ContainerId access$1400(MRAppMaster x0) {
        return x0.containerID;
    }

    static /* synthetic */ TaskAttemptListener access$1500(MRAppMaster x0) {
        return x0.taskAttemptListener;
    }

    static /* synthetic */ ClassLoader access$1600(MRAppMaster x0) {
        return x0.jobClassLoader;
    }

    static /* synthetic */ byte[] access$1700(MRAppMaster x0) {
        return x0.encryptedSpillKey;
    }

    static /* synthetic */ ApplicationAttemptId access$1800(MRAppMaster x0) {
        return x0.appAttemptID;
    }

    static /* synthetic */ String access$1900(MRAppMaster x0) {
        return x0.appName;
    }

    static /* synthetic */ long access$2000(MRAppMaster x0) {
        return x0.startTime;
    }

    static /* synthetic */ Dispatcher access$2100(MRAppMaster x0) {
        return x0.dispatcher;
    }

    static /* synthetic */ Clock access$2200(MRAppMaster x0) {
        return x0.clock;
    }

    static /* synthetic */ ContainerAllocator access$2300(MRAppMaster x0) {
        return x0.containerAllocator;
    }

    static /* synthetic */ AppContext access$2400(MRAppMaster x0) {
        return x0.context;
    }

    static /* synthetic */ Speculator access$2500(MRAppMaster x0) {
        return x0.speculator;
    }
}

