/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.TestAMWebServicesAttempt;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServicesAttempt
extends JerseyTestBase {
    private static Configuration conf = new Configuration();
    private static AppContext appContext;
    private String webserviceUserName = "testuser";
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestAMWebServicesAttempt() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.app.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testGetTaskAttemptIdState() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("state").queryParam("user.name", this.webserviceUserName).accept(new String[]{"application/json"}).get(ClientResponse.class);
                    Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                    JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                    Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                    Assert.assertEquals((Object)att.getState().toString(), (Object)json.get("state"));
                }
            }
        }
    }

    @Test
    public void testGetTaskAttemptIdXMLState() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("state").queryParam("user.name", this.webserviceUserName).accept(new String[]{"application/xml"}).get(ClientResponse.class);
                    Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
                    String xml = (String)response.getEntity(String.class);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(xml));
                    Document dom = db.parse(is);
                    NodeList nodes = dom.getElementsByTagName("jobTaskAttemptState");
                    Assert.assertEquals((long)1L, (long)nodes.getLength());
                    String state = WebServicesTestUtils.getXmlString((Element)((Element)nodes.item(0)), (String)"state");
                    Assert.assertEquals((Object)att.getState().toString(), (Object)state);
                }
            }
        }
    }

    @Test
    public void testPutTaskAttemptIdState() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("state").queryParam("user.name", this.webserviceUserName).accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)"{\"state\":\"KILLED\"}");
                    Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
                    JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
                    Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
                    Assert.assertEquals((Object)TaskAttemptState.KILLED.toString(), (Object)json.get("state"));
                }
            }
        }
    }

    @Test
    public void testPutTaskAttemptIdXMLState() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            for (Task task : ((Job)jobsMap.get(id)).getTasks().values()) {
                String tid = MRApps.toString((TaskId)task.getID());
                for (TaskAttempt att : task.getAttempts().values()) {
                    TaskAttemptId attemptid = att.getID();
                    String attid = MRApps.toString((TaskAttemptId)attemptid);
                    ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("mapreduce").path("jobs").path(jobId).path("tasks").path(tid).path("attempts").path(attid).path("state").queryParam("user.name", this.webserviceUserName).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).type(MediaType.APPLICATION_XML_TYPE)).put(ClientResponse.class, (Object)"<jobTaskAttemptState><state>KILLED</state></jobTaskAttemptState>");
                    Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
                    String xml = (String)response.getEntity(String.class);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    InputSource is = new InputSource();
                    is.setCharacterStream(new StringReader(xml));
                    Document dom = db.parse(is);
                    NodeList nodes = dom.getElementsByTagName("jobTaskAttemptState");
                    Assert.assertEquals((long)1L, (long)nodes.getLength());
                    String state = WebServicesTestUtils.getXmlString((Element)((Element)nodes.item(0)), (String)"state");
                    Assert.assertEquals((Object)TaskAttemptState.KILLED.toString(), (Object)state);
                }
            }
        }
    }

    static /* synthetic */ AppContext access$002(AppContext x0) {
        appContext = x0;
        return appContext;
    }

    static /* synthetic */ AppContext access$000() {
        return appContext;
    }

    static /* synthetic */ Configuration access$100() {
        return conf;
    }

    static /* synthetic */ Injector access$200(TestAMWebServicesAttempt x0) {
        return x0.injector;
    }
}

