/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.JobIdPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskAttemptIdPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskIdPBImpl;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppForTest;
import org.apache.hadoop.mapreduce.v2.app.webapp.TasksBlockForTest;
import org.apache.hadoop.mapreduce.v2.app.webapp.TestBlocks;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.BlockForTest;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBlocks {
    private ByteArrayOutputStream data = new ByteArrayOutputStream();

    @Test
    public void testConfigurationBlock() throws Exception {
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        Job job = (Job)Mockito.mock(Job.class);
        Path path = new Path("conf");
        Configuration configuration = new Configuration();
        configuration.set("Key for test", "Value for test");
        String redactedProp = "Key for redaction";
        configuration.set("mapreduce.job.redacted-properties", "Key for redaction");
        Mockito.when((Object)job.getConfFile()).thenReturn((Object)path);
        Mockito.when((Object)job.loadConfFile()).thenReturn((Object)configuration);
        Mockito.when((Object)ctx.getJob((JobId)Mockito.any(JobId.class))).thenReturn((Object)job);
        ConfBlockForTest configurationBlock = new ConfBlockForTest(this, ctx);
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest((HtmlBlock)new HtmlBlockForTest(this, null), pWriter, 0, false);
        configurationBlock.render((HtmlBlock.Block)html);
        pWriter.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("Sorry, can't do anything without a JobID"));
        configurationBlock.addParameter("job.id", "job_01_01");
        this.data.reset();
        configurationBlock.render((HtmlBlock.Block)html);
        pWriter.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("Key for test"));
        Assert.assertTrue((boolean)this.data.toString().contains("Value for test"));
        Assert.assertTrue((boolean)this.data.toString().contains("Key for redaction"));
        Assert.assertTrue((boolean)this.data.toString().contains("*********(redacted)"));
    }

    @Test
    public void testTasksBlock() throws Exception {
        ApplicationId appId = ApplicationIdPBImpl.newInstance((long)0L, (int)1);
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(0);
        jobId.setAppId(appId);
        TaskIdPBImpl taskId = new TaskIdPBImpl();
        taskId.setId(0);
        taskId.setTaskType(TaskType.MAP);
        taskId.setJobId((JobId)jobId);
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)task.getID()).thenReturn((Object)taskId);
        TaskReport report = (TaskReport)Mockito.mock(TaskReport.class);
        Mockito.when((Object)Float.valueOf(report.getProgress())).thenReturn((Object)Float.valueOf(0.7f));
        Mockito.when((Object)report.getTaskState()).thenReturn((Object)TaskState.SUCCEEDED);
        Mockito.when((Object)report.getStartTime()).thenReturn((Object)100001L);
        Mockito.when((Object)report.getFinishTime()).thenReturn((Object)100011L);
        Mockito.when((Object)report.getStatus()).thenReturn((Object)"Dummy Status \n*");
        Mockito.when((Object)task.getReport()).thenReturn((Object)report);
        Mockito.when((Object)task.getType()).thenReturn((Object)TaskType.MAP);
        HashMap<TaskIdPBImpl, Task> tasks = new HashMap<TaskIdPBImpl, Task>();
        tasks.put(taskId, task);
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getTasks()).thenReturn(tasks);
        App app = new App(ctx);
        app.setJob(job);
        TasksBlockForTest taskBlock = new TasksBlockForTest(app);
        taskBlock.addParameter("task.type", "m");
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest((HtmlBlock)new HtmlBlockForTest(this, null), pWriter, 0, false);
        taskBlock.render((HtmlBlock.Block)html);
        pWriter.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("task_0_0001_m_000000"));
        Assert.assertTrue((boolean)this.data.toString().contains("70.00"));
        Assert.assertTrue((boolean)this.data.toString().contains("SUCCEEDED"));
        Assert.assertTrue((boolean)this.data.toString().contains("100001"));
        Assert.assertTrue((boolean)this.data.toString().contains("100011"));
        Assert.assertFalse((boolean)this.data.toString().contains("Dummy Status \n*"));
        Assert.assertTrue((boolean)this.data.toString().contains("Dummy Status \\n*"));
    }

    @Test
    public void testAttemptsBlock() {
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        AppForTest app = new AppForTest(ctx);
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(0);
        jobId.setAppId(ApplicationIdPBImpl.newInstance((long)0L, (int)1));
        TaskIdPBImpl taskId = new TaskIdPBImpl();
        taskId.setId(0);
        taskId.setTaskType(TaskType.REDUCE);
        taskId.setJobId((JobId)jobId);
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)task.getID()).thenReturn((Object)taskId);
        TaskReport report = (TaskReport)Mockito.mock(TaskReport.class);
        Mockito.when((Object)task.getReport()).thenReturn((Object)report);
        Mockito.when((Object)task.getType()).thenReturn((Object)TaskType.REDUCE);
        HashMap<TaskIdPBImpl, Task> tasks = new HashMap<TaskIdPBImpl, Task>();
        HashMap<TaskAttemptIdPBImpl, TaskAttempt> attempts = new HashMap<TaskAttemptIdPBImpl, TaskAttempt>();
        TaskAttempt attempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        TaskAttemptIdPBImpl taId = new TaskAttemptIdPBImpl();
        taId.setId(0);
        taId.setTaskId(task.getID());
        Mockito.when((Object)attempt.getID()).thenReturn((Object)taId);
        TaskAttemptState taState = TaskAttemptState.SUCCEEDED;
        Mockito.when((Object)attempt.getState()).thenReturn((Object)taState);
        TaskAttemptReport taReport = (TaskAttemptReport)Mockito.mock(TaskAttemptReport.class);
        Mockito.when((Object)taReport.getTaskAttemptState()).thenReturn((Object)taState);
        Mockito.when((Object)attempt.getReport()).thenReturn((Object)taReport);
        attempts.put(taId, attempt);
        tasks.put(taskId, task);
        Mockito.when((Object)task.getAttempts()).thenReturn(attempts);
        app.setTask(task);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getTasks(TaskType.REDUCE)).thenReturn(tasks);
        app.setJob(job);
        AttemptsBlockForTest block = new AttemptsBlockForTest(this, (App)app, new Configuration());
        block.addParameter("task.type", "r");
        block.addParameter("attempt.state", "SUCCESSFUL");
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest((HtmlBlock)new HtmlBlockForTest(this, null), pWriter, 0, false);
        block.render((HtmlBlock.Block)html);
        pWriter.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("<a href='" + block.url(new String[]{"task", task.getID().toString()}) + "'>" + "attempt_0_0001_r_000000_0</a>"));
    }

    @Test
    public void testSingleCounterBlock() {
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        View.ViewContext ctx = (View.ViewContext)Mockito.mock(View.ViewContext.class);
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(0);
        jobId.setAppId(ApplicationIdPBImpl.newInstance((long)0L, (int)1));
        TaskIdPBImpl mapTaskId = new TaskIdPBImpl();
        mapTaskId.setId(0);
        mapTaskId.setTaskType(TaskType.MAP);
        mapTaskId.setJobId((JobId)jobId);
        Task mapTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)mapTask.getID()).thenReturn((Object)mapTaskId);
        TaskReport mapReport = (TaskReport)Mockito.mock(TaskReport.class);
        Mockito.when((Object)mapTask.getReport()).thenReturn((Object)mapReport);
        Mockito.when((Object)mapTask.getType()).thenReturn((Object)TaskType.MAP);
        TaskIdPBImpl reduceTaskId = new TaskIdPBImpl();
        reduceTaskId.setId(0);
        reduceTaskId.setTaskType(TaskType.REDUCE);
        reduceTaskId.setJobId((JobId)jobId);
        Task reduceTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)reduceTask.getID()).thenReturn((Object)reduceTaskId);
        TaskReport reduceReport = (TaskReport)Mockito.mock(TaskReport.class);
        Mockito.when((Object)reduceTask.getReport()).thenReturn((Object)reduceReport);
        Mockito.when((Object)reduceTask.getType()).thenReturn((Object)TaskType.REDUCE);
        HashMap<TaskIdPBImpl, Task> tasks = new HashMap<TaskIdPBImpl, Task>();
        tasks.put(mapTaskId, mapTask);
        tasks.put(reduceTaskId, reduceTask);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getTasks()).thenReturn(tasks);
        Mockito.when((Object)appCtx.getJob((JobId)Mockito.any(JobId.class))).thenReturn((Object)job);
        SingleCounterBlockForMapTest blockForMapTest = (SingleCounterBlockForMapTest)Mockito.spy((Object)new SingleCounterBlockForMapTest(this, appCtx, ctx));
        PrintWriter pWriterForMapTest = new PrintWriter(this.data);
        BlockForTest htmlForMapTest = new BlockForTest((HtmlBlock)new HtmlBlockForTest(this, null), pWriterForMapTest, 0, false);
        blockForMapTest.render((HtmlBlock.Block)htmlForMapTest);
        pWriterForMapTest.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("task_0_0001_m_000000"));
        Assert.assertFalse((boolean)this.data.toString().contains("task_0_0001_r_000000"));
        this.data.reset();
        SingleCounterBlockForReduceTest blockForReduceTest = (SingleCounterBlockForReduceTest)Mockito.spy((Object)new SingleCounterBlockForReduceTest(this, appCtx, ctx));
        PrintWriter pWriterForReduceTest = new PrintWriter(this.data);
        BlockForTest htmlForReduceTest = new BlockForTest((HtmlBlock)new HtmlBlockForTest(this, null), pWriterForReduceTest, 0, false);
        blockForReduceTest.render((HtmlBlock.Block)htmlForReduceTest);
        pWriterForReduceTest.flush();
        System.out.println(this.data.toString());
        Assert.assertFalse((boolean)this.data.toString().contains("task_0_0001_m_000000"));
        Assert.assertTrue((boolean)this.data.toString().contains("task_0_0001_r_000000"));
    }
}

