/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.speculate;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.speculate.DataStatistics;
import org.apache.hadoop.mapreduce.v2.app.speculate.StartEndTimesBase;
import org.apache.hadoop.mapreduce.v2.app.speculate.forecast.SimpleExponentialSmoothing;

public class SimpleExponentialTaskRuntimeEstimator
extends StartEndTimesBase {
    private static final long DEFAULT_ESTIMATE_RUNTIME = -1L;
    private static final double DEFAULT_PROGRESS_VALUE = 1.0E-10;
    private static final double CONFIDENCE_INTERVAL_FACTOR = 0.25;
    private long constTime;
    private int skipCount;
    private long stagnatedWindow;
    private final ConcurrentMap<TaskAttemptId, AtomicReference<SimpleExponentialSmoothing>> estimates = new ConcurrentHashMap();

    private SimpleExponentialSmoothing getForecastEntry(TaskAttemptId attemptID) {
        AtomicReference entryRef = (AtomicReference)this.estimates.get(attemptID);
        if (entryRef == null) {
            return null;
        }
        return (SimpleExponentialSmoothing)entryRef.get();
    }

    private void incorporateReading(TaskAttemptId attemptID, float newRawData, long newTimeStamp) {
        SimpleExponentialSmoothing foreCastEntry = this.getForecastEntry(attemptID);
        if (foreCastEntry == null) {
            Long tStartTime = (Long)this.startTimes.get(attemptID);
            if (tStartTime == null) {
                return;
            }
            this.estimates.putIfAbsent(attemptID, new AtomicReference<SimpleExponentialSmoothing>(SimpleExponentialSmoothing.createForecast((long)this.constTime, (int)this.skipCount, (long)this.stagnatedWindow, (long)tStartTime)));
            this.incorporateReading(attemptID, newRawData, newTimeStamp);
            return;
        }
        foreCastEntry.incorporateReading(newTimeStamp, (double)newRawData);
    }

    public void contextualize(Configuration conf, AppContext context) {
        super.contextualize(conf, context);
        this.constTime = conf.getLong("yarn.app.mapreduce.am.job.task.estimator.simple.exponential.smooth.lambda-ms", 120000L);
        this.stagnatedWindow = Math.max(2L * this.constTime, conf.getLong("yarn.app.mapreduce.am.job.task.estimator.simple.exponential.smooth.stagnated-ms", 360000L));
        this.skipCount = conf.getInt("yarn.app.mapreduce.am.job.task.estimator.simple.exponential.smooth.skip-initials", 24);
    }

    public long estimatedRuntime(TaskAttemptId id) {
        SimpleExponentialSmoothing foreCastEntry = this.getForecastEntry(id);
        if (foreCastEntry == null) {
            return -1L;
        }
        double remainingWork = Math.max(0.0, Math.min(1.0, 1.0 - foreCastEntry.getRawData()));
        double forecast = Math.max(1.0E-10, foreCastEntry.getForecast());
        long remainingTime = (long)(remainingWork / forecast);
        long estimatedRuntime = remainingTime + foreCastEntry.getTimeStamp() - foreCastEntry.getStartTime();
        return estimatedRuntime;
    }

    public long estimatedNewAttemptRuntime(TaskId id) {
        DataStatistics statistics = this.dataStatisticsForTask(id);
        if (statistics == null) {
            return -1L;
        }
        double statsMeanCI = statistics.meanCI();
        double expectedVal = statsMeanCI + Math.min(statsMeanCI * 0.25, statistics.std() / 2.0);
        return (long)expectedVal;
    }

    public boolean hasStagnatedProgress(TaskAttemptId id, long timeStamp) {
        SimpleExponentialSmoothing foreCastEntry = this.getForecastEntry(id);
        if (foreCastEntry == null) {
            return false;
        }
        return foreCastEntry.isDataStagnated(timeStamp);
    }

    public long runtimeEstimateVariance(TaskAttemptId id) {
        SimpleExponentialSmoothing forecastEntry = this.getForecastEntry(id);
        if (forecastEntry == null) {
            return -1L;
        }
        double forecast = forecastEntry.getForecast();
        if (forecastEntry.isDefaultForecast(forecast)) {
            return -1L;
        }
        return 0L;
    }

    public void updateAttempt(TaskAttemptStatusUpdateEvent.TaskAttemptStatus status, long timestamp) {
        super.updateAttempt(status, timestamp);
        TaskAttemptId attemptID = status.id;
        float progress = status.progress;
        this.incorporateReading(attemptID, progress, timestamp);
    }
}

