/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.speculate.forecast;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.v2.app.speculate.forecast.SimpleExponentialSmoothing;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.junit.Assert;
import org.junit.Test;

public class TestSimpleExponentialForecast {
    private static final Log LOG = LogFactory.getLog(TestSimpleExponentialForecast.class);
    private static long clockTicks = 1000L;
    private ControlledClock clock;

    private int incTestSimpleExponentialForecast() {
        this.clock = new ControlledClock();
        this.clock.tickMsec(clockTicks);
        SimpleExponentialSmoothing forecaster = new SimpleExponentialSmoothing(10000L, 12, 10000L, this.clock.getTime());
        for (double progress = 0.0; progress <= 1.0; progress += 0.005) {
            this.clock.tickMsec(clockTicks);
            forecaster.incorporateReading(this.clock.getTime(), progress);
            LOG.info((Object)("progress: " + progress + " --> " + forecaster.toString()));
        }
        return forecaster.getSSE() < Math.pow(10.0, -6.0) ? 0 : 1;
    }

    private int decTestSimpleExponentialForecast() {
        this.clock = new ControlledClock();
        this.clock.tickMsec(clockTicks);
        SimpleExponentialSmoothing forecaster = new SimpleExponentialSmoothing(800L, 12, 10000L, this.clock.getTime());
        double[] progressRates = new double[]{0.005, 0.004, 0.002, 0.001};
        for (double progress = 0.0; progress <= 1.0; progress += progressRates[(int)(progress / 0.25)]) {
            this.clock.tickMsec(clockTicks);
            forecaster.incorporateReading(this.clock.getTime(), progress);
            LOG.info((Object)("progress: " + progress + " --> " + forecaster.toString()));
        }
        return forecaster.getSSE() < Math.pow(10.0, -6.0) ? 0 : 1;
    }

    private int zeroTestSimpleExponentialForecast() {
        int currInd;
        this.clock = new ControlledClock();
        this.clock.tickMsec(clockTicks);
        SimpleExponentialSmoothing forecaster = new SimpleExponentialSmoothing(800L, 12, 10000L, this.clock.getTime());
        double[] progressRates = new double[]{0.005, 0.004, 0.002, 0.0, 0.003};
        int progressInd = 0;
        for (double progress = 0.0; progress <= 1.0; progress += progressRates[currInd]) {
            this.clock.tickMsec(clockTicks);
            forecaster.incorporateReading(this.clock.getTime(), progress);
            LOG.info((Object)("progress: " + progress + " --> " + forecaster.toString()));
            currInd = progressInd++ > 1000 ? 4 : (int)(progress / 0.25);
        }
        return forecaster.getSSE() < Math.pow(10.0, -6.0) ? 0 : 1;
    }

    @Test
    public void testSimpleExponentialForecastLinearInc() throws Exception {
        int res = this.incTestSimpleExponentialForecast();
        Assert.assertEquals((String)"We got the wrong estimate from simple exponential.", (long)res, (long)0L);
    }

    @Test
    public void testSimpleExponentialForecastLinearDec() throws Exception {
        int res = this.decTestSimpleExponentialForecast();
        Assert.assertEquals((String)"We got the wrong estimate from simple exponential.", (long)res, (long)0L);
    }

    @Test
    public void testSimpleExponentialForecastZeros() throws Exception {
        int res = this.zeroTestSimpleExponentialForecast();
        Assert.assertEquals((String)"We got the wrong estimate from simple exponential.", (long)res, (long)0L);
    }
}

